unit MeHelp;

(*------------------------------------------------------------------------------
    Mandelbrot Set Explorer
    Copyright (C) 2003 Chiaki Nakajima

    This file is part of Mandelbrot Set Explorer [MSE].

    MSE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    MSE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MSE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
------------------------------------------------------------------------------*)

interface

uses
{$IFDEF MSWINDOWS}
  Graphics, Controls, Forms, StdCtrls, ExtCtrls, ComCtrls,
{$ENDIF}
{$IFDEF LINUX}
  QTypes, QGraphics, QControls, QForms, QStdCtrls, QExtCtrls, QComCtrls,
{$ENDIF}
  SysUtils, Types, Classes, Variants, IniFiles, StrUtils;

const
  StringLineBreak = '<cr>';
  SectionHelp = 'Help';
  StringNotFound = 'Help message not found.';

type
  THelpModeDlg = class(TForm)
    PanelHelp: TPanel;
    MemoHelp: TMemo;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure DisplayHelp(Sender: TObject);
  private
    { Private }
    procedure WriteString(_Str: String);
  public
    { Public }
  end;

var
  HelpModeDlg: THelpModeDlg;
  Hlp: TIniFile;

implementation

uses
  MeTree, MeView3D, MePalEdt, MeMain;

{$IFDEF MSWINDOWS}
{$R *.dfm}
{$ENDIF}
{$IFDEF LINUX}
{$R *.xfm}
{$ENDIF}

procedure THelpModeDlg.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  FormMain.miHelpModeClick(Sender);
end;

procedure THelpModeDlg.DisplayHelp(Sender: TObject);
begin
  if (not HelpModeDlg.Visible) then Show;
  if ((Sender = FormMain.miHelpMode) or (Sender = FormMain.PanelClient)) then
    WriteString(Hlp.ReadString(SectionHelp, 'HelpMode', StringNotFound))
  else if ((Sender = FormMain.ImageEntire) or (Sender = FormMain.LabelEntire)) then
    WriteString(Hlp.ReadString(SectionMainForm, 'MapEntire', StringNotFound))
  else if ((Sender = FormMain.ImageWide) or (Sender = FormMain.LabelWide)) then
    WriteString(Hlp.ReadString(SectionMainForm, 'MapWide', StringNotFound))
  else if ((Sender = FormMain.ImageCurrent) or (Sender = FormMain.LabelCurrent)) then
    WriteString(Hlp.ReadString(SectionMainForm, 'MapCurrent', StringNotFound))
  else if (Sender = FormMain.LabelTitle) then
    WriteString(Hlp.ReadString(SectionMainForm, 'LabelTitle', StringNotFound))
  else if (Sender = FormMain.LabelNestLevel) then
    WriteString(Hlp.ReadString(SectionMainForm, 'LabelNestLevel', StringNotFound))
  else if (Sender = FormMain.LabelMaxIter) then
    WriteString(Hlp.ReadString(SectionMainForm, 'LabelMaxIter', StringNotFound))
  else if (Sender = FormMain.LabelR1) then
    WriteString(Hlp.ReadString(SectionMainForm, 'LabelR1', StringNotFound))
  else if (Sender = FormMain.LabelI1) then
    WriteString(Hlp.ReadString(SectionMainForm, 'LabelI1', StringNotFound))
  else if (Sender = FormMain.LabelR2) then
    WriteString(Hlp.ReadString(SectionMainForm, 'LabelR2', StringNotFound))
  else if (Sender = FormMain.LabelI2) then
    WriteString(Hlp.ReadString(SectionMainForm, 'LabelI2', StringNotFound))
  else if (Sender = FormMain.LabelSpan) then
    WriteString(Hlp.ReadString(SectionMainForm, 'LabelSpan', StringNotFound))
  else if (Sender = FormMain.LabelMag) then
    WriteString(Hlp.ReadString(SectionMainForm, 'LabelMag', StringNotFound))
  else if ((Sender = FormMain.LabelStatus) or (Sender = FormMain.PanelStatusBar)) then
    WriteString(Hlp.ReadString(SectionMainForm, 'LabelStatus', StringNotFound))
  else if ((Sender = FormMain.miFileUpdateMapFile) or (Sender = FormMain.SpeedButtonUpdateMapFile)) then
    WriteString(Hlp.ReadString(SectionMainForm, 'miFileUpdateMapFile', StringNotFound))
  else if ((Sender = FormMain.miZoomNewZoomBox) or (Sender = FormMain.SpeedButtonNewZoomBox)) then
    WriteString(Hlp.ReadString(SectionMainForm, 'miZoomNewZoomBox', StringNotFound))
  else if ((Sender = FormMain.miZoomDisplayZoomBox) or (Sender = FormMain.SpeedButtonDisplayZoomBox)) then
    WriteString(Hlp.ReadString(SectionMainForm, 'miZoomDisplayZoomBox', StringNotFound))
  else if ((Sender = FormMain.miZoomIn) or (Sender = FormMain.SpeedButtonZoomIn)) then
    WriteString(Hlp.ReadString(SectionMainForm, 'miZoomIn', StringNotFound))
  else if ((Sender = FormMain.miZoomOut) or (Sender = FormMain.SpeedButtonZoomOut)) then
    WriteString(Hlp.ReadString(SectionMainForm, 'miZoomOut', StringNotFound))
  else if ((Sender = FormMain.miZoomJumpToEntire) or (Sender = FormMain.SpeedButtonJumpToEntire)) then
    WriteString(Hlp.ReadString(SectionMainForm, 'miZoomJumpToEntire', StringNotFound))
  else if ((Sender = FormMain.miZoomAbort) or (Sender = FormMain.SpeedButtonAbort)) then
    WriteString(Hlp.ReadString(SectionMainForm, 'miZoomAbort', StringNotFound))
  else if ((Sender = FormMain.miEditTitle) or (Sender = FormMain.SpeedButtonEditTitle)) then
    WriteString(Hlp.ReadString(SectionMainForm, 'miEditTitle', StringNotFound))
  else if ((Sender = FormMain.miEditChangeMaxIteration) or (Sender = FormMain.SpeedButtonChangeMaxIteration)) then
    WriteString(Hlp.ReadString(SectionMainForm, 'miEditChangeMaxIteration', StringNotFound))
  else if ((Sender = FormMain.miEditDeleteZoomBox)  or (Sender = FormMain.SpeedButtonDeleteZoomBox)) then
    WriteString(Hlp.ReadString(SectionMainForm, 'miEditDeleteZoomBox', StringNotFound))
  else if ((Sender = FormMain.miEditPalette) or (Sender = FormMain.SpeedButtonEditPalette)) then
    WriteString(Hlp.ReadString(SectionMainForm, 'miEditPalette', StringNotFound))
  else if ((Sender = FormMain.miEditCopyToClipboard) or (Sender = FormMain.SpeedButtonCopyToClipboard)) then
    WriteString(Hlp.ReadString(SectionMainForm, 'miEditCopyToClipboard', StringNotFound))
  else if ((Sender = FormMain.miOptionDisplayMapWindow) or (Sender = FormMain.SpeedButtonDisplayMapWindow)) then
    WriteString(Hlp.ReadString(SectionMainForm, 'miOptionDisplayMapWindow', StringNotFound))
  else if ((Sender = FormMain.miOptionDisplay3DWindow) or (Sender = FormMain.SpeedButtonDisplay3DWindow)) then
    WriteString(Hlp.ReadString(SectionMainForm, 'miOptionDisplay3DWindow', StringNotFound))
  else if (Sender = FormMain.miOptionUseImageFiles) then
    WriteString(Hlp.ReadString(SectionMainForm, 'miOptionUseImageFiles', StringNotFound))
  else if (Sender = FormMain.miOptionSelectFont) then
    WriteString(Hlp.ReadString(SectionMainForm, 'miOptionSelectFont', StringNotFound))
  else if (Sender = FormMain.miHelpAbout) then
    WriteString(Hlp.ReadString(SectionMainForm, 'miHelpAbout', StringNotFound))
  else if (Sender = View3DDlg.Image3D) then
    WriteString(Hlp.ReadString(SectionView3D, 'Image3D', StringNotFound))
  else if (Sender = View3DDlg.SpeedButtonRotL) then
    WriteString(Hlp.ReadString(SectionView3D, 'SpeedButtonRotL', StringNotFound))
  else if (Sender = View3DDlg.SpeedButtonRotU) then
    WriteString(Hlp.ReadString(SectionView3D, 'SpeedButtonRotU', StringNotFound))
  else if (Sender = View3DDlg.SpeedButtonRotD) then
    WriteString(Hlp.ReadString(SectionView3D, 'SpeedButtonRotD', StringNotFound))
  else if (Sender = View3DDlg.SpeedButtonRotR) then
    WriteString(Hlp.ReadString(SectionView3D, 'SpeedButtonRotR', StringNotFound))
  else if (Sender = View3DDlg.SpeedButtonDepthU) then
    WriteString(Hlp.ReadString(SectionView3D, 'SpeedButtonDepthU', StringNotFound))
  else if (Sender = View3DDlg.SpeedButtonDepthD) then
    WriteString(Hlp.ReadString(SectionView3D, 'SpeedButtonDepthD', StringNotFound))
  else if (Sender = ZoomPrmDlg.TreeView) then
    WriteString(Hlp.ReadString(SectionTree, 'TreeView', StringNotFound))
  else if (Sender = EditPaletteDlg.SpeedButtonL) then
    WriteString(Hlp.ReadString(SectionEditPalette, 'SpeedButtonL', StringNotFound))
  else if (Sender = EditPaletteDlg.SpeedButtonS1L) then
    WriteString(Hlp.ReadString(SectionEditPalette, 'SpeedButtonS1L', StringNotFound))
  else if (Sender = EditPaletteDlg.SpeedButtonS1U) then
    WriteString(Hlp.ReadString(SectionEditPalette, 'SpeedButtonS1U', StringNotFound))
  else if (Sender = EditPaletteDlg.SpeedButtonU) then
    WriteString(Hlp.ReadString(SectionEditPalette, 'SpeedButtonU', StringNotFound))
  else if (Sender = EditPaletteDlg.ImagePalette) then
    WriteString(Hlp.ReadString(SectionEditPalette, 'ImagePalette', StringNotFound))
  else if (Sender = EditPaletteDlg.ImageColorSample) then
    WriteString(Hlp.ReadString(SectionEditPalette, 'ImageColorSample', StringNotFound))
  else if (Sender = EditPaletteDlg.TrackBarSeparator1) then
    WriteString(Hlp.ReadString(SectionEditPalette, 'TrackBarSeparator1', StringNotFound))
end;

procedure THelpModeDlg.WriteString(_Str: String);
begin
  MemoHelp.Text := AnsiReplaceStr(_Str, StringLineBreak, #$0d + #$0a);
end;

initialization

  Hlp := TIniFile.Create(ChangeFileExt(ParamStr(0), '.hlp'));

finalization

  Hlp.Free;

end.
