unit MeIntro;

(*------------------------------------------------------------------------------
    Mandelbrot Set Explorer
    Copyright (C) 2003 Chiaki Nakajima

    This file is part of Mandelbrot Set Explorer [MSE].

    MSE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    MSE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MSE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
------------------------------------------------------------------------------*)

interface

uses
{$IFDEF MSWINDOWS}
  Graphics, Controls, Forms, StdCtrls, ExtCtrls, ComCtrls,
{$ENDIF}
{$IFDEF LINUX}
  QTypes, QGraphics, QControls, QForms, QStdCtrls, QExtCtrls, QComCtrls,
{$ENDIF}
  SysUtils, Types, Classes, Variants, IniFiles, StrUtils;

type
  THelpIntroDlg = class(TForm)
    PanelIntro: TPanel;
    MemoIntro: TMemo;
    procedure FormShow(Sender: TObject);
  private
    { Private }
    procedure WriteString(_Str: String);
  public
    { Public }
  end;

var
  HelpIntroDlg: THelpIntroDlg;

implementation

uses
  MeHelp;

{$IFDEF MSWINDOWS}
{$R *.dfm}
{$ENDIF}
{$IFDEF LINUX}
{$R *.xfm}
{$ENDIF}

procedure THelpIntroDlg.FormShow(Sender: TObject);
begin
  WriteString(Hlp.ReadString(SectionHelp, 'Intro1', StringNotFound));
  WriteString(MemoIntro.Text + Hlp.ReadString(SectionHelp, 'Intro2', StringNotFound));
  WriteString(MemoIntro.Text + Hlp.ReadString(SectionHelp, 'Intro3', StringNotFound));
end;

procedure THelpIntroDlg.WriteString(_Str: String);
begin
  MemoIntro.Text := AnsiReplaceStr(_Str, StringLineBreak, #$0d + #$0a);
end;

end.
