unit MeSplash;

(*------------------------------------------------------------------------------
    Mandelbrot Set Explorer
    Copyright (C) 2003 Chiaki Nakajima

    This file is part of Mandelbrot Set Explorer [MSE].

    MSE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    MSE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MSE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
------------------------------------------------------------------------------*)

interface

uses
{$IFDEF MSWINDOWS}
  Graphics, Controls, Forms, Dialogs, StdCtrls, ExtCtrls,
{$ENDIF}
{$IFDEF LINUX}
  QTypes, QGraphics, QControls, QForms, QDialogs, QStdCtrls, QExtCtrls,
{$ENDIF}
  SysUtils, Types, Classes, Variants;

type
  TFormSplash = class(TForm)
    PanelClient: TPanel;
    ImageMap: TImage;
    ImagePoyon: TImage;
    LabelTitle1: TLabel;
    LabelTitle2: TLabel;
    LabelVersion: TLabel;
    LabelCopyright: TLabel;
    LabelLoading: TLabel;
    TimerHideDelay: TTimer;
    procedure TimerHideDelayTimer(Sender: TObject);
  private
    { Private }
  public
    { Public }
  end;

var
  FormSplash: TFormSplash;

implementation

{$IFDEF MSWINDOWS}
{$R *.dfm}
{$ENDIF}
{$IFDEF LINUX}
{$R *.xfm}
{$ENDIF}

procedure TFormSplash.TimerHideDelayTimer(Sender: TObject);
begin
  TimerHideDelay.Enabled := False;
  Release;
end;

end.
