program Mse;

(*------------------------------------------------------------------------------
    Mandelbrot Set Explorer
    Copyright (C) 2003 Chiaki Nakajima

    This file is part of Mandelbrot Set Explorer [MSE].

    MSE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    MSE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MSE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
------------------------------------------------------------------------------*)

uses
  QForms,
  MeMain in 'MeMain.pas' {FormMain},
  MeClose in 'MeClose.pas' {CloseQueryDlg},
  MeAbout in 'MeAbout.pas' {AboutBox},
  MeTree in 'MeTree.pas' {ZoomPrmDlg},
  MeZoomIn in 'MeZoomIn.pas' {ZoomInDlg},
  MeSplash in 'MeSplash.pas' {FormSplash},
  MeView3D in 'MeView3D.pas' {View3DDlg},
  MePalEdt in 'MePalEdt.pas' {EditPaletteDlg},
  MeHelp in 'MeHelp.pas' {HelpModeDlg},
  MeIntro in 'MeIntro.pas' {HelpIntroDlg},
  MeIni in 'MeIni.pas',
  MeBmp in 'MeBmp.pas';

{$R *.res}

begin
  Application.Initialize;
  with TFormSplash.Create(nil) do begin
    LabelVersion.Caption := 'Ver. ' + MeMain.VersionString;
    Show;
    Update;
  end;
  Application.CreateForm(TFormMain, FormMain);
  Application.CreateForm(TCloseQueryDlg, CloseQueryDlg);
  Application.CreateForm(TAboutBox, AboutBox);
  Application.CreateForm(TZoomPrmDlg, ZoomPrmDlg);
  Application.CreateForm(TZoomInDlg, ZoomInDlg);
  Application.CreateForm(TView3DDlg, View3DDlg);
  Application.CreateForm(TEditPaletteDlg, EditPaletteDlg);
  Application.CreateForm(THelpModeDlg, HelpModeDlg);
  Application.CreateForm(THelpIntroDlg, HelpIntroDlg);
  FormMain.LoadIniFile;
  Application.Run;
end.

