		;***************************************************************
		;
		;	Title:		Timpy
		;	Comment:	Tiny Mp3 Player [ Timpy ] Rev2.xpt@[EFA
		;	File Name:	Timpy.asm
		;	Version:	2.x
		;	(		Aug. 12, 2004	ϐ̃GfBAtɂȂĂ̂C)
		;	(		Aug. 14, 2004	r[v̂قɃ|[ǉBNȂǂύX)
		;	(				r[vA|[萔ǉȂoOtBbNX)
		;	(		Sep. 18, 2004	|[̓mCŶō폜)
		;	(				ɋNmp3f[^R[ḧɗpӂčĐ)
		;	(				n啝ɕύXBgݍ킹~߁ASwForeɂ郂[hؑ֕ɂ)
		;	(				VS1001\tgEFAZbg̃oOC)
		;	(				s[gĐ[h(1ȃs[gASȃs[g)ǉ)
		;	(				NSwRearĂƂŕs𖳎@\ǉ)
		;	(				J[hõoOC)
		;	Date:		Sep. 18, 2004
		;	Copyright(C) 	Chiaki Nakajima
		;
		;***************************************************************
		;	Include File(s)
		;
		$pl		(65535)
		$pw		(132)
		$include	(c8051f330.inc)			;vZbTŗL`
		;
		;===============================================================
		;	Port Assign
		;
pSpiSck		bit		P0.0				;SPI SCLK
pSpiMiso	bit		P0.1				;SPI MISO
pSpiMosi	bit		P0.2				;SPI MOSI
pSdCs		bit		P0.3				;SDCard CS(_)
pVsXcs		bit		P0.4				;VS1001 xCS(_)
pVsDclkEn	bit		P0.5				;VS1001 DCLKCl[u
pVsDreq		bit		P0.6				;VS1001 DREQ
pVsBsync	bit		P0.7				;VS1001 BSYNC
pVsXtali	bit		P1.0				;VS1001 XTALI
pVsReset	bit		P1.1				;VS1001 RESET(_)
pSwLower	bit		P1.2				;XCb`
pSwFore		bit		P1.3				;OXCb`
pSwRear		bit		P1.4				;XCb`
pSwUpper	bit		P1.5				;XCb`
pAnalogSwOn	bit		P1.6				;AiOXCb`I
pBattery	bit		P1.7				;obedo
pC2D		bit		P2.0				;C2D
		;
pSwPort		equ		P1				;XCb`̓|[g
		;
		;===============================================================
		;	Constant(s)
		;
;cSysclk	equ		24576000d			;24.576MHz : A51AZuł16rbg܂łȂ̂ł̐l͖
		;
cVsSciR		equ		00000011b			;VS1001 SCI Read Instruction Byte
cVsSciW		equ		00000010b			;VS1001 SCI Write Instruction Byte
cVsModeAddr	equ		000d				;VS1001 MODEWX^AhX
cVsStatusAddr	equ		001d				;VS1001 STATUSWX^AhX
cVsClockfAddr	equ		003d				;VS1001 CLOCKFWX^AhX
cVsVolAddr	equ		011d				;VS1001 VOLWX^AhX
cVsSmFfwd	equ		1 SHL 1				;SM_FFWD
cVsSmReset	equ		1 SHL 2				;SM_RESET
cVsSmPdown	equ		1 SHL 4				;SM_PDOWN
cVsSmBass	equ		1 SHL 7				;SM_BASS
		;
bSwLower	equ		pSwLower AND 007h		;XCb`rbgԍ
bSwRear		equ		pSwRear  AND 007h		;XCb`rbgԍ
bSwFore		equ		pSwFore  AND 007h		;OXCb`rbgԍ
bSwUpper	equ		pSwUpper AND 007h		;XCb`rbgԍ
cSwBitMask	equ		(1 SHL bSwLower) OR (1 SHL bSwRear) OR (1 SHL bSwFore) OR (1 SHL bSwUpper)	;XCb`rbg}XN
		;
cShutdown	equ		06000d				;CPU~܂ł̑҂(10msecP)
cOpModeReset	equ		01000d				;CPU~܂ł̑҂(10msecP)
cBeepNoteL	equ		048d + 007d			;r[v : 375Hz
cBeepNoteM	equ		048d + 004d			;r[v : 750Hz
cBeepNoteH	equ		048d + 001d			;r[v : 1500Hz
cBeepAtt	equ		0000d				;r[v̉ʒߒ萔(0.5dBP)
cBeepTimeRepeat	equ		0100d				;s[g[hʒm̃r[v(msecP)
cBeepTimeChngRm	equ		0200d				;s[g[hύX̃r[v(msecP)
cBeepTimeOp	equ		0050d				;쎞̃r[v(msecP)
cBeepTimeBatt	equ		0075d				;obe`FbÑr[v(msecP)
cBeepTimeErr	equ		0100d				;G[̃r[v(msecP)
cBeepTimeShDn	equ		0200d				;Vbg_Ẽr[v(msecP)
		;
		;===============================================================
		;	Data Area
		;
		;---------------------------------------;General Purpose Registers
		;					;  gp[`dȂ悤Ɋ蓖Ă
		dseg		at	000h				;WX^oN0
rbMain		equ		$						;MainɂĎgp
fParamCopySrc	equ		R0						;p[^Rs[|C^
fParamCopyDst	equ		R1						;p[^Rs[|C^
fIdleCtrH	equ		R2						;~ԃJE^(H)
fIdleCtrL	equ		R3						;~ԃJE^(L)
fNoOpCtrH	equ		R4						;쎞ԃJE^(H)
fNoOpCtrL	equ		R5						;쎞ԃJE^(L)
fLoopCtr	equ		R6						;ėp[vJE^
		;
		dseg		at	008h				;WX^oN1
rbGetSdBpbInfo	equ		$						;GetSdBpbInfoɂĎgp
fNumFats	equ		R0						;FAT̐
fRootEntCntH	equ		R1						;[gfBNgGg(H)
fRootEntCntL	equ		R2						;[gfBNgGg(L)
fFatSizeH	equ		R3						;FAT̃ZN^(H)
fFatSizeL	equ		R4						;FAT̃ZN^(L)
		;
rbSeekMp3File	equ		$						;SeekMp3FileɂĎgp
fFoundFileCtr	equ		R0						;MP3t@CJE^
fDptrSaveH	equ		R1						;ZN^|C^ۑWX^(H)
fDptrSaveL	equ		R2						;ZN^|C^ۑWX^(L)
		;
rbTxSdCommand	equ		$						;TxSdCommandɂĎgp
fTxSdCmdLCtrH	equ		R0						;[vJE^(H)
fTxSdCmdLCtrL	equ		R1						;[vJE^(L)
		;
rbMakeSdCheckD	equ		$						;MakeSdCheckDɂĎgp
fSdCheckDTmpH	equ		R0						;J[hopf[^WX^(H)
fSdCheckDTmpM	equ		R1						;J[hopf[^WX^(M)
fSdCheckDTmpN	equ		R2						;J[hopf[^WX^(N)
fSdCheckDTmpL	equ		R3						;J[hopf[^WX^(L)
		;
rbLoadNvParams	equ		$						;LoadNvParamsɂĎgp
fLoadNvPrmsLCtr	equ		R0						;[vJE^
fLoadNvPrmsDPtr	equ		R1						;f[^|C^
		;
rbSaveNvParams	equ		$						;SaveNvParamsɂĎgp
fSaveNvPrmsLCtr	equ		R0						;[vJE^
fSaveNvPrmsDPtr	equ		R1						;f[^|C^
		;
		dseg		at	010h				;WX^oN2
rbInitSd	equ		$						;InitSdɂĎgp
fInitSdLCtrH	equ		R0						;[vJE^(H)
fInitSdLCtrL	equ		R1						;[vJE^(L)
		;
rbFindPrevCS	equ		$						;FindPrevCSɂĎgp
fSaveClusterNo	equ		R0						;TJnfFileClusterNo
fSaveSectorCnt	equ		R1						;TJnfFileSectorCnt
fPrevClusterNo	equ		R2						;T̂ЂƂOClusterNo
fPrevSectorCnt	equ		R3						;T̂ЂƂOSectorCnt
		;
		dseg		at	018h				;WX^oN3
		;								;gp
		;
		;---------------------------------------;Bit Addressable
		dseg		at	020h
fPlayMode:	ds		1						;vC[hoCg
bPmOpMode0	equ		0						;샂[h(rbg0)
bPmOpMode1	equ		1						;샂[h(rbg1)
bPmOpMode2	equ		2						;샂[h(rbg2)
bPmSwUpdate	equ		6						;[UC^[tF[X̂߂̊荞݂sꂽZbg
bPmPlaying	equ		7						;~łȂԃZbgĂtO
bmPmOpMode	equ		007h						;샂[hrbg}XN
cOpModePlay	equ		0						;샂[h=0FʏĐ[h
cOpModeTrJump	equ		1						;샂[h=1FgbNWv[h
cOpModeRepeat	equ		2						;샂[h=2Fs[gݒ胂[h
cOpModeFfRew	equ		3						;샂[h=3F芪߂[h
		;
fRepeatMode:	ds		1						;s[gĐ[hݒoCgp
bRmOne		equ		0						;݂̋Ȃs[gĐ(1ON)
bRmAll		equ		1						;SȂs[gĐ(1ON)
		;
fSwPortPrev:	ds		1						;pSwPort̑Ol
fSwPortSave:	ds		1						;pSwPort̕ۑp
fSwStatus:	ds		1						;pSwPort̏(`b^LZς݁A1=ON)
fSwStatus0to1:	ds		1						;fSwStatusOFFONɕωrbg=1
fSwStatus1to0:	ds		1						;fSwStatusONOFFɕωrbg=1
		;
		;---------------------------------------;Direct and Indirect Addressing
		dseg		at	030h
fTimer2Ctr:	ds		1						;Timer2荞݃JE^
		;
fVsSciA:	ds		1						;VS1001 SCI[hECgAhX
fVsSciDL:	ds		1						;VS1001 SCI[hECgf[^(ʃoCg)
fVsSciDH:	ds		1						;VS1001 SCI[hECgf[^(ʃoCg)
fVsSdiD:	ds		1						;VS1001 SDICgf[^
		;
fSdSpiRxD:	ds		1						;SdCard SPI[hf[^
fSdSpiTxD:	ds		1						;SdCard SPICgf[^
fSdCommand:	ds		6						;SdCard SPIR}hobt@
fSdResponse:	ds		1						;SdCard SPIR}hX|X(R1݂̂z)
fSdSectorNo:	ds		3						;SdCard [hZN^ԍ(3oCg)(0..)
		;
fSecPerClus:	ds		1						;NX^̃ZN^
fFirstFatSec:	ds		2						;FAT̐擪ZN^ԍ
fFirstRootSec:	ds		2						;[gfBNgGg̐擪ZN^ԍ
fFirstDataSec:	ds		2						;f[^̈̐擪ZN^ԍ
		;
fBeepCode:	ds		1						;r[vgݒ
fBeepTime:	ds		1						;r[vԐݒ
		;
fBattVoltage:	ds		1						;obed(BCD2Aa.b[V]:ʃju=aAʃju=b)
		;
cNvParamTop	equ		$					;ԕۑϐGA
fVsVolume:	ds		1						;VS1001 {[l
fMp3Files:	ds		1						;J[hMP3t@C̑S
		;								;
cFileParamTop	equ		$						;Đt@CɊւp[^
fFileNo:	ds		1						;Ώۃt@Cԍ
fFileClusterNo:	ds		2						;̃NX^ԍ
fFileSectorCnt:	ds		1						;̃NX^ɑ΂ZN^ԍ(0..fSecPerClus - 1)
fFileSize:	ds		4						;fFileNõt@CTCY
fRemainBytes:	ds		4						;f[^t@C̍ĐcoCg
fPlayPointer:	ds		2						;XRAMɓǂݍ܂Ăf[^̍Đ|C^
cFileParamEnd	equ		$						;Đt@CɊւp[^܂
		;
cFileParamATop	equ		$						;}[JAɊւp[^
fFileNoA:	ds		1						;Ώۃt@Cԍ(}[JA)
fFileClusNoA:	ds		2						;̃NX^ԍ(}[JA)
fFileSecCntA:	ds		1						;̃NX^ɑ΂ZN^ԍ(0..fSecPerClus - 1)(}[JA)
fFileSizeA:	ds		4						;fFileNõt@CTCY(}[JA)
fRemainBytesA:	ds		4						;f[^t@C̍ĐcoCg(}[JA)
fPlayPointerA:	ds		2						;XRAMɓǂݍ܂Ăf[^̍Đ|C^(}[JA)
		;
fRepeatModeSav:	ds		1						;s[gĐ[hݒoCgۑp
		;
fSdCheckData:	ds		4						;J[hopf[^
cNvParamEnd	equ		$					;ԕۑϐGA܂
		;
DataSegmentEnd	equ		$			;f[^ZOg̍Ō
		;
		iseg		at	080h		;StackZOgJnAhX
Stack:		ds		07fh						;128oCg
		;
	if	DataSegmentEnd >= Stack
		__ERROR__	"DataSegment too large."
	endif
		;
		;===============================================================
		;	Macro(s)
		;
		;---------------------------------------;WX^oNI}N
SelectRegBank	macro		_rbSelect
		;
		anl		PSW, #11100111b					;RS0, RS1NA
		orl		PSW, #_rbSelect AND 00011000b			;RS0, RS1XV
		;
		endm
		;
		;---------------------------------------;16rbgVtg}N(A͔j)
ShiftL16	macro		_H, _L
		;
		clr		C						;CNA
		mov		A, _L						;A : ʃoCg
		rlc		A						;A : C܂߂č[e[g
		mov		_L, A						;_LXV
		mov		A, _H						;A : ʃoCg
		rlc		A						;A : C܂߂č[e[g
		mov		_H, A						;_HXV
		;
		endm
		;
		;---------------------------------------;16rbgEVtg}N(A͔j)
ShiftR16	macro		_H, _L
		;
		clr		C						;CNA
		mov		A, _H						;A : ʃoCg
		rrc		A						;A : C܂߂ĉE[e[g
		mov		_H, A						;_HXV
		mov		A, _L						;A : ʃoCg
		rrc		A						;A : C܂߂ĉE[e[g
		mov		_L, A						;_LXV
		;
		endm
		;
		;---------------------------------------;24rbgVtg}N(A͔j)
ShiftL24	macro		_H, _M, _L
		;
		clr		C						;CNA
		mov		A, _L						;A : ʃoCg
		rlc		A						;A : C܂߂č[e[g
		mov		_L, A						;_LXV
		mov		A, _M						;A : ʃoCg
		rlc		A						;A : C܂߂č[e[g
		mov		_M, A						;_MXV
		mov		A, _H						;A : ʃoCg
		rlc		A						;A : C܂߂č[e[g
		mov		_H, A						;_HXV
		;
		endm
		;
		;---------------------------------------;16rbgZ}N(A͔jȀԂɒ)
		;					;  Y = A + B
		;					;  C : L
AddYAB16	macro		_YH, _YL, _AH, _AL, _BH, _BL
		;
		mov		A, _AL						;A : _AL
		add		A, _BL						;A : _AL + _BL
		mov		_YL, A						;_YLXV
		mov		A, _AH						;A : _AH
		addc		A, _BH						;A : _AH + _BH + C
		mov		_YH, A						;_YHXV
		;
		endm
		;
		;---------------------------------------;16rbgZ}N(A͔jȀԂɒ)
		;					;  Y = Y + A
		;					;  C : L
AddYYA16	macro		_YH, _YL, _AH, _AL
		;
		mov		A, _AL						;A : _AL
		add		A, _YL						;A : _AL + _YL
		mov		_YL, A						;_YLXV
		mov		A, _AH						;A : _AH
		addc		A, _YH						;A : _AH + _YH + C
		mov		_YH, A						;_YHXV
		;
		endm
		;
		;---------------------------------------;16rbgZ}N(A͔jȀԂɒ)
		;					;  Y = A - B
		;					;  C : {[
SubYAB16	macro		_YH, _YL, _AH, _AL, _BH, _BL
		;
		clr		C						;CNA
		mov		A, _AL						;A : _AL
		subb		A, _BL						;A : _AL - _BL
		mov		_YL, A						;_YLXV
		mov		A, _AH						;A : _AH
		subb		A, _BH						;A : _AH - _BH - C
		mov		_YH, A						;_YHXV
		;
		endm
		;
		;
		;---------------------------------------;16rbgZ}N(A͔jȀԂɒ)
		;					;  Y = Y - A
		;					;  C : {[
SubYYA16	macro		_YH, _YL, _AH, _AL
		;
		clr		C						;CNA
		mov		A, _YL						;A : _YL
		subb		A, _AL						;A : _YL - _AL
		mov		_YL, A						;_YLXV
		mov		A, _YH						;A : _YH
		subb		A, _AH						;A : _YH - _AH - C
		mov		_YH, A						;_YHXV
		;
		endm
		;
		;---------------------------------------;24rbgZ}N(A͔jȀԂɒ)
		;					;  Y = Y + A
		;					;  C : L
AddYYA24	macro		_YH, _YM, _YL, _AH, _AM, _AL
		;
		mov		A, _AL						;A : _AL
		add		A, _YL						;A : _AL + _YL
		mov		_YL, A						;_YLXV
		mov		A, _AM						;A : _AM
		addc		A, _YM						;A : _AM + _YM + C
		mov		_YM, A						;_YMXV
		mov		A, _AH						;A : _AH
		addc		A, _YH						;A : _AH + _YH + C
		mov		_YH, A						;_YHXV
		;
		endm
		;
		;---------------------------------------;32rbgZ}N(A͔jȀԂɒ)
		;					;  Y = Y + A
		;					;  C : L
AddYYA32	macro		_YH, _YM, _YN, _YL, _AH, _AM, _AN, _AL
		;
		mov		A, _AL						;A : _AL
		add		A, _YL						;A : _AL + _YL
		mov		_YL, A						;_YLXV
		mov		A, _AN						;A : _AN
		addc		A, _YN						;A : _AN + _YN + C
		mov		_YN, A						;_YNXV
		mov		A, _AM						;A : _AM
		addc		A, _YM						;A : _AM + _YM + C
		mov		_YM, A						;_YMXV
		mov		A, _AH						;A : _AH
		addc		A, _YH						;A : _AH + _YH + C
		mov		_YH, A						;_YHXV
		;
		endm
		;
		;---------------------------------------;32rbgZ}N(A͔jȀԂɒ)
		;					;  Y = Y - A
		;					;  C : {[
SubYYA32	macro		_YH, _YM, _YN, _YL, _AH, _AM, _AN, _AL
		;
		clr		C						;CNA
		mov		A, _YL						;A : _YL
		subb		A, _AL						;A : _YL - _AL
		mov		_YL, A						;_YLXV
		mov		A, _YN						;A : _YN
		subb		A, _AN						;A : _YN - _AN - C
		mov		_YN, A						;_YNXV
		mov		A, _YM						;A : _YM
		subb		A, _AM						;A : _YM - _AM - C
		mov		_YM, A						;_YMXV
		mov		A, _YH						;A : _YH
		subb		A, _AH						;A : _YH - _AH - C
		mov		_YH, A						;_YHXV
		;
		endm
		;
		;---------------------------------------;Spi0MI҂}N
		;					;  SPI0DATɏޑOSPIFNAĂKv
WaitSpi0End	macro
		local		_WaitSpi0End1
		;
_WaitSpi0End1:	jnb		SPIF, _WaitSpi0End1				;MItONAȂ烋[v
		;
		endm
		;
		;---------------------------------------;Spi0Mobt@GveB҂}N
WaitSpi0TxRdy	macro
		local		_WaitSpi0TxRdy
		;
_WaitSpi0TxRdy:	jnb		TXBMT, _WaitSpi0TxRdy				;Mobt@GveBtONAȂ烋[v
		;
		endm
		;
		;---------------------------------------;SPI0f[^M}N
		;					;  _Dst : Mf[^
RxSpi0		macro		_Dst
		;
		TxSpi0		#0ffh						;M̂߂̃_~[o
		WaitSpi0End							;MI҂
		mov		_Dst, SPI0DAT					;Mf[^]
		;
		endm
		;
		;---------------------------------------;SPI0f[^M}N
		;					;  _Src : Mf[^
TxSpi0		macro		_Src
		;
		WaitSpi0TxRdy							;Mobt@GveB҂
		clr		SPIF						;MItONA
		mov		SPI0DAT, _Src					;Mf[^]
		WaitSpi0End							;MI҂
		;
		endm
		;
		;---------------------------------------;FLASH[h}N
		;					;  DPTR : [hAhX
		;					;  A : [hf[^
ReadFlash	macro
		;
		clr		A						;A : 0
		movc		A, @A + DPTR					;A : [hf[^
		;
		endm
		;
		;---------------------------------------;FLASHCg}N
		;					;  DPTR : CgAhX
		;					;  A : Cgf[^
WriteFlash	macro
		;
		mov		FLKEY, #0a5h					;FLKEY : 0a5h
		mov		FLKEY, #0f1h					;FLKEY : 0f1h
		movx		@DPTR, A					;
		;
		endm
		;
		;---------------------------------------;Đt@Cp[^ƃ}[Np[^Ԃ̃Rs[}N
		;					;  _Dst : Rs[擪AhX
		;					;  _Src : Rs[擪AhX
CopyFileParam	macro		_Dst, _Src
		local		_CopyFilePrm1
		;
		mov		fParamCopyDst, #_Dst				;fParamCopyDst : Rs[擪AhX
		mov		fParamCopySrc, #_Src				;fParamCopySrc : Rs[擪AhX
_CopyFilePrm1:	mov		A, @fParamCopySrc				;A : Rs[f[^
		mov		@fParamCopyDst, A				;Rs[
		inc		fParamCopyDst					;Rs[擪AhX + 1
		inc		fParamCopySrc					;Rs[擪AhX + 1
		cjne		fParamCopySrc, #_Src + (cFileParamEnd - cFileParamTop) + 1, _CopyFilePrm1	;IłȂ΃[v
		;
		endm
		;
		;---------------------------------------;r[v}N
MakeBeep	macro		_Note, _Time
		;
		mov		fBeepCode, #_Note				;f[^ݒ
		mov		fBeepTime, #_Time				;Ԑݒ
		lcall		Beep						;r[v
		;
		endm
		;
		;===============================================================
		;	Vectors Section
		;
		;---------------------------------------;X^[g
		cseg		at	00000h
VectorReset:	ljmp		Initialize			;Zbg
		cseg		at	00003h
VectorInt0:	ljmp		VectorReset			;Int0
		cseg		at	0000bh
VectorTmr0Ovfl:	ljmp		VectorReset			;Tmr0I[ot[
		cseg		at	00013h
VectorInt1:	ljmp		IsrInt1				;Int1
		cseg		at	0001bh
VectorTmr1Ovfl:	ljmp		VectorReset			;Tmr1I[ot[
		cseg		at	00023h
VectorUart0:	ljmp		VectorReset			;Uart0
		cseg		at	0002bh
VectorTmr2Ovfl:	ljmp		IsrTimer2			;Tmr2I[ot[
		cseg		at	00033h
VectorSpi0:	ljmp		VectorReset			;Spi0
		cseg		at	0003bh
VectorSmb0:	ljmp		VectorReset			;Smb0
		cseg		at	00043h
VectorReserve0:	ljmp		VectorReset			;Reserved
		cseg		at	0004bh
VectorAdc0Wind:	ljmp		VectorReset			;Adc0EChEr
		cseg		at	00053h
VectorAdc0End:	ljmp		VectorReset			;Adc0ϊI
		cseg		at	0005bh
VectorPca:	ljmp		VectorReset			;Pca
		cseg		at	00063h
VectorCmp0:	ljmp		VectorReset			;Cmp0
		cseg		at	0006bh
VectorReserve1:	ljmp		VectorReset			;Reserved
		cseg		at	00073h
VectorTmr3Ovfl:	ljmp		VectorReset			;Tmr3I[ot[
		;
		;===============================================================
		;	Initializing
		;
		cseg		at	00080h
		;
Initialize:	;---------------------------------------;ԏ
		mov		SP, #Stack - 1					;X^bN|C^
		;
		;							;HFIV[^
;		mov		OSCICL, #0xxh					;HFUgł邾24.576MHzɋ߂Â
		mov		OSCICN, #083h					;HFIV[^Cl[uAȂ
		;
		;							;Wdt
		mov		PCA0MD, #000h					;WDTfBXG[u
		;
		;							;Spi0
		mov		SPI0CFG, #01000000b				;}X^[hACKPHA=CKPOL=0
		mov		SPI0CN, #001h					;3-wire}X^[hASPICl[u
;		mov		SPI0CKR, #011d					;fSCK=1MHz
		mov		SPI0CKR, #097d					;fSCK=125kHz
		;
		;							;Voltage Reference
		mov		REF0CN, #008h					;VREF=VDD
		;
		;							;Adc0 : obedo
		mov		AMX0P, #00fh					;P1.7:bBatteryVoltage
		mov		AMX0N, #011h					;VOGh[h
		mov		ADC0CF, #01001100b				;CLKSAR=SYSCLK/10Af[^͍l
		mov		ADC0CN, #01000000b				;[p[gbN[hAADC0~
		;
		;							;Timer0 : usecPʃfBC^C}(WaitAusecp)
		;							;Timer1 : msecPʃfBC^C}(WaitAmsecp)
		mov		TCON, #000h					;~A/INT1̓xgK
		mov		TMOD, #00010010b				;Timer0:Mode2ATimer1:Mode1
		mov		CKCON, #00001100b				;Timer0,1SYSCLKgp
		;
		;							;Timer2 : [UC^[tF[X̂߂̃C^[o^C}
		mov		TMR2CN, #00000000b				;16bit[h^C}ANbN=SYSCLK/12A~
		mov		TMR2RLL, #LOW  0b000h				;LOW  (0 - (cSysclk / 12d / 100d)) : C^[o=10msec
		mov		TMR2RLH, #HIGH 0b000h				;HIGH (0 - (cSysclk / 12d / 100d)) : C^[o=10msec
		;
		;							;I/O|[g : 萔錾gĂȂ̂ŕύX̍ۂ͗v
		mov		P0, #11011111b					;pVsDclkEn̂"L"o
		mov		P0MDIN,  #11111111b				;SrbgfW^I/O
		mov		P0MDOUT, #10011101b				;pVsDreqApSpiMisó͓ApVsDclkEn̓I[vhCo
		mov		P0SKIP,  #11111000b				;P0.7-3͔ėpI/O
		mov		P1, #10111101b					;pVsResetApAnalogSwOn̂"L"
		mov		P1MDIN,  #01111111b				;P1.7̂݃AiOI/O
		mov		P1MDOUT, #01000011b				;pBatteryApSw*͓
		mov		P1SKIP,  #11111110b				;P1.7-1͔ėpI/O
		mov		P2MDOUT, #00000001b				;P2.0̓vbVv
		mov		XBR0, #00ah					;SYSCLK, SPII/OɃATC
		mov		XBR1, #040h					;NXo[Cl[u
		;
		;							;ϐ揉
		mov		R0, #Stack					;R0 : JnAhX
_Init1:		mov		@R0, #0						;@R0 : 0NA
		djnz		R0, _Init1					;R0 : R0 - 1A<> 0 Ȃ烋[v
		;
		;							;荞ݐ
		mov		IT01CF, #11100000b				;/INT1̓ANeBu"H"AP0.6
		;
		;							;VS1001
		mov		A, #010d					;A : 10
		acall		WaitAusec					;Ausec҂
		setb		pVsReset					;RESETlQ[g
		mov		fVsVolume, #030h				;{[l
		mov		A, #0100d					;A : 100
		acall		WaitAmsec					;Amsec҂
		setb		pAnalogSwOn					;AiOXCb`I
		;
		;							;Jn
		setb		TR2						;Timer2Jn
		setb		ET2						;Timer2荞݋
		mov		fPlayMode, #0					;fPlayMode
		;
		;===============================================================
		;	Main
		;
Main:		;---------------------------------------;C[v
		;
		;							;SDCard
		lcall		InitSd						;SPI[hɐݒ
		mov		A, fSdResponse					;A : X|X
		jnz		_MainE						;<> 0ȂG[
		;
		;							;SPINbNAbv
;		mov		SPI0CKR, #011d					;fSCK=1MHz
;		mov		SPI0CKR, #005d					;fSCK=2MHz
		mov		SPI0CKR, #002d					;fSCK=4MHz
		;
		;							;SDJ[hW
		lcall		GetSdBpbInfo					;SdCard BPB̏擾
		jc		_MainE						;G[ȂWv
		;
		;							;J[hMP3t@C̐`FbN
		mov		fFileNo, #0					;fFileNo : 256Ȗڂw(ۂɂ͂肦Ȃl)
		lcall		SeekMp3File					;".MP3"t@CT
		mov		A, fMp3Files					;A : MP3t@C̐
		mov		B, A						;B : MP3t@C̐ۑ
		jz		_MainE						;0ȂG[
		;
		;							;s𖳎鑀̃`FbN
		jnb		pSwRear, _Main5					;SwRearĂs𖳎
		;
		;							;J[h`FbN
		lcall		LoadNvParams					;sԕA
		lcall		SeekMp3File					;ۑ".MP3"t@CT
		jc		_Main5						;ȂȂJ[hĂƌȂ
		;
		lcall		ReadFileData					;t@C1ZN^ǂݍ
		jc		_MainE						;G[ȂWv
		;
		mov		fMp3Files, B					;fMp3Files : J[hMP3t@C̐𕜋A
		lcall		MakeSdCheckD					;SDJ[h`FbNpf[^
		mov		DPTR, #NvAreaTop + (fSdCheckData + 0 - cNvParamTop)	;DPTR : s̃J[hopf[^̃AhX
		ReadFlash							;A : s̃J[hopf[^
		cjne		A, fSdCheckData + 0, _Main5			;svȂƂ݂Ȃ
		;
		mov		DPTR, #NvAreaTop + (fSdCheckData + 1 - cNvParamTop)	;DPTR : s̃J[hopf[^̃AhX
		ReadFlash							;A : s̃J[hopf[^
		cjne		A, fSdCheckData + 1, _Main5			;svȂƂ݂Ȃ
		;
		mov		DPTR, #NvAreaTop + (fSdCheckData + 2 - cNvParamTop)	;DPTR : s̃J[hopf[^̃AhX
		ReadFlash							;A : s̃J[hopf[^
		cjne		A, fSdCheckData + 2, _Main5			;svȂƂ݂Ȃ
		;
		mov		DPTR, #NvAreaTop + (fSdCheckData + 3 - cNvParamTop)	;DPTR : s̃J[hopf[^̃AhX
		ReadFlash							;A : s̃J[hopf[^
		cjne		A, fSdCheckData + 3, _Main5			;svȂƂ݂Ȃ
		;
		;							;J[hĂȂꍇ
		lcall		LoadNvParams					;ēxsԕA
		lcall		ReadFileData					;t@C1ZN^ǂݍ
		jc		_MainE						;G[ȂWv
		;
		sjmp		_Main6						;Đ
		;
_MainE:		ljmp		OnFatalError				;vIG[̓ݑ
		;
_Main5:		;							;J[hĂꍇ
		lcall		LoadNvParams					;ēxsԕA
		mov		fFileNo, #0					;fFileNo : 256Ȗڂw(ۂɂ͂肦Ȃl)
		lcall		SeekMp3File					;".MP3"t@CĒTAfMp3Filesď
		mov		fFileNo, #1					;fFileNo
		lcall		SeekMp3File					;".MP3"t@CT
		lcall		ReadFileData					;t@C1ZN^ǂݍ
		mov		fPlayPointer + 0, #0
		mov		fPlayPointer + 1, #0				;fPlayPointer
		CopyFileParam	cFileParamATop, cFileParamTop			;}[JAփp[^Rs[
		mov		fRepeatMode, #0					;s[gĐ[hNA
		;
_Main6:		;							;Đr[vAŏI
;		lcall		PlayPowerupSnd					;NĐ
		MakeBeep	cBeepNoteL, cBeepTimeOp				;r[v(ቹ)
		MakeBeep	cBeepNoteM, cBeepTimeOp				;r[v()
		MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v()
		clr		fPlayMode.bPmSwUpdate				;PmSwUpdatetONA
		;
_Main2:		;							;VS1001ďAĐ
		acall		InitVs						;\tgEFAZbg
		acall		SetVsVolume					;{[ݒ
		acall		SetVsClockf					;NbNݒ
		;
		mov		fIdleCtrL, #0
		mov		fIdleCtrH, #0					;~ԃJE^
		;
		mov		fNoOpCtrL, #0
		mov		fNoOpCtrH, #0					;쎞ԃJE^
		;
_Main1:		;
		;							;ĐȂINT1荞݋
		clr		C						;CNAĂ
		jnb		fPlayMode.bPmPlaying, _Main3			;ĐtONAȂWv
		;
		lcall		CheckRemain					;ĐcoCg`FbNAA = 0ȂcȂ
		jz		_Main3						;c薳ȂWv
		;
		setb		C						;CZbg
_Main3:		mov		EX1, C						;INT1荞݋փRs[
		;
		;---------------------------------------;荞݋ɂăACh[h
		setb		EA						;O[o荞݋
		orl		PCON, #00000001b				;IDLEZbg
		;
		;		Zzzzz.....					;̊荞݂܂ŏȓd͏
		;
		;---------------------------------------;荞݂ɂIDLE畜A
		clr		EA						;O[o荞݋֎~
		;
_MainbattCheck:	;---------------------------------------;obed`FbN
		lcall		ReadBattVolts					;d
		mov		A, fBattVoltage					;A : obed(BCD2)
		add		A, #0 - 030h					;A < 3.0VȂL[Ȃ
		jc		_MainSwProc					;3.0VȏȂ玟
		;
		ljmp		OnFatalError					;3.0VȂvIG[
		;
_MainSwProc:	;---------------------------------------;XCb`
		;							;XCb`XV`FbN
		jb		fPlayMode.bPmSwUpdate, _MainSwProc4		;PmSwUpdateZbgȂ珈s
		;
		ajmp		_MainSwProc0					;NAȂ珈sv
		;
_MainSwProc4:	;							;XCb`s
		clr		fPlayMode.bPmSwUpdate				;PmSwUpdateNA
		;
		;							;XCb`̓`FbN
		mov		A, fSwStatus					;A : XCb`̏
		jnz		_MainSwProc3					;ǂꂩXCb`Ă΃XCb`
		;
		mov		A, fSwStatus1to0				;A : XCb`̏ԕω(ONOFF)
		jnz		_MainSwProc3					;XCb`삪΃XCb`
		;
		;							;SXCb`OFF̏ꍇ@쎞ԍXVA`FbN
		AddYYA16	fNoOpCtrH, fNoOpCtrL, #0, #1			;fNoOpCtr : fNoOpCtr + 1
		cjne		fNoOpCtrL, #LOW cOpModeReset, _MainSwProc0	;fNoOpCtr <> cOpModeResetȂWv
		;
		cjne		fNoOpCtrH, #HIGH cOpModeReset, _MainSwProc0	;fNoOpCtr <> cOpModeResetȂWv
		;
		;							;쎞ԂcOpModeResetԌp̂ő샂[hZbg
		anl		fPlayMode, #NOT bmPmOpMode			;샂[hrbgNA
		sjmp		_MainSwProc0					;XCb`I
		;
_MainSwProc3:	;							;XCb`Cxgꍇ
		mov		fIdleCtrL, #0
		mov		fIdleCtrH, #0					;~ԃJE^
		;
		mov		fNoOpCtrL, #0
		mov		fNoOpCtrH, #0					;쎞ԃJE^
		;
		;							;Cxg
		jb		fPlayMode.bPmPlaying, _MainSwOpMode		;ĐtOZbgȂWv
		;
		;							;~̑
		jb		fSwStatus0to1.bSwFore, OpPlay			;SwForeOFFON : vC
		;
		jb		fSwStatus0to1.bSwUpper, OpJumpMarkA		;SwUpperOFFON : }[JփWv
		;
		jb		fSwStatus0to1.bSwLower, OpSetMarkA		;SwLowerOFFON : }[JZbg
		;
		jb		fSwStatus0to1.bSwRear, OpBattery		;SwRearOFFON : obe`FbN
		;
		sjmp		_MainSwProc0					;XCb`I
		;
_MainSwOpMode:	mov		A, fPlayMode					;A : fPlayMode
		anl		A, #bmPmOpMode					;A : 샂[hrbgo
		cjne		A, #cOpModePlay, _MainSwOpMode1			;샂[h <> ʏĐ[hȂWv
		;
		;							;ʏĐ[h̑
		jb		fSwStatus0to1.bSwFore, OpModeTrJump		;SwForeOFFON : gbNWv[h
		;
		jb		fSwStatus.bSwUpper, OpVolumeUp			;SwUpperON : {[Abv
		;
		jb		fSwStatus.bSwLower, OpVolumeDn			;SwLowerON : {[_E
		;
		jb		fSwStatus0to1.bSwRear, OpStop			;SwRearOFFON : Xgbv
		;
		sjmp		_MainSwProc0					;XCb`I
		;
_MainSwOpMode1:	cjne		A, #cOpModeTrJump, _MainSwOpMode2		;샂[h <> gbNWv[hȂWv
		;
		;							;gbNWv[h̑
		jb		fSwStatus0to1.bSwFore, OpModeRepeat		;SwForeOFFON : s[gݒ胂[h
		;
		jb		fSwStatus0to1.bSwUpper, OpTrJumpNext		;SwUpperOFFON : ̋ȂփWv
		;
		jb		fSwStatus0to1.bSwLower, OpTrJumpPrev		;SwLowerOFFON : ŐȂփWv
		;
		jb		fSwStatus0to1.bSwRear, OpModePlay		;SwRearOFFON : ʏĐ[h
		;
		sjmp		_MainSwProc0					;XCb`I
		;
_MainSwOpMode2:	cjne		A, #cOpModeRepeat, _MainSwOpMode3		;샂[h <> s[gݒ胂[hȂWv
		;
		;							;s[gݒ胂[h̑
		jb		fSwStatus0to1.bSwFore, OpModeFfRew		;SwForeOFFON : 芪߂[h
		;
		jb		fSwStatus0to1.bSwUpper, OpRepeatAll		;SwUpperOFFON : Sȃs[gĐON/OFF
		;
		jb		fSwStatus0to1.bSwLower, OpRepeatOne		;SwLowerOFFON : ݂̋ȃs[gĐON/OFF
		;
		jb		fSwStatus0to1.bSwRear, OpModePlay		;SwRearOFFON : ʏĐ[h
		;
		sjmp		_MainSwProc0					;XCb`I
		;
_MainSwOpMode3:	cjne		A, #cOpModeFfRew, _MainSwProc0			;샂[h <> 芪߂[hȂWv
		;
		;							;s[gݒ胂[h̑
		jb		fSwStatus0to1.bSwFore, OpModePlay		;SwForeOFFON : ʏĐ[h
		;
		jb		fSwStatus.bSwUpper, OpFF			;SwUpperON : 
		;
		jb		fSwStatus.bSwLower, OpREW			;SwLowerON : ߂
		;
		jb		fSwStatus0to1.bSwRear, OpModePlay		;SwRearOFFON : ʏĐ[h
		;
_MainSwProc0:	ljmp		_MainPlayProc					;XCb`IȀ
		;
		;---------------------------------------;[U쏈[`ւ̓ݑ
OpModePlay:	ajmp		AOpModePlay					;ʏĐ[h
OpModeTrJump:	ajmp		AOpModeTrJump					;gbNWv[h
OpModeRepeat:	ajmp		AOpModeRepeat					;s[gݒ胂[h
OpModeFfRew:	ajmp		AOpModeFfRew					;芪߂[h
OpStop:		ajmp		AOpStop						;Xgbv
OpPlay:		ajmp		AOpPlay						;vC
OpFF:		ajmp		AOpFF						;
OpREW:		ajmp		AOpREW						;߂
OpVolumeUp:	ajmp		AOpVolumeUp					;{[Abv
OpVolumeDn:	ajmp		AOpVolumeDn					;{[_E
OpTrJumpNext:	ajmp		AOpTrJumpNext					;̋ȂփWv
OpTrJumpPrev:	ajmp		AOpTrJumpPrev					;ŐȂփWv
OpJumpMarkA:	ajmp		AOpJumpMarkA					;}[JփWv
OpSetMarkA:	ajmp		AOpSetMarkA					;}[JZbg
OpRepeatAll:	ajmp		AOpRepeatAll					;Sȃs[gĐON/OFF
OpRepeatOne:	ajmp		AOpRepeatOne					;݂̋ȃs[gĐON/OFF
OpBattery:	ajmp		AOpBattery					;obe`FbN
		;
_MainPlayProc:	;---------------------------------------;Đf[^
		;							;ĐtO`FbN
		jb		fPlayMode.bPmPlaying, _MainPlayProcB		;ĐȂWv
		;
		ajmp		_MainPlayProc3					;~փWv
		;
_MainPlayProcB:	setb		pAnalogSwOn					;AiOXCb`I
		;
_MainPlayProc7:	;							;VS1001 DREQ`FbN
		jb		pVsDreq, _MainPlayProc8				;DREQ = "H"ȂWv
		;
		ajmp		_MainPlayProc1					;DREQ = "L"ȂĐXLbv
		;
_MainPlayProc8:	;							;݂̃t@CĐI`FbN
		lcall		CheckRemain					;c`FbNAA = 0ȂcȂ
		jz		_MainPlayProc4					;fRemainBytes = 0ȂWv
		;
		;							;݂̃t@CĐs
		mov		DPH, fPlayPointer + 0				;
		mov		DPL, fPlayPointer + 1				;DPTR : XRAM̍Đ|C^
		movx		A, @DPTR					;A : Mf[^
		mov		fVsSdiD, A					;fVsSdiD : Mf[^
		lcall		TxVsSdi						;SDIf[^M
		inc		DPTR						;DPTR : Đ|C^CNg
		mov		A, DPH						;A : XRAM̍Đ|C^(H)
		jnb		ACC.1, _MainPlayProc6				;XRAM̍Đ|C^ < 512ȂWv
		;
		lcall		FindNextCS					;ɓǂݍނׂf[^̃NX^ԍEZN^ԍ擾
		lcall		ReadFileData					;t@C1ZN^ǂݍ
		mov		DPTR, #0					;DPTR : XRAM̍Đ|C^
_MainPlayProc6:	mov		fPlayPointer + 0, DPH				;
		mov		fPlayPointer + 1, DPL				;fPlayPointer : XRAM̍Đ|C^ۑ
		SubYYA32	fRemainBytes + 0, fRemainBytes + 1, fRemainBytes + 2, fRemainBytes + 3, #0, #0, #0, #1
		;								;fRemainBytes : fRemainBytes - 1
		sjmp		_MainPlayProc7					;DREQ"H"Ȃ瑱ăf[^M
		;
_MainPlayProc4:	;							;݂̃t@CĐI
		jb		fRepeatMode.bRmOne, _MainPlayProc9		;݂̋ȃs[gĐtOZbgȂWv
		;
		mov		A, fFileNo					;A : ݂̋Ȕԍ
		cjne		A, fMp3Files, _MainPlayProc5			;A <> SȐȂWv
		;
		;							;Ō̃t@CĐI
		jb		fRepeatMode.bRmAll, _MainPlayProcA		;Sȃs[gĐtOZbgȂWv
		;
		clr		fPlayMode.bPmPlaying				;ĐtONAčĐ~
		MakeBeep	cBeepNoteM, cBeepTimeOp				;r[v()
_MainPlayProcA:	mov		fFileNo, #1					;1ȖڂĂ
		lcall		SeekMp3File					;".MP3"t@CT
		lcall		ReadFileData					;t@C1ZN^ǂݍ
		mov		fPlayPointer + 0, #0
		mov		fPlayPointer + 1, #0				;fPlayPointer
		ajmp		_MainPlayProc2					;Wv
		;
_MainPlayProc5:	;							;̃t@C
		inc		fFileNo						;t@CԍXV
_MainPlayProc9:	lcall		SeekMp3File					;t@CT
		jc		_MainPlayProcE					;G[̏ꍇɂ̓Wv
		;
		lcall		ReadFileData					;t@C1ZN^ǂݍ
		mov		fPlayPointer + 0, #0
		mov		fPlayPointer + 1, #0				;fPlayPointer : XRAM̍Đ|C^
		ajmp		_MainPlayProc2					;Wv
		;
_MainPlayProc3:	;							;~
		clr		pAnalogSwOn					;AiOXCb`It
		;							;~ԍXVA`FbN
		AddYYA16	fIdleCtrH, fIdleCtrL, #0, #1			;fIdleCtr : fIdleCtr + 1
		mov		A, fIdleCtrL					;A : fIdleCtrL
		cjne		A, #LOW cShutdown, _MainPlayProc1		;fIdleCtr <> cShutdownȂWv
		;
		mov		A, fIdleCtrH					;A : fIdleCtrH
		cjne		A, #HIGH cShutdown, _MainPlayProc1		;fIdleCtr <> cShutdownȂWv
		;
		;							;~ԂcShutDownԌp̂ŃVbg_E
		MakeBeep	cBeepNoteL, cBeepTimeShDn			;r[v(ቹ)
		;
		;							;Vbg_E
		clr		EA						;S荞݋֎~
ShutDown:	clr		pAnalogSwOn					;AiOXCb`It
		;sjmp		ShutDown					;***** DEBUG *****
		orl		PCON, #00000010b				;STOPZbgACPU~
		nop								;_~[
		;
_MainPlayProc1:	ajmp		_Main1					;_Main1փWv
		;
_MainPlayProc2:	ajmp		_Main2					;_Main2փWv
		;
_MainPlayProcE:	ajmp		_MainE					;_MainEփWv
		;
AOpModePlay:	;---------------------------------------;ʏĐ[h
		anl		fPlayMode, #NOT bmPmOpMode			;샂[hrbgNA
		orl		fPlayMode, #cOpModePlay				;ʏĐ[hɐݒ
		MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v()
		ajmp		_MainSwProc0					;Cփ^[
		;
AOpModeTrJump:	;---------------------------------------;gbNWv[h
		anl		fPlayMode, #NOT bmPmOpMode			;샂[hrbgNA
		orl		fPlayMode, #cOpModeTrJump			;gbNWv[hɐݒ
		MakeBeep	cBeepNoteM, cBeepTimeOp				;r[v()
		mov		A, #0100d					;0.1b҂
		lcall		WaitAmsec					;Amsec҂
		MakeBeep	cBeepNoteM, cBeepTimeOp				;r[v()
		mov		A, #0100d					;0.1b҂
		lcall		WaitAmsec					;Amsec҂
		MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v()
		ajmp		_MainSwProc0					;Cփ^[
		;
AOpModeRepeat:	;---------------------------------------;s[gݒ胂[h
		anl		fPlayMode, #NOT bmPmOpMode			;샂[hrbgNA
		orl		fPlayMode, #cOpModeRepeat			;s[gݒ胂[hɐݒ
		MakeBeep	cBeepNoteL, cBeepTimeOp				;r[v(ቹ)
		mov		A, #0100d					;0.1b҂
		lcall		WaitAmsec					;Amsec҂
		MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v()
		mov		A, #0100d					;0.1b҂
		lcall		WaitAmsec					;Amsec҂
		MakeBeep	cBeepNoteL, cBeepTimeOp				;r[v(ቹ)
		ajmp		_MainSwProc0					;Cփ^[
		;
AOpModeFfRew:	;---------------------------------------;芪߂[h
		anl		fPlayMode, #NOT bmPmOpMode			;샂[hrbgNA
		orl		fPlayMode, #cOpModeFfRew			;芪߂[hɐݒ
		MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v()
		mov		A, #0100d					;0.1b҂
		lcall		WaitAmsec					;Amsec҂
		MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v()
		mov		A, #0100d					;0.1b҂
		lcall		WaitAmsec					;Amsec҂
		MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v()
		ajmp		_MainSwProc0					;Cփ^[
		;
AOpStop:	;---------------------------------------;Xgbv
		;							;Đ~
		clr		fPlayMode.bPmPlaying				;ĐtONA
		anl		fPlayMode, #NOT bmPmOpMode			;샂[hrbgNA
		lcall		SaveNvParams					;s֏ԕۑ
		MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v()
		ajmp		_MainSwProc0					;Cփ^[
		;
AOpPlay:	;---------------------------------------;vC
		;							;ĐJn
		setb		fPlayMode.bPmPlaying				;ĐtOZbg
		jnb		fRepeatMode.bRmAll, _AOpPlay1			;Sȃs[gĐtONAȂWv
		;
		MakeBeep	cBeepNoteH, cBeepTimeRepeat			;r[v()
		sjmp		_AOpPlay0					;Wv
		;
_AOpPlay1:	jnb		fRepeatMode.bRmOne, _AOpPlay2			;݂̋ȃs[gĐtONAȂWv
		;
		MakeBeep	cBeepNoteM, cBeepTimeRepeat			;r[v()
		sjmp		_AOpPlay0					;Wv
		;
_AOpPlay2:	MakeBeep	cBeepNoteL, cBeepTimeRepeat			;r[v(ቹ)
		;
_AOpPlay0:	ajmp		_MainSwProc0					;Cփ^[
		;
AOpFF:		;---------------------------------------;
		;							;Timer2荞161̂ݏ
		mov		A, fTimer2Ctr					;A : fTimer2Ctr
		anl		A, #00001111b					;4rbg𒊏o
		jnz		_AOpFF0						;A <> 0Ȃ珈XLbv
		;
		;							;Đf[^̎c > 512H
		SubYYA32	fRemainBytes + 0, fRemainBytes + 1, fRemainBytes + 2, fRemainBytes + 3, #0, #0, #HIGH 0512d, #LOW 0512d
		;								;fRemainBytes : fRemainBytes - 512
		jnc		_AOpFF1						;fRemainBytes >= 0ȂWv
		;
		;							;݂̃t@C͏Ȉꍇ
		ajmp		AOpTrJumpNext					;̋Ȃ
		;
_AOpFF1:	;							;̃ZN^֔΂AfPlayPointer͂̂܂
		lcall		FindNextCS					;ɓǂݍނׂf[^̃NX^ԍEZN^ԍ擾
		lcall		ReadFileData					;t@C1ZN^ǂݍ
;		acall		InitVs						;\tgEFAZbg
;		acall		SetVsVolume					;{[ݒ
;		acall		SetVsClockf					;NbNݒ
_AOpFF0:	ajmp		_MainSwProc0					;Cփ^[
		;
AOpREW:		;---------------------------------------;߂
;		;							;512oCg߂邩ǂ̃`FbN
;		AddYYA32	fRemainBytes + 0, fRemainBytes + 1, fRemainBytes + 2, fRemainBytes + 3, #0, #0, #HIGH 0512d, #LOW 0512d
;		;								;fRemainBytes : fRemainBytes + 512
;		push		fRemainBytes + 0
;		push		fRemainBytes + 1
;		push		fRemainBytes + 2
;		push		fRemainBytes + 3				;fRemainBytesۑ
;		SubYYA32	fRemainBytes + 0, fRemainBytes + 1, fRemainBytes + 2, fRemainBytes + 3, fFileSize + 0, fFileSize + 1, fFileSize + 2, fFileSize + 3
;		;								;fRemainBytes : fRemainBytes - fFileSize
;		pop		fRemainBytes + 3
;		pop		fRemainBytes + 2
;		pop		fRemainBytes + 1
;		pop		fRemainBytes + 0				;fRemainBytesA
;		jc		_AOpREW1					;fRemainBytes < fFileSizeȂWv
;		;
;		;							;݂̃t@C͏Ȉꍇ
;		ajmp		AOpJumpPrevT					;ŐȂ
;		;
;_AOpREW1:	;							;ЂƂÕZN^֖߂AfPlayPointer͂̂܂
;		lcall		FindPrevCS					;݂̂ЂƂÕNX^ԍEZN^ԍ擾
;		lcall		ReadFileData					;t@C1ZN^ǂݍ
;		acall		InitVs						;\tgEFAZbg
;		acall		SetVsVolume					;{[ݒ
;		acall		SetVsClockf					;NbNݒ
		ajmp		_MainSwProc0					;Cփ^[
		;
AOpVolumeUp:	;---------------------------------------;{[Abv
		;							;Timer2荞41̂ݏ
		mov		A, fTimer2Ctr					;A : fTimer2Ctr
		anl		A, #00000011b					;2rbg𒊏o
		jnz		_AOpVolumeUp0					;A <> 0Ȃ珈XLbv
		;
		;							;݂̃{[l`FbN
		mov		A, fVsVolume					;A : fVsVolume
		jz		_AOpVolumeUp0					;A = 0ȂI
		;
		;							;{[lXV
		dec		A						;A : A - 1
		mov		fVsVolume, A					;fVsVolumeXV
		lcall		SetVsVolume					;{[ݒ
_AOpVolumeUp0:	ajmp		_MainSwProc0					;Cփ^[
		;
AOpVolumeDn:	;---------------------------------------;{[_E
		;							;Timer2荞41̂ݏ
		mov		A, fTimer2Ctr					;A : fTimer2Ctr
		anl		A, #00000011b					;2rbg𒊏o
		jnz		_AOpVolumeDn0					;A <> 0Ȃ珈XLbv
		;
		;							;mCYoȂ悤0fehŒlƂ
		mov		A, fVsVolume					;A : fVsVolume
		inc		A						;A : A + 1
		cjne		A, #0ffh, _AOpVolumeDn1				;A <> 0ffhȂXV
		;
		sjmp		_AOpVolumeDn0					;A = 0ffhȂXVȂ
		;
_AOpVolumeDn1:	;							;{[lXV
		mov		fVsVolume, A					;fVsVolumeXV
		lcall		SetVsVolume					;{[ݒ
_AOpVolumeDn0:	ajmp		_MainSwProc0					;Cփ^[
		;
AOpTrJumpNext:	;---------------------------------------;̋ȂփWv
		;							;̋ȂT
		mov		A, fFileNo					;A : ݂̋Ȕԍ
		cjne		A, fMp3Files, _AOpTrJpNext2			;A <> SȐȂWv
		;
		;							;Ō̋Ȃ̏ꍇ
		mov		fFileNo, #1					;1Ȗڂ
		sjmp		_AOpTrJpNext3					;Đ
		;
		;							;Ō̋ȂłȂꍇ
_AOpTrJpNext2:	inc		fFileNo						;fFileNo : fFileNo + 1
_AOpTrJpNext3:	lcall		SeekMp3File					;t@CT
		jnc		_AOpTrJpNext1					;G[ȂΑs
		;
		ljmp		OnFatalError					;G[̏ꍇɂ̓Wv
		;
_AOpTrJpNext1:	;							;̋Ȃꍇ
		lcall		ReadFileData					;t@C1ZN^ǂݍ
		mov		fPlayPointer + 0, #0
		mov		fPlayPointer + 1, #0				;fPlayPointer : XRAM̍Đ|C^
		;
		;							;ĐJn
		setb		fPlayMode.bPmPlaying				;ĐtOZbg
		MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v()
		ajmp		_MainSwProc0					;Cփ^[
		;
AOpTrJumpPrev:	;---------------------------------------;ŐȂփWv
		;							;ŐȂT
		mov		A, fFileNo					;A : ݂̋Ȕԍ
		cjne		A, #1, _AOpTrJpPrev2				;A <> 1ȂWv
		;
		;							;1Ȗڂ̏ꍇ
		mov		fFileNo, fMp3Files				;Ō̋Ȃ
		sjmp		_AOpTrJpPrev3					;Đ
		;
		;							;1ȖڂłȂꍇ
_AOpTrJpPrev2:	dec		fFileNo						;fFileNo : fFileNo - 1
_AOpTrJpPrev3:	lcall		SeekMp3File					;t@CT
		jnc		_AOpTrJpPrev1					;G[ȂΑs
		;
		ljmp		OnFatalError					;G[̏ꍇɂ̓Wv
		;
_AOpTrJpPrev1:	sjmp		_AOpTrJpNext1					;AOpJumpNextTƓ
		;
AOpJumpMarkA:	;---------------------------------------;}[JփWv
		;							;}[JAփWv
		CopyFileParam	cFileParamTop, cFileParamATop			;}[NAp[^Rs[
		lcall		ReadFileData					;t@C1ZN^ǂݍ
		;
		;							;ĐJn
		setb		fPlayMode.bPmPlaying				;ĐtOZbg
		MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v()
		ajmp		_MainSwProc0					;Cփ^[
		;
AOpSetMarkA:	;---------------------------------------;}[JZbg
		CopyFileParam	cFileParamATop, cFileParamTop		;}[JAփp[^Rs[
		lcall		SaveNvParams					;s֏ԕۑ
		;
		;							;ĐĊJ
		MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v()
		MakeBeep	cBeepNoteM, cBeepTimeOp				;r[v()
		MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v()
		ajmp		_MainSwProc0					;Cփ^[
		;
AOpRepeatAll:	;---------------------------------------;Sȃs[gĐON/OFF
		clr		fRepeatMode.bRmOne				;݂̋ȃs[gĐtONA
		jb		fRepeatMode.bRmAll, _AOpModeRptA1		;Sȃs[gĐtOZbgȂWv
		;
		;							;Sȃs[gĐONɂ
		setb		fRepeatMode.bRmAll				;Sȃs[gĐtOZbg
		MakeBeep	cBeepNoteH, cBeepTimeChngRm			;r[v()
		sjmp		_AOpModeRptA0					;Wv
		;
_AOpModeRptA1:	;							;Sȃs[gĐOFFɂ
		clr		fRepeatMode.bRmAll				;Sȃs[gĐtONA
		MakeBeep	cBeepNoteL, cBeepTimeChngRm			;r[v(ቹ)
		;
_AOpModeRptA0:	ajmp		_MainSwProc0					;Cփ^[
		;
AOpRepeatOne:	;---------------------------------------;݂̋ȃs[gĐON/OFF
		clr		fRepeatMode.bRmAll				;Sȃs[gĐtONA
		jb		fRepeatMode.bRmOne, _AOpModeRptO1		;݂̋ȃs[gĐtOZbgȂWv
		;
		;							;݂̋ȃs[gĐONɂ
		setb		fRepeatMode.bRmOne				;݂̋ȃs[gĐtOZbg
		MakeBeep	cBeepNoteM, cBeepTimeChngRm			;r[v()
		sjmp		_AOpModeRptO0					;Wv
		;
_AOpModeRptO1:	;							;݂̋ȃs[gĐOFFɂ
		clr		fRepeatMode.bRmOne				;݂̋ȃs[gĐtONA
		MakeBeep	cBeepNoteL, cBeepTimeChngRm			;r[v(ቹ)
		;
_AOpModeRptO0:	ajmp		_MainSwProc0					;Cփ^[
		;
AOpBattery:	;---------------------------------------;obe`FbN
		;							;obedr[vŒm点
		lcall		ReadBattVolts					;obedǂݍ
		mov		fLoopCtr, #08d					;fLoopCtr : [vJE^
		mov		A, fBattVoltage					;A : obedl(BCD2)
_AOpBattery2:	push		ACC
		jb		ACC.7, _AOpBattery1				;A(7) = 1ȂWv
		;
		MakeBeep	cBeepNoteM, cBeepTimeBatt			;r[v()
		sjmp		_AOpBattery3					;Wv
		;
_AOpBattery1:	MakeBeep	cBeepNoteH, cBeepTimeBatt			;r[v()
_AOpBattery3:	mov		A, #02d						;0.2b҂
		cjne		fLoopCtr, #05d, _AOpBattery4			;fLoopCtr <> 5ȂWv
		;
		mov		A, #04d						;0.4b҂
_AOpBattery4:	lcall		WaitA100msec					;A100msec҂
		pop		ACC
		rl		A						;A : [e[g
		djnz		fLoopCtr, _AOpBattery2				;[v
		;
		ajmp		_MainSwProc0					;Cփ^[
		;
		;===============================================================
		;	Subroutines
		;
WaitAusec:	;---------------------------------------;Acc(usec)҂(ᐸx)
		;					;@Timer0gp
		push		ACC
		;
		clr		TR0						;Timer0~
		mov		TL0, #LOW  0ffe7h				;LOW (0 - (cSysclk / 1000000d + 1)) : 1usecp萔ŏ
		mov		TH0, TL0					;[hl
		clr		TF0						;I[ot[tONA
		setb		TR0						;Timer0Jn
_WaitAusec1:	jnb		TF0, _WaitAusec1				;I[ot[tONAȂ烋[v
		;
		clr		TF0						;I[ot[tONA
		djnz		ACC, _WaitAusec1				;A : A - 1A<> 0Ȃ烋[v
		;
		clr		TR0						;Timer0~
		;
		pop		ACC
		ret
		;
WaitAmsec:	;---------------------------------------;Acc(msec)҂(ᐸx)
		;					;@Timer1gp
		push		ACC
		;
_WaitAmsec2:	clr		TR1						;Timer1~
		mov		TL1, #LOW  0a000h				;LOW  (0 - (cSysclk / 1000d)) : 1msecp萔ŏ
		mov		TH1, #HIGH 0a000h				;HIGH (0 - (cSysclk / 1000d)) : 1msecp萔ŏ
		clr		TF1						;I[ot[tONA
		setb		TR1						;Timer1Jn
_WaitAmsec1:	jnb		TF1, _WaitAmsec1				;I[ot[tONAȂ烋[v
		;
		djnz		ACC, _WaitAmsec2				;A : A - 1A<> 0Ȃ烋[v
		;
		clr		TF1						;I[ot[tONA
		clr		TR1						;Timer1~
		;
		pop		ACC
		ret
		;
WaitA100msec:	;---------------------------------------;Acc(100msec)҂(ᐸx)
		;					;@WaitAmsecgp
		push		ACC
		push		B
		;
		mov		B, ACC						;B : [vJE^
		mov		A, #0100d					;A : 100(msec)
		;
_WaitA100msec1:	acall		WaitAmsec					;Amsec҂
		djnz		B, _WaitA100msec1				;B : B - 1A<> 0Ȃ烋[v
		;
		pop		B
		pop		ACC
		ret
		;
ReadBattVolts:	;---------------------------------------;obedǂݍ
		;					;  Adc0ϊlobedɕϊfBattVoltageɃZbg
		;					;  fBattVoltage : BCD2Ńobed킷
		push		ACC
		push		B
		;
		;							;A/Dϊ
		setb		AD0EN						;ADC0Cl[u
		clr		AD0INT						;AD0INTNA
		setb		AD0BUSY						;ϊJn
		jnb		AD0INT, $					;ϊI҂
		;
		;							;f[^ϊ
		mov		A, ADC0H					;A : ϊl̏ʃoCg
		clr		AD0EN						;ADC0fBXG[u
		;
		mov		B, #030d * 2					;B : tXP[ɑΉdl
		mul		AB						;B : 030d * 2 * 255 / 256(oCi)
		mov		A, B						;AɃRs[
		mov		B, #010d					;B : 10
		div		AB						;A : A / 10AB : ]
		swap		A						;\̈ʂʃju
		add		A, B						;ʃju : Aʃju : 
		mov		fBattVoltage, A					;fBattVoltageXV
		;
		pop		B						;WX^oNA
		pop		ACC
		ret
		;
RxVsSci:	;---------------------------------------;VS1001 SCIWX^[h
		;					;  xCS܂
		;					;  fVsSciA : [hAhX
		;					;  fVsSciDH,L : [hf[^
		push		ACC
		;
		clr		pVsXcs						;xCsAT[g
		TxSpi0		#cVsSciR					;SCI Read Instruction ByteM
		TxSpi0		fVsSciA						;AhXM
		RxSpi0		fVsSciDH					;f[^ʃoCgM
		RxSpi0		fVsSciDL					;f[^ʃoCgM
		WaitSpi0End							;MI҂
		setb		pVsXcs						;xCslQ[g
		;
		pop		ACC
		ret
		;
TxVsSci:	;---------------------------------------;VS1001 SCIWX^Cg
		;					;  xCS܂
		;					;  fVsSciA : CgAhX
		;					;  fVsSciDH,L : Cgf[^
		push		ACC
		;
		clr		pVsXcs						;xCsAT[g
		TxSpi0		#cVsSciW					;SCI Write Instruction ByteM
		TxSpi0		fVsSciA						;AhXM
		TxSpi0		fVsSciDH					;f[^ʃoCgM
		TxSpi0		fVsSciDL					;f[^ʃoCgM
		WaitSpi0End							;MI҂
		setb		pVsXcs						;xCslQ[g
		;
		pop		ACC
		ret
		;
TxVsSdi:	;---------------------------------------;VS1001 SDIf[^Cg
		;					;  DCLK܂
		;					;  fVsSdiD : Cgf[^
		push		ACC
		;
		setb		pVsDclkEn					;DCLK"L"
		setb		pVsBsync					;BSYNC="H"
;		TxSpi0		fVsSdiD						;f[^oCgM
		;								;ȉ3s͑MI҂ȂTxSpi0
		WaitSpi0TxRdy							;Mobt@GveB҂
		clr		SPIF						;MItONA
		mov		SPI0DAT, fVsSdiD				;Mf[^]
		;
_TxVsSdi1:	jnb		pSpiSck, _TxVsSdi1				;pSpiSck="L"Ȃ烋[v
		;
_TxVsSdi2:	jb		pSpiSck, _TxVsSdi2				;pSpiSck="H"Ȃ烋[v
		;
		clr		pVsBsync					;BSYNC="L"
		WaitSpi0End							;MI҂
		clr		pVsDclkEn					;DCLK"L"ݒ
		;
		pop		ACC
		ret
		;
InitVs:		;---------------------------------------;VS1001 \tgEGAZbg
		push		ACC
		push		DPL
		push		DPH
		;
		;							;ZbgO20480
		mov		DPTR, #0 - 02048d				;DPTR : 2048
		mov		fVsSdiD, #000h					;Mf[^ : 0
_InitVs2:	jnb		pVsDreq, _InitVs2				;DREQ="L"Ȃ烋[v
		acall		TxVsSdi						;SDIf[^M
		inc		DPTR						;DPTR : DPTR + 1
		mov		A, DPL						;
		orl		A, DPH						;A : DPL or DPH
		jnz		_InitVs2					;A <> 0Ȃ烋[v
		;
		;							;RESETs
		mov		fVsSciA, #cVsModeAddr				;MODEWX^ݒ
		mov		fVsSciDL, #cVsSmReset				;SM_RESETZbg
		mov		fVsSciDH, #000h					;MODEWX^̏ʃoCg0
		acall		TxVsSci						;MODEWX^Cg
		mov		A, #010d					;A : 10
		acall		WaitAusec					;Ausec҂
		mov		fVsSciDL, #080h					;SM_RESETNAASM_BASSCl[u
		acall		TxVsSci						;MODEWX^Cg
		mov		A, #010d					;A : 10
		acall		WaitAusec					;Ausec҂
_InitVs1:	jnb		pVsDreq, _InitVs1				;DREQ="L"Ȃ烋[v
		;
		mov		fVsSdiD, #000h					;Zbg0f[^
		acall		TxVsSdi						;SDIf[^M
		;
		mov		A, #010d					;A : 10
		acall		WaitAusec					;Ausec҂
		;
		pop		DPH
		pop		DPL
		pop		ACC
		ret
		;
SetVsVolume:	;---------------------------------------;VS1001 {[ݒ
		;					;  fVsVolume : ݒl
		;							;VOLݒ
		mov		A, #010d					;A : 10
		acall		WaitAusec					;Ausec҂
		;
		mov		fVsSciA, #cVsVolAddr				;VOLWX^ݒ
		mov		fVsSciDL, fVsVolume				;VOLZbg
		mov		fVsSciDH, fVsVolume				;VOLZbg
		acall		TxVsSci						;MODEWX^Cg
		;
		mov		A, #010d					;A : 10
		acall		WaitAusec					;Ausec҂
		;
		ret
		;
SetVsClockf:	;---------------------------------------;VS1001 NbNݒ
		;							;CLOCKFݒ
		;
		mov		A, #010d					;A : 10
		acall		WaitAusec					;Ausec҂
		;
		mov		fVsSciA, #cVsClockfAddr				;CLOCKFWX^ݒ
		mov		fVsSciDL, #LOW  012288d				;cSysclk / 2000ݒ
		mov		fVsSciDH, #HIGH 012288d				;cSysclk / 2000ݒ
		acall		TxVsSci						;CLOCKFWX^Cg
		;
		mov		A, #010d					;A : 10
		acall		WaitAusec					;Ausec҂
		;
		ret
		;
Beep:		;---------------------------------------;VS1001 r[v
		;					;  fBeepCode : VS1001 Sine Test4oCgڂ̒l
		;					;  fBeepTime : (msecP)
		push		ACC
		;
		;							;r[vʒ
		push		fVsVolume					;{[lۑ
		mov		A, fVsVolume					;A : {[l
		add		A, #cBeepAtt					;A : A + ʒߒ萔
	if	(cBeepAtt AND 080h)
		jc		_Beep4						;LoOKA
	else
		jnc		_Beep4						;LoȂOKA
	endif
		;
		mov		A, fVsVolume					;I[ot[Ȃ特ʂȂ
_Beep4:		mov		fVsVolume, A					;fVsVolumeXV
		;
		;							;VS1001
		acall		InitVs						;\tgEFAZbg
		acall		SetVsVolume					;{[ݒ
		acall		SetVsClockf					;NbNݒ
		;
		;							;r[vI
		mov		fVsSdiD, #053h					;Sine Test 1oCg
		acall		TxVsSdi						;SDIf[^M
		mov		fVsSdiD, #0efh					;Sine Test 2oCg
		acall		TxVsSdi						;SDIf[^M
		mov		fVsSdiD, #06eh					;Sine Test 3oCg
		acall		TxVsSdi						;SDIf[^M
		mov		fVsSdiD, fBeepCode				;Sine Test 4oCg
		acall		TxVsSdi						;SDIf[^M
		mov		fVsSdiD, #0					;Sine Test 5..8oCg
		mov		A, #04d						;A : [vJE^
_Beep1:		acall		TxVsSdi						;SDIf[^M
		djnz		ACC, _Beep1					;A : A - 1A<> 0Ȃ烋[v
		;
		setb		pAnalogSwOn					;AiOXCb`I
		;
		;							;r[vpԑ҂
		mov		A, fBeepTime					;A : r[vԐݒ
		acall		WaitAmsec					;Amsec҂
		;
		;							;r[vIt
		mov		fVsSdiD, #045h					;Sine Test 1oCg
		acall		TxVsSdi						;SDIf[^M
		mov		fVsSdiD, #078h					;Sine Test 2oCg
		acall		TxVsSdi						;SDIf[^M
		mov		fVsSdiD, #069h					;Sine Test 3oCg
		acall		TxVsSdi						;SDIf[^M
		mov		fVsSdiD, #074h					;Sine Test 4oCg
		acall		TxVsSdi						;SDIf[^M
		mov		fVsSdiD, #0					;Sine Test 5..8oCg
		mov		A, #04d						;A : [vJE^
_Beep2:		acall		TxVsSdi						;SDIf[^M
		djnz		ACC, _Beep2					;A : A - 1A<> 0Ȃ烋[v
		;
		;							;r[vIt(Ȃ2񑗂ȂƃItɂȂȂ)
		mov		fVsSdiD, #045h					;Sine Test 1oCg
		acall		TxVsSdi						;SDIf[^M
		mov		fVsSdiD, #078h					;Sine Test 2oCg
		acall		TxVsSdi						;SDIf[^M
		mov		fVsSdiD, #069h					;Sine Test 3oCg
		acall		TxVsSdi						;SDIf[^M
		mov		fVsSdiD, #074h					;Sine Test 4oCg
		acall		TxVsSdi						;SDIf[^M
		mov		fVsSdiD, #0					;Sine Test 5..8oCg
		mov		A, #04d						;A : [vJE^
_Beep3:		acall		TxVsSdi						;SDIf[^M
		djnz		ACC, _Beep3					;A : A - 1A<> 0Ȃ烋[v
		;
		;							;VS1001
		pop		fVsVolume					;{[lA
		acall		InitVs						;\tgEFAZbg
		acall		SetVsVolume					;{[ݒ
		acall		SetVsClockf					;NbNݒ
		;
		pop		ACC
		ret
		;
PlayPowerupSnd:	;---------------------------------------;NĐ
		push		ACC
		push		DPL
		push		DPH
		;
		acall		InitVs						;\tgEFAZbg
		acall		SetVsVolume					;{[ݒ
		acall		SetVsClockf					;NbNݒ
		setb		pAnalogSwOn					;AiOXCb`I
		;
		mov		DPTR, #PowerupSndTop				;DPTR : Nf[^擪AhXŏ
		;
		setb		EX1						;INT1荞݋
		;
_PlayPUpSnd1:	setb		EA						;O[o荞݋
		orl		PCON, #00000001b				;IDLEZbg
		;
		;		Zzzzz.....					;̊荞݂܂ŏȓd͏
		;
		;							;荞݂ɂIDLE畜A
		clr		EA						;O[o荞݋֎~
		;
		;							;obed`FbN
		lcall		ReadBattVolts					;d
		mov		A, fBattVoltage					;A : obed(BCD2)
		add		A, #0 - 030h					;A < 3.0VȂL[Ȃ
		jc		_PlayPUpSnd2					;3.0VȏȂ玟
		;
		ljmp		OnFatalError					;3.0VȂvIG[
		;
_PlayPUpSnd2:	;							;XCb`XV`FbN
		mov		A, fSwStatus					;A : pSwPort̏
		jnz		_PlayPUpSnd0					;ǂꂩXCb`ꂽȂĐf
		;
_PlayPUpSnd4:	;							;VS1001 DREQ`FbN
		jnb		pVsDreq, _PlayPUpSnd1				;DREQ = "L"ȂĐXLbv
		;
_PlayPUpSnd3:	;							;VS1001փf[^M
		ReadFlash							;A : Mf[^
		mov		fVsSdiD, A					;fVsSdiD : Mf[^
		lcall		TxVsSdi						;SDIf[^M
		inc		DPTR						;DPTR : Đ|C^CNg
		mov		A, DPH						;A : Đ|C^(H)
		cjne		A, #HIGH PowerupSndEnd, _PlayPUpSnd4		;DPTR : Đ|C^ <> PowerupSndEndȂ烋[v
		;
		mov		A, DPL						;A : Đ|C^(L)
		cjne		A, #LOW  PowerupSndEnd, _PlayPUpSnd4		;DPTR : Đ|C^ <> PowerupSndEndȂ烋[v
		;
_PlayPUpSnd0:	;							;ĐI
		acall		InitVs						;\tgEFAZbg
		acall		SetVsVolume					;{[ݒ
		acall		SetVsClockf					;NbNݒ
		clr		pAnalogSwOn					;AiOXCb`It
		;
		pop		DPH
		pop		DPL
		pop		ACC
		ret
		;
TxSdCommand:	;---------------------------------------;SdCard R}hM
		;					;  f[^[hɂReadSdSectorg
		;					;  fSdCommand : R}h(6oCg)
		;					;  fSdResponse : X|X(1oCg)A0ffhȂ^CAEg
		push		ACC
		push		PSW
		SelectRegBank	rbTxSdCommand					;WX^oNؑ
		;
		clr		pSdCs						;CsAT[g
		mov		A, fSdCommand + 0				;A : R}hԍ
		orl		A, #040h					;R}htH[}bgrbgݒ
		TxSpi0		A						;R}h(0)M
		TxSpi0		fSdCommand + 1					;R}h(1)M
		TxSpi0		fSdCommand + 2					;R}h(2)M
		TxSpi0		fSdCommand + 3					;R}h(3)M
		TxSpi0		fSdCommand + 4					;R}h(4)M
		TxSpi0		fSdCommand + 5					;R}h(5)M
		mov		fTxSdCmdLCtrL, #LOW  02000d			;[vJE^(L)
		mov		fTxSdCmdLCtrH, #HIGH 02000d			;[vJE^(H)
_TxSdCommand1:	RxSpi0		A						;A : SPIM
		cjne		A, #0ffh, _TxSdCommand2				;A <> 0ffhȂWv
		;
		SubYYA16	fTxSdCmdLCtrH, fTxSdCmdLCtrL, #0, #1		;fTxSdCmdLCtr : fTxSdCmdLCtr - 1
		mov		A, fTxSdCmdLCtrH				;A : fTxSdCmdLCtrH
		orl		A, fTxSdCmdLCtrL				;A : fTxSdCmdLCtrH | fTxSdCmdLCtrL
		jnz		_TxSdCommand1					;fTxSdCmdLCtr <> 0Ȃ烋[v
		;
		mov		A, #0ffh					;A : ^CAEg
		;
_TxSdCommand2:	mov		fSdResponse, A					;X|XXV
		setb		pSdCs						;CslQ[g
		TxSpi0		#0ffh						;DataOutnCCs[_Xɂ邽߂̃_~[o
		WaitSpi0End							;MI҂
		;
		pop		PSW						;WX^oNA
		pop		ACC
		ret
		;
InitSd:		;---------------------------------------;SdCard 
		push		ACC
		push		PSW
		SelectRegBank	rbInitSd					;WX^oNؑ
		;
		;							;CsAT[gO80NbNo
		mov		fInitSdLCtrL, #010d				;[vJE^
_InitSd1:	TxSpi0		#0ffh						;NbN̂ݏo
		djnz		fInitSdLCtrL, _InitSd1				;fInitSdLCtrL : fInitSdLCtrL - 1A<> 0Ȃ烋[v
		;
		WaitSpi0End							;MI҂
		;
		;							;CMD0s
		mov		fInitSdLCtrL, #LOW  02000d			;[vJE^(L)
		mov		fInitSdLCtrH, #HIGH 02000d			;[vJE^(H)
		mov		fSdCommand + 0, #000h				;CMD0
		mov		fSdCommand + 1, #000h				;Argument3
		mov		fSdCommand + 2, #000h				;Argument2
		mov		fSdCommand + 3, #000h				;Argument1
		mov		fSdCommand + 4, #000h				;Argument0
		mov		fSdCommand + 5, #095h				;CRC
_InitSd2:	lcall		TxSdCommand					;R}hs
		mov		A, fSdResponse					;A : X|X
		inc		A						;A : A + 1
		jz		_InitSd3					;X|X = 0ffhȂWv
		;
		mov		A, fSdResponse					;A : X|X
		dec		A						;A : A - 1
		jz		_InitSd3					;X|X = 001hȂWv
		;
		SubYYA16	fInitSdLCtrH, fInitSdLCtrL, #0, #1		;fInitSdLCtr : fInitSdLCtr - 1
		mov		A, fInitSdLCtrH					;A : fInitSdLCtrH
		orl		A, fInitSdLCtrL					;A : fInitSdLCtrH | fInitSdLCtrL
		jnz		_InitSd2					;fInitSdLCtr <> 0Ȃ烋[v
		;
		mov		fSdResponse, #0ffh				;fSdResponse : ^CAEg
		sjmp		_InitSd0					;Wv
		;
_InitSd3:	;							;CMD1s
		mov		fInitSdLCtrL, #LOW  02000d			;[vJE^(L)
		mov		fInitSdLCtrH, #HIGH 02000d			;[vJE^(H)
		mov		fSdCommand + 0, #001h				;CMD1
_InitSd4:	lcall		TxSdCommand					;R}hs
		mov		A, fSdResponse					;A : X|X
		inc		A						;A : A + 1
		jz		_InitSd0					;X|X = 0ffhȂWv
		;
		mov		A, fSdResponse					;A : X|X
		jz		_InitSd0					;X|X = 000hȂWv
		;
		SubYYA16	fInitSdLCtrH, fInitSdLCtrL, #0, #1		;fInitSdLCtr : fInitSdLCtr - 1
		mov		A, fInitSdLCtrH					;A : fInitSdLCtrH
		orl		A, fInitSdLCtrL					;A : fInitSdLCtrH | fInitSdLCtrL
		jnz		_InitSd4					;fInitSdLCtr <> 0Ȃ烋[v
		;
_InitSd0:	pop		PSW						;WX^oNA
		pop		ACC
		ret
		;
ReadSdSector:	;---------------------------------------;SdCard ZN^[h
		;					;  1ZN^̃f[^(512oCg)XRAMɓǂݍ
		;					;  fSdSectorNo : ZN^ԍ(3oCg)
		;					;  fSdResponse : X|X(1oCg)
		;					;  C : 0 = IA1 = G[
		push		ACC
		push		DPL
		push		DPH
		;
		clr		C						;CNA
		mov		A, fSdSectorNo + 2				;A : ZN^ԍ(7..0)
		rlc		A						;A : ZN^ԍ(6..0):0
		mov		fSdCommand + 3, A				;[hAhX(15..8)XV
		mov		A, fSdSectorNo + 1				;A : ZN^ԍ(15..8)
		rlc		A						;A : ZN^ԍ(14..7)
		mov		fSdCommand + 2, A				;[hAhX(23..16)XV
		mov		A, fSdSectorNo + 0				;A : ZN^ԍ(23..16)
		rlc		A						;A : ZN^ԍ(22..15)
		mov		fSdCommand + 1, A				;[hAhX(31..24)XV
		mov		DPTR, #0000h					;DPTR
		;
_ReadSdSector7:	clr		pSdCs						;CsAT[g
_ReadSdSector3:	RxSpi0		A						;A : SPIM
		cjne		A, #0ffh, _ReadSdSector3			;Mf[^ <> 0ffhȂ炳ɎM
		;
		TxSpi0		#017d + 040h					;READ_SINGLE_BLOCKR}hM
		TxSpi0		fSdCommand + 1					;AhX(31..24)M
		TxSpi0		fSdCommand + 2					;AhX(23..16)M
		TxSpi0		fSdCommand + 3					;AhX(15..8)M
		TxSpi0		#000h						;AhX(7..0)M
		TxSpi0		#095h						;CRC(_~[)M
_ReadSdSector1:	RxSpi0		A						;A : SPIM
		cjne		A, #0feh, _ReadSdSector1			;Mf[^ <> 0fehȂ烋[v
		;
		;								;***** gCKv
		;
_ReadSdSector5:	mov		fSdResponse, A					;X|XXV
		;
		RxSpi0		A						;A : SPIM
		movx		@DPTR, A					;Mf[^XV
		inc		DPTR						;DPTR : DPTR + 1
		mov		A, DPH
		cjne		A, #002h, _ReadSdSector5			;DPTR < 512Ȃ烋[v
		;
		RxSpi0		A						;A : CRCM(_~[)
		RxSpi0		A						;A : CRCM(_~[)
		;
		clr		C						;CNA
		;
_ReadSdSector0:	setb		pSdCs						;CslQ[g
		TxSpi0		#0ffh						;DataOutnCCs[_Xɂ邽߂̃_~[o
		WaitSpi0End							;MI҂
		;
		pop		DPH
		pop		DPL
		pop		ACC
		ret
		;
GetSdBpbInfo:	;---------------------------------------;SdCard BPB̏擾
		;					;  WX^oNrbGetSdBpbInfogp
		;					;  C : 0 = IA1 = G[
		push		ACC
		push		PSW
		push		DPL
		push		DPH
		SelectRegBank	rbGetSdBpbInfo					;WX^oNؑ
		;
		mov		fSdSectorNo + 2, #000h				;ZN^0(MBR)
		mov		fSdSectorNo + 1, #000h				;ZN^0(MBR)
		mov		fSdSectorNo + 0, #000h				;ZN^0(MBR)
		lcall		ReadSdSector					;MBRǂݍ
		jnc		_GetSdBpbInfo2					;C = 0ȂWv
		;
		ajmp		_GetSdBpbInfoE					;C = 1ȂG[
		;
_GetSdBpbInfo2:	mov		DPTR, #0446d + 008d				;DPTR : 0446d + 008d
		movx		A, @DPTR					;A : BPB擪ZN^(L)
		mov		fSdSectorNo + 2, A				;fSdSectorNo0XV
		inc		DPTR						;DPTR : 0446d + 009d
		movx		A, @DPTR					;A : BPB擪ZN^(H)
		mov		fSdSectorNo + 1, A				;fSdSectorNo1XV
		mov		fSdSectorNo + 0, #000h				;fSdSectorNo2XV
		lcall		ReadSdSector					;BPBǂݍ
		jc		_GetSdBpbInfoE					;C = 1ȂG[
		;
		mov		DPTR, #011d					;DPTR : 011d
		movx		A, @DPTR					;A : BPB_BytsPerSec(L) : ZN^̃oCg(L)
		cjne		A, #LOW 0512d, _GetSdBpbInfoE			;A <> 512(L)ȂG[
		;
		inc		DPTR						;DPTR : 012d
		movx		A, @DPTR					;A : BPB_BytsPerSec(H) : ZN^̃oCg(H)
		cjne		A, #HIGH 0512d, _GetSdBpbInfoE			;A <> 512(H)ȂG[
		;
		inc		DPTR						;DPTR : 013d
		movx		A, @DPTR					;A : BPB_SecPerClus : NX^̃ZN^
		mov		fSecPerClus, A					;fSecPerClusXV
		;
		inc		DPTR						;DPTR : 014d
		movx		A, @DPTR					;A : BPB_RsvdSecCnt(L) : \ZN^(L)
		add		A, fSdSectorNo + 2				;A : BPB擪ZN^(L) + \ZN^(L)
		mov		fFirstFatSec + 1, A				;fFirstFatSec(L)XV
		;
		inc		DPTR						;DPTR : 015d
		movx		A, @DPTR					;A : BPB_RsvdSecCnt(H) : \ZN^(H)
		addc		A, fSdSectorNo + 1				;A : BPB擪ZN^(H) + \ZN^(H) + C
		mov		fFirstFatSec + 0, A				;fFirstFatSec(H)XV
		;
		inc		DPTR						;DPTR : 016d
		movx		A, @DPTR					;A : BPB_NumFATs : FAT̐
		mov		fNumFats, A					;fNumFatsɃXgA
		;
		inc		DPTR						;DPTR : 017d
		movx		A, @DPTR					;A : BPB_RootEntCnt(L) : [gfBNgGg(L)
		mov		fRootEntCntL, A					;fRootEntCntLɃXgA
		;
		inc		DPTR						;DPTR : 018d
		movx		A, @DPTR					;A : BPB_RootEntCnt(H) : [gfBNgGg(H)
		mov		fRootEntCntH, A					;fRootEntCntHɃXgA
		orl		A, fRootEntCntL					;A : BPB_RootEntCnt(H + L)
		jz		_GetSdBpbInfoE					;A = 0ȂFAT32Ȃ̂ŖT|[g
		;
		mov		DPTR, #022d					;DPTR : 022d
		movx		A, @DPTR					;A : BPB_FATSz16(L) : FAT̃ZN^(L)
		mov		fFatSizeL, A					;fFatSizeLɃXgA
		;
		inc		DPTR						;DPTR : 023d
		movx		A, @DPTR					;A : BPB_FATSz16(H) : FAT̃ZN^(H)
		mov		fFatSizeH, A					;fFatSizeHɃXgA
		;
		cjne		fNumFats, #2, _GetSdBpbInfo1			;FAT̐ <> 2ȂWv
		;
		ShiftL16	fFatSizeH, fFatSizeL				;fFatSize : FAT̃ZN^ * 2
		;
_GetSdBpbInfo1:	;cjne		fNumFats, #1, _GetSdBpbInfoE			;FAT̐ <> 1ȂG[ƌȂ
		;
		AddYAB16	fFirstRootSec + 0, fFirstRootSec + 1, fFirstFatSec + 0, fFirstFatSec + 1, fFatSizeH, fFatSizeL
		;								;fFirstRootSec : FAT̐擪ZN^ԍ + (FAT̃ZN^ * FAT̐)
		;
		ShiftR16	fRootEntCntH, fRootEntCntL			;fRootEntCnt : [gfBNgGg / 2 (A͔j)
		ShiftR16	fRootEntCntH, fRootEntCntL			;fRootEntCnt : [gfBNgGg / 4
		ShiftR16	fRootEntCntH, fRootEntCntL			;fRootEntCnt : [gfBNgGg / 8
		ShiftR16	fRootEntCntH, fRootEntCntL			;fRootEntCnt : [gfBNgGg / 16 (= [gfBNg̃ZN^)
		AddYAB16	fFirstDataSec + 0, fFirstDataSec + 1, fFirstRootSec + 0, fFirstRootSec + 1, fRootEntCntH, fRootEntCntL
		;								;fFirstDataSec : [gfBNgGg̐擪ZN^ԍ + [gfBNg̃ZN^
		mov		A, #000h					;I
		sjmp		_GetSdBpbInfo0					;Wv
		;
_GetSdBpbInfoE:	mov		A, #001h					;G[
		;
_GetSdBpbInfo0:	pop		DPH
		pop		DPL
		pop		PSW						;WX^oNA
		rrc		A						;C : IXe[^X
		pop		ACC
		ret
		;
SeekMp3File:	;---------------------------------------;".MP3"t@CT
		;					;  fFileNo : Ԗڂ".MP3"t@CT
		;					;  eϐ
		;					;  C : 0 = IA1 = G[A܂͌Ȃ
		push		ACC
		push		PSW
		push		DPL
		push		DPH
		SelectRegBank	rbSeekMp3File					;WX^oNؑ
		;
		mov		fFoundFileCtr, #0				;fFoundFileCtr : MP3t@CJE^
		mov		fSdSectorNo + 0, #000h				;0Ōߑł
		mov		fSdSectorNo + 1, fFirstRootSec + 0
		mov		fSdSectorNo + 2, fFirstRootSec + 1		;fSdSectorNo : [gfBNgGg̐擪ZN^ԍ
_SeekMp3File5:	lcall		ReadSdSector					;Gg̃ZN^[h
		jnc		_SeekMp3File6					;C = 0ȂG[Ȃ
		;
		ljmp		_SeekMp3FileE					;C = 1ȂG[
		;
_SeekMp3File6:	mov		DPTR, #0					;DPTR : ZN^|C^
		;
_SeekMp3File3:	mov		fDptrSaveL, DPL
		mov		fDptrSaveH, DPH					;fDptrSave : ZN^|C^ۑ
		movx		A, @DPTR					;A : DIR_Name[0]
		cjne		A, #0e5h, _SeekMp3File1				;A <> 0e5h(󂫃Gg)ȂWv
		;
		sjmp		_SeekMp3File2					;̃Gg
		;
_SeekMp3File1:	AddYYA16	DPH, DPL, #0, #008d				;DPTR : GgItZbg = 8
		movx		A, @DPTR					;A : DIR_Name[8]
		cjne		A, #"M", _SeekMp3File2				;A <> "M"Ȃ玟̃Gg
		;
		inc		DPTR						;DPTR : GgItZbg = 9
		movx		A, @DPTR					;A : DIR_Name[9]
		cjne		A, #"P", _SeekMp3File2				;A <> "P"Ȃ玟̃Gg
		;
		inc		DPTR						;DPTR : GgItZbg = 10
		movx		A, @DPTR					;A : DIR_Name[10]
		cjne		A, #"3", _SeekMp3File2				;A <> "3"Ȃ玟̃Gg
		;
		inc		DPTR						;DPTR : GgItZbg = 11
		movx		A, @DPTR					;A : DIR_Attr
		anl		A, #018h					;A : ATTR_DIRECTORYATTR_VOLUME_IDrbg𒊏o
		jnz		_SeekMp3File2					;A : LrbgZbgȂ玟̃Gg
		;
		inc		fFoundFileCtr					;fFoundFileCtr : MP3t@CJE^ + 1
		mov		A, fFoundFileCtr				;
		cjne		A, fFileNo, _SeekMp3File2			;A <> fFileNoȂ玟̃Gg
		;
		AddYYA16	DPH, DPL, #0, #015d				;DPTR : GgItZbg = 26
		movx		A, @DPTR					;A : DIR_FstClusLO(L)
		mov		fFileClusterNo + 1, A				;
		inc		DPTR						;DPTR : GgItZbg = 27
		movx		A, @DPTR					;A : DIR_FstClusLO(H)
		mov		fFileClusterNo + 0, A				;fFileClusterNo
		inc		DPTR						;DPTR : GgItZbg = 28
		movx		A, @DPTR					;A : DIR_FIleSize(0)
		mov		fFileSize + 3, A				;
		mov		fRemainBytes + 3, A				;
		inc		DPTR						;DPTR : GgItZbg = 29
		movx		A, @DPTR					;A : DIR_FIleSize(1)
		mov		fFileSize + 2, A				;
		mov		fRemainBytes + 2, A				;
		inc		DPTR						;DPTR : GgItZbg = 30
		movx		A, @DPTR					;A : DIR_FIleSize(2)
		mov		fFileSize + 1, A				;
		mov		fRemainBytes + 1, A				;
		inc		DPTR						;DPTR : GgItZbg = 31
		movx		A, @DPTR					;A : DIR_FIleSize(3)
		mov		fFileSize + 0, A				;fFileSize
		mov		fRemainBytes + 0, A				;fRemainBytes
		mov		fFileSectorCnt, #0				;fFileSectorCnt
		;
		clr		A						;I
		sjmp		_SeekMp3File0					;Wv
		;
_SeekMp3File4:	sjmp		_SeekMp3File5					;_SeekMp3File5ւ̓ݑ
		;
_SeekMp3File2:	mov		DPL,  fDptrSaveL				;
		mov		DPH,  fDptrSaveH				;DPTR : ZN^|C^𕜋A
		AddYYA16	DPH, DPL, #0, #032d				;DPTR : DPTR + 32 = ̃Gg
		mov		A, DPH						;A : ZN^|C^(H)
		cjne		A, #002h, _SeekMp3File3				;DPTR < 512ȂWv
		;
		AddYYA16	fSdSectorNo + 1, fSdSectorNo + 2, #0, #1	;GgZN^ԍCNg
		mov		A, fSdSectorNo + 2				;A : GgZN^ԍ(L)
		cjne		A, fFirstDataSec + 1, _SeekMp3File4		;A <> fFirstDataSec(L)ȂWv
		;
		mov		A, fSdSectorNo + 1				;A : GgZN^ԍ(H)
		cjne		A, fFirstDataSec + 0, _SeekMp3File4		;A <> fFirstDataSec(H)ȂWv
		;
_SeekMp3FileE:	mov		fMp3Files, fFoundFileCtr			;fMp3Files : ܂łŌMP3t@C̐
		mov		A, #001h					;G[
		;
_SeekMp3File0:	pop		DPH
		pop		DPL
		pop		PSW						;WX^oNA
		rrc		A						;C : IXe[^X
		pop		ACC
		ret
		;
ReadFileData:	;---------------------------------------;t@C1ZN^ǂݍ
		;					;  fFileClusterNo : [hNX^ԍ
		;					;  fFileSectorCnt : NX^̒Ń[hZN^ԍ
		;					;  C : 0 = IA1 = G[
		push		ACC
		;
		mov		fSdSectorNo + 0, #0				;
		mov		fSdSectorNo + 1, fFileClusterNo + 0		;
		mov		fSdSectorNo + 2, fFileClusterNo + 1		;fSdSectorNo : [hNX^ԍ
		SubYYA16	fSdSectorNo + 1, fSdSectorNo + 2, #0, #2	;fSdSectorNo : [hNX^ԍ - 2
		mov		A, fSecPerClus					;A : NX^̃ZN^
_ReadFileData1:	jb		ACC.0, _ReadFileData2				;ACC.0ZbgȂVtgI
		;
		push		ACC						;Aۑ
		ShiftL24	fSdSectorNo + 0, fSdSectorNo + 1, fSdSectorNo + 2
		;								;fSdSectorNo : fSdSectorNo * 2
		pop		ACC						;AA
		rr		A						;A : A / 2
		sjmp		_ReadFileData1					;[v
		;
_ReadFileData2:	AddYYA24	fSdSectorNo + 0, fSdSectorNo + 1, fSdSectorNo + 2, #0, fFirstDataSec + 0, fFirstDataSec + 1
		;								;fSdSectorNo : ([hNX^ԍ - 2) * NX^̃ZN^ + f[^̈̐擪ZN^ԍ
		AddYYA24	fSdSectorNo + 0, fSdSectorNo + 1, fSdSectorNo + 2, #0, #0, fFileSectorCnt
		;								;fSdSectorNo : ([hNX^ԍ - 2) * NX^̃ZN^ + f[^̈̐擪ZN^ԍ + NX^̒Ń[hZN^ԍ
		lcall		ReadSdSector					;ZN^[h
		;
		pop		ACC
		ret
		;
FindNextCS:	;---------------------------------------;ɓǂݍނׂf[^̃NX^ԍEZN^ԍ擾
		;					;  fFileClusterNo : [hNX^ԍ
		;					;  fFileSectorCnt : NX^̒Ń[hZN^ԍ
		;					;  C : 0 = IA1 = G[
		push		ACC
		push		DPL
		push		DPH
		;
		inc		fFileSectorCnt					;fFileSectorCnt : NX^̒Ń[hZN^ԍCNg
		mov		A, fFileSectorCnt				;A : NX^̒Ń[hZN^ԍ
		cjne		A, fSecPerClus, _FindNextCS0			;A <> NX^̃ZN^ȂWv
		;
		mov		fSdSectorNo + 0, #0				;
		mov		fSdSectorNo + 1, #0				;
		mov		fSdSectorNo + 2, fFileClusterNo + 0		;fSdSectorNo : [hNX^ԍ / (512 / 2)
		AddYYA24	fSdSectorNo + 0, fSdSectorNo + 1, fSdSectorNo + 2, #0, fFirstFatSec + 0, fFirstFatSec + 1
		;								;fSdSectorNo : FAT܂܂ZN^
		lcall		ReadSdSector					;ZN^[h
		jc		_FindNextCS0					;C = 1ȂG[I
		;
		mov		DPL, fFileClusterNo + 1				;
		mov		DPH, #0						;DPTR : [hNX^ԍ(L)
		ShiftL16	DPH, DPL					;DPTR : [hNX^ԍ(L) * 2 = FATւ̃|C^
		movx		A, @DPTR					;A : FAT(L)
		mov		fFileClusterNo + 1, A				;fFileClusterNo(L) : Ƀ[hNX^ԍ(L)
		inc		DPTR						;DPTR : DPTR + 1
		movx		A, @DPTR					;A : FAT(H)
		mov		fFileClusterNo + 0, A				;fFileClusterNo(H) : Ƀ[hNX^ԍ(H)
		mov		fFileSectorCnt, #0				;NX^̒Ń[hZN^ԍ
		clr		C						;I
		;
_FindNextCS0:	pop		DPH
		pop		DPL
		pop		ACC
		ret
		;
;FindPrevCS:	;---------------------------------------;݂̂ЂƂÕNX^ԍEZN^ԍ擾
;		;					;  fFileClusterNo : [hNX^ԍ
;		;					;  fFileSectorCnt : NX^̒Ń[hZN^ԍ
;		;					;  C : 0 = IA1 = G[
;		push		ACC
;		push		PSW
;		SelectRegBank	rbFindPrevCS					;WX^oNؑ
;		;
;		mov		fSaveClusterNo, fFileClusterNo			;fSaveClusterNo : fFileClusterNoۑ
;		mov		fSaveSectorCnt, fFileSectorCnt			;fSaveSectorCnt : fFileSectorCntۑ
;		mov		fPrevClusterNo, fFileClusterNo			;fPrevClusterNo : fFileClusterNoRs[
;		mov		fPrevSectorCnt, fFileSectorCnt			;fPrevSectorCnt : fFileSectorCntRs[
;		;
;		lcall		SeekMp3File					;t@CTAfMp3FilesXV
;		jc		_FindPrevCSE					;G[ȂWv
;		;
;_FindPrevCS2:	mov		A, fSaveClusterNo				;A : ۑĂfSaveClusterNo
;		cjne		A, fFileClusterNo, _FindPrevCS1			;fSaveClusterNo <> fFileClusterNoȂWv
;		;
;		mov		A, fSaveSectorCnt				;A : ۑĂfSaveSectorCnt
;		cjne		A, fFileSectorCnt, _FindPrevCS1			;fSaveSectorCnt <> fFileSectorCntȂWv
;		;
;		;							;fSave*fFile*vꍇATI
;		mov		fFileClusterNo, fPrevClusterNo			;fFileClusterNo : fPrevClusterNoRs[
;		mov		fFileSectorCnt, fPrevSectorCnt			;fFileSectorCnt : fPrevSectorCntRs[
;		clr		A						;I
;		sjmp		_FindPrevCS0					;Wv
;		;
;_FindPrevCS1:	;							;fSave*fFile*vȂꍇÃZN^
;		lcall		FindNextCS					;ɓǂݍނׂf[^̃NX^ԍEZN^ԍ擾
;		jc		_FindPrevCSE					;G[ȂWv
;		;
;		sjmp		_FindPrevCS2					;vrփ[v
;		;
;_FindPrevCSE:	mov		A, #001h					;G[
;		;
;_FindPrevCS0:	pop		PSW						;WX^oNA
;		rrc		A						;C : IXe[^X
;		pop		ACC
;		ret
;		;
CheckRemain:	;---------------------------------------;Đf[^cĂ邩ǂ̃`FbN
		;					;  fRemainBytes : f[^t@C̍ĐcoCg
		;					;  A : 0 = cȂA1 = c肠
		mov		A, fRemainBytes + 3				;A : fRemainBytes(3)
		orl		A, fRemainBytes + 2				;A : fRemainBytes(3 | 2)
		orl		A, fRemainBytes + 1				;A : fRemainBytes(3 | 2 | 1)
		orl		A, fRemainBytes + 0				;A : fRemainBytes(3 | 2 | 1 | 0)
		;
		ret
		;
MakeSdCheckD:	;---------------------------------------;SDJ[h`FbNpf[^
		;					;  fSdCheckData : fMp3Files + fFileSize
		push		ACC
		;
		mov		fSdCheckData + 0, fFileSize + 0			;
		mov		fSdCheckData + 1, fFileSize + 1			;
		mov		fSdCheckData + 2, fFileSize + 2			;
		mov		fSdCheckData + 3, fFileSize + 3			;fSdCheckData : J[hopf[^fFileSizeŏ
		AddYYA32	fSdCheckData + 0, fSdCheckData + 1, fSdCheckData + 2, fSdCheckData + 3, #0, #0, #0, fMp3Files	
		;								;fSdCheckData : fMp3Files + fFileSize
		;
		pop		ACC
		ret
		;
OnFatalError:	;---------------------------------------;vIG[
		;					;  G[ʒmr[v̌AVbg_E
		clr		EA						;S荞݋֎~
		MakeBeep	cBeepNoteL, cBeepTimeErr			;r[v(ቹ)
		mov		A, #0100d					;0.1b҂
		lcall		WaitAmsec					;Amsec҂
		MakeBeep	cBeepNoteL, cBeepTimeErr			;r[v(ቹ)
		ljmp		ShutDown				;Vbg_E
		;
LoadNvParams:	;---------------------------------------;sԕA
		push		ACC
		push		PSW
		push		DPL
		push		DPH
		SelectRegBank	rbLoadNvParams					;WX^oNؑ
		;
		mov		DPTR, #NvAreaTop				;DPTR : ԕۑ̈擪AhX
		mov		fLoadNvPrmsLCtr, #cNvParamEnd - cNvParamTop	;fLoadNvPrmsLCtr : [vJE^
		mov		fLoadNvPrmsDPtr, #cNvParamTop			;fLoadNvPrmsDPtr
_LoadNvParams1:	ReadFlash							;A : [hf[^
		mov		@fLoadNvPrmsDPtr, A				;f[^A
		inc		DPTR						;DPTR + 1
		inc		fLoadNvPrmsDPtr					;fLoadNvPrmsDPtr + 1
		djnz		fLoadNvPrmsLCtr, _LoadNvParams1			;fLoadNvPrmsLCtr - 1A<> 0Ȃ烋[v
		;
		mov		fRepeatMode, fRepeatModeSav			;fRepeatModeSavfRepeatModeփRs[
		;
		pop		DPH
		pop		DPL
		pop		PSW						;WX^oNA
		pop		ACC
		ret
		;
SaveNvParams:	;---------------------------------------;s֏ԕۑ
		push		ACC
		push		PSW
		push		DPL
		push		DPH
		push		IE
		SelectRegBank	rbSaveNvParams					;WX^oNؑ
		;
		clr		EA						;S荞݋֎~
		mov		fRepeatModeSav, fRepeatMode			;fRepeatModefRepeatModeSavփRs[
		lcall		MakeSdCheckD					;SDJ[h`FbNpf[^
		;
		;							;ԕۑ̈
		mov		DPTR, #NvAreaTop				;DPTR : ԕۑ̈擪AhX
		orl		PSCTL, #00000011b				;PSEEAPSWEZbg
		clr		A						;A : 0(_~[)
		WriteFlash							;݂ɂ
		anl		PSCTL, #NOT (00000010b)				;PSEENA
		;							;ԕۑ
		mov		fSaveNvPrmsLCtr, #cNvParamEnd - cNvParamTop	;fSaveNvPrmsLCtr : [vJE^
		mov		fSaveNvPrmsDPtr, #cNvParamTop			;fSaveNvPrmsDPtr
_SaveNvParams1:	mov		A, @fSaveNvPrmsDPtr				;A : ۑf[^
		WriteFlash							;ۑ
		inc		DPTR						;DPTR + 1
		inc		fSaveNvPrmsDPtr					;fSaveNvPrmsDPtr + 1
		djnz		fSaveNvPrmsLCtr, _SaveNvParams1			;fSaveNvPrmsLCtr - 1A<> 0Ȃ烋[v
		;
		anl		PSCTL, #NOT (00000001b)				;PSWENA
		;
		pop		IE
		pop		DPH
		pop		DPL
		pop		PSW					;WX^oNA
		pop		ACC
		ret
		;
		;===============================================================
		;	Interrupt Service Routines
		;
IsrTimer2:	;---------------------------------------;Timer2荞ݏ : [UC^[tF[X
		;					;  fSwStatus*̐邱Ƃɒ
		push		ACC
		push		PSW
		;
		clr		TF2H						;TF2HNA
		;
		mov		fSwStatus0to1, fSwStatus			;fSwStatus0to1fSwStatus̑OlRs[Ă
		mov		fSwStatus1to0, fSwStatus			;fSwStatus1to0fSwStatus̑OlRs[Ă
		mov		A, pSwPort					;XCb`(l)
		cpl		A						;_]Đ_ɂ
		mov		fSwPortSave, A					;fSwPortSaveɈꎞۑ
		xrl		A, fSwPortPrev					;A : Ol xor l
		anl		fSwStatus, A					;fSwStatusɂđOl = l̃rbĝ݃NA
		cpl		A						;A : Ol = l̃rbĝ1
		anl		A, fSwPortSave					;A : fSwPortSaveɂđOl = l̃rbg𒊏o
		orl		A, fSwStatus					;A : fSwStatusɂđOl = l̃rbgXV
		anl		A, #cSwBitMask					;A : XCb`̓rbĝݒo
		mov		fSwStatus, A					;fSwStatusXV
		xrl		fSwStatus0to1, A				;fSwStatus0to1 : fSwStatusɂđOl <> l̃rbĝ1
		anl		fSwStatus0to1, A				;fSwStatus0to1 : ((Ol <> l) and (l = 1))̃rbĝ1
		xrl		fSwStatus1to0, A				;fSwStatus1to0 : fSwStatusɂđOl <> l̃rbĝ1
		cpl		A						;]
		anl		fSwStatus1to0, A				;fSwStatus1to0 : ((Ol <> l) and (l = 0))̃rbĝ1
		mov		fSwPortPrev, fSwPortSave			;fSwPortPrevXV
		setb		fPlayMode.bPmSwUpdate				;PmSwUpdatetOZbg
		;
		inc		fTimer2Ctr					;Timer2荞݃JE^XV
		;
		pop		PSW
		pop		ACC
		reti
		;
IsrInt1:	;---------------------------------------;Int1荞ݏ : VS1001 DREQɂċN
		reti								;IDLE畜A邾
		;
		;===============================================================
		;	Power-up Sound Data
		;
		cseg		at	01000h		;ԕۑp̈
		;
PowerupSndTop:	;
		;
;		$include	(KDE_Dialog_Disappear.inc)			;Nf[^@܂ςƂȂ̂ł܂r[vɖ߂
		;
PowerupSndEnd:	;
		;
		;===============================================================
		;	Non-volatile Parameter(s)
		;
		cseg		at	01a00h		;ԕۑp̈
		;
NvAreaTop:	ds		cNvParamEnd - cNvParamTop
		;
		;===============================================================
		;	End of Source
		;
		end
		;===============================================================
