		;***************************************************************
		;
		;	Title:		Timpy - Headphone
		;	Comment:	Tiny MP3 Player [ Timpy ] Rev4.0 wbhtH{̗pt@[EFA
		;	File Name:	Timpy-H.asm
		;	Version:	1.1
		;	(		Jan. 15, 2006	CjV[X)
		;	(ver1.1		Mar. 26, 2006	LM4911LM4924Ɍ)
		;	Last Update:	Mar. 26, 2006
		;	Copyright(C) 	Chiaki Nakajima
		;
		;***************************************************************
		;	Include File(s)
		;
		$pl		(65535)
		$pw		(132)
		$include	(c8051f310.inc)			;vZbTŗL`
		;
		;===============================================================
		;	Port Assign
		;
pSwF		bit		P0.0				;OXCb`
pSwR		bit		P0.1				;XCb`
pXtal1		bit		P0.2				;XTAL1
pXtal2		bit		P0.3				;XTAL2
pIrTx		bit		P0.4				;UART TX0
pIrRx		bit		P0.5				;UART RX0
pVsDreq		bit		P0.6				;VS1011 DREQ
pSpiSck		bit		P0.7				;SPI SCLK
pSpiMiso	bit		P1.0				;SPI MISO
pSpiMosi	bit		P1.1				;SPI MOSI
pSdCs		bit		P1.2				;SDCard CS(_)
pBattery	bit		P1.3				;obedo
pVsXdcs		bit		P1.4				;VS1011 xDCS(_)
pVsXcs		bit		P1.5				;VS1011 xCS(_)
pVsReset	bit		P1.6				;VS1011 xRESET(_)
pSmbSda		bit		P1.7				;SMBus SDA
pSmbScl		bit		P2.0				;SMBus SCL
pVsXtali	bit		P2.1				;VS1011 XTALI
pNsX1		bit		P2.2				;NS953M X1
pIrTxMod	bit		P2.3				;ԊOLEDϒo
pAmpSd		bit		P2.4				;LM4924 SD
pNsSto		bit		P2.5				;NS953M STO
pIrRxPwr	bit		P2.6				;ԊOW[d
pSwD		bit		P2.7				;XCb`
pSwU		bit		P3.0				;XCb`
pC2D		bit		P3.0				;C2D
		;
		;===============================================================
		;	Constant(s)
		;
;cSysclk	equ		24576000d			;24.576MHz : A51AZuł16rbg܂łȂ̂ł̐l͖
		;
cVsSciR		equ		00000011b			;VS1011 SCI Read Instruction Byte
cVsSciW		equ		00000010b			;VS1011 SCI Write Instruction Byte
cVsModeAddr	equ		000h				;VS1011 MODEWX^AhX
cVsStatusAddr	equ		001h				;VS1011 STATUSWX^AhX
cVsBassAddr	equ		002h				;VS1011 BASSWX^AhX
cVsClockfAddr	equ		003h				;VS1011 CLOCKFWX^AhX
cVsDecTimeAddr	equ		004h				;VS1011 DECODE_TIMEWX^AhX
cVsWramAddr	equ		006h				;VS1011 WRAMWX^AhX
cVsWramaddrAddr	equ		007h				;VS1011 WRAMADDRWX^AhX
cVsAiaddrAddr	equ		00ah				;VS1011 AIADDRWX^AhX
cVsVolAddr	equ		00bh				;VS1011 VOLWX^AhX
cVsAictrl0Addr	equ		00ch				;VS1011 AICTRL0WX^AhX
cVsSmReset	equ		1 SHL 002d			;SM_RESET
cVsSmPdown	equ		1 SHL 004d			;SM_PDOWN
cVsSmTests	equ		1 SHL 005d			;SM_TESTS
cVsSmSdiNew	equ		1 SHL 011d			;SM_SDINEW
cVsSmInit	equ		cVsSmSdiNew			;SCI_MODẼftHgl
cVsSsApdown2	equ		1 SHL 003d			;SS_APDOWN2
cVsVolume	equ		0000d				;VS1011 {[l
		;
bSwF		equ		0				;OXCb`rbgԍ
bSwU		equ		1				;XCb`rbgԍ
bSwD		equ		2				;XCb`rbgԍ
bSwR		equ		3				;XCb`rbgԍ
cSwBitMask	equ		(1 SHL bSwD) OR (1 SHL bSwR) OR (1 SHL bSwF) OR (1 SHL bSwU)	;XCb`rbg}XN
		;
cShutdown	equ		06000d				;CPU~܂ł̑҂(10msecP)
cOpModeReset	equ		01000d				;샂[hZbg܂ł̑҂(10msecP)
cBeepNoteL	equ		11100100b			;r[v : 375Hz
cBeepNoteM	equ		11101000b			;r[v : 750Hz
cBeepNoteH	equ		11110000b			;r[v : 1500Hz
cBeepAtt	equ		0006d				;r[v̉ʒߒ萔(1dBP)
cBeepTimeRepeat	equ		0100d				;s[g[hʒm̃r[v(msecP)
cBeepTimeChngRm	equ		0200d				;s[g[hύX̃r[v(msecP)
cBeepTimeOp	equ		0050d				;쎞̃r[v(msecP)
cBeepTimeBatt	equ		0070d				;obe`FbÑr[v(msecP)
cBeepTimeErr	equ		0150d				;G[̃r[v(msecP)
cBeepTimeShDn	equ		0250d				;Vbg_Ẽr[v(msecP)
		;
cFfRewSkipSecs	equ		0064d				;FF/REWɓǂݔ΂ZN^
cFfRewAtt	equ		0024d				;FF/REW̉ʒߒ萔(0.5dBP)
		;
cIrTxBuffer	equ		00210h				;ԊOMobt@̐擪AhX(XRAM)
cIrRxBuffer	equ		00200h				;ԊOMobt@̐擪AhX(XRAM)
cIrRxLength	equ		004d				;Mf[^oCg(Œ蒷)
cIrTxInterval	equ		003d				;M瑗Mւ̐؂ւC^[o(10msecP)
cIrRxTimeout	equ		005d				;M^CAEg(10msecP)
cIrStartCode	equ		055h				;X^[gR[h
cIrAck		equ		006h				;ACK
cIrNack		equ		015h				;NACK
cIrBusy		equ		011h				;BUSY
		;
		;===============================================================
		;	Data Area
		;
		;---------------------------------------;General Purpose Registers
		;					;  gp[`dȂ悤Ɋ蓖Ă
		dseg		at	000h				;WX^oN0
rbMain		equ		$						;MainɂĎgp
fParamCopySrc	set		R0						;p[^Rs[|C^
fParamCopyDst	set		R1						;p[^Rs[|C^
fIdleCtrH	equ		R2						;~ԃJE^(H)
fIdleCtrL	equ		R3						;~ԃJE^(L)
fNoOpCtrH	equ		R4						;쎞ԃJE^(H)
fNoOpCtrL	equ		R5						;쎞ԃJE^(L)
fLoopCtr	equ		R6						;ėp[vJE^
		;
		dseg		at	008h				;WX^oN1
rbGetSdBpbInfo	equ		$						;GetSdBpbInfoɂĎgp
fNumFats	equ		R0						;FAT̐
fRootEntCntH	equ		R1						;[gfBNgGg(H)
fRootEntCntL	equ		R2						;[gfBNgGg(L)
fFatSizeH	equ		R3						;FAT̃ZN^(H)
fFatSizeL	equ		R4						;FAT̃ZN^(L)
		;
rbSeekMp3File	equ		$						;SeekMp3FileɂĎgp
fFoundFileCtr	equ		R0						;MP3t@CJE^
fDirNestLevel	equ		R1						;fBNglXgx
fSubDirFound	equ		R2						;TufBNgtO
fFileNoSaved	equ		R3						;ʌfFileNoꎞۑWX^
fRetAddrH	equ		R4						;[JTu[`̃^[AhXޔWX^(H)
fRetAddrL	equ		R5						;[JTu[`̃^[AhXޔWX^(L)
		;
rbTxSdCommand	equ		$						;TxSdCommandɂĎgp
fTxSdCmdLCtrH	equ		R0						;[vJE^(H)
fTxSdCmdLCtrL	equ		R1						;[vJE^(L)
		;
rbMakeSdCheckD	equ		$						;MakeSdCheckDɂĎgp
fSdCheckDTmpH	equ		R0						;J[hopf[^WX^(H)
fSdCheckDTmpM	equ		R1						;J[hopf[^WX^(M)
fSdCheckDTmpN	equ		R2						;J[hopf[^WX^(N)
fSdCheckDTmpL	equ		R3						;J[hopf[^WX^(L)
		;
rbLoadNvParams	equ		$						;LoadNvParamsɂĎgp
fLoadNvPrmsLCtr	equ		R0						;[vJE^
fLoadNvPrmsDPtr	equ		R1						;f[^|C^
		;
rbSaveNvParams	equ		$						;SaveNvParamsɂĎgp
fSaveNvPrmsLCtr	equ		R0						;[vJE^
fSaveNvPrmsDPtr	equ		R1						;f[^|C^
		;
		dseg		at	010h				;WX^oN2
rbInitSd	equ		$						;InitSdɂĎgp
fInitSdLCtr	equ		R0						;[vJE^
		;
rbOpREW		equ		$						;OpREWɂĎgp
fSkipSecCtrH	equ		R0						;ǂݔ΂ZN^(H)
fSkipSecCtrM	equ		R1						;ǂݔ΂ZN^(M)
fSkipSecCtrL	equ		R2						;ǂݔ΂ZN^(L)
		;
rbIRComSync	equ		$						;IRComSyncɂĎgp
fParamCopySrc	set		R0						;p[^Rs[|C^
fParamCopyDst	set		R1						;p[^Rs[|C^
fTmpH		equ		R2						;e|t@C(H)
fTmpM		equ		R3						;e|t@C(M)
fTmpN		equ		R4						;e|t@C(N)
fTmpL		equ		R5						;e|t@C(L)
fTagByteCtr	equ		R6						;^Of[^oCgJE^
fPswSave	equ		R7						;PSWۑpWX^
		;
		dseg		at	018h				;WX^oN3
rbIsrUart0	equ		$						;IsrUart0ɂĎgp
fIrTxDataPtr	equ		R0						;Mobt@f[^|C^
fIrRxDataPtr	equ		R1						;Mobt@f[^|C^
fIrTxRemain	equ		R2						;MoCg
fIrCheckSum	equ		R3						;`FbNT
		;
		;---------------------------------------;Bit Addressable
		dseg		at	020h
fPlayMode:	ds		1						;vC[hoCg
bPmOpMode0	equ		0						;샂[h(rbg0)
bPmOpMode1	equ		1						;샂[h(rbg1)
bPmOpMode2	equ		2						;샂[h(rbg2)
bPmPlaying	equ		5						;~łȂԃZbgĂtO
bPmFm		equ		6						;FM[ĥƂZbg
bPmSwUpdate	equ		7						;[UC^[tF[X̂߂̊荞݂sꂽZbg
bmPmOpMode	equ		007h						;샂[hrbg}XN
cOmMp3Play	equ		0						;bPmFm = 0̂Ƃ : MP3ʏĐ[h
cOmMp3TrJump	equ		1						;bPmFm = 0̂Ƃ : gbNWv[h
cOmMp3DirJump	equ		2						;bPmFm = 0̂Ƃ : fBNgWv[h
cOmMp3FfRew	equ		3						;bPmFm = 0̂Ƃ : 芪߂[h
cOmMp3ToneCnt	equ		4						;bPmFm = 0̂Ƃ : g[Rg[ݒ胂[h
cOmMp3Repeat	equ		5						;bPmFm = 0̂Ƃ : s[gݒ胂[h
cOmFmPlay	equ		0						;bPmFm = 1̂Ƃ : FMʏM[h
cOmFmSelectSt	equ		1						;bPmFm = 1̂Ƃ : vZbgǑI[h
cOmFmSearchSt	equ		2						;bPmFm = 1̂Ƃ : ǃT[`[h
cOmFmTuneManu	equ		3						;bPmFm = 1̂Ƃ : }jAIǃ[h
cOmFmToneCnt	equ		4						;bPmFm = 1̂Ƃ : g[Rg[ݒ胂[h
		;
fIrMode:	ds		1						;ԊOʐM[hoCg
bImActive	equ		0						;ʐMtO
bImRx		equ		1						;MtO
bImRxDataReady	equ		2						;MtO
bImTxReq	equ		3						;MJnvtO
bImTxInterval	equ		4						;MJnC^[otO
bImTx		equ		5						;MtO
		;
cIRComStatReq	equ		000d						;Xe[^XNGXgR}h
cIRComSync	equ		001d						;VNR}h
cIRComResend	equ		002d						;ÕpPbgđR}h
cIRComVolUp	equ		003d						;{[AbvR}h
cIRComVolDn	equ		004d						;{[_ER}h
cIRComTreble	equ		005d						;拭ݒR}h
cIRComBass	equ		006d						;拭ݒR}h
cIRComMp3Stop	equ		007d						;MP3XgbvR}h
cIRComMp3Play	equ		008d						;MP3vCR}h
cIRComMp3Jump	equ		009d						;MP3WvR}h
cIRComMp3FfRew	equ		010d						;MP3芪߂R}h
cIRComMp3Repeat	equ		011d						;MP3s[gݒR}h
cIRComFmStop	equ		012d						;FMWIIt
cIRComFmPlay	equ		013d						;FMWII
cIRComFmJump	equ		014d						;FMvZbgǑIR}h
cIRComFmSearch	equ		015d						;FMI[gT[`R}h
cIRComFmManual	equ		016d						;FM}jAIǃR}h
cIRComTest	equ		017d						;eXgR}h
cIRComNums	equ		018d						;ԊOMR}h̒`ςݐ
		;
fSwPortPrev:	ds		1						;pSwPort̑Ol
fSwPortSave:	ds		1						;pSwPort̕ۑp
fSwStatus:	ds		1						;pSwPort̏(`b^LZς݁A1=ON)
fSwStatus0to1:	ds		1						;fSwStatusOFFONɕωrbg=1
fSwStatus1to0:	ds		1						;fSwStatusONOFFɕωrbg=1
		;
fNsR0:		ds		1						;NS953M R0ݒl
		;
BitAddressEnd	equ		$					;rbgAhẌ̍Ō
		;
	if	BitAddressEnd >= 030h
		__ERROR__	"Bit address area too large."
	endif
		;
		;---------------------------------------;Direct and Indirect Addressing
;		dseg		at	030h
fUITimerCtr:	ds		1						;Timer3荞݃JE^
fBattVoltage:	ds		1						;obed(BCD2)
		;
fLoopAmsecCtr0:	ds		1						;LoopAmsecCtrpJE^0
fLoopAmsecCtr1:	ds		1						;LoopAmsecCtrpJE^1
		;
fVsSciA:	ds		1						;VS1011 SCI[hECgAhX
fVsSciDL:	ds		1						;VS1011 SCI[hECgf[^(ʃoCg)
fVsSciDH:	ds		1						;VS1011 SCI[hECgf[^(ʃoCg)
fVsSdiD:	ds		1						;VS1011 SDICgf[^
		;
fSdSpiRxD:	ds		1						;SdCard SPI[hf[^
fSdSpiTxD:	ds		1						;SdCard SPICgf[^
;fSdCommand:	;
fSdCommand0:	ds		1						;SdCard SPIR}hobt@(0)
fSdCommand1:	ds		1						;SdCard SPIR}hobt@(1)
fSdCommand2:	ds		1						;SdCard SPIR}hobt@(2)
fSdCommand3:	ds		1						;SdCard SPIR}hobt@(3)
fSdCommand4:	ds		1						;SdCard SPIR}hobt@(4)
fSdCommand5:	ds		1						;SdCard SPIR}hobt@(5)
fSdResponse:	ds		1						;SdCard SPIR}hX|X(R1݂̂z)
;fSdSectorNo:	;
fSdSectorNoH:	ds		1						;SdCard [hZN^ԍ(H)(0..)
fSdSectorNoM:	ds		1						;SdCard [hZN^ԍ(M)(0..)
fSdSectorNoL:	ds		1						;SdCard [hZN^ԍ(L)(0..)
;fXramSectorNo:	;
fXramSectorNoH:	ds		1						;XRAMɓǂݍ܂ĂZN^̔ԍ(H)
fXramSectorNoM:	ds		1						;XRAMɓǂݍ܂ĂZN^̔ԍ(M)
fXramSectorNoL:	ds		1						;XRAMɓǂݍ܂ĂZN^̔ԍ(L)
		;
fSecPerClus:	ds		1						;NX^̃ZN^
;fFirstFatSec:	;
fFirstFatSecH:	ds		1						;FAT̐擪ZN^ԍ(H)
fFirstFatSecL:	ds		1						;FAT̐擪ZN^ԍ(L)
;fFirstRootSec:	;
fFirstRootSecH:	ds		1						;[gfBNgGg̐擪ZN^ԍ(H)
fFirstRootSecL:	ds		1						;[gfBNgGg̐擪ZN^ԍ(L)
;fFirstDataSec:	;
fFirstDataSecH:	ds		1						;f[^̈̐擪ZN^ԍ(H)
fFirstDataSecL:	ds		1						;f[^̈̐擪ZN^ԍ(L)
		;
fBeepCode:	ds		1						;r[vgݒ
fBeepTime:	ds		1						;r[vԐݒ
		;
fSaveVolFfRew:	ds		1						;FF/REWẢʂۑĂWX^
fFfRewMode:	ds		1						;/߂[h
cFfMode		equ		+1d						;胂[h
cFfRewOff	equ		 0d						;ʏ푬x[h
cRewMode	equ		-1d						;߂[h
		;
fNsR1:		ds		1						;NS953M R1ݒl
fNsR2:		ds		1						;NS953M R2ݒl
		;
fTdaReg2:	ds		1						;TDA7463AD WX^ݒl(TuAhX2)
		;
fIrTxBytes:	ds		1						;ԊOMf[^oCg
fIrRxBytes:	ds		1						;ԊOMf[^oCg
fIrInterval:	ds		1						;ԊOf[^C^[oJE^
		;
;fDecodeTime:	;
fDecodeTimeH:	ds		1						;VS1011 fR[h(H)
fDecodeTimeL:	ds		1						;VS1011 fR[h(L)
		;
cNvParamTop	equ		$					;ԕۑϐGA
fVolume:	ds		1						;{[l(03fh..000h)
fMp3Files:	ds		1						;J[hMP3t@C̑S
		;
cFileParamTop	equ		$						;Đt@CɊւp[^
fFileNo:	ds		1						;Ώۃt@Cԍ
;fFileClusNo:	;
fFileClusNoH:	ds		1						;̃NX^ԍ(H)
fFileClusNoL:	ds		1						;̃NX^ԍ(L)
fFileSectorCnt:	ds		1						;̃NX^ɑ΂ZN^ԍ(0..fSecPerClus - 1)
;fFileSize:	;
fFileSizeH:	ds		1						;fFileNõt@CTCY(H)
fFileSizeM:	ds		1						;fFileNõt@CTCY(M)
fFileSizeN:	ds		1						;fFileNõt@CTCY(N)
fFileSizeL:	ds		1						;fFileNõt@CTCY(L)
;fRemainBytes:	;
fRemainBytesH:	ds		1						;f[^t@C̍ĐcoCg(H)
fRemainBytesM:	ds		1						;f[^t@C̍ĐcoCg(M)
fRemainBytesN:	ds		1						;f[^t@C̍ĐcoCg(N)
fRemainBytesL:	ds		1						;f[^t@C̍ĐcoCg(L)
;fPlayPointer:	
fPlayPointerH:	ds		1						;XRAMɓǂݍ܂Ăf[^̍Đ|C^(H)
fPlayPointerL:	ds		1						;XRAMɓǂݍ܂Ăf[^̍Đ|C^(L)
cFileParamEnd	equ		$						;Đt@CɊւp[^܂
		;
cFileParamATop	equ		$						;}[JAɊւp[^
fFileNoA:	ds		1						;Ώۃt@Cԍ(}[JA)
fFileClusNoA:	ds		2						;̃NX^ԍ(}[JA)
fFileSecCntA:	ds		1						;̃NX^ɑ΂ZN^ԍ(0..fSecPerClus - 1)(}[JA)
fFileSizeA:	ds		4						;fFileNõt@CTCY(}[JA)
fRemainBytesA:	ds		4						;f[^t@C̍ĐcoCg(}[JA)
fPlayPointerA:	ds		2						;XRAMɓǂݍ܂Ăf[^̍Đ|C^(}[JA)
		;
fRepeatMode:	ds		1						;s[gĐ[hݒoCg
bRmOne		equ		0						;݂̋Ȃs[gĐ(1ON)
bRmDir		equ		1						;݂̃fBNgs[gĐ(1ON)
bRmAll		equ		2						;SȂs[gĐ(1ON)
		;
		;
;fSdCheckData:	;
fSdCheckDataH:	ds		1						;J[hopf[^(H)
fSdCheckDataM:	ds		1						;J[hopf[^(M)
fSdCheckDataN:	ds		1						;J[hopf[^(N)
fSdCheckDataL:	ds		1						;J[hopf[^(L)
		;
fPreStNo:	ds		1						;vZbgǔԍ
fFreqTableIdx:	ds		1						;Iǒ̎ge[uCfbNX
		;
fTdaReg0:	ds		1						;TDA7463AD WX^ݒl(TuAhX0)
fTdaReg1:	ds		1						;TDA7463AD WX^ݒl(TuAhX1)
		;
;fStartTime:	;
fStartTimeH:	ds		1						;VS1011 ĐJn(H)
fStartTimeL:	ds		1						;VS1011 ĐJn(L)
		;
cNvParamEnd	equ		$					;ԕۑϐGA܂
		;
DataSegmentEnd	equ		$			;f[^ZOg̍Ō
		;
		iseg		at	080h		;StackZOgJnAhX
Stack:		ds		07fh						;128oCg
		;
	if	DataSegmentEnd >= (Stack + 1)
		__ERROR__	"DataSegment too large."
	endif
		;
		;===============================================================
		;	Macro(s)
		;
		;---------------------------------------;WX^oNI}N
SelectRegBank	macro		_rbSelect
		;
		anl		PSW, #11100111b					;RS0, RS1NA
		orl		PSW, #_rbSelect AND 00011000b			;RS0, RS1XV
		;
		endm
		;
		;---------------------------------------;16rbgVtg}N
ShiftL16	macro		_H, _L
		;
		push		ACC
		;
		clr		C						;CNA
		mov		A, _L						;A : ʃoCg
		rlc		A						;A : C܂߂č[e[g
		mov		_L, A						;_LXV
		mov		A, _H						;A : ʃoCg
		rlc		A						;A : C܂߂č[e[g
		mov		_H, A						;_HXV
		;
		pop		ACC
		;
		endm
		;
		;---------------------------------------;16rbgEVtg}N
ShiftR16	macro		_H, _L
		;
		push		ACC
		;
		clr		C						;CNA
		mov		A, _H						;A : ʃoCg
		rrc		A						;A : C܂߂ĉE[e[g
		mov		_H, A						;_HXV
		mov		A, _L						;A : ʃoCg
		rrc		A						;A : C܂߂ĉE[e[g
		mov		_L, A						;_LXV
		;
		pop		ACC
		;
		endm
		;
		;---------------------------------------;24rbgVtg}N
ShiftL24	macro		_H, _M, _L
		;
		push		ACC
		;
		clr		C						;CNA
		mov		A, _L						;A : ʃoCg
		rlc		A						;A : C܂߂č[e[g
		mov		_L, A						;_LXV
		mov		A, _M						;A : ʃoCg
		rlc		A						;A : C܂߂č[e[g
		mov		_M, A						;_MXV
		mov		A, _H						;A : ʃoCg
		rlc		A						;A : C܂߂č[e[g
		mov		_H, A						;_HXV
		;
		pop		ACC
		;
		endm
		;
		;---------------------------------------;24rbgEVtg}N
ShiftR24	macro		_H, _M, _L
		;
		push		ACC
		;
		clr		C						;CNA
		mov		A, _H						;A : ʃoCg
		rrc		A						;A : C܂߂ĉE[e[g
		mov		_H, A						;_HXV
		mov		A, _M						;A : ʃoCg
		rrc		A						;A : C܂߂ĉE[e[g
		mov		_M, A						;_MXV
		mov		A, _L						;A : ʃoCg
		rrc		A						;A : C܂߂ĉE[e[g
		mov		_L, A						;_LXV
		;
		pop		ACC
		;
		endm
		;
		;---------------------------------------;16rbgZ}N(̏Ԃɒ)
		;					;  Y = A + B
		;					;  C : L
AddYAB16	macro		_YH, _YL, _AH, _AL, _BH, _BL
		;
	if	(_YH = ACC) or (_YL = ACC)
		__ERROR__	"Illegal operand in AddYAB16."
	endif
		;
		push		ACC
		;
		mov		A, _AL						;A : _AL
		add		A, _BL						;A : _AL + _BL
		mov		_YL, A						;_YLXV
		mov		A, _AH						;A : _AH
		addc		A, _BH						;A : _AH + _BH + C
		mov		_YH, A						;_YHXV
		;
		pop		ACC
		;
		endm
		;
		;---------------------------------------;16rbgZ}N(̏Ԃɒ)
		;					;  Y = Y + A
		;					;  C : L
AddYYA16	macro		_YH, _YL, _AH, _AL
		;
	if	(_YH = ACC) or (_YL = ACC)
		__ERROR__	"Illegal operand in AddYYA16."
	endif
		;
		push		ACC
		;
		mov		A, _AL						;A : _AL
		add		A, _YL						;A : _AL + _YL
		mov		_YL, A						;_YLXV
		mov		A, _AH						;A : _AH
		addc		A, _YH						;A : _AH + _YH + C
		mov		_YH, A						;_YHXV
		;
		pop		ACC
		;
		endm
		;
		;---------------------------------------;16rbgZ}N(̏Ԃɒ)
		;					;  Y = A - B
		;					;  C : {[
SubYAB16	macro		_YH, _YL, _AH, _AL, _BH, _BL
		;
	if	(_YH = ACC) or (_YL = ACC)
		__ERROR__	"Illegal operand in SubYAB16."
	endif
		;
		push		ACC
		;
		clr		C						;CNA
		mov		A, _AL						;A : _AL
		subb		A, _BL						;A : _AL - _BL
		mov		_YL, A						;_YLXV
		mov		A, _AH						;A : _AH
		subb		A, _BH						;A : _AH - _BH - C
		mov		_YH, A						;_YHXV
		;
		pop		ACC
		;
		endm
		;
		;
		;---------------------------------------;16rbgZ}N(̏Ԃɒ)
		;					;  Y = Y - A
		;					;  C : {[
SubYYA16	macro		_YH, _YL, _AH, _AL
		;
	if	(_YH = ACC) or (_YL = ACC)
		__ERROR__	"Illegal operand in SubYYA16."
	endif
		;
		push		ACC
		;
		clr		C						;CNA
		mov		A, _YL						;A : _YL
		subb		A, _AL						;A : _YL - _AL
		mov		_YL, A						;_YLXV
		mov		A, _YH						;A : _YH
		subb		A, _AH						;A : _YH - _AH - C
		mov		_YH, A						;_YHXV
		;
		pop		ACC
		;
		endm
		;
		;---------------------------------------;24rbgZ}N(̏Ԃɒ)
		;					;  Y = Y + A
		;					;  C : L
AddYYA24	macro		_YH, _YM, _YL, _AH, _AM, _AL
		;
	if	(_YH = ACC) or (_YM = ACC) or (_YL = ACC)
		__ERROR__	"Illegal operand in AddYYA24."
	endif
		;
		push		ACC
		;
		mov		A, _AL						;A : _AL
		add		A, _YL						;A : _AL + _YL
		mov		_YL, A						;_YLXV
		mov		A, _AM						;A : _AM
		addc		A, _YM						;A : _AM + _YM + C
		mov		_YM, A						;_YMXV
		mov		A, _AH						;A : _AH
		addc		A, _YH						;A : _AH + _YH + C
		mov		_YH, A						;_YHXV
		;
		pop		ACC
		;
		endm
		;
		;---------------------------------------;24rbgZ}N(̏Ԃɒ)
		;					;  Y = Y - A
		;					;  C : {[
SubYYA24	macro		_YH, _YM, _YL, _AH, _AM, _AL
		;
	if	(_YH = ACC) or (_YM = ACC) or (_YL = ACC)
		__ERROR__	"Illegal operand in SubYYA24."
	endif
		;
		push		ACC
		;
		clr		C						;CNA
		mov		A, _YL						;A : _YL
		subb		A, _AL						;A : _YL - _AL
		mov		_YL, A						;_YLXV
		mov		A, _YM						;A : _YM
		subb		A, _AM						;A : _YM - _AM - C
		mov		_YM, A						;_YMXV
		mov		A, _YH						;A : _YH
		subb		A, _AH						;A : _YH - _AH - C
		mov		_YH, A						;_YHXV
		;
		pop		ACC
		;
		endm
		;
		;---------------------------------------;32rbgZ}N(̏Ԃɒ)
		;					;  Y = Y + A
		;					;  C : L
AddYYA32	macro		_YH, _YM, _YN, _YL, _AH, _AM, _AN, _AL
		;
	if	(_YH = ACC) or (_YM = ACC) or (_YN = ACC) or (_YL = ACC)
		__ERROR__	"Illegal operand in AddYYA32."
	endif
		;
		push		ACC
		;
		mov		A, _AL						;A : _AL
		add		A, _YL						;A : _AL + _YL
		mov		_YL, A						;_YLXV
		mov		A, _AN						;A : _AN
		addc		A, _YN						;A : _AN + _YN + C
		mov		_YN, A						;_YNXV
		mov		A, _AM						;A : _AM
		addc		A, _YM						;A : _AM + _YM + C
		mov		_YM, A						;_YMXV
		mov		A, _AH						;A : _AH
		addc		A, _YH						;A : _AH + _YH + C
		mov		_YH, A						;_YHXV
		;
		pop		ACC
		;
		endm
		;
		;---------------------------------------;32rbgZ}N(̏Ԃɒ)
		;					;  Y = A - B
		;					;  C : {[
SubYAB32	macro		_YH, _YM, _YN, _YL, _AH, _AM, _AN, _AL, _BH, _BM, _BN, _BL
		;
	if	(_YH = ACC) or (_YM = ACC) or (_YN = ACC) or (_YL = ACC)
		__ERROR__	"Illegal operand in SubYAB32."
	endif
		;
		push		ACC
		;
		clr		C						;CNA
		mov		A, _AL						;A : _AL
		subb		A, _BL						;A : _AL - _BL
		mov		_YL, A						;_YLXV
		mov		A, _AN						;A : _AN
		subb		A, _BN						;A : _AN - _BN - C
		mov		_YN, A						;_YNXV
		mov		A, _AM						;A : _AM
		subb		A, _BM						;A : _AM - _BM - C
		mov		_YM, A						;_YMXV
		mov		A, _AH						;A : _AH
		subb		A, _BH						;A : _AH - _BH - C
		mov		_YH, A						;_YHXV
		;
		pop		ACC
		;
		endm
		;
		;
		;---------------------------------------;32rbgZ}N(̏Ԃɒ)
		;					;  Y = Y - A
		;					;  C : {[
SubYYA32	macro		_YH, _YM, _YN, _YL, _AH, _AM, _AN, _AL
		;
	if	(_YH = ACC) or (_YM = ACC) or (_YN = ACC) or (_YL = ACC)
		__ERROR__	"Illegal operand in SubYYA32."
	endif
		;
		push		ACC
		;
		clr		C						;CNA
		mov		A, _YL						;A : _YL
		subb		A, _AL						;A : _YL - _AL
		mov		_YL, A						;_YLXV
		mov		A, _YN						;A : _YN
		subb		A, _AN						;A : _YN - _AN - C
		mov		_YN, A						;_YNXV
		mov		A, _YM						;A : _YM
		subb		A, _AM						;A : _YM - _AM - C
		mov		_YM, A						;_YMXV
		mov		A, _YH						;A : _YH
		subb		A, _AH						;A : _YH - _AH - C
		mov		_YH, A						;_YHXV
		;
		pop		ACC
		;
		endm
		;
		;---------------------------------------;Spi0MI҂}N
		;					;  SPI0DATɏޑOSPIFNAĂKv
WaitSpi0End	macro
		local		_WaitSpi0End1
		;
_WaitSpi0End1:	jnb		SPIF, _WaitSpi0End1				;MItONAȂ烋[v
		;
		endm
		;
		;---------------------------------------;Spi0Mobt@GveB҂}N
WaitSpi0TxRdy	macro
		local		_WaitSpi0TxRdy
		;
_WaitSpi0TxRdy:	jnb		TXBMT, _WaitSpi0TxRdy				;Mobt@GveBtONAȂ烋[v
		;
		endm
		;
		;---------------------------------------;SPI0f[^M}N
		;					;  _Dst : Mf[^
RxSpi0		macro		_Dst
		;
		TxSpi0		#0ffh						;M̂߂̃_~[o
		WaitSpi0End							;MI҂
		mov		_Dst, SPI0DAT					;Mf[^]
		;
		endm
		;
		;---------------------------------------;SPI0f[^M}N
		;					;  _Src : Mf[^
TxSpi0		macro		_Src
		;
		WaitSpi0TxRdy							;Mobt@GveB҂
		clr		SPIF						;MItONA
		mov		SPI0DAT, _Src					;Mf[^]
		WaitSpi0End							;MI҂
		;
		endm
		;
		;---------------------------------------;VS1011 SCIWX^[h
		;					;  _Addr : WX^AhX(萔)
		;					;@_DataH, L : [hɂXV郌WX^
ReadVsSci	macro		_Addr, _DataH, _DataL
		;
		mov		fVsSciA, #_Addr					;_AddrWX^ݒ
		call		RxVsSci						;WX^[h
		mov		_DataL, fVsSciDL				;_DatảʃoCgXV
		mov		_DataH, fVsSciDH				;_DatȁʃoCgXV
		;
		endm
		;
		;---------------------------------------;VS1011 SCIWX^Cg
		;					;  _Addr : WX^AhX(萔)
		;					;@_DataH, L : ݒ肷l
WriteVsSci	macro		_Addr, _DataH, _DataL
		;
		mov		fVsSciA, #_Addr					;_AddrWX^ݒ
		mov		fVsSciDL, _DataL				;_DatảʃoCgݒ
		mov		fVsSciDH, _DataH				;_DatȁʃoCgݒ
		call		TxVsSci						;WX^Cg
		;
		endm
		;
		;---------------------------------------;FLASH[h}N
		;					;  DPTR : [hAhX
		;					;  A : [hf[^
ReadFlash	macro
		;
		clr		A						;A : 0
		movc		A, @A + DPTR					;A : [hf[^
		;
		endm
		;
		;---------------------------------------;FLASHCg}N
		;					;  DPTR : CgAhX
		;					;  A : Cgf[^
WriteFlash	macro
		;
		mov		FLKEY, #0a5h					;FLKEY : 0a5h
		mov		FLKEY, #0f1h					;FLKEY : 0f1h
		movx		@DPTR, A					;
		;
		endm
		;
		;---------------------------------------;Đt@Cp[^ƃ}[Np[^Ԃ̃Rs[}N
		;					;  _Dst : Rs[擪AhX
		;					;  _Src : Rs[擪AhX
CopyFileParam	macro		_Dst, _Src
		local		_CopyFilePrm1
		;
		mov		fParamCopyDst, #_Dst				;fParamCopyDst : Rs[擪AhX
		mov		fParamCopySrc, #_Src				;fParamCopySrc : Rs[擪AhX
_CopyFilePrm1:	mov		A, @fParamCopySrc				;A : Rs[f[^
		mov		@fParamCopyDst, A				;Rs[
		inc		fParamCopyDst					;Rs[擪AhX + 1
		inc		fParamCopySrc					;Rs[擪AhX + 1
		cjne		fParamCopySrc, #_Src + (cFileParamEnd - cFileParamTop) + 1, _CopyFilePrm1	;IłȂ΃[v
		;
		endm
		;
		;---------------------------------------;r[v}N
MakeBeep	macro		_Note, _Time
		;
		mov		fBeepCode, #_Note				;f[^ݒ
		mov		fBeepTime, #_Time				;Ԑݒ
		call		Beep						;r[v
		;
		endm
		;
		;---------------------------------------;샂[hύX̃r[v}N
MakeBeepOp	macro		_Note1, _Note2, _Note3
		;
		MakeBeep	_Note1, cBeepTimeOp				;1r[v
;		mov		A, #010d					;r[v̊Ԋu
;		call		WaitAmsec					;Amsec҂
		MakeBeep	_Note2, cBeepTimeOp				;2r[v
;		mov		A, #010d					;r[v̊Ԋu
;		call		WaitAmsec					;Amsec҂
		MakeBeep	_Note3, cBeepTimeOp				;3r[v
		;
		endm
		;
		;---------------------------------------;s[g[hʒmpr[v}N
MakeBeepRep	macro		_Note
		;
		MakeBeep	_Note, cBeepTimeOp				;1
;		mov		A, #010d					;r[v̊Ԋu
;		call		WaitAmsec					;Amsec҂
		MakeBeep	_Note, cBeepTimeOp				;2
		;
		endm
		;
		;---------------------------------------;UART0 {[[gݒ}N
Tx		equ		1
Rx		equ		2
		;
SetUartBaud	macro		_TxRx
		;
	if _TxRx = Tx							;Mpݒ : 9600baud
		anl		CKCON, #11111101b				;SCA1NA : NbN\[X = SYSCLK / 12
		mov		TH1, #096h					;9600baud
	else
	if _TxRx = Rx							;Mpݒ : 1200baud
		orl		CKCON, #00000010b				;SCA1Zbg : NbN\[X = SYSCLK / 48
		mov		TH1, #02bh					;1200baud
	else
		__ERROR__	"Illegal operand in SetUartBaud."
	endif
	endif
		;
		endm
		;
		;---------------------------------------;SMBus X^[gRfBV}N
		;					;@IASI̓ZbgĂ
TxSmbSta	macro
		;
		clr		SI						;SINA
		setb		STA						;X^[gRfBV
		jnb		SI, $						;SIZbg҂
		;
		clr		STA						;STANA
		;
		endm
		;
		;---------------------------------------;SMBus f[^M}N
		;					;@M҂BIASI̓ZbgAMACK/NACKSMB0CN.ACKrbgɓĂ
TxSmbData	macro		_Data
		;
		mov		SMB0DAT, _Data					;f[^Cg
		clr		SI						;SINA
		jnb		SI, $						;SIZbg҂ASI̓Zbgꂽ܂܂ɂȂĂ
		;
		endm
		;
		;---------------------------------------;SMBus f[^M}N
		;					;@OSMB0CN.ACKrbgZbgĂ
		;					;@SINAĎM҂BIASI̓ZbgAMf[^SMB0DATɓĂ
RxSmbData	macro
		;
		clr		SI						;SINA
		jnb		SI, $						;SIZbg҂ASI̓Zbgꂽ܂܂ɂȂĂ
		;
		endm
		;
		;---------------------------------------;SMBus XgbvRfBV}N
		;					;@IASI̓NAĂ
TxSmbSto	macro
		;
		setb		STO						;XgbvRfBV
		clr		SI						;SINA
		;
		endm
		;
		;---------------------------------------;TDA7463AD Output Mute}N
On		equ		1
Off		equ		2
		;
TdaMute		macro		_OnOff
	if _OnOff = On							;Mute = ON
		orl		fTdaReg2, #00111111b				;Volumeŏ
	else
	if _OnOff = Off							;Mute = OFF
		mov		fTdaReg2, fVolume				;fVolumeōXV
		orl		fTdaReg2, #11000000b				;Output Gain, Attenuation = 0dB
	else
		__ERROR__	"Illegal operand in TdaMute."
	endif
	endif
		call		TxTdaReg					;TDA7463ADWX^Cg
		;
		endm
		;
		;---------------------------------------;LM4924 N}N
LmOn		macro
		;
		setb		pAmpSd						;LM4924 SD = "H" : Vbg_EOFF
		;
		endm
		;
		;---------------------------------------;LM4924 ~}N
LmOff		macro
		;
		clr		pAmpSd						;LM4924 SD = "L" : Vbg_EON
		;
		endm
		;
		;===============================================================
		;	Vectors Section
		;
		;---------------------------------------;X^[g
		cseg		at	00000h
VectorReset:	ljmp		Initialize			;Zbg
		cseg		at	00003h
VectorInt0:	ljmp		VectorReset			;Int0
		cseg		at	0000bh
VectorTmr0Ovfl:	ljmp		VectorReset			;Tmr0I[ot[
		cseg		at	00013h
VectorInt1:	ljmp		IsrInt1				;Int1
		cseg		at	0001bh
VectorTmr1Ovfl:	ljmp		VectorReset			;Tmr1I[ot[
		cseg		at	00023h
VectorUart0:	ljmp		IsrUart0			;Uart0
		cseg		at	0002bh
VectorTmr2Ovfl:	ljmp		VectorReset			;Tmr2I[ot[
		cseg		at	00033h
VectorSpi0:	ljmp		VectorReset			;Spi0
		cseg		at	0003bh
VectorSmb0:	ljmp		VectorReset			;Smb0
		cseg		at	00043h
VectorReserve0:	ljmp		VectorReset			;Reserved
		cseg		at	0004bh
VectorAdc0Wind:	ljmp		VectorReset			;Adc0EChEr
		cseg		at	00053h
VectorAdc0End:	ljmp		VectorReset			;Adc0ϊI
		cseg		at	0005bh
VectorPca:	ljmp		VectorReset			;Pca
		cseg		at	00063h
VectorCmp0:	ljmp		VectorReset			;Cmp0
		cseg		at	0006bh
VectorReserve1:	ljmp		VectorReset			;Reserved
		cseg		at	00073h
VectorTmr3Ovfl:	ljmp		IsrTimer3			;Tmr3I[ot[
		;
		;===============================================================
		;	Initializing
		;
		cseg		at	00080h
		;
Initialize:	;---------------------------------------;ԏ
		mov		SP, #Stack - 1					;X^bN|C^
		;
		;							;HFIV[^
;		mov		OSCICL, #0xxh					;HFUgł邾24.576MHzɋ߂Â
		mov		OSCICN, #083h					;HFIV[^Cl[uAȂ
		;
		;							;WDT
		mov		PCA0MD, #000h					;WDTfBXG[u
		;
		;							;UART0
		mov		SCON0, #01000000b				;8rbg[hAMƂ肠֎~
		;
		;							;SPI0
		mov		SPI0CFG, #01000000b				;}X^[hACKPHA = CKPOL = 0
		mov		SPI0CN, #001h					;3-wire}X^[hASPICl[u
		mov		SPI0CKR, #097d					;fSCK = 125kHz
		;
		;							;SMBus
		mov		SMB0CF, #11000010b				;싖Ȃ@\֎~ANbN\[X : Timer2
		;
		;							;Voltage Reference
		mov		REF0CN, #008h					;VREF = VDD
		;
		;							;ADC0 : obedo
		mov		AMX0P, #003h					;P1.3 : pBattery
		mov		AMX0N, #01fh					;VOGh[h
		mov		ADC0CF, #01001100b				;CLKSAR = SYSCLK / 10Af[^͍l
		mov		ADC0CN, #01000000b				;[p[gbN[hAADC0~
		;
		;							;Timer0..3 : NbNݒ
		mov		CKCON, #00110110b				;Timer0ATimer2SYSCLKATimer1ATimer3͕NbNgp
		;
		;							;Timer0 :PCANbN\[X 24576000 / 3 = 8192000Hz
		;							;Timer1 :UART0NbN\[X
		mov		TMOD, #00100010b				;Timer0 : Mode2ATimer1 : Mode2
		mov		TH0, #LOW (0 - 003d)				;0 - (24576000 / 8192000)
		mov		TH1, #02bh					;Ƃ肠1200baud
		mov		TCON, #01010000b				;Timer0ATimer1싖A/INT1̓xgK
		;
		;							;Timer2 :SMBusNbN\[X 300kHz
		mov		TMR2RLL, #LOW  (0 - 082d)			;LOW  (0 - (cSysclk / 300000))
		mov		TMR2RLH, #HIGH (0 - 082d)			;HIGH (0 - (cSysclk / 300000))
		mov		TMR2CN, #00000100b				;16bit[h^C}A싖
		;
		;							;Timer3 : [UC^[tF[X̂߂̃C^[o^C}
		mov		TMR3RLL, #LOW  (0 - 20480d)			;LOW  (0 - (cSysclk / 12d / 100d)) : C^[o = 10msec
		mov		TMR3RLH, #HIGH (0 - 20480d)			;HIGH (0 - (cSysclk / 12d / 100d)) : C^[o = 10msec
		mov		TMR3CN, #00000000b				;16bit[h^C}ANbN = SYSCLK / 12A~
		;
		;							;PCA
		mov		PCA0MD, #00000100b				;NbN : ^C}0I[ot[
		mov		PCA0CPH0, #125d					;W[0 : o͎g = 32.768kHz
		mov		PCA0CPM0, #01000110b				;W[0 : go̓[h
		mov		PCA0CPH1, #009d					;W[1 : o͎g = 455kHz
		mov		PCA0CPM1, #01000110b				;W[1 : go̓[h
		mov		PCA0CPM2, #01001000b				;W[2 : \tgEFA^C}[h(WaitAusec, WaitAmsecŎgp)
		setb		CR						;PCA싖
		;
		;							;I/O|[g : 萔錾gĂȂ̂ŕύX̍ۂ͗v
		mov		P0, #11111111b					;Ss"H"
		mov		P0MDIN,  #11110011b				;pXtal1ApXtal2̓AiÓA̓fW^I/O
		mov		P0MDOUT, #10010000b				;pSpiSckApIrTx̓vbVvA̓I[vhC()
		mov		P0SKIP,  #01001111b				;pSpiSckAUART0sXLbv
		mov		P1, #10111111b					;pVsReset̂"L"
		mov		P1MDIN,  #11110111b				;pBatterŷ݃AiO
		mov		P1MDOUT, #01110110b				;pSmbSdaApBatteryApSpiMiso̓I[vhC
		mov		P1SKIP,  #01111100b				;pSmbSdaApSpiMosiApSpiMisosXLbv
		mov		P2, #10100001b					;pSwDApNsStoApSmbScl̂"H"
		mov		P2MDIN,  #11111111b				;SsfW^I/O
		mov		P2MDOUT, #01011110b				;pSwDApNsStoApSmbScl̓I[vhC()
		mov		P2SKIP,  #00000000b				;XLbvȂ
		mov		P3, #11111111b					;Ss"H"
		mov		P3MDIN,  #11111111b				;SsfW^I/O
		mov		P3MDOUT, #00000000b				;SsI[vhC()
		mov		XBR0, #00001111b				;SYSCLKASMBusASPIAUARTsɃATC
		mov		XBR1, #01000010b				;CEX0ACEX1sɃATCANXo[Cl[u
		;
		;							;ONbNN
		mov		OSCXCN, #01100111b				;NX^IV[^[h
		mov		A, #001d					;A : 1
		call		WaitAmsec					;Amsec҂
_Init2:		mov		A, OSCXCN					;A : OSCXCN
		jnb		ACC.7, _Init2					;XTLVLD = 1ɂȂ܂Ń[v
		;
		mov		CLKSEL, #001h					;ONbNI
		mov		OSCICN, #000h					;NbN~
		;
		;							;ϐ揉
		mov		R0, #Stack					;R0 : JnAhX
_Init1:		mov		@R0, #0						;@R0 : 0NA
		djnz		R0, _Init1					;R0 : R0 - 1A<> 0 Ȃ烋[v
		;
		mov		fXramSectorNoH, #0ffh				;
		mov		fXramSectorNoM, #0ffh				;
		mov		fXramSectorNoL, #0ffh				;fXramSectorNoɂ肦ȂlĂ
		mov		fVolume, #030h					;{[l
		;
		;							;荞ݐ
		mov		IT01CF, #11100000b				;/INT1̓ANeBu"H"ApVsDreq = P0.6
		;
		;							;NfBCATDA7463AD̓ddオ莞Ԋm
		mov		A, #0150d					;A : 150
		call		WaitAmsec					;Amsec҂
		;
		;							;TDA7463AD
		mov		fTdaReg0, #11000100b				;fTdaReg0
		mov		fTdaReg1, #11110010b				;fTdaReg1
		mov		fTdaReg2, #11111111b				;fTdaReg2
		call		TxTdaReg					;TDA7463ADWX^Cg
		;
		;							;LM4924N
		LmOn								;LM4924 Vbg_EOFF
		;
		;							;VS1011
		;								;r[vɂċN̂ŕsv
;		call		PowerUpVs					;VS1011N
;		call		InitVs						;\tgEFAZbgAݒ
		;
		;							;NS953M
		call		InitNs						;NS953M \tgEGAZbgAݒ
		mov		fPreStNo, #0					;vZbgǔԍ
		call		SetPreStIdx					;vZbgǂ̎ge[uCfbNXZbg
		mov		fNsR0, #00010001b				;PE = 1
		call		TxNsR0						;NS953MN
		;
		;							;SDCard
		call		InitSd						;SPI[hɐݒ
		mov		A, fSdResponse					;A : X|X
		jnz		_InitE						;<> 0ȂG[
		;
		;							;SPINbNAbv
;		mov		SPI0CKR, #011d					;fSCK=1MHz
;		mov		SPI0CKR, #005d					;fSCK=2MHz
		mov		SPI0CKR, #002d					;fSCK=4MHz
		;
		;							;SDJ[hW
		call		GetSdBpbInfo					;SdCard BPB̏擾
		jc		_InitE						;G[ȂWv
		;
		;							;J[hMP3t@C̐`FbN
		mov		fFileNo, #0255d					;fFileNo : 255Ȗڂw(ۂɂ͂肦Ȃl)
		call		SeekMp3FileNo					;fFileNoԖڂ".MP3"t@CT
		mov		A, fMp3Files					;A : MP3t@C̐
		mov		B, A						;B : MP3t@C̐ۑ
		jz		_InitE						;0ȂG[
		;
		;							;s𖳎鑀̃`FbN
		jnb		pSwR, _Init4					;SwRĂs𖳎
		;
		;							;J[h`FbN
		call		LoadNvParams					;sԕA
		call		SeekMp3FileNo					;ۑ".MP3"t@CT
		jc		_Init5						;ȂȂJ[hĂƌȂ
		;
		call		ReadFileData					;t@C1ZN^ǂݍ
		;
		mov		fMp3Files, B					;fMp3Files : J[hMP3t@C̐𕜋A
		call		MakeSdCheckD					;SDJ[h`FbNpf[^
		mov		DPTR, #NvAreaTop + (fSdCheckDataH - cNvParamTop)	;DPTR : s̃J[hopf[^̃AhX
		ReadFlash							;A : s̃J[hopf[^
		cjne		A, fSdCheckDataH, _Init5			;svȂƂ݂Ȃ
		;
		mov		DPTR, #NvAreaTop + (fSdCheckDataM - cNvParamTop)	;DPTR : s̃J[hopf[^̃AhX
		ReadFlash							;A : s̃J[hopf[^
		cjne		A, fSdCheckDataM, _Init5			;svȂƂ݂Ȃ
		;
		mov		DPTR, #NvAreaTop + (fSdCheckDataN - cNvParamTop)	;DPTR : s̃J[hopf[^̃AhX
		ReadFlash							;A : s̃J[hopf[^
		cjne		A, fSdCheckDataN, _Init5			;svȂƂ݂Ȃ
		;
		mov		DPTR, #NvAreaTop + (fSdCheckDataL - cNvParamTop)	;DPTR : s̃J[hopf[^̃AhX
		ReadFlash							;A : s̃J[hopf[^
		cjne		A, fSdCheckDataL, _Init5			;svȂƂ݂Ȃ
		;
		;							;J[hĂȂꍇ
		call		LoadNvParams					;ēxsԕA
		call		ReadFileData					;t@C1ZN^ǂݍ
		jmp		_Init6						;Đ
		;
_InitE:		jmp		OnFatalError				;vIG[̓ݑ
		;
_Init5:		;							;J[hĂꍇ
		call		LoadNvParams					;ēxsԕA
_Init4:		mov		fFileNo, #0255d					;fFileNo : 255Ȗڂw(ۂɂ͂肦Ȃl)
		call		SeekMp3FileNo					;fFileNoԖڂ".MP3"t@CĒTAfMp3Filesď
		mov		fFileNo, #1					;fFileNo
		call		SeekMp3FileNo					;fFileNoԖڂ".MP3"t@CT
		call		ReadFileData					;t@C1ZN^ǂݍ
		mov		fPlayPointerH, #0
		mov		fPlayPointerL, #0				;fPlayPointer
		CopyFileParam	cFileParamATop, cFileParamTop			;}[JAփp[^Rs[
		mov		fRepeatMode, #0					;s[gĐ[hNA
		;
_Init6:		;							;Đr[vAŏI
		MakeBeep	cBeepNoteL, cBeepTimeOp				;r[v(ቹ)
		MakeBeep	cBeepNoteM, cBeepTimeOp				;r[v()
		MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v()
		clr		fPlayMode.bPmSwUpdate				;PmSwUpdatetONA
		;
		;							;ԊOʐMMJn
		setb		pIrRxPwr					;W[dON
		SetUartBaud	Rx						;Mp{[[gɐݒ
		mov		fIrMode, #0					;ԊOʐM[hStONA
		clr		RI0						;RItONA
		setb		REN0						;M싖
		;
		;							;Jn
		setb		ES0						;UART0荞݋
		;
		orl		TMR3CN, #00000100b				;TR3ZbgATimer3Jn
		orl		EIE1, #10000000b				;ET3ZbgATimer3荞݋
		mov		fPlayMode, #0					;fPlayMode
		;
		;===============================================================
		;	Main
		;
Main:		;---------------------------------------;C[v
		;
_Main2:		;							;VS1011ďAĐ
		call		InitVs						;\tgEFAZbgAݒ
		;
		mov		fIdleCtrL, #0
		mov		fIdleCtrH, #0					;~ԃJE^
		mov		fNoOpCtrL, #0
		mov		fNoOpCtrH, #0					;쎞ԃJE^
		;
_Main1:		;
		;							;MP3ĐȂINT1荞݋
		clr		C						;CNAĂ
		jb		fPlayMode.bPmFm, _Main3				;FM[hȂWv
		;
		jnb		fPlayMode.bPmPlaying, _Main3			;ĐtONAȂWv
		;
		call		CheckRemain					;ĐcoCg`FbNAA = 0ȂcȂ
		jz		_Main3						;c薳ȂWv
		;
		setb		C						;CZbg
_Main3:		mov		EX1, C						;INT1荞݋փRs[
		;
		;---------------------------------------;荞݋ɂăACh[h
		setb		EA						;O[o荞݋
		orl		PCON, #00000001b				;IDLEZbg
		;
		;		Zzzzz.....					;̊荞݂܂ŏȓd͏
		;
		;---------------------------------------;荞݂ɂIDLE畜A
;		clr		EA						;O[o荞݋֎~
		clr		EX1						;INT1荞݋֎~
		;
_MainBattCheck:	;---------------------------------------;obed`FbN
		call		ReadBattVolts					;obed[h
		mov		A, fBattVoltage					;A : obedl(BCD2)
		add		A, #0 - 030h					;A < 3.0VȂL[Ȃ
		jc		_MainIrProc					;3.0VȏȂ玟
		;
		jmp		OnFatalError					;3.0VȂvIG[
		;
_MainIrProc:	;---------------------------------------;ԊOʐM
		;							;M`FbN
		jb		fIrMode.bImRxDataReady, _MainIrProc1		;MtOZbgȂWv
		;
		jmp		_MainIrProc0					;NAȂ珈sv
		;
_MainIrProc1:	;							;ԊOʐMs
		clr		fIrMode.bImRxDataReady				;MtONA
		mov		fIdleCtrL, #0
		mov		fIdleCtrH, #0					;~ԃJE^
		;
		;							;R}h
		mov		EMI0CN, #HIGH cIrRxBuffer			;EMI0CNMobt@̈ɐݒ
		mov		fParamCopySrc, #LOW (cIrRxBuffer + 1)		;Mobt@f[^|C^
		movx		A, @fParamCopySrc				;A : MR}h
		inc		fParamCopySrc					;Mobt@f[^|C^XV
		push		ACC						;R}hꎞޔ
		movx		A, @fParamCopySrc				;A : Mp[^
		mov		B, A						;B : p[^
		pop		ACC						;A : R}h
		cjne		A, #cIRComNums, _MainIrProc2			;A - cIrComNums
_MainIrProc2:	jnc		_MainIrResNack					;R}h >= cIrComNumsȂG[
		;
		mov		DPTR, #IrComTable				;DPTR : R}hʃxN^e[u擪AhX
		add		A, ACC						;A : A * 2
		jmp		@A + DPTR					;샂[hʂɃWv
		;
IrComTable:	;								;R}hʃxN^e[u擪AhX
		ajmp		IRComStatReq					;Xe[^XNGXgR}h
		ajmp		IRComSync					;VNR}h
		ajmp		IRComResend					;ÕpPbgđR}h
		ajmp		IRComVolUp					;{[AbvR}h
		ajmp		IRComVolDn					;{[_ER}h
		ajmp		IRComTreble					;拭ݒR}h
		ajmp		IRComBass					;拭ݒR}h
		ajmp		IRComMp3Stop					;MP3XgbvR}h
		ajmp		IRComMp3Play					;MP3vCR}h
		ajmp		IRComMp3Jump					;MP3WvR}h
		ajmp		IRComMp3FfRew					;MP3芪߂R}h
		ajmp		IRComMp3Repeat					;MP3s[gݒR}h
		ajmp		IRComFmStop					;FMWIIt
		ajmp		IRComFmPlay					;FMWII
		ajmp		IRComFmJump					;FMvZbgǑIR}h
		ajmp		IRComFmSearch					;FMI[gT[`R}h
		ajmp		IRComFmManual					;FM}jAIǃR}h
		ajmp		IRComTest					;eXgR}h
		;
_MainIrComNop:	;							;R}h𖳎ꍇ
		mov		fIrMode, #0					;ԊOʐM[hStONA
		clr		RI0						;RItONA
		setb		REN0						;M싖
		jmp		_MainIrProc0
		;
_MainIrResBusy:	;							;rW[ɊY邽߃R}hsłȂꍇ
		mov		A, #cIrBusy					;A : BUSY
		jmp		_MainIrResErr					;`FbNTAMv
		;
_MainIrResNack:	;							;Mf[^ɃG[ꍇ
		mov		A, #cIrNack					;A : NACK
		jmp		_MainIrResErr					;`FbNTAMv
		;
_MainIrResErr:	;							;ACKȊÕXe[^X𑗐M
		;							;@A : Mf[^
		push		ACC						;Mf[^ꎞޔ
		;
		mov		EMI0CN, #HIGH cIrTxBuffer			;EMI0CN𑗐Mobt@̈ɐݒ
		mov		fParamCopyDst, #LOW cIrTxBuffer			;Mobt@f[^|C^
		;
		mov		A, #cIrStartCode				;A : X^[gR[h
		movx		@fParamCopyDst, A				;Mf[^obt@֓]
		inc		fParamCopyDst					;Mobt@f[^|C^XV
		;
		mov		A, #001d					;A : f[^oCg
		movx		@fParamCopyDst, A				;Mf[^obt@֓]
		inc		fParamCopyDst					;Mobt@f[^|C^XV
		;
		pop		ACC						;A : Mf[^
		movx		@fParamCopyDst, A				;Mf[^obt@֓]
		inc		fParamCopyDst					;Mobt@f[^|C^XV
		;
		mov		fIrTxBytes, #004d				;ԊOMf[^oCg
		jmp		_MainIrSumTx					;`FbNTAMv
		;
_MainIrResAck:	;							;1oCg̃X|Xf[^ACK𑗐M
		;							;@A : X|Xf[^
		push		ACC						;Mf[^ꎞޔ
		;
		mov		EMI0CN, #HIGH cIrTxBuffer			;EMI0CN𑗐Mobt@̈ɐݒ
		mov		fParamCopyDst, #LOW cIrTxBuffer			;Mobt@f[^|C^
		;
		mov		A, #cIrStartCode				;A : X^[gR[h
		movx		@fParamCopyDst, A				;Mf[^obt@֓]
		inc		fParamCopyDst					;Mobt@f[^|C^XV
		;
		mov		A, #002d					;A : f[^oCg
		movx		@fParamCopyDst, A				;Mf[^obt@֓]
		inc		fParamCopyDst					;Mobt@f[^|C^XV
		;
		mov		A, #cIrAck					;A : ACK
		movx		@fParamCopyDst, A				;Mf[^obt@֓]
		inc		fParamCopyDst					;Mobt@f[^|C^XV
		;
		pop		ACC						;A : Mf[^
		movx		@fParamCopyDst, A				;Mf[^obt@֓]
		inc		fParamCopyDst					;Mobt@f[^|C^XV
		;
		mov		fIrTxBytes, #005d				;ԊOMf[^oCg
;		jmp		_MainIrSumTx					;`FbNTAMv
		;
_MainIrSumTx:	;							;`FbNTAMv
		mov		fParamCopyDst, #LOW cIrTxBuffer			;Mobt@f[^|C^
		mov		fLoopCtr, fIrTxBytes				;[vJE^
		dec		fLoopCtr					;`FbNT̕A1炵Ă
		mov		B, #0						;B : `FbNTWX^
_MainIrSumTx1:	movx		A, @fParamCopyDst				;A : Mf[^
		add		A, B						;`FbNTvZ
		mov		B, A						;`FbNTXV
		inc		fParamCopyDst					;Mobt@f[^|C^XV
		djnz		fLoopCtr, _MainIrSumTx1				;[vJE^XVA0łȂ΃[v
		;
		clr		C						;CNA
		clr		A						;A : 0
		subb		A, B						;A : 0 - `FbNT
		movx		@fParamCopyDst, A				;`FbNTobt@֓]
		setb		fIrMode.bImTxReq				;MJnvtOZbg
		;
_MainIrProc0:	jmp		_MainSwProc					;XCb`
		;
IRComStatReq:	;---------------------------------------;Xe[^XNGXgR}h
		mov		EMI0CN, #HIGH cIrTxBuffer			;EMI0CN𑗐Mobt@̈ɐݒ
		mov		fParamCopyDst, #LOW cIrTxBuffer			;Mobt@f[^|C^
		;
		mov		A, #cIrStartCode				;A : X^[gR[h
		movx		@fParamCopyDst, A				;Mf[^obt@֓]
		inc		fParamCopyDst					;Mobt@f[^|C^XV
		;
		mov		A, #013d					;A : f[^oCg
		movx		@fParamCopyDst, A				;Mf[^obt@֓]
		inc		fParamCopyDst					;Mobt@f[^|C^XV
		;
		mov		A, #cIrAck					;A : ACK
		movx		@fParamCopyDst, A				;Mf[^obt@֓]
		inc		fParamCopyDst					;Mobt@f[^|C^XV
		;
		mov		A, fPlayMode					;A : vC[hoCg
		movx		@fParamCopyDst, A				;Mf[^obt@֓]
		inc		fParamCopyDst					;Mobt@f[^|C^XV
		;
		mov		A, fBattVoltage					;A : obed(BCD2)
		movx		@fParamCopyDst, A				;Mf[^obt@֓]
		inc		fParamCopyDst					;Mobt@f[^|C^XV
		;
		mov		A, fVolume					;A : {[l
		movx		@fParamCopyDst, A				;Mf[^obt@֓]
		inc		fParamCopyDst					;Mobt@f[^|C^XV
		;
		mov		A, fTdaReg0					;A : TDA7463AD WX^ݒl(TuAhX0)
		movx		@fParamCopyDst, A				;Mf[^obt@֓]
		inc		fParamCopyDst					;Mobt@f[^|C^XV
		;
		mov		A, fTdaReg1					;A : TDA7463AD WX^ݒl(TuAhX1)
		movx		@fParamCopyDst, A				;Mf[^obt@֓]
		inc		fParamCopyDst					;Mobt@f[^|C^XV
		;
		mov		A, fMp3Files					;A : }WbNioAƂ肠MP3t@C
		movx		@fParamCopyDst, A				;Mf[^obt@֓]
		inc		fParamCopyDst					;Mobt@f[^|C^XV
		;
		mov		A, fFileNo					;A : Đ̃t@Cԍ
		movx		@fParamCopyDst, A				;Mf[^obt@֓]
		inc		fParamCopyDst					;Mobt@f[^|C^XV
		;
		jnb		fPlayMode.bPmPlaying, _IRComStatReq1		;~ȂWv
		;
		jb		fPlayMode.bPmFm, _IRComStatReq1			;FM[hȂWv
		;
		call		GetVsDecTime					;fR[hԃ[h
_IRComStatReq1:	mov		A, fDecodeTimeH					;A : fR[h(H)
		movx		@fParamCopyDst, A				;Mf[^obt@֓]
		inc		fParamCopyDst					;Mobt@f[^|C^XV
		;
		mov		A, fDecodeTimeL					;A : fR[h(L)
		movx		@fParamCopyDst, A				;Mf[^obt@֓]
		inc		fParamCopyDst					;Mobt@f[^|C^XV
		;
		mov		A, fRepeatMode					;A : s[gĐ[hݒoCg
		movx		@fParamCopyDst, A				;Mf[^obt@֓]
		inc		fParamCopyDst					;Mobt@f[^|C^XV
		;
		mov		A, fPreStNo					;A : vZbgǔԍ
		movx		@fParamCopyDst, A				;Mf[^obt@֓]
		inc		fParamCopyDst					;Mobt@f[^|C^XV
		;
		mov		A, fFreqTableIdx				;A : Iǒ̎ge[uCfbNX
		movx		@fParamCopyDst, A				;Mf[^obt@֓]
		inc		fParamCopyDst					;Mobt@f[^|C^XV
		;
		mov		fIrTxBytes, #016d				;ԊOMf[^oCg
		jmp		_MainIrSumTx					;`FbNTAMv
		;
IRComSync:	;---------------------------------------;VNR}h
		;							;rW[`FbN
		jnb		fPlayMode.bPmPlaying, _IRComSync1		;~ȂWv
		;
		jmp		_MainIrResBusy					;~łȂȂrW[
		;
_IRComSync1:	;							;R}hs
		mov		EMI0CN, #HIGH cIrRxBuffer			;EMI0CNMobt@̈ɐݒ
		mov		fParamCopySrc, #LOW (cIrRxBuffer + 2)		;Mobt@f[^|C^
		movx		A, @fParamCopySrc				;A : p[^
		jnz		_IRComSync2					;<> 0ȂWv
		;
		;							;MP3t@Cf[^̃NGXg
		mov		A, fMp3Files					;A : J[hMP3t@C̑S
		jmp		_MainIrResAck					;sAACKM
		;
_IRComSync2:	;							;AԖڂMP3t@C̃^Of[^NGXg
		mov		fFileNo, A					;fFileNoXV
		call		SeekMp3FileNo					;t@CT
		jnc		_IRComSyncA					;t@CWv
		;
		;							;t@CȂꍇ
		call		LoadNvParams					;sԕA
		call		ReadFileData					;t@C1ZN^ǂݍ
		jmp		_MainIrComNop					;R}h𖳎
		;
_IRComSyncA:	;							;Ȃꍇ
		push		PSW						;PSWۑ
		SelectRegBank	rbIRComSync					;WX^oNؑ
		mov		fPswSave, PSW					;F0ۑ
		;
_IRComSync4:	;							;t@C̃^Of[^܂œǂݔ΂
		SubYAB32	fTmpH, fTmpM, fTmpN, fTmpL, fRemainBytesH, fRemainBytesM, fRemainBytesN, fRemainBytesL, #0, #0, #HIGH (0512d + 0128d), #LOW (0512d + 0128d)
		;								;fRemainBytes - (512 + 128)
		jc		_IRComSync3					;fRemainBytes < (512 + 128)Ȃǂݔ΂I
		;
		call		FindNextCS					;ɓǂݍނׂf[^̃NX^ԍEZN^ԍ擾
		SubYYA32	fRemainBytesH, fRemainBytesM, fRemainBytesN, fRemainBytesL, #0, #0, #HIGH 0512d, #LOW 0512d
		;								;1ZN^ǂݔ΂
		jmp		_IRComSync4					;[v
		;
_IRComSync3:	;							;^Of[^ǂ`FbN̂܂܁CƂ肠Mobt@փRs[
		call		ReadFileData					;t@C1ZN^ǂݍ
		SubYAB16	DPH, DPL, fRemainBytesN, fRemainBytesL, #0, #0128d	;DPTR : ^Of[^̐擪AhX
		mov		EMI0CN, #HIGH cIrTxBuffer			;EMI0CN𑗐Mobt@̈ɐݒ
		mov		fParamCopyDst, #LOW cIrTxBuffer			;Mobt@f[^|C^
		;
		mov		A, #cIrStartCode				;A : X^[gR[h
		movx		@fParamCopyDst, A				;Mf[^obt@֓]
		inc		fParamCopyDst					;Mobt@f[^|C^XV
		;
		mov		A, #(0128d + 1)					;A : f[^oCg
		movx		@fParamCopyDst, A				;Mf[^obt@֓]
		inc		fParamCopyDst					;Mobt@f[^|C^XV
		;
		mov		A, #cIrAck					;A : ACK
		movx		@fParamCopyDst, A				;Mf[^obt@֓]
		inc		fParamCopyDst					;Mobt@f[^|C^XV
		;
		mov		fTagByteCtr, #0128d				;^Of[^oCgJE^
_IRComSync5:	movx		A, @DPTR					;A : ^Of[^
		movx		@fParamCopyDst, A				;^Of[^obt@֓]
		inc		DPTR						;ZN^obt@|C^XV
		mov		A, DPH						;A : ZN^obt@|C^(H)
		jnb		ACC.1, _IRComSync6				;ZN^obt@|C^ < 512ȂWv
		;
		call		FindNextCS					;ɓǂݍނׂf[^̃NX^ԍEZN^ԍ擾
		call		ReadFileData					;t@C1ZN^ǂݍ
		mov		DPTR, #0000h					;ZN^obt@|C^
		;
_IRComSync6:	inc		fParamCopyDst					;Mobt@f[^|C^XV
		djnz		fTagByteCtr, _IRComSync5			;^Of[^oCgJE^0ɂȂ܂Ń[v
		;
		;							;^Of[^ǂ̃`FbN
		mov		DPTR, #cIrTxBuffer + 3				;^Of[^|C^
		movx		A, @DPTR					;A : ^Of[^1oCg
		cjne		A, #"T", _IRComSync7				;"T"łȂ΃^OłȂ
		;
		inc		DPTR						;^Of[^|C^XV
		movx		A, @DPTR					;A : ^Of[^2oCg
		cjne		A, #"A", _IRComSync7				;"A"łȂ΃^OłȂ
		;
		inc		DPTR						;^Of[^|C^XV
		movx		A, @DPTR					;A : ^Of[^3oCg
		cjne		A, #"G", _IRComSync7				;"G"łȂ΃^OłȂ
		;
_IRComSync9:	;							;^O`FbNOK
		mov		PSW, fPswSave					;SeekMp3FileNoIPSWA
		jnb		F0, _IRComSyncB					;1ȖڃtONAȂWv
		;
		mov		DPTR, #cIrTxBuffer + 3 + 2			;^Of[^|C^ : ^Of[^3oCg
		mov		A, #"g"						;A : "g"
		movx		@DPTR, A					;fBNg1Ȗڂ̂ƂA"TAG""TAg"ɂ
		;
_IRComSyncB:	call		LoadNvParams					;sԕA
		call		ReadFileData					;t@C1ZN^ǂݍ
		mov		fIrTxBytes, #(0128d + 1 + 3)			;ԊOMf[^oCg
		pop		PSW						;WX^oNA
		jmp		_MainIrSumTx					;`FbNTAMv
		;
_IRComSync7:	;							;^O`FbNNG
		push		B						;Bۑ
		mov		DPTR, #cIrTxBuffer + 3				;^Of[^|C^
		mov		B, #0128d					;^Of[^oCgJE^
		mov		A, #" "						;tBf[^
_IRComSync8:	movx		@DPTR, A					;Xy[XłƂ肠S̈tB
		inc		DPTR						;^Of[^|C^XV
		djnz		B, _IRComSync8					;^Of[^oCgJE^0ɂȂ܂Ń[v
		;
		mov		DPTR, #cIrTxBuffer + 3				;^Of[^|C^
		mov		A, #"T"						;A : "T"
		movx		@DPTR, A					;փ^Of[^
		;
		inc		DPTR						;^Of[^|C^XV
		mov		A, #"A"						;A : "A"
		movx		@DPTR, A					;փ^Of[^
		;
		inc		DPTR						;^Of[^|C^XV
		mov		A, #"G"						;A : "G"
		movx		@DPTR, A					;փ^Of[^
		;
		inc		DPTR						;^Of[^|C^XV
		mov		A, #"F"						;A : "F"
		movx		@DPTR, A					;փ^Of[^
		;
		inc		DPTR						;^Of[^|C^XV
		mov		A, #"i"						;A : "i"
		movx		@DPTR, A					;փ^Of[^
		;
		inc		DPTR						;^Of[^|C^XV
		mov		A, #"l"						;A : "l"
		movx		@DPTR, A					;փ^Of[^
		;
		inc		DPTR						;^Of[^|C^XV
		mov		A, #"e"						;A : "e"
		movx		@DPTR, A					;փ^Of[^
		;
		inc		DPTR						;^Of[^|C^XV
		mov		A, #"N"						;A : "N"
		movx		@DPTR, A					;փ^Of[^
		;
		inc		DPTR						;^Of[^|C^XV
		mov		A, #"o"						;A : "o"
		movx		@DPTR, A					;փ^Of[^
		;
		inc		DPTR						;^Of[^|C^XV
		mov		A, #"."						;A : "."
		movx		@DPTR, A					;փ^Of[^
		;
		mov		A, fFileNo					;A : t@Cԍ
		mov		B, #0100d					;B : 100
		div		AB						;t@Cԍ / 100
		add		A, #"0"						;ASCIIɕϊ
		inc		DPTR						;^Of[^|C^XV
		movx		@DPTR, A					;փ^Of[^
		;
		mov		A, B						;A : t@Cԍ / 100̏]
		mov		B, #010d					;B : 10
		div		AB						;t@Cԍ / 10
		add		A, #"0"						;ASCIIɕϊ
		inc		DPTR						;^Of[^|C^XV
		movx		@DPTR, A					;փ^Of[^
		;
		mov		A, B						;A : t@Cԍ / 10̏]
		add		A, #"0"						;ASCIIɕϊ
		inc		DPTR						;^Of[^|C^XV
		movx		@DPTR, A					;փ^Of[^
		;
		pop		B						;BA
		jmp		_IRComSync9					;փ^Of[^M
		;
IRComResend:	;---------------------------------------;ÕpPbgđR}h
		setb		fIrMode.bImTxReq				;MJnvtOZbg
		jmp		_MainIrProc0					;I
		;
IRComVolUp:	;---------------------------------------;{[AbvR}h
		call		ProcVolumeUp					;{[Abv
		mov		A, fVolume					;A : {[l
		jmp		_MainIrResAck					;sAACKM
		;
IRComVolDn:	;---------------------------------------;{[_ER}h
		call		ProcVolumeDn					;{[_E
		mov		A, fVolume					;A : {[l
		jmp		_MainIrResAck					;sAACKM
		;
IRComTreble:	;---------------------------------------;拭ݒR}h
		mov		EMI0CN, #HIGH cIrRxBuffer			;EMI0CNMobt@̈ɐݒ
		mov		fParamCopySrc, #LOW (cIrRxBuffer + 2)		;Mobt@f[^|C^
		movx		A, @fParamCopySrc				;A : p[^
		;
		anl		fTdaReg0, #11110011b				;ݒrbgNA
		anl		A, #00001100b					;ݒrbgo
		orl		fTdaReg0, A					;fTdaReg0XV
		call		TxTdaReg					;TDA7463ADWX^Cg
		jmp		_MainIrResAck					;sAACKM
		;
IRComBass:	;---------------------------------------;拭ݒR}h
		mov		EMI0CN, #HIGH cIrRxBuffer			;EMI0CNMobt@̈ɐݒ
		mov		fParamCopySrc, #LOW (cIrRxBuffer + 2)		;Mobt@f[^|C^
		movx		A, @fParamCopySrc				;A : p[^
		;
		anl		fTdaReg1, #11111001b				;ݒrbgNA
		anl		A, #00000110b					;ݒrbgo
		orl		fTdaReg1, A					;fTdaReg1XV
		call		TxTdaReg					;TDA7463ADWX^Cg
		jmp		_MainIrResAck					;sAACKM
		;
IRComMp3Stop:	;---------------------------------------;MP3XgbvR}h
		;							;rW[`FbN
		mov		A, fPlayMode					;A : vC[hoCg
		anl		A, #bmPmOpMode					;샂[hrbgo
		jz		_IRComMp3Stop1					;MP3ʏĐ[hAFMʏM[hȂWv
		;
		jmp		_MainIrResBusy					;쒆ȂrW[
		;
_IRComMp3Stop1:	;							;R}hs
		call		ProcMp3Stop					;MP3Xgbv
		mov		A, fPlayMode					;A : vC[hoCg
		jmp		_MainIrResAck					;sAACKM
		;
IRComMp3Play:	;---------------------------------------;MP3vCR}h
		;							;rW[`FbN
		mov		A, fPlayMode					;A : vC[hoCg
		anl		A, #bmPmOpMode					;샂[hrbgo
		jz		_IRComMp3Play1					;MP3ʏĐ[hAFMʏM[hȂWv
		;
		jmp		_MainIrResBusy					;쒆ȂrW[
		;
_IRComMp3Play1:	;							;R}hs
		call		ProcMp3Play					;MP3vC
		mov		A, fPlayMode					;A : vC[hoCg
		jmp		_MainIrResAck					;sAACKM
		;
IRComMp3Jump:	;---------------------------------------;MP3WvR}h
		;							;rW[`FbN
		mov		A, fPlayMode					;A : vC[hoCg
		anl		A, #bmPmOpMode					;샂[hrbgo
		jz		_IRComMp3Jump1					;MP3ʏĐ[hAFMʏM[hȂWv
		;
		jmp		_MainIrResBusy					;쒆ȂrW[
		;
_IRComMp3Jump1:	;							;R}hs
		mov		EMI0CN, #HIGH cIrRxBuffer			;EMI0CNMobt@̈ɐݒ
		mov		fParamCopySrc, #LOW (cIrRxBuffer + 2)		;Mobt@f[^|C^
		movx		A, @fParamCopySrc				;A : p[^
		mov		fFileNo, A					;fFileNoXV
		call		SeekMp3FileNo					;t@CT
		jc		_IRComMp3JumpE					;G[̏ꍇɂ̓Wv
		;
		;							;Ȃꍇ
		call		ReadFileData					;t@C1ZN^ǂݍ
		mov		fPlayPointerH, #0
		mov		fPlayPointerL, #0				;fPlayPointer : XRAM̍Đ|C^
		;
		;							;ĐJn
		setb		fPlayMode.bPmPlaying				;ĐtOZbg
		MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v()
		mov		A, fFileNo					;A : fFileNo
		jmp		_MainIrResAck					;sAACKM
		;
_IRComMp3JumpE:	;							;t@CȂꍇ
		clr		fPlayMode.bPmPlaying				;ĐtONA
		call		SaveNvParams					;s֏ԕۑ
		MakeBeep	cBeepNoteL, cBeepTimeOp				;r[v(ቹ)
		jmp		_MainIrComNop					;R}h𖳎
		;
IRComMp3FfRew:	;---------------------------------------;MP3芪߂R}h
		;							;rW[`FbN
		mov		A, fPlayMode					;A : vC[hoCg
		anl		A, #bmPmOpMode					;샂[hrbgo
		jz		_IRComMp3FR1					;MP3ʏĐ[hAFMʏM[hȂWv
		;
		jmp		_MainIrResBusy					;쒆ȂrW[
		;
_IRComMp3FR1:	;							;R}hs
		mov		EMI0CN, #HIGH cIrRxBuffer			;EMI0CNMobt@̈ɐݒ
		mov		fParamCopySrc, #LOW (cIrRxBuffer + 2)		;Mobt@f[^|C^
		movx		A, @fParamCopySrc				;A : p[^
		mov		fFfRewMode, A					;fFfRewModeXV
		jmp		_MainIrResAck					;sAACKM
		;
IRComMp3Repeat:	;---------------------------------------;MP3s[gݒR}h
		mov		EMI0CN, #HIGH cIrRxBuffer			;EMI0CNMobt@̈ɐݒ
		mov		fParamCopySrc, #LOW (cIrRxBuffer + 2)		;Mobt@f[^|C^
		movx		A, @fParamCopySrc				;A : p[^
		mov		fRepeatMode, A					;fRepeatModeXV
		jmp		_MainIrResAck					;sAACKM
		;
IRComFmStop:	;---------------------------------------;FMWIItR}h
		;							;rW[`FbN
		mov		A, fPlayMode					;A : vC[hoCg
		anl		A, #bmPmOpMode					;샂[hrbgo
		jz		_IRComFmStop1					;MP3ʏĐ[hAFMʏM[hȂWv
		;
		jmp		_MainIrResBusy					;쒆ȂrW[
		;
_IRComFmStop1:	;							;R}hs
		call		ProcFmStop					;FMWIIt
		mov		A, fPlayMode					;A : vC[hoCg
		jmp		_MainIrResAck					;sAACKM
		;
IRComFmPlay:	;---------------------------------------;FMWIIR}h
		;							;rW[`FbN
		mov		A, fPlayMode					;A : vC[hoCg
		anl		A, #bmPmOpMode					;샂[hrbgo
		jz		_IRComFmPlay1					;MP3ʏĐ[hAFMʏM[hȂWv
		;
		jmp		_MainIrResBusy					;쒆ȂrW[
		;
_IRComFmPlay1:	;							;R}hs
		call		ProcFmPlay					;FMWII
		mov		A, fPlayMode					;A : vC[hoCg
		jmp		_MainIrResAck					;sAACKM
		;
IRComFmJump:	;---------------------------------------;FMvZbgǑIR}h
		;							;rW[`FbN
		mov		A, fPlayMode					;A : vC[hoCg
		anl		A, #bmPmOpMode					;샂[hrbgo
		jz		_IRComFmJump1					;MP3ʏĐ[hAFMʏM[hȂWv
		;
		jmp		_MainIrResBusy					;쒆ȂrW[
		;
_IRComFmJump1:	;							;R}hs
		mov		EMI0CN, #HIGH cIrRxBuffer			;EMI0CNMobt@̈ɐݒ
		mov		fParamCopySrc, #LOW (cIrRxBuffer + 2)		;Mobt@f[^|C^
		movx		A, @fParamCopySrc				;A : p[^
		cjne		A, #cPreStTables, $ + 3				;p[^ - vZbgǐ
		jnc		_IRComFmJumpE					;p[^ >= vZbgǐȂG[
		;
		mov		fPreStNo, A					;vZbgǔԍXV
		call		SetPreStIdx					;vZbgǂ̎ge[uCfbNXZbg
		MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v()
		call		SetNsTuneFreq					;NS953M֎MgZbg
		call		SetTdaInput					;TDA7463AD͐؂ւ
		mov		A, fPreStNo					;A : vZbgǔԍ
		jmp		_MainIrResAck					;sAACKM
		;
_IRComFmJumpE:	;							;ȃvZbgǔԍ̏ꍇ
		clr		fPlayMode.bPmPlaying				;ĐtONA
		call		SaveNvParams					;s֏ԕۑ
		MakeBeep	cBeepNoteL, cBeepTimeOp				;r[v(ቹ)
		jmp		_MainIrComNop					;R}h𖳎
		;
IRComFmSearch:	;---------------------------------------;FMI[gT[`R}h
		;							;rW[`FbN
		mov		A, fPlayMode					;A : vC[hoCg
		anl		A, #bmPmOpMode					;샂[hrbgo
		jz		_IRComFmSrch1					;MP3ʏĐ[hAFMʏM[hȂWv
		;
		jmp		_MainIrResBusy					;쒆ȂrW[
		;
_IRComFmSrch1:	;							;R}hs
		jmp		_MainIrComNop					;
		;
IRComFmManual:	;---------------------------------------;FM}jAIǃR}h
		;							;rW[`FbN
		mov		A, fPlayMode					;A : vC[hoCg
		anl		A, #bmPmOpMode					;샂[hrbgo
		jz		_IRComFmManu1					;MP3ʏĐ[hAFMʏM[hȂWv
		;
		jmp		_MainIrResBusy					;쒆ȂrW[
		;
_IRComFmManu1:	;							;s\`FbN
		jb		fPlayMode.bPmPlaying, _IRComFmManu2		;~łȂ΃Wv
		;
		jmp		_MainIrComNop					;~Ȃ疳
		;
_IRComFmManu2:	jb		fPlayMode.bPmFm, _IRComFmManu3			;FMWI[hȂWv
		;
		jmp		_MainIrComNop					;FMWI[hłȂȂ疳
		;
_IRComFmManu3:	;							;R}hs
		mov		EMI0CN, #HIGH cIrRxBuffer			;EMI0CNMobt@̈ɐݒ
		mov		fParamCopySrc, #LOW (cIrRxBuffer + 2)		;Mobt@f[^|C^
		movx		A, @fParamCopySrc				;A : p[^
		cjne		A, #cFreqTableIdxes, $ + 3			;p[^ - ge[uCfbNX
		jnc		_IRComFmManuE					;p[^ >= ge[uCfbNXȂG[
		;
		mov		fFreqTableIdx, A				;ge[uCfbNXXV
		call		SetNsTuneFreq					;NS953M֎MgZbg
		mov		A, fFreqtableIdx				;A : ge[uCfbNX
		jmp		_MainIrResAck					;sAACKM
		;
_IRComFmManuE:	;							;Ȏge[uCfbNX̏ꍇ
		clr		fPlayMode.bPmPlaying				;ĐtONA
		call		SaveNvParams					;s֏ԕۑ
		MakeBeep	cBeepNoteL, cBeepTimeOp				;r[v(ቹ)
		jmp		_MainIrComNop					;R}h𖳎
		;
IRComTest:	;---------------------------------------;eXgR}h
		clr		A						;ANA
		jmp		_MainIrResAck					;sAACKM
		;
_MainSwProc:	;---------------------------------------;XCb`
		;							;XCb`XV`FbN
		jb		fPlayMode.bPmSwUpdate, _MainSwProc4		;PmSwUpdateZbgȂ珈s
		;
		jmp		_MainSwProc01					;NAȂ珈sv
		;
_MainSwProc4:	;							;XCb`s
		;
		;							;XCb`̓`FbN
		mov		A, fSwStatus					;A : XCb`̏
		jnz		_MainSwProc3					;ǂꂩXCb`Ă΃XCb`
		;
		mov		A, fSwStatus1to0				;A : XCb`̏ԕω(ONOFF)
		jnz		_MainSwProc3					;XCb`삪΃XCb`
		;
		;							;SXCb`OFF̏ꍇ@쎞ԍXVA`FbN
		AddYYA16	fNoOpCtrH, fNoOpCtrL, #0, #1			;fNoOpCtr : fNoOpCtr + 1
		cjne		fNoOpCtrL, #LOW cOpModeReset, _MainSwProc00	;fNoOpCtr <> cOpModeResetȂWv
		;
		cjne		fNoOpCtrH, #HIGH cOpModeReset, _MainSwProc00	;fNoOpCtr <> cOpModeResetȂWv
		;
		;							;쎞ԂcOpModeResetԌp̂ő샂[hZbg
		anl		fPlayMode, #NOT bmPmOpMode			;샂[hrbgNA
_MainSwProc00:	jmp		_MainSwProc0					;XCb`I
		;
_MainSwProc3:	;							;XCb`Cxgꍇ
		mov		fIdleCtrL, #0
		mov		fIdleCtrH, #0					;~ԃJE^
		mov		fNoOpCtrL, #0
		mov		fNoOpCtrH, #0					;쎞ԃJE^
		;
		;							;Cxg
		jb		fPlayMode.bPmPlaying, _MainSwOpMode		;ĐtOZbgȂWv
		;
		;							;~̑
		jb		fSwStatus0to1.bSwF, sOpMp3Play			;SwFOFFON : MP3vC
		jb		fSwStatus0to1.bSwU, sOpFmPlay			;SwUOFFON : FMWII
		jb		fSwStatus0to1.bSwU, sOpJumpMarkA		;SwUOFFON : }[JփWv
		jb		fSwStatus0to1.bSwD, sOpSetMarkA			;SwDOFFON : }[JZbg
		jb		fSwStatus0to1.bSwR, sOpBattery			;SwROFFON : obe`FbN
		jmp		_MainSwProc0					;XCb`I
		;
		;								;[U쏈[`ւ̓ݑ
sOpMp3Play:	jmp		OpMp3Play					;MP3vC
sOpFmPlay:	jmp		OpFmPlay					;FMWII
sOpJumpMarkA:	jmp		OpJumpMarkA					;}[JփWv
sOpSetMarkA:	jmp		OpSetMarkA					;}[JZbg
sOpBattery:	jmp		OpBattery					;obe`FbN
		;
		;							;[hʂɕ
_MainSwOpMode:	mov		DPTR, #OmTableMp3				;DPTR : MP3p샂[hʃxN^e[u擪AhX
		jnb		fPlayMode.bPmFm, _MainSwOm1			;FM[hłȂ΃Wv
		;
		mov		DPTR, #OmTableFm				;DPTR : FMp샂[hʃxN^e[u擪AhX
		;
_MainSwOm1:	mov		A, fPlayMode					;A : fPlayMode
		anl		A, #bmPmOpMode					;A : 샂[hrbgo
		add		A, ACC						;A : A * 2
		jmp		@A + DPTR					;샂[hʂɃWv
		;
OmTableMp3:	;								;MP3p샂[hʃxN^e[u擪AhX
		ajmp		OnOmMp3Play					;MP3ʏĐ[h̑
		ajmp		OnOmMp3TrJump					;gbNWv[h̑
		ajmp		OnOmMp3DirJump					;fBNgWv[h̑
		ajmp		OnOmMp3FfRew					;芪߂[h̑
		ajmp		OnOmMp3ToneCnt					;g[Rg[ݒ胂[h̑
		ajmp		OnOmMp3Repeat					;s[gݒ胂[h̑
		;
OmTableFm:	;								;FMp샂[hʃxN^e[u擪AhX
		ajmp		OnOmFmPlay					;FMʏM[h̑
		ajmp		OnOmFmSelectSt					;vZbgǑI[h̑
		ajmp		OnOmFmSearchSt					;ǃT[`[h̑
		ajmp		OnOmFmTuneManu					;}jAIǃ[h̑
		ajmp		OnOmFmToneCnt					;g[Rg[ݒ胂[h̑
		;
OnOmMp3Play:	;							;MP3ʏĐ[h̑
		jb		fSwStatus0to1.bSwF, sOpMp3ModeSucc		;SwFOFFON : [hύX
		jb		fSwStatus.bSwU, sOpMp3VolumeUp			;SwUON : {[Abv
		jb		fSwStatus.bSwD, sOpMp3VolumeDn			;SwDON : {[_E
		jb		fSwStatus0to1.bSwR, sOpMp3Stop			;SwROFFON : Xgbv
		jmp		_MainSwProc0					;XCb`I
		;
		;								;[U쏈[`ւ̓ݑ
sOpMp3VolumeUp:	jmp		OpVolumeUp					;{[Abv
sOpMp3VolumeDn:	jmp		OpVolumeDn					;{[_E
sOpMp3Stop:	jmp		OpMp3Stop					;Xgbv
		;
OnOmMp3TrJump:	;							;gbNWv[h̑
		jb		fSwStatus0to1.bSwF, sOpMp3ModeSucc		;SwFOFFON : [hύX
		jb		fSwStatus0to1.bSwU, sOpTrJumpNext		;SwUOFFON : ̋ȂփWv
		jb		fSwStatus0to1.bSwD, sOpTrJumpPrev		;SwDOFFON : ŐȂփWv
		jb		fSwStatus0to1.bSwR, sOpModeMp3Play		;SwROFFON : ʏĐ[h
		jmp		_MainSwProc0					;XCb`I
		;
		;								;[U쏈[`ւ̓ݑ
sOpMp3ModeSucc:	jmp		OpMp3ModeSucc					;[hύX
sOpTrJumpNext:	jmp		OpTrJumpNext					;̋ȂփWv
sOpTrJumpPrev:	jmp		OpTrJumpPrev					;ŐȂփWv
sOpModeMp3Play:	jmp		OpModeMp3Play					;ʏĐ[h
		;
OnOmMp3DirJump:	;							;fBNgWv[h̑
		jb		fSwStatus0to1.bSwF, sOpMp3ModeSucc		;SwFOFFON : [hύX
		jb		fSwStatus0to1.bSwU, sOpDirJumpNext		;SwUOFFON : ̃fBNgփWv
		jb		fSwStatus0to1.bSwD, sOpDirJumpPrev		;SwDOFFON : ÕfBNgփWv
		jb		fSwStatus0to1.bSwR, sOpModeMp3Play		;SwROFFON : ʏĐ[h
		jmp		_MainSwProc0					;XCb`I
		;
		;								;[U쏈[`ւ̓ݑ
sOpDirJumpNext:	jmp		OpDirJumpNext					;̃fBNgփWv
sOpDirJumpPrev:	jmp		OpDirJumpPrev					;ÕfBNgփWv
		;
OnOmMp3FfRew:	;							;芪߂[h̑
		jb		fSwStatus0to1.bSwF, sOpMp3ModeSucc		;SwFOFFON : [hύX
		jb		fSwStatus0to1.bSwU, sOpFfRewAttOn		;SwUOFFON : /߂ʒON
		jb		fSwStatus0to1.bSwD, sOpFfRewAttOn		;SwDOFFON : /߂ʒON
		jb		fSwStatus.bSwU, sOpFF				;SwUON : 
		jb		fSwStatus.bSwD, sOpREW				;SwDON : ߂
		jb		fSwStatus1to0.bSwU, sOpFfRewAttOff		;SwUONOFF : /߂ʒOFF
		jb		fSwStatus1to0.bSwD, sOpFfRewAttOff		;SwDONOFF : /߂ʒOFF
		jb		fSwStatus0to1.bSwR, sOpModeMp3Play		;SwROFFON : ʏĐ[h
		jmp		_MainSwProc0					;XCb`I
		;
		;								;[U쏈[`ւ̓ݑ
sOpFF:		jmp		OpFF						;
sOpREW:		jmp		OpREW						;߂
sOpFfRewAttOn:	jmp		OpFfRewAttOn					;/߂ʒON
sOpFfRewAttOff:	jmp		OpFfRewAttOff					;/߂ʒOFF
		;
OnOmMp3ToneCnt:	;							;g[Rg[ݒ胂[h̑
		jb		fSwStatus0to1.bSwF, sOpMp3ModeSucc		;SwFOFFON : [hύX
		jb		fSwStatus0to1.bSwU, sOpMp3Treble		;SwUOFFON : g[Rg[ݒύX
		jb		fSwStatus0to1.bSwD, sOpMp3Bass			;SwDOFFON : g[Rg[ݒύX
		jb		fSwStatus0to1.bSwR, sOpModeMp3Play		;SwROFFON : ʏĐ[h
		jmp		_MainSwProc0					;XCb`I
		;
		;								;[U쏈[`ւ̓ݑ
sOpMp3Treble:	jmp		OpTreble					;g[Rg[ݒύX
sOpMp3Bass:	jmp		OpBass						;g[Rg[ݒύX
		;
OnOmMp3Repeat:	;							;s[gݒ胂[h̑
		jb		fSwStatus0to1.bSwF, sOpMp3ModeSucc		;SwFOFFON : [hύX
		jb		fSwStatus0to1.bSwU, sOpRepeatMode		;SwUOFFON : s[g[hύX
		jb		fSwStatus0to1.bSwD, sOpRepeatOff		;SwDOFFON : s[gIt
		jb		fSwStatus0to1.bSwR, sOpModeMp3Play		;SwROFFON : ʏĐ[h
		jmp		_MainSwProc0					;XCb`I
		;
		;								;[U쏈[`ւ̓ݑ
sOpRepeatMode:	jmp		OpRepeatMode					;s[g[hύX
sOpRepeatOff:	jmp		OpRepeatOff					;s[gIt
		;
OnOmFmPlay:	;							;FMʏM[h̑
		jb		fSwStatus0to1.bSwF, sOpFmModeSucc		;SwFOFFON : [hύX
		jb		fSwStatus.bSwU, sOpFmVolumeUp			;SwUON : {[Abv
		jb		fSwStatus.bSwD, sOpFmVolumeDn			;SwDON : {[_E
		jb		fSwStatus0to1.bSwR, sOpFmStop			;SwROFFON : FMM~
		jmp		_MainSwProc0					;XCb`I
		;
		;								;[U쏈[`ւ̓ݑ
sOpFmModeSucc:	jmp		OpFmModeSucc					;[hύX
sOpFmVolumeUp:	jmp		OpVolumeUp					;{[Abv
sOpFmVolumeDn:	jmp		OpVolumeDn					;{[_E
sOpFmStop:	jmp		OpFmStop					;FMM~
		;
OnOmFmSelectSt:	;							;vZbgǑI[h̑
		jb		fSwStatus0to1.bSwF, sOpFmModeSucc		;SwFOFFON : [hύX
		jb		fSwStatus0to1.bSwU, sOpFmPreStInc		;SwUOFFON : vZbgǑIԍAbv
		jb		fSwStatus0to1.bSwD, sOpFmPreStDec		;SwDOFFON : vZbgǑIԍ_E
		jb		fSwStatus0to1.bSwR, sOpModeFmPlay		;SwROFFON : ʏM[h
		jmp		_MainSwProc0					;XCb`I
		;
sOpFmPreStInc:	jmp		OpFmPreStInc					;vZbgǑIԍAbv
sOpFmPreStDec:	jmp		OpFmPreStDec					;vZbgǑIԍ_E
sOpModeFmPlay:	jmp		OpModeFmPlay					;ʏM[h
		;
OnOmFmSearchSt:	;							;ǃT[`[h̑
		jb		fSwStatus0to1.bSwF, sOpFmModeSucc		;SwFOFFON : [hύX
		jb		fSwStatus0to1.bSwU, sOpFmSearchU		;SwUOFFON : ǃT[`()
		jb		fSwStatus0to1.bSwD, sOpFmSearchD		;SwDOFFON : ǃT[`()
		jb		fSwStatus0to1.bSwR, sOpModeFmPlay		;SwROFFON : ʏM[h
		jmp		_MainSwProc0					;XCb`I
		;
sOpFmSearchU:	jmp		OpFmSearchU					;ǃT[`()
sOpFmSearchD:	jmp		OpFmSearchD					;ǃT[`()
		;
OnOmFmTuneManu:	;							;}jAIǃ[h̑
		jb		fSwStatus0to1.bSwF, sOpFmModeSucc		;SwFOFFON : [hύX
		jb		fSwStatus.bSwU, sOpFmTuneManUp			;SwUON : }jAI()
		jb		fSwStatus.bSwD, sOpFmTuneManDn			;SwDON : }jAI()
		jb		fSwStatus0to1.bSwR, sOpModeFmPlay		;SwROFFON : ʏM[h
		jmp		_MainSwProc0					;XCb`I
		;
sOpFmTuneManUp:	jmp		OpFmTuneManUp					;}jAI()
sOpFmTuneManDn:	jmp		OpFmTuneManDn					;}jAI()
		;
OnOmFmToneCnt:	;							;g[Rg[ݒ胂[h̑
		jb		fSwStatus0to1.bSwF, sOpFmModeSucc		;SwFOFFON : [hύX
		jb		fSwStatus0to1.bSwU, sOpFmTreble			;SwUOFFON : g[Rg[ݒύX
		jb		fSwStatus0to1.bSwD, sOpFmBass			;SwDOFFON : g[Rg[ݒύX
		jb		fSwStatus0to1.bSwR, sOpModeFmPlay		;SwROFFON : ʏM[h
		jmp		_MainSwProc0					;XCb`I
		;
sOpFmTreble:	jmp		OpTreble					;g[Rg[ݒύX
sOpFmBass:	jmp		OpBass						;g[Rg[ݒύX
		;
_MainSwProc0:	clr		fPlayMode.bPmSwUpdate				;PmSwUpdateNA
		;
_MainSwProc01:	jmp		_MainPlayProc					;XCb`IȀ
		;
_MainPlayProc:	;---------------------------------------;vC
		;							;ĐtO`FbN
		jb		fPlayMode.bPmPlaying, _MainPlayProc7		;ĐȂWv
		;
		jmp		_MainPlayProc3					;~փWv
		;
_MainPlayProc7:	;							;FM[h`FbN
		jnb		fPlayMode.bPmFm, _MainPlayProcB			;FM[hłȂȂMP3[h̏
		;
		call		PowerDownVs					;VS1011NĂ~
		jmp		_MainPlayProc1					;MP3[h̏XLbv
		;
_MainPlayProcB:	;							;ԊOɂ鑁/߂R}h
		mov		A, fFfRewMode					;A : /߂[h
		cjne		A, #cFfMode, _MainPlayProcC			;胂[hłȂȂWv
		;
		call		ProcFF						;菈
		jmp		_MainPlayProcD					;
		;
_MainPlayProcC:	cjne		A, #cRewMode, _MainPlayProcD			;߂[hłȂȂWv
		;
		call		ProcREW						;߂
		;
_MainPlayProcD:	;							;VS1011 DREQ`FbN
		jb		pVsDreq, _MainPlayProc8				;DREQ = "H"ȂWv
		;
		jmp		_MainPlayProc1					;DREQ = "L"ȂĐXLbv
		;
_MainPlayProc8:	;							;݂̃t@CĐI`FbN
		call		CheckRemain					;c`FbNAA = 0ȂcȂ
		jz		_MainPlayProc4					;fRemainBytes = 0ȂWv
		;
		;							;݂̃t@CĐs
		mov		DPH, fPlayPointerH				;
		mov		DPL, fPlayPointerL				;DPTR : XRAM̍Đ|C^
		movx		A, @DPTR					;A : Mf[^
		mov		fVsSdiD, A					;fVsSdiD : Mf[^
		call		TxVsSdi						;SDIf[^M
		inc		DPTR						;DPTR : Đ|C^CNg
		mov		A, DPH						;A : XRAM̍Đ|C^(H)
		jnb		ACC.1, _MainPlayProc6				;XRAM̍Đ|C^ < 512ȂWv
		;
		call		FindNextCS					;ɓǂݍނׂf[^̃NX^ԍEZN^ԍ擾
		call		ReadFileData					;t@C1ZN^ǂݍ
		mov		DPTR, #0					;DPTR : XRAM̍Đ|C^
_MainPlayProc6:	mov		fPlayPointerH, DPH				;
		mov		fPlayPointerL, DPL				;fPlayPointer : XRAM̍Đ|C^ۑ
		SubYYA32	fRemainBytesH, fRemainBytesM, fRemainBytesN, fRemainBytesL, #0, #0, #0, #1
		;								;fRemainBytes : fRemainBytes - 1
		jmp		_MainPlayProcD					;DREQ"H"Ȃ瑱ăf[^M
		;
_MainPlayProc4:	;							;݂̃t@CĐI
		mov		A, fRepeatMode					;A : fRepeatMode
		jb		ACC.bRmOne, _MainPlayProc9			;݂̋ȃs[gĐtOZbgȂWv
		;
		jnb		ACC.bRmDir, _MainPlayProcF			;݂̃fBNgs[gĐtONAȂWv
		;
		;							;݂̃fBNgs[gĐ[h̏ꍇ
		mov		A, fFileNo					;A : ݂̋Ȕԍ
		clr		C						;CNA
		subb		A, fMp3Files					;A : ݂̋Ȕԍ - SȐ
		jz		_MainPlayProcG					;Ō̃t@CȂfBNg1ȖڂփWv
		;
		inc		fFileNo						;t@CԍXV
		call		SeekMp3FileNo					;fFileNoԖڂ".MP3"t@CT
		jc		_MainPlayProcE					;G[̏ꍇɂ̓Wv
		;
		jnb		F0, _MainPlayProcH				;̃fBNg1Ȃ߂łȂ΍Đ
		;
		call		SeekMp3PrevDir					;ÕfBNgɂŏ".MP3"t@CT
		jc		_MainPlayProcE					;G[̏ꍇɂ̓Wv
		;
		jmp		_MainPlayProc9					;fFileNoԖڂ̃t@CĐ
		;
_MainPlayProcG:	call		SeekMp3CurrDir					;fFileNoԖڂ̃t@C܂܂fBNg̍ŏ".MP3"t@CT
		jc		_MainPlayProcE					;G[̏ꍇɂ̓Wv
		;
		jmp		_MainPlayProc9					;fFileNoԖڂ̃t@CĐ
		;
_MainPlayProcF:	mov		A, fFileNo					;A : ݂̋Ȕԍ
		cjne		A, fMp3Files, _MainPlayProc5			;A <> SȐȂWv
		;
		;							;Ō̃t@CĐI
		mov		A, fRepeatMode					;A : fRepeatMode
		jb		ACC.bRmAll, _MainPlayProcA			;Sȃs[gĐtOZbgȂWv
		;
		clr		fPlayMode.bPmPlaying				;ĐtONAčĐ~
		MakeBeep	cBeepNoteM, cBeepTimeOp				;r[v()
_MainPlayProcA:	mov		fFileNo, #1					;1ȖڂĂ
		jmp		_MainPlayProc9					;fFileNoԖڂ̃t@CĐ
		;
_MainPlayProc5:	;							;̃t@C
		inc		fFileNo						;t@CԍXV
_MainPlayProc9:	call		SeekMp3FileNo					;fFileNoԖڂ".MP3"t@CT
		jc		_MainPlayProcE					;G[̏ꍇɂ̓Wv
		;
_MainPlayProcH:	call		ReadFileData					;t@C1ZN^ǂݍ
		mov		fPlayPointerH, #0
		mov		fPlayPointerL, #0				;fPlayPointer : XRAM̍Đ|C^
		jmp		_MainPlayProc2					;Wv
		;
_MainPlayProc3:	;							;~
		TdaMute		On						;TDA7463AD Output Mute
		call		PowerDownVs					;VS1011~
		;
		;							;~ԍXVA`FbN
		AddYYA16	fIdleCtrH, fIdleCtrL, #0, #1			;fIdleCtr : fIdleCtr + 1
		mov		A, fIdleCtrL					;A : fIdleCtrL
		cjne		A, #LOW cShutdown, _MainPlayProc1		;fIdleCtr <> cShutdownȂWv
		;
		mov		A, fIdleCtrH					;A : fIdleCtrH
		cjne		A, #HIGH cShutdown, _MainPlayProc1		;fIdleCtr <> cShutdownȂWv
		;
		;							;~ԂcShutDownԌp̂ŃVbg_E
		MakeBeep	cBeepNoteL, cBeepTimeShDn			;r[v(ቹ)
		jmp		ShutDown					;Vbg_E
		;
_MainPlayProc1:	jmp		_Main1					;_Main1փWv
		;
_MainPlayProc2:	jmp		_Main2					;_Main2փWv
		;
_MainPlayProcE:	jmp		_InitE					;_InitEփWv
		;
OpBattery:	;---------------------------------------;obe`FbN
		;							;obedr[vŒm点
		call		ReadBattVolts					;obed[h
		mov		A, fBattVoltage					;A : obedl(BCD2)
		;
		mov		fLoopCtr, #08d					;fLoopCtr : [vJE^
_OpBattery2:	push		ACC
		jb		ACC.7, _OpBattery1				;A(7) = 1ȂWv
		;
		MakeBeep	cBeepNoteM, cBeepTimeBatt			;r[v()
		jmp		_OpBattery3					;Wv
		;
_OpBattery1:	MakeBeep	cBeepNoteH, cBeepTimeBatt			;r[v()
_OpBattery3:	mov		A, #01d						;0.1b҂
		cjne		fLoopCtr, #05d, _OpBattery4			;fLoopCtr <> 5ȂWv
		;
		mov		A, #03d						;0.3b҂
_OpBattery4:	call		WaitA100msec					;A100msec҂
		pop		ACC
		rl		A						;A : [e[g
		djnz		fLoopCtr, _OpBattery2				;[v
		;
		jmp		_MainSwProc0					;Cփ^[
		;
OpMp3ModeSucc:	;---------------------------------------;MP3샂[hύX
		mov		A, fPlayMode					;A : fPlayMode
		anl		A, #bmPmOpMode					;샂[hrbg𒊏o
		inc		A						;샂[hЂƂi߂
		cjne		A, #cOmMp3Repeat + 1, _OMp3ModeSucc1		;샂[h[I[ołȂ΃Wv
		;
		mov		A, #cOmMp3Play					;[I[oȂʏĐ[h
_OMp3ModeSucc1:	anl		fPlayMode, #NOT bmPmOpMode			;샂[hrbgNA
		orl		fPlayMode, A					;샂[hXV
		;
		mov		DPTR, #_OMp3ModeSucc2				;DPTR : 샂[hʃr[vxN^e[u擪AhX
		add		A, ACC						;A : A * 2
		jmp		@A + DPTR					;샂[hʂɃWv
		;
_OMp3ModeSucc2:	;								;샂[hʃr[vxN^e[u擪AhX
		ajmp		_OMp3MSPlay					;VS1011ʏĐ[h̃r[v
		ajmp		_OMp3MSTrJump					;gbNWv[h̃r[v
		ajmp		_OMp3MSDirJump					;fBNgWv[h̃r[v
		ajmp		_OMp3MSFfRew					;芪߂[h̃r[v
		ajmp		_OMp3MSToneCnt					;g[Rg[ݒ胂[h̃r[v
		ajmp		_OMp3MSRepeat					;s[gݒ胂[h̃r[v
		;
_OMp3MSPlay:	;								;VS1011ʏĐ[h̃r[v
		MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v()
		jmp		_OMp3ModeSucc3					;
		;
_OMp3MSTrJump:	;								;gbNWv[h̃r[v
		MakeBeepOp	cBeepNoteM, cBeepNoteM, cBeepNoteH		;r[v(AA)
		jmp		_OMp3ModeSucc3					;
		;
_OMp3MSDirJump:	;								;fBNgWv[h̃r[v
		MakeBeepOp	cBeepNoteL, cBeepNoteH, cBeepNoteH		;r[v(AA)
		jmp		_OMp3ModeSucc3					;
		;
_OMp3MSFfRew:	;								;芪߂[h̃r[v
		MakeBeepOp	cBeepNoteH, cBeepNoteH, cBeepNoteH		;r[v(AA)
		jmp		_OMp3ModeSucc3					;
		;
_OMp3MSToneCnt:	;								;g[Rg[ݒ胂[h̃r[v
		MakeBeepOp	cBeepNoteH, cBeepNoteM, cBeepNoteH		;r[v(AA)
		jmp		_OMp3ModeSucc3					;
		;
_OMp3MSRepeat:	;								;s[gݒ胂[h̃r[v
		MakeBeepOp	cBeepNoteL, cBeepNoteH, cBeepNoteL		;r[v(AA)
		jmp		_OMp3ModeSucc3					;
		;
_OMp3ModeSucc3:	jmp		_MainSwProc0					;Cփ^[
		;
OpModeMp3Play:	;---------------------------------------;샂[hʏĐ[hɕύX鑀
		anl		fPlayMode, #NOT bmPmOpMode			;샂[hrbgNA
		orl		fPlayMode, #cOmMp3Play				;샂[hXV
		MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v()
		jmp		_MainSwProc0					;Cփ^[
		;
OpMp3Stop:	;---------------------------------------;Xgbv
		call		ProcMp3Stop				;Xgbv
		jmp		_MainSwProc0					;Cփ^[
		;
ProcMp3Stop:	;---------------------------------------;Xgbv({̑/ԊO실)
		;							;Đ~
		clr		fPlayMode.bPmPlaying				;ĐtONA
		anl		fPlayMode, #NOT bmPmOpMode			;샂[hrbgNA
		call		GetVsDecTime					;fR[hԃ[h
		mov		fStartTimeH, fDecodeTimeH			;
		mov		fStartTimeL, fDecodeTimeL			;fStartTime݂܂ł̃fR[hԂōXV
		call		SaveNvParams					;s֏ԕۑ
		MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v()
		;
		ret
		;
OpMp3Play:	;---------------------------------------;vC
		call		ProcMp3Play				;vC
		jmp		_MainSwProc0					;Cփ^[
		;
ProcMp3Play:	;---------------------------------------;vC({̑/ԊO실)
		;							;ĐJn
		setb		fPlayMode.bPmPlaying				;ĐtOZbg
		clr		fPlayMode.bPmFm					;FMWI[hNA
		call		MakeBeepRm					;s[g[hʒmpr[v
		;
		ret
		;
OpVolumeUp:	;---------------------------------------;{[Abv
		;							;Timer3荞81̂ݏ
		mov		A, fUITimerCtr					;A : fUITimerCtr
		anl		A, #00000111b					;3rbg𒊏o
		jnz		_OpVolumeUp0					;A <> 0Ȃ珈XLbv
		;
		call		ProcVolumeUp				;{[Abv
_OpVolumeUp0:	jmp		_MainSwProc0					;Cփ^[
		;
ProcVolumeUp:	;---------------------------------------;{[Abv({̑/ԊO실)
		;							;݂̃{[l`FbN
		mov		A, fVolume					;A : {[l
		jz		_ProcVolumeUp0					;A = 0ȂI
		;
		;							;{[lXV
		dec		A						;A : A - 1
		mov		fVolume, A					;fVolumeXV
		call		SetVolume					;{[ݒ
		;
_ProcVolumeUp0:	ret
		;
OpVolumeDn:	;---------------------------------------;{[_E
		;							;Timer3荞81̂ݏ
		mov		A, fUITimerCtr					;A : fUITimerCtr
		anl		A, #00000111b					;3rbg𒊏o
		jnz		_OpVolumeDn0					;A <> 0Ȃ珈XLbv
		;
		call		ProcVolumeDn				;{[_E
_OpVolumeDn0:	jmp		_MainSwProc0					;Cփ^[
		;
ProcVolumeDn:	;---------------------------------------;{[_E({̑/ԊO실)
		;							;݂̃{[l`FbN
		mov		A, fVolume					;A : fVolume
		cjne		A, #00111111b, _ProcVolumeDn1			;A <> ŏlȂݒ
		;
		jmp		_ProcVolumeDn0					;łɍŏlȂ珈XLbv
		;
_ProcVolumeDn1:	inc		A						;A : A + 1
		mov		fVolume, A					;fVolumeXV
		call		SetVolume					;{[ݒ
		;
_ProcVolumeDn0:	ret
		;
OpTreble:	;---------------------------------------;g[Rg[ݒύX
		mov		A, fTdaReg0					;A : fTdaReg0
		anl		A, #00001100b					;ݒrbgo
		jnb		ACC.2, _OpTreble1				;Boost OnȂWv
		;
		mov		A, #00000000b					;A : Low Boost
		jmp		_OpTreble3					;ݒ
		;
_OpTreble1:	jb		ACC.3, _OpTreble2				;High BoostȂWv
		;
		mov		A, #00001000b					;A : High Boost
		jmp		_OpTreble3					;ݒ
		;
_OpTreble2:	mov		A, #00000100b					;A : Boost Off
_OpTreble3:	anl		fTdaReg0, #11110011b				;ݒrbgNA
		orl		fTdaReg0, A					;fTdaReg0XV
		call		TxTdaReg					;TDA7463ADWX^Cg
		jmp		_MainSwProc0					;Cփ^[
		;
OpBass:		;---------------------------------------;g[Rg[ݒύX
		mov		A, fTdaReg1					;A : fTdaReg1
		anl		A, #00000110b					;ݒrbgo
		jnb		ACC.1, _OpBass1					;Boost OnȂWv
		;
		mov		A, #00000000b					;A : Low Boost
		jmp		_OpBass3					;ݒ
		;
_OpBass1:	jb		ACC.2, _OpBass2					;High BoostȂWv
		;
		mov		A, #00000100b					;A : High Boost
		jmp		_OpBass3					;ݒ
		;
_OpBass2:	mov		A, #00000010b					;A : Boost Off
_OpBass3:	anl		fTdaReg1, #11111001b				;ݒrbgNA
		orl		fTdaReg1, A					;fTdaReg1XV
		call		TxTdaReg					;TDA7463ADWX^Cg
		jmp		_MainSwProc0					;Cփ^[
		;
OpTrJumpNext:	;---------------------------------------;̋ȂփWv
		;							;̋ȂT
		call		SeekMp3NextFNo					;t@CT
		jc		_OpTrJumpNextE					;G[̏ꍇɂ̓Wv
		;
		;							;̋Ȃꍇ
_OpTrJpNext1:	call		ReadFileData					;t@C1ZN^ǂݍ
		mov		fPlayPointerH, #0
		mov		fPlayPointerL, #0				;fPlayPointer : XRAM̍Đ|C^
		;
		;							;ĐJn
		setb		fPlayMode.bPmPlaying				;ĐtOZbg
		MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v()
		jmp		_MainSwProc0					;Cփ^[
		;
_OpTrJumpNextE:	jmp		OnFatalError					;G[̏ꍇɂ̓Wv
		;
OpTrJumpPrev:	;---------------------------------------;ŐȂփWv
		;							;ŐȂT
		call		SeekMp3PrevFNo					;t@CT
		jc		_OpTrJumpNextE					;G[̏ꍇɂ̓Wv
		;
		jmp		_OpTrJpNext1					;OpJumpNextTƓ
		;
OpDirJumpNext:	;---------------------------------------;̃fBNgփWv
		;							;̃fBNgT
		call		SeekMp3NextDir					;̃fBNgɂŏ".MP3"t@CT
		jnc		_OpDirJpNext1					;G[ȂΑs
		;
		;							;Ȃꍇ
		mov		fFileNo, #1					;1Ȗڂ֔΂
		;
_OpDirJpNext1:	call		SeekMp3FileNo					;fFileNoԖڂ̃t@CT
		jc		_OpDirJpNextE					;G[̏ꍇɂ̓Wv
		;
		call		ReadFileData					;t@C1ZN^ǂݍ
		mov		fPlayPointerH, #0
		mov		fPlayPointerL, #0				;fPlayPointer : XRAM̍Đ|C^
		;
		;							;ĐJn
		setb		fPlayMode.bPmPlaying				;ĐtOZbg
		MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v()
		jmp		_MainSwProc0					;Cփ^[
		;
_OpDirJpNextE:	jmp		OnFatalError					;G[̏ꍇɂ̓Wv
		;
OpDirJumpPrev:	;---------------------------------------;ÕfBNgփWv
		;							;ÕfBNgT
		call		SeekMp3PrevDir					;ÕfBNgɂŏ".MP3"t@CT
		jnc		_OpDirJpPrev1					;G[ȂΑs
		;
		;							;Ȃꍇ
		mov		fFileNo, #1					;1Ȗڂ֔΂
		;
_OpDirJpPrev1:	jmp		_OpDirJpNext1					;OpDirJumpNextƓ
		;
OpFfRewAttOn:	;---------------------------------------;/߂ʒON
;		mov		fSaveVolFfRew, fVsVolume			;fSaveVolFfRew : ̃{[lۑ
;		mov		A, fVsVolume					;A : {[l
;		add		A, #cFfRewAtt					;A : A + ʒߒ萔
;		jnc		_OpFRAttOn1					;LoȂOKA
;		;
;		mov		A, fVsVolume					;I[ot[Ȃ特ʂȂ
;_OpFRAttOn1:	mov		fVsVolume, A					;fVsVolumeXV
;		call		SetVsVolume					;{[ݒ
		jmp		_MainSwProc0					;Cփ^[
		;
OpFfRewAttOff:	;---------------------------------------;/߂ʒOFF
;		mov		fVsVolume, fSaveVolFfRew			;fVsVolume : ̃{[l𕜋A
;		call		SetVsVolume					;{[ݒ
		jmp		_MainSwProc0					;Cփ^[
		;
OpFF:		;---------------------------------------;葀
		call		ProcFF						;菈
		jmp		_MainSwProc0					;Cփ^[
		;
ProcFF:		;---------------------------------------;菈({̑/ԊO실)
		;							;Timer2荞41̂ݏ
		mov		A, fUITimerCtr					;A : fUITimerCtr
		anl		A, #00000011b					;2rbg𒊏o
		jnz		_ProcFF0					;A <> 0Ȃ珈XLbv
		;
		;							;݂̋Ȃ𑁑ł邩ǂ`FbN
		SubYYA32	fRemainBytesH, fRemainBytesM, fRemainBytesN, fRemainBytesL, #0, #0, #HIGH (0512d * cFfRewSkipSecs), #LOW (0512d * cFfRewSkipSecs)
		;								;fRemainBytes : fRemainBytes - (512 * cFfRewSkipSecs)
		jnc		_ProcFF1					;fRemainBytes >= 0ȂWv
		;
		;							;݂̃t@C͏Ȉꍇ
		jmp		OpTrJumpNext					;̋Ȃ
		;
_ProcFF1:	;							;cFfRewSkipSecsZN^ǂݔ΂AfPlayPointer͂̂܂(fRemainBytesƂ̐ۂ)
		mov		A, #cFfRewSkipSecs				;A : cFfRewSkipSecs
_ProcFF2:	call		FindNextCS					;ɓǂݍނׂf[^̃NX^ԍEZN^ԍ擾
		djnz		ACC, _ProcFF2					;A : A - 1, <> 0Ȃ烋[v
		;
		call		ReadFileData					;t@C1ZN^ǂݍ
		call		FeedVsZero					;20480
;		call		InitVs						;\tgEFAZbgAݒ
		;
_ProcFF0:	ret
		;
OpREW:		;---------------------------------------;߂
		call		ProcREW						;߂
		jmp		_MainSwProc0					;Cփ^[
		;
ProcREW:	;---------------------------------------;߂({̑/ԊO실)
		;							;Timer2荞41̂ݏ
		mov		A, fUITimerCtr					;A : fUITimerCtr
		anl		A, #00000011b					;2rbg𒊏o
		jz		_ProcREW4					;A = 0Ȃ珈s
		;
		jmp		_ProcREW0					;A <> 0Ȃ珈XLbv
		;
_ProcREW4:	;							;݂̋Ȃ߂邩ǂ`FbN
		AddYYA32	fRemainBytesH, fRemainBytesM, fRemainBytesN, fRemainBytesL, #0, #0, #HIGH (0512d * cFfRewSkipSecs), #LOW (0512d * cFfRewSkipSecs)
		;								;fRemainBytes : fRemainBytes + (512 * cFfRewSkipSecs)
		SubYYA32	fFileSizeH, fFileSizeM, fFileSizeN, fFileSizeL, fRemainBytesH, fRemainBytesM, fRemainBytesN, fRemainBytesL
		;								;fFileSize : fFileSize - fRemainBytes
		jnc		_ProcREW5					;fFileSize : fFileSize - fRemainBytes >= 0ȂWv
		;
		;							;݂̃t@C͂߂ȂꍇAŐȂ̍ŏIZN^܂ŃXLbvAɂ犪߂
		MakeBeep	cBeepNoteH, cBeepTimeOp				;ȊԂ̃r[v()
		call		SeekMp3PrevFNo					;t@CT
		jnc		_ProcREW2					;G[ȂΑs
		;
_ProcREWE:	jmp		OnFatalError					;G[̏ꍇɂ̓Wv
		;
_ProcREW2:	;							;ŐȂ̍ŏIZN^܂œǂݔ΂
		SubYYA32	fRemainBytesH, fRemainBytesM, fRemainBytesN, fRemainBytesL, #0, #0, #HIGH 0512d, #LOW 0512d
		;								;fRemainBytes : fRemainBytes - 512
		jc		_ProcREW3					;fRemainBytes < 0ȂWv
		;
		call		FindNextCS					;ɓǂݍނׂf[^̃NX^ԍEZN^ԍ擾
		jmp		_ProcREW2					;[v
		;
_ProcREW3:	AddYYA32	fRemainBytesH, fRemainBytesM, fRemainBytesN, fRemainBytesL, #0, #0, #HIGH 0512d, #LOW 0512d
		;								;fRemainBytes : fRemainBytes + 512
		mov		fPlayPointerH, #0
		mov		fPlayPointerL, #0				;fPlayPointer : XRAM̍Đ|C^
		jmp		_ProcREW4					;Ɋ߂
		;								;@̂܂܏IƁAǂݔ΂̎c肪ȂꍇɎ̊߂܂łɎ̋Ȃ֍sĂ܂
		;
_ProcREW5:	;							;cFfRewSkipSecsZN^߂AfPlayPointer͏
		;							;fFileSizefFileSize - fRemainBytes(߂߂ɓǂݔ΂oCg)Ă邱Ƃɒ
		mov		fSkipSecCtrH, fFileSizeH
		mov		fSkipSecCtrM, fFileSizeM
		mov		fSkipSecCtrL, fFileSizeN			;fSkipSecCtr : fFileSize / 256
		ShiftR24	fSkipSecCtrH, fSkipSecCtrM, fSkipSecCtrL	;fSkipSecCtr : fFileSize / 512(= ߂߂ɓǂݔ΂ZN^)
		call		SeekMp3FileNo					;t@CTA݂̋Ȃ̐擪
		jc		_ProcREWE					;G[ȂWv
		;
_ProcREW6:	;							;ǂݔ΂I`FbN
		mov		A, fSkipSecCtrH					;A : fSkipSecCtr(H)
		orl		A, fSkipSecCtrM					;A : fSkipSecCtr(H | M)
		orl		A, fSkipSecCtrL					;A : fSkipSecCtr(H | M | L)
		jz		_ProcREW7					;A = 0ȂI
		;
		call		FindNextCS					;ɓǂݍނׂf[^̃NX^ԍEZN^ԍ擾
		SubYYA32	fRemainBytesH, fRemainBytesM, fRemainBytesN, fRemainBytesL, #0, #0, #HIGH 0512d, #LOW 0512d
		;								;fRemainBytes : fRemainBytes - 512
		SubYYA24	fSkipSecCtrH, fSkipSecCtrM, fSkipSecCtrL, #0, #0, #1
		;								;fSkipSecCtr : fSkipSecCtr - 1
		jmp		_ProcREW6					;[v
		;
_ProcREW7:	;							;߂̂߂̓ǂݔ΂I
		call		ReadFileData					;t@C1ZN^ǂݍ
		mov		fPlayPointerH, #0
		mov		fPlayPointerL, #0				;fPlayPointer : XRAM̍Đ|C^
		call		FeedVsZero					;20480
;		call		InitVs						;\tgEFAZbgAݒ
		;
_ProcREW0:	ret
		;
OpJumpMarkA:	;---------------------------------------;}[JփWv
		;							;}[JAփWv
		CopyFileParam	cFileParamTop, cFileParamATop			;}[NAp[^Rs[
		call		ReadFileData					;t@C1ZN^ǂݍ
		;
		;							;ĐJn
		setb		fPlayMode.bPmPlaying				;ĐtOZbg
		MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v()
		jmp		_MainSwProc0					;Cփ^[
		;
OpSetMarkA:	;---------------------------------------;}[JZbg
		CopyFileParam	cFileParamATop, cFileParamTop		;}[JAփp[^Rs[
		call		SaveNvParams					;s֏ԕۑ
		;
		;							;ĐĊJ
		MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v()
		MakeBeep	cBeepNoteM, cBeepTimeOp				;r[v()
		MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v()
		jmp		_MainSwProc0					;Cփ^[
		;
OpRepeatMode:	;---------------------------------------;s[g[hݒ葀
		mov		A, fRepeatMode					;A : fRepeatMode
		jnz		_OpRepeatMode1					;A <> 0ȂWv
		;
		setb		ACC.bRmOne				;݂̋ȃs[gĐtOZbg
		jmp		_OpRepeatMode2					;ݒ
		;
_OpRepeatMode1:	;							;s[g[h
		mov		C, ACC.bRmAll					;C : bRmAll
		rlc		A						;A : 1rbgVtg
		anl		A, #(1 SHL bRmALL) OR (1 SHL bRmDir) OR (1 SHL bRmOne)	;bRm***ȊÕrbgNA
_OpRepeatMode2:	mov		fRepeatMode, A					;fRepeatModeXV
		call		MakeBeepRm					;s[g[hʒmpr[v
		jmp		_MainSwProc0					;Cփ^[
		;
OpRepeatOff:	;---------------------------------------;s[gIt
		mov		fRepeatMode, #0					;fRepeatModeXV
		call		MakeBeepRm					;s[g[hʒmpr[v
		jmp		_MainSwProc0					;Cփ^[
		;
OpFmModeSucc:	;---------------------------------------;FM샂[hύX
		mov		A, fPlayMode					;A : fPlayMode
		anl		A, #bmPmOpMode					;샂[hrbg𒊏o
		inc		A						;샂[hЂƂi߂
		cjne		A, #cOmFmToneCnt + 1, _OFmModeSucc1		;샂[h[I[ołȂ΃Wv
		;
		mov		A, #cOmFmPlay					;[I[oȂʏM[h
_OFmModeSucc1:	anl		fPlayMode, #NOT bmPmOpMode			;샂[hrbgNA
		orl		fPlayMode, A					;샂[hXV
		;
		mov		DPTR, #_OFmModeSucc2				;DPTR : 샂[hʃr[vxN^e[u擪AhX
		add		A, ACC						;A : A * 2
		jmp		@A + DPTR					;샂[hʂɃWv
		;
_OFmModeSucc2:	;								;샂[hʃr[vxN^e[u擪AhX
		ajmp		_OFmMSPlay					;FMʏM[h̃r[v
		ajmp		_OFmMSSelectSt					;vZbgǑI[h̃r[v
		ajmp		_OFmMSSearchSt					;ǃT[`[h̃r[v
		ajmp		_OFmMSTuneManu					;}jAIǃ[h̃r[v
		ajmp		_OFmMSToneCnt					;g[Rg[ݒ胂[h̃r[v
		;
_OFmMSPlay:	;								;FMʏM[h̃r[v
		MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v()
		jmp		_OFmModeSucc3					;
		;
_OFmMSSelectSt:	;								;vZbgǑI[h̃r[v
		MakeBeepOp	cBeepNoteM, cBeepNoteM, cBeepNoteH		;r[v(AA)
		jmp		_OFmModeSucc3					;
		;
_OFmMSSearchSt:	;								;ǃT[`[h̃r[v
		MakeBeepOp	cBeepNoteL, cBeepNoteH, cBeepNoteH		;r[v(AA)
		jmp		_OFmModeSucc3					;
		;
_OFmMSTuneManu:	;								;}jAIǃ[h̃r[v
		MakeBeepOp	cBeepNoteH, cBeepNoteH, cBeepNoteH		;r[v(AA)
		jmp		_OFmModeSucc3					;
		;
_OFmMSToneCnt:	;								;g[Rg[ݒ胂[h̃r[v
		MakeBeepOp	cBeepNoteH, cBeepNoteM, cBeepNoteH		;r[v(AA)
		jmp		_OFmModeSucc3					;
		;
_OFmModeSucc3:	call		SetTdaInput					;TDA7463AD͐؂ւ
		jmp		_MainSwProc0					;Cփ^[
		;
OpModeFmPlay:	;---------------------------------------;샂[hʏM[hɕύX
		anl		fPlayMode, #NOT bmPmOpMode			;샂[hrbgNA
		orl		fPlayMode, #cOmFmPlay				;샂[hXV
		MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v()
		call		SetTdaInput					;TDA7463AD͐؂ւ
		jmp		_MainSwProc0					;Cփ^[
		;
OpFmStop:	;---------------------------------------;FMWIIt
		call		ProcFmStop				;FMWIIt
		jmp		_MainSwProc0					;Cփ^[
		;
ProcFmStop:	;---------------------------------------;FMWIIt({̑/ԊO실)
		clr		fPlayMode.bPmPlaying				;ĐtONA
		clr		fPlayMode.bPmFm					;FM[hNA
		anl		fPlayMode, #NOT bmPmOpMode			;샂[hrbgNA
		call		SaveNvParams					;s֏ԕۑ
		MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v()
		;
		ret
		;
OpFmPlay:	;---------------------------------------;FMWII
		call		ProcFmPlay				;FMWII
		jmp		_MainSwProc0					;Cփ^[
		;
ProcFmPlay:	;---------------------------------------;FMWII({̑/ԊO실)
		setb		fPlayMode.bPmPlaying				;ĐtOZbg
		setb		fPlayMode.bPmFm					;FM[hZbg
		MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v()
		call		SetNsTuneFreq					;NS953M֎MgZbg
		call		SetTdaInput					;TDA7463AD͐؂ւ
		;
		ret
		;
OpFmPreStInc:	;---------------------------------------;vZbgǔԍAbv
		inc		fPreStNo					;vZbgǂ̔ԍCNg
		mov		A, #cPreStTables				;A : vZbgǂ̐
		cjne		A, fPreStNo, _OpFmPreStInc1			;I[ot[łȂȂWv
		;
		mov		fPreStNo, #0					;vZbgǔԍ擪
_OpFmPreStInc1:	call		SetPreStIdx					;vZbgǂ̎ge[uCfbNXZbg
		;
		MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v()
		call		SetNsTuneFreq					;NS953M֎MgZbg
		call		SetTdaInput					;TDA7463AD͐؂ւ
		jmp		_MainSwProc0					;Cփ^[
		;
OpFmPreStDec:	;---------------------------------------;vZbgǔԍ_E
		dec		fPreStNo					;vZbgǂ̔ԍfNg
		mov		A, #0ffh					;A : 0ffh
		cjne		A, fPreStNo, _OpFmPreStDec1			;I[ot[łȂȂWv
		;
		mov		fPreStNo, #cPreStTables - 1			;vZbgǔԍŌ
_OpFmPreStDec1:	jmp		_OpFmPreStInc1					;OpFmPreStIncƓ
		;
OpFmSearchU:	;---------------------------------------;ǃT[`()
		;							;݂̎g[Ȃ牺[T[`
		mov		A, #cFreqTableIdxes - 1				;A : ge[uCfbNX̏[
		cjne		A, fFreqTableIdx, _OpFmSearchU1			;[łȂȂWv
		;
		mov		fFreqTableIdx, #0				;ge[uCfbNX[ɐݒ
		;
_OpFmSearchU1:	;							;T[`s
		setb		F0						;փT[`ݒ
		call		FmSearchSt					;ǃT[`s
		jnc		_OpFmSearchU2					;ȂWv
		;
		;							;Ȃꍇ
		MakeBeep	cBeepNoteL, cBeepTimeOp				;r[v(ቹ)
		jmp		_OpFmSearchU0					;I
		;
_OpFmSearchU2:	;							;ꍇ
		MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v()
_OpFmSearchU0:	call		SetTdaInput					;TDA7463AD͐؂ւ
		;
		jmp		_MainSwProc0					;Cփ^[
		;
OpFmSearchD:	;---------------------------------------;ǃT[`()
		;							;݂̎g[Ȃ[T[`
		mov		A, #0						;A : ge[uCfbNX̉[
		cjne		A, fFreqTableIdx, _OpFmSearchD1			;[łȂȂWv
		;
		mov		fFreqTableIdx, #cFreqTableIdxes - 1		;ge[uCfbNX[ɐݒ
		;
_OpFmSearchD1:	;							;T[`s
		clr		F0						;փT[`ݒ
		call		FmSearchSt					;ǃT[`s
		jnc		_OpFmSearchD2					;ȂWv
		;
		;							;Ȃꍇ
		MakeBeep	cBeepNoteL, cBeepTimeOp				;r[v(ቹ)
		jmp		_OpFmSearchD0					;I
		;
_OpFmSearchD2:	;							;ꍇ
		MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v()
_OpFmSearchD0:	call		SetTdaInput					;TDA7463AD͐؂ւ
		;
		jmp		_MainSwProc0					;Cփ^[
		;
OpFmTuneManUp:	;---------------------------------------;}jAI()
		;							;Timer2荞161̂ݏ
		mov		A, fUITimerCtr					;A : fUITimerCtr
		anl		A, #00001111b					;2rbg𒊏o
		jnz		_OpFmTManUp0					;A <> 0Ȃ珈XLbv
		;
		;							;Mg0.1MHzグ
		inc		fFreqTableIdx					;ge[uCfbNXCNg
		mov		A, #cFreqTableIdxes				;A : ge[uCfbNX̗vf
		cjne		A, fFreqTableIdx, _OpFmTManUp1			;I[ot[łȂȂWv
		;
		mov		fFreqTableIdx, #0				;ge[uCfbNX擪
		MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v()
		call		SetTdaInput					;TDA7463AD͐؂ւ
_OpFmTManUp1:	call		SetNsTuneFreq					;NS953M֎MgZbg
		;
_OpFmTManUp0:	jmp		_MainSwProc0					;Cփ^[
		;
OpFmTuneManDn:	;---------------------------------------;}jAI()
		;							;Timer2荞161̂ݏ
		mov		A, fUITimerCtr					;A : fUITimerCtr
		anl		A, #00001111b					;2rbg𒊏o
		jnz		_OpFmTManDn0					;A <> 0Ȃ珈XLbv
		;
		;							;Mg0.1MHz
		dec		fFreqTableIdx					;ge[uCfbNXfNg
		mov		A, #0ffh					;A : 0ffh
		cjne		A, fFreqTableIdx, _OpFmTManDn1			;I[ot[łȂȂWv
		;
		mov		fFreqTableIdx, #cFreqTableIdxes - 1		;ge[uCfbNXŌ
		MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v()
		call		SetTdaInput					;TDA7463AD͐؂ւ
_OpFmTManDn1:	call		SetNsTuneFreq					;NS953M֎MgZbg
		;
_OpFmTManDn0:	jmp		_MainSwProc0					;Cփ^[
		;
		;===============================================================
		;	Subroutines
		;
LoopAmsec:	;---------------------------------------;[vɂ(A)msec҂
		push		ACC
		;
		;							;1msec҂
_LoopAmsec2:	mov		fLoopAmsecCtr1, #32d
		mov		fLoopAmsecCtr0, #0
_LoopAmsec1:	djnz		fLoopAmsecCtr0, _LoopAmsec1			;256񃋁[v(767TCN)
		;
		djnz		fLoopAmsecCtr1, _LoopAmsec1			;32񃋁[v(24639TCN = 1msec)
		;
		;							;A񃋁[v
		djnz		ACC, _LoopAmsec2				;A - 1C!= 0 Ȃ烋[v
		;
		pop		ACC
		ret
		;
WaitAusec:	;---------------------------------------;Acc(usec)҂ (A > 0)
		;					;@PCA Module2gp
		push		ACC
		push		B
		;
		mov		B, #08d						;B : 24576000 / 3 / 1000000
		mul		AB						;BA : A * 8
		AddYAB16	PCA0CPH2, PCA0CPL2, B, ACC, PCA0H, PCA0L	;PCA0CP[HL]2 : PCA0[HL] + (A * 8)
		clr		CCF2						;CCF2NA
		jnb		CCF2, $						;CCF2Zbg܂Ń[v
		;
		pop		B
		pop		ACC
		ret
		;
WaitAmsec:	;---------------------------------------;Acc(msec)҂ (A > 0)
		;					;@PCA Module2gp
		push		ACC
		;
_WaitAmsec1:	;							;1msec҂
		push		ACC
		;
		AddYAB16	PCA0CPH2, PCA0CPL2, #HIGH 08192d, #LOW 08192d, PCA0H, PCA0L	;PCA0CP[HL]2 : PCA0[HL] + (24576000 / 3 / 1000)
		clr		CCF2						;CCF2NA
		jnb		CCF2, $						;CCF2Zbg܂Ń[v
		;
		pop		ACC
		djnz		ACC, _WaitAmsec1				;A : A - 1A<> 0Ȃ烋[v
		;
		pop		ACC
		ret
		;
WaitA100msec:	;---------------------------------------;Acc(100msec)҂(ᐸx)
		;					;@WaitAmsecgp
		push		ACC
		push		B
		;
		mov		B, ACC						;B : [vJE^
		mov		A, #0100d					;A : 100(msec)
		;
_WaitA100msec1:	call		WaitAmsec					;Amsec҂
		djnz		B, _WaitA100msec1				;B : B - 1A<> 0Ȃ烋[v
		;
		pop		B
		pop		ACC
		ret
		;
ReadBattVolts:	;---------------------------------------;obedǂݍ
		;					;  Adc0ϊlobedɕϊ
		;					;  fBattVoltage : obed(BCD2Aa.b[V]:ʃju=aAʃju=b)
		push		ACC
		push		B
		;
		;							;A/Dϊ
		setb		AD0EN						;ADC0Cl[u
		clr		AD0INT						;AD0INTNA
		setb		AD0BUSY						;ϊJn
		jnb		AD0INT, $					;ϊI҂
		;
		;							;f[^ϊ
		mov		A, ADC0H					;A : ϊl̏ʃoCg
		clr		AD0EN						;ADC0fBXG[u
		;
		mov		B, #057d					;B : tXP[ɑΉdl = 2.85V * 2 * 10
		mul		AB						;B : 2.85 * 2 * 10 * 255 / 256(oCi)
		mov		A, B						;AɃRs[
		mov		B, #010d					;B : 10
		div		AB						;A : A / 10AB : ]
		swap		A						;\̈ʂʃju
		add		A, B						;A : ʃju : Aʃju : 
		mov		fBattVoltage, A					;fBattVoltageXV
		;
		pop		B						;WX^oNA
		pop		ACC
		ret
		;
InitNs:		;---------------------------------------;NS953M \tgEGAZbgAݒ
		;							;\tgEFAZbg
		TxSmbSta							;X^[gRfBV
		TxSmbData	#11111111b					;X[uAhX = Srbg"H"
		;
		;							;WX^
		TxSmbSta							;RepeatedX^[gRfBV : \tgEFAZbg
		TxSmbData	#11001000b					;X[uAhX
		TxSmbData	#00000000b					;TuAhX = 0
		TxSmbData	#00010000b					;R0lM
		TxSmbData	#00001111b					;R1lM
		TxSmbData	#11100100b					;R2lM
		TxSmbData	#00110111b					;R3lM
;		TxSmbData	#01111111b					;R3lM
		TxSmbData	#11011000b					;R4lM
		TxSmbData	#01011101b					;R5lM
		TxSmbData	#10001001b					;R6lM
		TxSmbData	#01001100b					;R7lM
		TxSmbData	#00001001b					;R8lM
		TxSmbData	#01001101b					;R9lM
		TxSmbData	#00101000b					;R10lM
		TxSmbData	#10001100b					;R11lM
		TxSmbData	#00000100b					;R12lM
		TxSmbData	#00000000b					;R13lM
		TxSmbSto							;XgbvRfBV
		;
		ret
		;
TxNsR0:		;---------------------------------------;NS953M R0Cg
		;					;  fNsR0NS953M֐ݒ肷
		TxSmbSta							;X^[gRfBV
		TxSmbData	#11001000b					;X[uAhX
		TxSmbData	#00000000b					;TuAhX = 0
		TxSmbData	fNsR0						;R0M
		TxSmbSto							;XgbvRfBV
		;
		ret
		;
TxNsR1R2:	;---------------------------------------;NS953M R1AR2Cg
		;					;  fNsR1AfNsR2NS953M֐ݒ肷
		TxSmbSta							;X^[gRfBV
		TxSmbData	#11001000b					;X[uAhX
		TxSmbData	#00000001b					;TuAhX = 1
		TxSmbData	fNsR1						;R1M
		TxSmbData	fNsR2						;R2M
		TxSmbSto							;XgbvRfBV
		;
		ret
		;
SetPreStIdx:	;---------------------------------------;vZbgǂɑΉge[uCfbNXZbg
		;					;  fPreStNoɂfFreqTableIdxXV
		push		ACC
		push		DPL
		push		DPH
		;
		mov		DPTR, #PreStTableTop				;DPTR : vZbgǂ̎ge[uCfbNX̃e[u̐擪AhX
		mov		A, fPreStNo					;A : IǂvZbgǂ̔ԍ
		movc		A, @A + DPTR					;A : FmR[12]Tableւ̃CfbNX
		mov		fFreqTableIdx, A				;fFreqTableIdxXV
		;
		pop		DPH
		pop		DPL
		pop		ACC
		ret
		;
SetNsTuneFreq:	;---------------------------------------;NS953M֎MgZbg
		;					;  fFreqTableIdxɂNS953MR1R2XVAݒlfNsR1AfNsR2Ɏc
		push		ACC
		push		DPL
		push		DPH
		;
		mov		DPTR, #FmR1TableTop				;DPTR : R1ݒle[u̐擪AhX
		mov		A, fFreqTableIdx				;A : Iǂg̃e[uCfbNX
		movc		A, @A + DPTR					;A : R1̐ݒl
		mov		fNsR1, A					;fNsR1XV
		;
		mov		DPTR, #FmR2TableTop				;DPTR : R2ݒle[u̐擪AhX
		mov		A, fFreqTableIdx				;A : Iǂg̃e[uCfbNX
		movc		A, @A + DPTR					;A : R2̐ݒl
		mov		fNsR2, A					;fNsR2XV
		;
		call		TxNsR1R2					;NS953M R1AR2Cg
		;
		pop		DPH
		pop		DPL
		pop		ACC
		ret
		;
FmSearchSt:	;---------------------------------------;NS953MǃT[`
		;					;  PSW.F0 = 0 : փT[`A= 1 : փT[`
		;					;  C = 1 : ȂꍇAC = 0 : ꍇ
		;
		push		ACC
		;
		;							;~[g
		mov		fNsR0, #00010010b				;R0[1] = 1
		call		TxNsR0						;NS953M R0Cg
		;
_FmSearchSt1:	;							;STORSSIɃZbg
		anl		fNsR0, #00001111b				;R0[7:4]NA
		orl		fNsR0, #00110000b				;R0[7:4] = 3
		call		TxNsR0						;NS953M R0Cg
		;
		;							;T[``FbN
		jnb		F0, _FmSearchSt3				;ȂWv
		;
		;							;Mg0.1MHzグ
		inc		fFreqTableIdx					;ge[uCfbNXCNg
		mov		A, #cFreqTableIdxes				;A : ge[uCfbNX̗vf
		cjne		A, fFreqTableIdx, _FmSearchSt2			;I[ot[łȂȂWv
		;
		;							;[܂ŃT[`Ȃꍇ
		dec		fFreqTableIdx					;ge[uCfbNX[ɐݒ
		call		SetNsTuneFreq					;NS953M֎MgZbg
		setb		C						;CZbg
		jmp		_FmSearchSt0					;I
		;
_FmSearchSt3:	;							;Mg0.1MHz
		dec		fFreqTableIdx					;ge[uCfbNXfNg
		mov		A, #0ffh					;A : 0ffh
		cjne		A, fFreqTableIdx, _FmSearchSt2			;I[ot[łȂȂWv
		;
		;							;[܂ŃT[`Ȃꍇ
		inc		fFreqTableIdx					;ge[uCfbNX[ɐݒ
		call		SetNsTuneFreq					;NS953M֎MgZbg
		setb		C						;CZbg
		jmp		_FmSearchSt0					;I
		;
_FmSearchSt2:	;							;PCNTXV
		call		SetNsTuneFreq					;NS953M֎MgZbgAfNsR1AfNsR2XV
		;
		;							;20msec҂
;		mov		A, #020d					;A : 20
		mov		A, #080d					;A : 20
		call		WaitAmsec					;Amsec҂
		;
		;							;RSSI
		jnb		pNsSto, _FmSearchSt1				;STO = "L"ȂWv
		;
		;							;STOIFJEgɃZbg
		anl		fNsR0, #00001111b				;R0[7:4]NA
		orl		fNsR0, #00100000b				;R0[7:4] = 2
		call		TxNsR0						;NS953M R0Cg
		;
		;							;IFCSTZbg
		setb		fNsR0.2						;R0[2]Zbg
		call		TxNsR0						;NS953M R0Cg
		;
		;							;10msec҂
		mov		A, #010d					;A : 10
		call		WaitAmsec					;Amsec҂
		;
		;							;IFJEg
		jnb		pNsSto, _FmSearchSt1				;STO = "L"ȂWv
		;
		;							;PCNT(1) - 6Zbg
		SubYYA16	fNsR2, fNsR1, #0, #006d				;fNsR2:fNsR1 - 6
		call		TxNsR1R2					;NS953M R1AR2Cg
		;
		;							;STOJLɃZbg
		anl		fNsR0, #00001111b				;R0[7:4]NA
		orl		fNsR0, #01100000b				;R0[7:4] = 6
		call		TxNsR0						;NS953M R0Cg
		;
		;							;20msec҂
		mov		A, #020d					;A : 20
		call		WaitAmsec					;Amsec҂
		;
		;							;IFCSTZbg
		setb		fNsR0.2						;R0[2]Zbg
		call		TxNsR0						;NS953M R0Cg
		;
		;							;10msec҂
		mov		A, #010d					;A : 10
		call		WaitAmsec					;Amsec҂
		;
		;							;IFJEg
		jnb		pNsSto, _FmSearchSt1				;STO = "L"ȂWv
		;
		;							;PCNT(1) + 6Zbg
		AddYYA16	fNsR2, fNsR1, #0, #012d				;fNsR2:fNsR1 + 12d
		call		TxNsR1R2					;NS953M R1AR2Cg
		;
		;							;STOJUɃZbg
		anl		fNsR0, #00001111b				;R0[7:4]NA
		orl		fNsR0, #01010000b				;R0[7:4] = 5
		call		TxNsR0						;NS953M R0Cg
		;
		;							;20msec҂
		mov		A, #020d					;A : 20
		call		WaitAmsec					;Amsec҂
		;
		;							;IFCSTZbg
		setb		fNsR0.2						;R0[2]Zbg
		call		TxNsR0						;NS953M R0Cg
		;
		;							;10msec҂
		mov		A, #010d					;A : 10
		call		WaitAmsec					;Amsec҂
		;
		;							;IFJEg
		jb		pNsSto, _FmSearchSt4				;STO = "H"ȂWv
		;
		jmp		_FmSearchSt1					;STO = "L"ȂWv
		;
_FmSearchSt4:	;							;ꍇ
		;							;PCNT(1)Zbg
		call		SetNsTuneFreq					;NS953M֎MgZbg
		;
		clr		C						;CNA
		;
_FmSearchSt0:	;							;~[g
		mov		fNsR0, #00010001b				;R0[1] = 0
		call		TxNsR0						;NS953M R0Cg
		;
		pop		ACC
		ret
		;
TxTdaReg:	;---------------------------------------;TDA7463ADWX^Cg
		;					;  fTdaReg0..2 : WX^ݒl
		TxSmbSta							;X^[gRfBV
		TxSmbData	#10001000b					;X[uAhX
		TxSmbData	#00010000b					;TuAhX = 0AI[gCNgL
		TxSmbData	fTdaReg0					;fTdaReg0M
		TxSmbData	fTdaReg1					;fTdaReg1M
		TxSmbData	fTdaReg2					;fTdaReg2M
		TxSmbSto							;XgbvRfBV
		;
		ret
		;
SetTdaInput:	;---------------------------------------;TDA7463AD͐؂ւ
		;					;@fPlayMode.bPmFm̒lɂē͂؂ւ
		anl		fTdaReg0, #01111111b				;INPUT2ɐݒ
		jb		fPlayMode.bPmFm, _SetTdaInput1			;fPlayMode.bPmFmZbgȂWv
		;
		orl		fTdaReg0, #10000000b				;INPUT1ɐݒ
_SetTdaInput1:	call		TxTdaReg					;TDA7463ADWX^Cg
		;
		ret
		;
SetVolume:	;---------------------------------------;{[ݒ
		;					;  fVolume : {[l(03fh..000h)
		mov		fTdaReg2, fVolume				;fTdaReg2{[lōXV
		orl		fTdaReg2, #11000000b				;Output Gain, Attenuation = 0dB
		call		TxTdaReg					;TDA7463ADWX^Cg
		;
		ret
		;
RxVsSci:	;---------------------------------------;VS1011 SCIWX^[h
		;					;  xCS܂
		;					;  fVsSciA : [hAhX
		;					;  fVsSciDH,L : [hf[^
		push		ACC
		;
		clr		pVsXcs						;xCSAT[g
		TxSpi0		#cVsSciR					;SCI Read Instruction ByteM
		TxSpi0		fVsSciA						;AhXM
		RxSpi0		fVsSciDH					;f[^ʃoCgM
		RxSpi0		fVsSciDL					;f[^ʃoCgM
		WaitSpi0End							;MI҂
		setb		pVsXcs						;xCSlQ[g
		;
		pop		ACC
		ret
		;
TxVsSci:	;---------------------------------------;VS1011 SCIWX^Cg
		;					;  xCS܂
		;					;  fVsSciA : CgAhX
		;					;  fVsSciDH,L : Cgf[^
		push		ACC
		;
		clr		pVsXcs						;xCSAT[g
		TxSpi0		#cVsSciW					;SCI Write Instruction ByteM
		TxSpi0		fVsSciA						;AhXM
		TxSpi0		fVsSciDH					;f[^ʃoCgM
		TxSpi0		fVsSciDL					;f[^ʃoCgM
		WaitSpi0End							;MI҂
		setb		pVsXcs						;xCSlQ[g
		;
		mov		A, #010d					;A : 10
		call		WaitAusec					;Ausec҂
		;
		pop		ACC
		ret
		;
TxVsSdi:	;---------------------------------------;VS1011 SDIf[^Cg
		;					;  xDCS܂
		;					;  fVsSdiD : Cgf[^
		push		ACC
		;
_TxVsSdi1:	jnb		pVsDreq, _TxVsSdi1				;DREQ="L"Ȃ烋[v
		;
		clr		pVsXdcs						;xDCSAT[g
		TxSpi0		fVsSdiD						;f[^oCgM
		WaitSpi0End							;MI҂
		setb		pVsXdcs						;xDCSlQ[g
		;
		pop		ACC
		ret
		;
PowerUpVs:	;---------------------------------------;VS1011 N
		;					;  VS1011͋N܂̓r[vŋN
		;							;Nς݂Ȃ牽Ȃ
		jb		pVsReset, _PowerUpVs0				;pVsReset"H"ȂWv
		;
		;							;Zbg
		setb		pVsReset					;VS1011Zbg
		;
		mov		A, #001d					;A : 1
		call		WaitAmsec					;Amsec҂
		;
_PowerUpVs1:	jnb		pVsDreq, _PowerUpVs1				;DREQ="L"Ȃ烋[v
		;
_PowerUpVs0:	ret
		;
PowerDownVs:	;---------------------------------------;VS1011 ~
		;					;  VS1011͍ĐI~Œ~
		;							;~ς݂Ȃ牽Ȃ
		jnb		pVsReset, _PowerDownVs0				;pVsReset"L"ȂWv
		;
		push		ACC
		;
		;							;Zbgs
		call		FeedVsZero					;20480f[^o
		mov		A, #001d					;A : 1
		call		WaitAmsec					;Amsec҂
		clr		pVsReset					;VS1011ZbgAT[g
		;
		pop		ACC
		;
_PowerDownVs0:	ret
		;
FeedVsZero:	;---------------------------------------;VS1011 20480f[^o
		push		ACC
		push		DPL
		push		DPH
		;
		mov		DPTR, #0 - 02048d				;DPTR : 2048
		mov		fVsSdiD, #000h					;Mf[^ : 0
_FeedVsZero1:	call		TxVsSdi						;SDIf[^M
		inc		DPTR						;DPTR : DPTR + 1
		mov		A, DPL						;
		orl		A, DPH						;A : DPL or DPH
		jnz		_FeedVsZero1					;A <> 0Ȃ烋[v
		;
		pop		DPH
		pop		DPL
		pop		ACC
		ret
		;
InitVs:		;---------------------------------------;VS1011 \tgEGAZbgAݒ
		push		ACC
		;
		;							;RESETs
		WriteVsSci	cVsModeAddr, #HIGH (cVsSmInit + cVsSmReset), #LOW (cVsSmInit + cVsSmReset)
		;								;SM_RESETZbg(VS1011ł͎IɃNA)
		mov		A, #001d					;A : 1
		call		WaitAmsec					;Amsec҂
		;
_InitVs1:	jnb		pVsDreq, _InitVs1				;DREQ="L"Ȃ烋[v
		;
		;							;ݒ
		call		SetVsVolume					;{[ݒ
;		call		SetVsClockf					;NbNݒ
		;
		pop		ACC
		ret
		;
GetVsDecTime:	;---------------------------------------;VS1011 fR[hԃ[h
		push		DPH
		push		DPL
		;
		ReadVsSci	cVsDecTimeAddr, DPH, DPL			;fR[hԃ[h
		AddYAB16	fDecodeTimeH, fDecodeTimeL, fStartTimeH, fStartTimeL, DPH, DPL	;fDecodeTime : fStartTime + fR[hԂōXV
		;
		pop		DPL
		pop		DPH
		ret
		;
;SetVsDecTime:	;---------------------------------------;VS1011 fR[hԃCg
;		;					;@}jAɂ̓Cgł悤ɏĂ邪AۂɎĂ݂
;		;					;@CgAĐJnɂ̒lZbgĂ܂B
;		;					;@dȂ̂łƂ肠Cg͂AfStartTimefDecodeTimẻZŋ߂邱ƂɂB
;		WriteVsSci	cVsDecTimeAddr, fDecodeTimeH, fDecodeTimeL	;fR[hԃCg
;		WriteVsSci	cVsDecTimeAddr, fDecodeTimeH, fDecodeTimeL	;fR[hԃCg
;		;
;		ret
;		;
SetVsVolume:	;---------------------------------------;VS1011 {[ݒ
		WriteVsSci	cVsVolAddr, #cVsVolume, #cVsVolume		;VOLWX^ݒ
		;
		ret
		;
Beep:		;---------------------------------------;VS1011 r[v
		;					;  fBeepCode : VS1011 Sine Test4oCgڂ̒l
		;					;  fBeepTime : (msecP)
		push		ACC
		;
		;							;r[vʒ
		push		fVolume						;{[lۑ
		mov		A, fVolume					;A : {[l
		add		A, #cBeepAtt					;A : A + ʒߒ萔
		jnb		ACC.6, _Beep4					;I[ot[łȂ΃Wv
		;
		mov		A, fVolume					;I[ot[Ȃ特ʂȂ
_Beep4:		mov		fVolume, A					;fVolumer[vʂōXV
		TdaMute		On						;TDA7463AD Output Mute(ȂƂȂ̃|bvmCYł)
		;
		;							;VS1011
		call		PowerUpVs					;VS1011N
		call		InitVs						;\tgEFAZbgAݒ
		WriteVsSci	cVsModeAddr, #HIGH (cVsSmInit + cVsSmTests), #LOW (cVsSmInit + cVsSmTests)
		;								;SM_TESTSZbg
		;
		mov		A, #0250d					;A : SM_TESTSZbg̑҂
		;								;  ꂪƋN1ڂ̃r[vȂB100usecł͕s
		call		WaitAusec					;Ausec҂
		;
		;							;r[vI
		mov		fVsSdiD, #053h					;Sine Test 1oCg
		call		TxVsSdi						;SDIf[^M
		mov		fVsSdiD, #0efh					;Sine Test 2oCg
		call		TxVsSdi						;SDIf[^M
		mov		fVsSdiD, #06eh					;Sine Test 3oCg
		call		TxVsSdi						;SDIf[^M
		mov		fVsSdiD, fBeepCode				;Sine Test 4oCg
		call		TxVsSdi						;SDIf[^M
		mov		fVsSdiD, #0					;Sine Test 5..8oCg
		mov		A, #04d						;A : [vJE^
_Beep1:		call		TxVsSdi						;SDIf[^M
		djnz		ACC, _Beep1					;A : A - 1A<> 0Ȃ烋[v
		;
		orl		fTdaReg0, #10000000b				;Input = 1
		call		TxTdaReg					;TDA7463ADWX^Cg
		;
		mov		A, #050d					;A : r[vオ莞mCYŷ߂̑҂
		call		WaitAmsec					;Amsec҂
		;
		TdaMute		Off						;TDA7463AD Output Mute
		;
		mov		A, fBeepTime					;r[vp҂
		call		WaitAmsec					;Amsec҂
		;
		TdaMute		On						;TDA7463AD Output Mute
		;
		;							;VS1011
		call		InitVs						;\tgEFAZbgAݒASM_TESTSNAAr[vIt
		pop		fVolume						;{[lA
		;
		mov		A, #012d					;A : r[v莞mCYŷ߂̑҂
		call		WaitAmsec					;Amsec҂
		;
		TdaMute		Off						;TDA7463AD Output Mute
		;
		pop		ACC
		ret
		;
MakeBeepRm:	;---------------------------------------;s[g[hʒmpr[v
		push		ACC
		;
		mov		A, fRepeatMode					;A : fRepeatMode
		jnb		ACC.bRmAll, _MakeBeepRm1			;Sȃs[gĐtONAȂWv
		;
		MakeBeepRep	cBeepNoteH					;r[v(2)
		jmp		_MakeBeepRm0					;Wv
		;
_MakeBeepRm1:	jnb		ACC.bRmDir, _MakeBeepRm2			;fBNgs[gĐtONAȂWv
		;
		MakeBeepRep	cBeepNoteM					;r[v(2)
		jmp		_MakeBeepRm0					;Wv
		;
_MakeBeepRm2:	jnb		ACC.bRmOne, _MakeBeepRm3			;݂̋ȃs[gĐtONAȂWv
		;
		MakeBeepRep	cBeepNoteL					;r[v(ቹ2)
		jmp		_MakeBeepRm0					;Wv
		;
_MakeBeepRm3:	MakeBeep	cBeepNoteH, cBeepTimeOp				;r[v(1)
		;
_MakeBeepRm0:	pop		ACC
		ret
		;
TxSdCommand:	;---------------------------------------;SdCard R}hM
		;					;  f[^[hɂReadSdSectorg
		;					;  fSdCommand : R}h(6oCg)
		;					;  fSdResponse : X|X(1oCg)A0ffhȂ^CAEg
		push		ACC
		push		PSW
		SelectRegBank	rbTxSdCommand					;WX^oNؑ
		;
		clr		pSdCs						;CsAT[g
		mov		A, fSdCommand0					;A : R}hԍ
		orl		A, #040h					;R}htH[}bgrbgݒ
		TxSpi0		A						;R}h(0)M
		TxSpi0		fSdCommand1					;R}h(1)M
		TxSpi0		fSdCommand2					;R}h(2)M
		TxSpi0		fSdCommand3					;R}h(3)M
		TxSpi0		fSdCommand4					;R}h(4)M
		TxSpi0		fSdCommand5					;R}h(5)M
		mov		fTxSdCmdLCtrL, #LOW  02000d			;[vJE^(L)
		mov		fTxSdCmdLCtrH, #HIGH 02000d			;[vJE^(H)
_TxSdCommand1:	RxSpi0		A						;A : SPIM
		cjne		A, #0ffh, _TxSdCommand2				;A <> 0ffhȂWv
		;
		SubYYA16	fTxSdCmdLCtrH, fTxSdCmdLCtrL, #0, #1		;fTxSdCmdLCtr : fTxSdCmdLCtr - 1
		mov		A, fTxSdCmdLCtrH				;A : fTxSdCmdLCtrH
		orl		A, fTxSdCmdLCtrL				;A : fTxSdCmdLCtrH | fTxSdCmdLCtrL
		jnz		_TxSdCommand1					;fTxSdCmdLCtr <> 0Ȃ烋[v
		;
		mov		A, #0ffh					;A : ^CAEg
		;
_TxSdCommand2:	mov		fSdResponse, A					;X|XXV
		setb		pSdCs						;CslQ[g
		TxSpi0		#0ffh						;DataOutnCCs[_Xɂ邽߂̃_~[o
		WaitSpi0End							;MI҂
		;
		pop		PSW						;WX^oNA
		pop		ACC
		ret
		;
InitSd:		;---------------------------------------;SdCard 
		push		ACC
		push		PSW
		SelectRegBank	rbInitSd					;WX^oNؑ
		;
		;							;CsAT[gO80NbNo
		mov		fInitSdLCtr, #010d				;[vJE^
_InitSd1:	TxSpi0		#0ffh						;NbN̂ݏo
		djnz		fInitSdLCtr, _InitSd1				;fInitSdLCtr : fInitSdLCtr - 1A<> 0Ȃ烋[v
		;
		WaitSpi0End							;MI҂
		;
		;							;CMD0s
		mov		fInitSdLCtr, #0100d				;[vJE^AgC񐔂͂Ƃ肠100
		mov		fSdCommand0, #000h				;CMD0
		mov		fSdCommand1, #000h				;Argument3
		mov		fSdCommand2, #000h				;Argument2
		mov		fSdCommand3, #000h				;Argument1
		mov		fSdCommand4, #000h				;Argument0
		mov		fSdCommand5, #095h				;CRC
_InitSd2:	call		TxSdCommand					;R}hs
		mov		A, fSdResponse					;A : X|X
		cjne		A, #001h, _InitSd5				;X|X <> 001hȂ烊gC
		;
		jmp		_InitSd3					;X|X = 001hȂ玟
		;
_InitSd5:	dec		fInitSdLCtr					;fInitSdLCtr : fInitSdLCtr - 1
		mov		A, fInitSdLCtr					;A : fInitSdLCtr
		jnz		_InitSd2					;fInitSdLCtr <> 0Ȃ烊gC
		;
		mov		fSdResponse, #0ffh				;fSdResponse : ^CAEg
		jmp		_InitSd0					;Wv
		;
_InitSd3:	;							;CMD1s
		mov		fInitSdLCtr, #0250d				;[vJE^AgC񐔂͂Ƃ肠250
		;								;TransFlashJ[hɂ100ł͕s
		mov		fSdCommand0, #001h				;CMD1
_InitSd4:	call		TxSdCommand					;R}hs
		mov		A, fSdResponse					;A : X|X
		jz		_InitSd0					;X|X = 000hȂI
		;
		dec		fInitSdLCtr					;fInitSdLCtr : fInitSdLCtr - 1
		mov		A, fInitSdLCtr					;A : fInitSdLCtr
		jnz		_InitSd4					;fInitSdLCtr <> 0Ȃ烊gC
;***		jmp		_InitSd4					;gC
		;
_InitSd0:	pop		PSW						;WX^oNA
		pop		ACC
		ret
		;
ReadSdSector:	;---------------------------------------;SdCard ZN^[h
		;					;  1ZN^̃f[^(512oCg)XRAMɓǂݍ
		;					;  fSdSectorNo : ZN^ԍ(3oCg)
		;					;  fSdResponse : X|X(1oCg)
		;					;  ߂l : ȂAG[̓Vbg_E\肾G[o͖
		push		ACC
		push		DPL
		push		DPH
		;
		;							;łXRAMɓǂݍ܂ĂZN^Ȃǂݍ݂XLbv
		mov		A, fSdSectorNoL					;A : ZN^ԍ(7..0)
		cjne		A, fXramSectorNoL, _ReadSdSector2		;A <> fXramSectorNoLȂWv
		;
		mov		A, fSdSectorNoM					;A : ZN^ԍ(15..8)
		cjne		A, fXramSectorNoM, _ReadSdSector2		;A <> fXramSectorNoMȂWv
		;
		mov		A, fSdSectorNoH					;A : ZN^ԍ(23..16)
		cjne		A, fXramSectorNoH, _ReadSdSector2		;A <> fXramSectorNoHȂWv
		;
		jmp		_ReadSdSector0					;XRAMɓǂݍ܂ĂZN^Ȃ̂œǂݍ݂XLbv
		;
_ReadSdSector2:	;							;XRAMƈvȂ̂œǂݍݎs
		clr		C						;CNA
		mov		A, fSdSectorNoL					;A : ZN^ԍ(7..0)
		mov		fXramSectorNoL, A				;fXramSectorNoLXV
		rlc		A						;A : ZN^ԍ(6..0):0
		mov		fSdCommand3, A					;[hAhX(15..8)XV
		mov		A, fSdSectorNoM					;A : ZN^ԍ(15..8)
		mov		fXramSectorNoM, A				;fXramSectorNoMXV
		rlc		A						;A : ZN^ԍ(14..7)
		mov		fSdCommand2, A					;[hAhX(23..16)XV
		mov		A, fSdSectorNoH					;A : ZN^ԍ(23..16)
		mov		fXramSectorNoH, A				;fXramSectorNoHXV
		rlc		A						;A : ZN^ԍ(22..15)
		mov		fSdCommand1, A					;[hAhX(31..24)XV
		mov		DPTR, #0000h					;DPTR
		;
		clr		pSdCs						;CsAT[g
_ReadSdSector3:	RxSpi0		A						;A : SPIM
		cjne		A, #0ffh, _ReadSdSector3			;Mf[^ <> 0ffhȂ炳ɎM
		;
		TxSpi0		#017d + 040h					;READ_SINGLE_BLOCKR}hM
		TxSpi0		fSdCommand1					;AhX(31..24)M
		TxSpi0		fSdCommand2					;AhX(23..16)M
		TxSpi0		fSdCommand3					;AhX(15..8)M
		TxSpi0		#000h						;AhX(7..0)M
		TxSpi0		#095h						;CRC(_~[)M
_ReadSdSector1:	RxSpi0		A						;A : SPIM
		cjne		A, #0feh, _ReadSdSector1			;Mf[^ <> 0fehȂ烋[v
		;
		;								;***** gCKv
		;
_ReadSdSector5:	mov		fSdResponse, A					;X|XXV
		;
		RxSpi0		A						;A : SPIM
		movx		@DPTR, A					;Mf[^XV
		inc		DPTR						;DPTR : DPTR + 1
		mov		A, DPH
		cjne		A, #002h, _ReadSdSector5			;DPTR < 512Ȃ烋[v
		;
		RxSpi0		A						;A : CRCM(_~[)
		RxSpi0		A						;A : CRCM(_~[)
		;
		clr		C						;CNA
		;
		setb		pSdCs						;CslQ[g
		TxSpi0		#0ffh						;DataOutnCCs[_Xɂ邽߂̃_~[o
		WaitSpi0End							;MI҂
		;
_ReadSdSector0:	pop		DPH
		pop		DPL
		pop		ACC
		ret
		;
GetSdBpbInfo:	;---------------------------------------;SdCard BPB̏擾
		;					;  WX^oNrbGetSdBpbInfogp
		;					;  C : 0 = IA1 = G[
		push		ACC
		push		PSW
		push		DPL
		push		DPH
		SelectRegBank	rbGetSdBpbInfo					;WX^oNؑ
		;
		mov		fSdSectorNoL, #000h				;ZN^0(MBR)
		mov		fSdSectorNoM, #000h				;ZN^0(MBR)
		mov		fSdSectorNoH, #000h				;ZN^0(MBR)
		call		ReadSdSector					;MBRǂݍ
		;
		mov		DPTR, #0446d + 008d				;DPTR : 0446d + 008d
		movx		A, @DPTR					;A : BPB擪ZN^(L)
		mov		fSdSectorNoL, A					;fSdSectorNoLXV
		inc		DPTR						;DPTR : 0446d + 009d
		movx		A, @DPTR					;A : BPB擪ZN^(H)
		mov		fSdSectorNoM, A					;fSdSectorNoMXV
		mov		fSdSectorNoH, #000h				;fSdSectorNoHXV
		call		ReadSdSector					;BPBǂݍ
		;
		mov		DPTR, #011d					;DPTR : 011d
		movx		A, @DPTR					;A : BPB_BytsPerSec(L) : ZN^̃oCg(L)
		cjne		A, #LOW 0512d, _GetSdBpbInfoE			;A <> 512(L)ȂG[
		;
		inc		DPTR						;DPTR : 012d
		movx		A, @DPTR					;A : BPB_BytsPerSec(H) : ZN^̃oCg(H)
		cjne		A, #HIGH 0512d, _GetSdBpbInfoE			;A <> 512(H)ȂG[
		;
		jmp		_GetSdBpbInfo2					;
		;
_GetSdBpbInfoE:	mov		A, #001h					;G[
		jmp		_GetSdBpbInfo0					;Wv
		;
_GetSdBpbInfo2:	inc		DPTR						;DPTR : 013d
		movx		A, @DPTR					;A : BPB_SecPerClus : NX^̃ZN^
		mov		fSecPerClus, A					;fSecPerClusXV
		;
		inc		DPTR						;DPTR : 014d
		movx		A, @DPTR					;A : BPB_RsvdSecCnt(L) : \ZN^(L)
		add		A, fSdSectorNoL					;A : BPB擪ZN^(L) + \ZN^(L)
		mov		fFirstFatSecL, A				;fFirstFatSecLXV
		;
		inc		DPTR						;DPTR : 015d
		movx		A, @DPTR					;A : BPB_RsvdSecCnt(H) : \ZN^(H)
		addc		A, fSdSectorNoM					;A : BPB擪ZN^(H) + \ZN^(H) + C
		mov		fFirstFatSecH, A				;fFirstFatSecHXV
		;
		inc		DPTR						;DPTR : 016d
		movx		A, @DPTR					;A : BPB_NumFATs : FAT̐
		mov		fNumFats, A					;fNumFatsɃXgA
		;
		inc		DPTR						;DPTR : 017d
		movx		A, @DPTR					;A : BPB_RootEntCnt(L) : [gfBNgGg(L)
		mov		fRootEntCntL, A					;fRootEntCntLɃXgA
		;
		inc		DPTR						;DPTR : 018d
		movx		A, @DPTR					;A : BPB_RootEntCnt(H) : [gfBNgGg(H)
		mov		fRootEntCntH, A					;fRootEntCntHɃXgA
		orl		A, fRootEntCntL					;A : BPB_RootEntCnt(H + L)
		jz		_GetSdBpbInfoE					;A = 0ȂFAT32Ȃ̂ŖT|[g
		;
		mov		DPTR, #022d					;DPTR : 022d
		movx		A, @DPTR					;A : BPB_FATSz16(L) : FAT̃ZN^(L)
		mov		fFatSizeL, A					;fFatSizeLɃXgA
		;
		inc		DPTR						;DPTR : 023d
		movx		A, @DPTR					;A : BPB_FATSz16(H) : FAT̃ZN^(H)
		mov		fFatSizeH, A					;fFatSizeHɃXgA
		;
		cjne		fNumFats, #2, _GetSdBpbInfo1			;FAT̐ <> 2ȂWv
		;
		ShiftL16	fFatSizeH, fFatSizeL				;fFatSize : FAT̃ZN^ * 2
		;
_GetSdBpbInfo1:	;cjne		fNumFats, #1, _GetSdBpbInfoE			;FAT̐ <> 1ȂG[ƌȂ
		;
		AddYAB16	fFirstRootSecH, fFirstRootSecL, fFirstFatSecH, fFirstFatSecL, fFatSizeH, fFatSizeL
		;								;fFirstRootSec : FAT̐擪ZN^ԍ + (FAT̃ZN^ * FAT̐)
		;
		ShiftR16	fRootEntCntH, fRootEntCntL			;fRootEntCnt : [gfBNgGg / 2
		ShiftR16	fRootEntCntH, fRootEntCntL			;fRootEntCnt : [gfBNgGg / 4
		ShiftR16	fRootEntCntH, fRootEntCntL			;fRootEntCnt : [gfBNgGg / 8
		ShiftR16	fRootEntCntH, fRootEntCntL			;fRootEntCnt : [gfBNgGg / 16 (= [gfBNg̃ZN^)
		AddYAB16	fFirstDataSecH, fFirstDataSecL, fFirstRootSecH, fFirstRootSecL, fRootEntCntH, fRootEntCntL
		;								;fFirstDataSec : [gfBNgGg̐擪ZN^ԍ + [gfBNg̃ZN^
		mov		A, #000h					;I
		;
_GetSdBpbInfo0:	pop		DPH
		pop		DPL
		pop		PSW						;WX^oNA
		rrc		A						;C : IXe[^X
		pop		ACC
		ret
		;
FindNextCS:	;---------------------------------------;ɓǂݍނׂf[^̃NX^ԍEZN^ԍ擾
		;					;  fFileClusterNo : ƂȂNX^ԍ
		;					;  fFileSectorCnt : ƂȂNX^̃ZN^ԍ
		;					;  C : 0 = IA1 = ̃NX^͖(EOCo)
		push		ACC
		push		DPL
		push		DPH
		;
		inc		fFileSectorCnt					;fFileSectorCnt : NX^̃ZN^ԍCNg
		mov		A, fFileSectorCnt				;A : NX^̃ZN^ԍ
		cjne		A, fSecPerClus, _FindNextCS1			;A <> NX^̃ZN^Ȃ琳I
		;
		mov		fSdSectorNoH, #0				;
		mov		fSdSectorNoM, #0				;
		mov		fSdSectorNoL, fFileClusNoH			;fSdSectorNo : [hNX^ԍ / (512 / 2)
		AddYYA24	fSdSectorNoH, fSdSectorNoM, fSdSectorNoL, #0, fFirstFatSecH, fFirstFatSecL
		;								;fSdSectorNo : FAT܂܂ZN^
		call		ReadSdSector					;ZN^[h
		;
		mov		DPL, fFileClusNoL				;
		mov		DPH, #0						;DPTR : [hNX^ԍ(L)
		ShiftL16	DPH, DPL					;DPTR : [hNX^ԍ(L) * 2 = FATւ̃|C^
		movx		A, @DPTR					;A : FAT(L)
		mov		fFileClusNoL, A					;fFileClusNoL : Ƀ[hNX^ԍ(L)
		inc		DPTR						;DPTR : DPTR + 1
		movx		A, @DPTR					;A : FAT(H)
		mov		fFileClusNoH, A					;fFileClusNoH : Ƀ[hNX^ԍ(H)
		mov		fFileSectorCnt, #0				;NX^̃ZN^ԍ
		;
		mov		A, fFileClusNoL					;A : fFileClusNoL : Ƀ[hNX^ԍ(L)
		cjne		A, #0ffh, _FindNextCS1				;A <> EOCȂ琳I
		;
		mov		A, fFileClusNoH					;A : fFileClusNoH : Ƀ[hNX^ԍ(H)
		cjne		A, #0ffh, _FindNextCS1				;A <> EOCȂ琳I
		;
		setb		C						;EOCoACZbg
		jmp		_FindNextCS0					;^[
		;
_FindNextCS1:	clr		C						;I
		;
_FindNextCS0:	pop		DPH
		pop		DPL
		pop		ACC
		ret
		;
SeekMp3FileNo:	;---------------------------------------;fFileNoԖڂ".MP3"t@CT
		;					;  eϐ
		;					;  C : 0 = IA1 = Ȃ
		;					;  F0 : 1 = fBNg1ȖځA0 = 2Ȗڈȍ~
		push		ACC
		push		PSW
		push		DPL
		push		DPH
		SelectRegBank	rbSeekMp3File					;WX^oNؑ
		;
_smFileNo1:	mov		fFoundFileCtr, #0				;fFoundFileCtr : MP3t@CJE^
		mov		fDirNestLevel, #0				;fDirNestLevel : fBNglXgx
		mov		fSdSectorNoH, #000h				;0Ōߑł
		mov		fSdSectorNoM, fFirstRootSecH
		mov		fSdSectorNoL, fFirstRootSecL			;fSdSectorNo : [gfBNgGg̐擪ZN^ԍ
		setb		F0						;1ȖڃtOZbgĂ
		;
_smFileNo5:	call		_smReadDirEnt					;fBNgGg̃ZN^[h
		;
_smFileNo3:	;							;󂫃Gg`FbN
		call		_smChkEmptyEnt					;DPTR|CgfBNgGg󂫂ǂ`FbN
		jnc		_smFileNo2					;󂫂ȂΎ̃Gg
		;
		;							;TufBNg`FbN
		call		_smChkSubDir					;DPTR|CgfBNgGgTufBNgǂ`FbN
		jc		_smFileNo8					;TufBNgł͂ȂȂWv
		;
		;							;GgfBNg̏ꍇ
		call		_smDescendDir					;DPTR|CgGgTufBNgƂ1x
		setb		F0						;1ȖڃtOZbg
		jmp		_smFileNo5					;P̊Kw
		;
_smFileNo8:	;							;GgfBNgłȂꍇ
		call		_smChkMp3File					;DPTR|CgfBNgGgMP3t@Cǂ`FbN
		jc		_smFileNo2					;MP3t@CłȂȂ玟̃Gg
		;
		;							;MP3t@C
		inc		fFoundFileCtr					;MP3t@CJE^ + 1
		mov		A, fFoundFileCtr				;
		cjne		A, fFileNo, _smFileNo6				;A <> fFileNoȂ玟̃Gg
		;
		call		_smUpdatePrms					;DPTR|CgGg̓eŃt@CɊւϐ
		call		_smAscendRoot					;[gfBNg܂Ŗ߂
		clr		A						;I
		jmp		_smFileNo0					;Wv
		;
_smFileNo6:	clr		F0						;1ȖڃtONA
		;
_smFileNo2:	;							;̃Gg
		anl		DPL, #NOT 031d					;DPTR̃Gg̐擪ɂ
		AddYYA16	DPH, DPL, #0, #032d				;DPTR : DPTR + 32 = ̃Gg
		mov		A, DPH						;A : ZN^|C^(H)
		cjne		A, #002h, _smFileNo3				;DPTR < 512ȂWv
		;
		;							;̃ZN^
		mov		A, fDirNestLevel				;A : fBNglXgx
		jz		_smFileNo4					;A = 0ȂWv
		;
		;							;TufBNg̏ꍇ
		call		FindNextCS					;ɓǂݍނׂf[^̃NX^ԍEZN^ԍ擾
		jnc		_smFileNo5					;CNAȂ玟̃ZN^
		;
		;							;EOCo
		call		_smAscendDir					;X^bNɕۑĂGg𕜋AāA1x̃fBNg֖߂
		setb		F0						;1ȖڃtOZbg
		jmp		_smFileNo2					;̃Gg
		;
_smFileNo4:	;							;[gfBNg̏ꍇ
		call		_smNextRootSec					;[gfBNgɂZN^ЂƂi߂
		jnc		_smFileNo5					;CNAȂ玟̃ZN^
		;
		;							;[gfBNg̍ŌɓB
		mov		fMp3Files, fFoundFileCtr			;fMp3Files܂łŌMP3t@C̐ōXV
		clr		F0						;1ȖڃtONA
		mov		A, #001h					;G[
		;
_smFileNo0:	pop		DPH
		pop		DPL
		mov		C, F0						;C : 1ȖڃtO
		mov		ACC.1, C					;ACC.1 : 1ȖڃtO
		pop		PSW						;WX^oNA
		mov		C, ACC.1					;C : 1ȖڃtO
		mov		F0, C						;F0 : 1ȖڃtO
		mov		C, ACC.0					;C : IXe[^X
		pop		ACC
		ret
		;
SeekMp3NextFNo:	;---------------------------------------;fFileNo + 1Ԗڂ".MP3"t@CT
		;					;  eϐ
		;					;  C : 0 = IA1 = Ȃ
		push		ACC
		push		PSW
		push		DPL
		push		DPH
		SelectRegBank	rbSeekMp3File					;WX^oNؑ
		;
		;							;̋ȂT
		inc		fFileNo						;fFileNo : fFileNo + 1
		mov		A, fMp3Files					;A : SȐ
		cjne		A, fFileNo, _smNextFNo1				;fMp3Files - fFileNoAWvȂ
_smNextFNo1:	jnc		_smNextFNo2					;fMp3Files >= fFileNoȂWv
		;
		;							;Ō̋Ȃ̏ꍇ
		mov		fFileNo, #1					;1Ȗڂ
		;
_smNextFNo2:	jmp		_smFileNo1				;ȍ~SeekMp3FileNoƓ
		;
SeekMp3PrevFNo:	;---------------------------------------;fFileNo - 1Ԗڂ".MP3"t@CT
		;					;  eϐ
		;					;  C : 0 = IA1 = Ȃ
		push		ACC
		push		PSW
		push		DPL
		push		DPH
		SelectRegBank	rbSeekMp3File					;WX^oNؑ
		;
		;							;ŐȂT
		dec		fFileNo						;fFileNo : fFileNo - 1
		mov		A, fFileNo					;A : XVȔԍ
		jnz		_smPrevFNo1					;A <> 0ȂWv
		;
		;							;1Ȗڂꍇ
		mov		fFileNo, fMp3Files				;Ō̋Ȃ
		;
_smPrevFNo1:	jmp		_smFileNo1				;ȍ~SeekMp3FileNoƓ
		;
SeekMp3NextDir:	;---------------------------------------;fFileNoԖڂ̃t@C܂܂fBNg̎̃fBNgɂŏ".MP3"t@CT
		;					;@[gfBNgAMP3t@CfBNg͖
		;					;@߂l : fFileNo
		;					;  C : 0 = IA1 = Ȃ
		push		ACC
		push		PSW
		push		DPL
		push		DPH
		SelectRegBank	rbSeekMp3File					;WX^oNؑ
		;
		mov		fFoundFileCtr, #0				;fFoundFileCtr : MP3t@CJE^
		mov		fDirNestLevel, #0				;fDirNestLevel : fBNglXgx
		mov		fSubDirFound, #0				;fSubDirFound : TufBNgtONA
		mov		fSdSectorNoH, #000h				;0Ōߑł
		mov		fSdSectorNoM, fFirstRootSecH			;
		mov		fSdSectorNoL, fFirstRootSecL			;fSdSectorNo : [gfBNgGg̐擪ZN^ԍ
		;
_smNextDir5:	call		_smReadDirEnt					;fBNgGg̃ZN^[h
		;
_smNextDir3:	;							;󂫃Gg`FbN
		call		_smChkEmptyEnt					;DPTR|CgfBNgGg󂫂ǂ`FbN
		jnc		_smNextDir2					;󂫂ȂΎ̃Gg
		;
		;							;TufBNg`FbN
		call		_smChkSubDir					;DPTR|CgfBNgGgTufBNgǂ`FbN
		jc		_smNextDir8					;TufBNgł͂ȂȂWv
		;
		;							;GgfBNg̏ꍇ
		mov		fSubDirFound, #0ffh				;fSubDirFound : TufBNgtOZbg
		call		_smDescendDir					;DPTR|CgGgTufBNgƂ1x
		jmp		_smNextDir5					;P̊Kw
		;
_smNextDir8:	;							;GgfBNgłȂꍇ
		call		_smChkMp3File					;DPTR|CgfBNgGgMP3t@Cǂ`FbN
		jc		_smNextDir2					;MP3t@CłȂȂ玟̃Gg
		;
		;							;MP3t@C
		inc		fFoundFileCtr					;MP3t@CJE^ + 1
		mov		A, fSubDirFound					;A : TufBNgtO
		jz		_smNextDir2					;TufBNgtONAȂ玟̃Gg
		;
		;							;iTufBNg1ȖڂMP3t@Cj𔭌
;*****		call		_smUpdatePrms					;DPTR|CgGg̓eŃt@CɊւϐ
		mov		fSubDirFound, #0				;TufBNgtONA
		mov		A, fFileNo					;A : fFileNo
		clr		C						;CNA
		subb		A, fFoundFileCtr				;A : fFileNo - fFoundFileCtr
		jnc		_smNextDir2					;fFileNo >= fFoundFileCtrȂ玟̃Gg
		;
		;							;ړĨt@C
		mov		fFileNo, fFoundFileCtr				;fFileNoXV
		call		_smAscendRoot					;[gfBNg܂Ŗ߂
		clr		A						;I
		jmp		_smNextDir0					;Wv
		;
_smNextDir2:	;							;̃Gg
		anl		DPL, #NOT 031d					;DPTR̃Gg̐擪ɂ
		AddYYA16	DPH, DPL, #0, #032d				;DPTR : DPTR + 32 = ̃Gg
		mov		A, DPH						;A : ZN^|C^(H)
		cjne		A, #002h, _smNextDir3				;DPTR < 512ȂWv
		;
		;							;̃ZN^
		mov		A, fDirNestLevel				;A : fBNglXgx
		jz		_smNextDir4					;A = 0ȂWv
		;
		;							;TufBNg̏ꍇ
		call		FindNextCS					;ɓǂݍނׂf[^̃NX^ԍEZN^ԍ擾
		jnc		_smNextDir5					;CNAȂ玟̃ZN^
		;
		;							;EOCo
		call		_smAscendDir					;X^bNɕۑĂGg𕜋AāA1x̃fBNg֖߂
		mov		fSubDirFound, #0				;TufBNgtONA
		jmp		_smNextDir2					;̃Gg
		;
_smNextDir4:	;							;[gfBNg̏ꍇ
		call		_smNextRootSec					;[gfBNgɂZN^ЂƂi߂
		jnc		_smNextDir5					;CNAȂ玟̃ZN^
		;
		;							;[gfBNg̍ŌɓB@fFileNo0ffĥ܂܂Ȃ̂Œ
		mov		A, #001h					;G[
		;
_smNextDir0:	pop		DPH
		pop		DPL
		pop		PSW						;WX^oNA
		rrc		A						;C : IXe[^X
		pop		ACC
		ret
		;
SeekMp3CurrDir:	;---------------------------------------;fFileNoԖڂ̃t@C܂܂fBNg̍ŏ".MP3"t@CT
		;					;@[gfBNgAMP3t@CfBNg͖
		;					;@߂l : fFileNo
		;					;  C : 0 = IA1 = Ȃ
		push		ACC
		push		PSW
		push		DPL
		push		DPH
		SelectRegBank	rbSeekMp3File					;WX^oNؑ
		;
		mov		fFoundFileCtr, #0				;fFoundFileCtr : MP3t@CJE^
		mov		fDirNestLevel, #0				;fDirNestLevel : fBNglXgx
		mov		fSubDirFound, #0				;fSubDirFound : TufBNgtONA
		mov		fFileNoSaved, #0				;fFileNoSaved : ʌfFileNoꎞۑWX^
		mov		fSdSectorNoH, #000h				;0Ōߑł
		mov		fSdSectorNoM, fFirstRootSecH
		mov		fSdSectorNoL, fFirstRootSecL			;fSdSectorNo : [gfBNgGg̐擪ZN^ԍ
		;
_smCurrDir5:	call		_smReadDirEnt					;fBNgGg̃ZN^[h
		;
_smCurrDir3:	;							;󂫃Gg`FbN
		call		_smChkEmptyEnt					;DPTR|CgfBNgGg󂫂ǂ`FbN
		jnc		_smCurrDir2					;󂫂ȂΎ̃Gg
		;
		;							;TufBNg`FbN
		call		_smChkSubDir					;DPTR|CgfBNgGgTufBNgǂ`FbN
		jc		_smCurrDir8					;TufBNgł͂ȂȂWv
		;
		;							;GgfBNg̏ꍇ
		mov		fSubDirFound, #0ffh				;fSubDirFound : TufBNgtOZbg
		call		_smDescendDir					;DPTR|CgGgTufBNgƂ1x
		jmp		_smCurrDir5					;P̊Kw
		;
_smCurrDir8:	;							;GgfBNgłȂꍇ
		call		_smChkMp3File					;DPTR|CgfBNgGgMP3t@Cǂ`FbN
		jc		_smCurrDir2					;MP3t@CłȂȂ玟̃Gg
		;
		;							;MP3t@C
		inc		fFoundFileCtr					;MP3t@CJE^ + 1
		mov		A, fSubDirFound					;A : TufBNgtO
		jz		_smCurrDir1					;TufBNgtONAȂt@Cԍ̃`FbN
		;
		;							;iTufBNg1ȖڂMP3t@Cj𔭌
		mov		A, fFoundFileCtr				;A, MP3t@CJE^
		mov		fFileNoSaved, A					;fFileNoSavedXV
;*****		call		_smUpdatePrms					;DPTR|CgGg̓eŃt@CɊւϐ
		mov		fSubDirFound, #0				;TufBNgtONA
		;
_smCurrDir1:	mov		A, fFoundFileCtr				;A : MP3t@CJE^
		cjne		A, fFileNo, _smCurrDir2				;A <> fFileNoȂWv
		;
		;							;fFileNoԖڂ̃t@CɓB
		mov		A, fFileNoSaved					;A : ʌfFileNoꎞۑWX^
		jz		_smCurrDirE					;܂₪ĂȂȂG[
		;
		;							;fFileNoԖڂ̃t@CɓBɌ₪Ăꍇ
_smCurrDir6:	mov		fFileNo, fFileNoSaved				;fFileNoXV
		call		_smAscendRoot					;[gfBNg܂Ŗ߂
		clr		A						;I
		jmp		_smCurrDir0					;Wv
		;
_smCurrDir2:	;							;̃Gg
		anl		DPL, #NOT 031d					;DPTR̃Gg̐擪ɂ
		AddYYA16	DPH, DPL, #0, #032d				;DPTR : DPTR + 32 = ̃Gg
		mov		A, DPH						;A : ZN^|C^(H)
		cjne		A, #002h, _smCurrDir3				;DPTR < 512ȂWv
		;
		;							;̃ZN^
		mov		A, fDirNestLevel				;A : fBNglXgx
		jz		_smCurrDir4					;A = 0ȂWv
		;
		;							;TufBNg̏ꍇ
		call		FindNextCS					;ɓǂݍނׂf[^̃NX^ԍEZN^ԍ擾
		jnc		_smCurrDir5					;CNAȂ玟̃ZN^
		;
		;							;EOCo
		call		_smAscendDir					;X^bNɕۑĂGg𕜋AāA1x̃fBNg֖߂
		mov		fSubDirFound, #0				;TufBNgtONA
		jmp		_smCurrDir2					;̃Gg
		;
_smCurrDir4:	;							;[gfBNg̏ꍇ
		call		_smNextRootSec					;[gfBNgɂZN^ЂƂi߂
		jnc		_smCurrDir5					;CNAȂ玟̃ZN^
		;
		;							;[gfBNg̍ŌɓBA܂͌₪Ȃꍇ
_smCurrDirE:	mov		A, #001h					;G[
		;
_smCurrDir0:	pop		DPH
		pop		DPL
		pop		PSW						;WX^oNA
		rrc		A						;C : IXe[^X
		pop		ACC
		ret
		;
SeekMp3PrevDir:	;---------------------------------------;fFileNoԖڂ̃t@C܂܂fBNg̑ÕfBNgɂŏ".MP3"t@CT
		;					;@[gfBNgAMP3t@CfBNg͖
		;					;@߂l : fFileNo
		;					;  C : 0 = IA1 = Ȃ
		push		ACC
		push		PSW
		push		DPL
		push		DPH
		SelectRegBank	rbSeekMp3File					;WX^oNؑ
		;
		mov		fFoundFileCtr, #0				;fFoundFileCtr : MP3t@CJE^
		mov		fDirNestLevel, #0				;fDirNestLevel : fBNglXgx
		mov		fSubDirFound, #0				;fSubDirFound : TufBNgtONA
		mov		fFileNoSaved, #0				;fFileNoSaved : ʌfFileNoꎞۑWX^
		mov		fSdSectorNoH, #000h				;0Ōߑł
		mov		fSdSectorNoM, fFirstRootSecH
		mov		fSdSectorNoL, fFirstRootSecL			;fSdSectorNo : [gfBNgGg̐擪ZN^ԍ
		;
_smPrevDir5:	call		_smReadDirEnt					;fBNgGg̃ZN^[h
		;
_smPrevDir3:	;							;󂫃Gg`FbN
		call		_smChkEmptyEnt					;DPTR|CgfBNgGg󂫂ǂ`FbN
		jnc		_smPrevDir2					;󂫂ȂΎ̃Gg
		;
		;							;TufBNg`FbN
		call		_smChkSubDir					;DPTR|CgfBNgGgTufBNgǂ`FbN
		jc		_smPrevDir8					;TufBNgł͂ȂȂWv
		;
		;							;GgfBNg̏ꍇ
		mov		fSubDirFound, #0ffh				;fSubDirFound : TufBNgtOZbg
		call		_smDescendDir					;DPTR|CgGgTufBNgƂ1x
		jmp		_smPrevDir5					;P̊Kw
		;
_smPrevDir8:	;							;GgfBNgłȂꍇ
		call		_smChkMp3File					;DPTR|CgfBNgGgMP3t@Cǂ`FbN
		jc		_smPrevDir2					;MP3t@CłȂȂ玟̃Gg
		;
		;							;MP3t@C
		inc		fFoundFileCtr					;MP3t@CJE^ + 1
		mov		A, fFoundFileCtr				;
		cjne		A, fFileNo, _smPrevDir7				;A <> fFileNoȂWv
		;
		;							;fFileNoԖڂ̃t@CɓB
		mov		A, fFileNoSaved					;A : ʌfFileNoꎞۑWX^
		jz		_smPrevDir9					;܂₪ĂȂȂWv
		;
		;							;fFileNoԖڂ̃t@CɓBłɌ₪Ăꍇ
_smPrevDir6:	mov		fFileNo, fFileNoSaved				;fFileNoXV
		call		_smAscendRoot					;[gfBNg܂Ŗ߂
		clr		A						;I
		jmp		_smPrevDir0					;Wv
		;
_smPrevDir9:	;							;fFileNoԖڂ̃t@CɓBɂ܂₪ĂȂꍇ
		mov		fFileNo, #0ffh					;Ō̌T߁AŌ܂Ō
		;
_smPrevDir7:	mov		A, fSubDirFound					;A : TufBNgtO
		jz		_smPrevDir2					;TufBNgtONAȂ玟̃Gg
		;
		;							;iTufBNg1ȖڂMP3t@Cj𔭌
		mov		A, fFoundFileCtr				;A, fFoundFileCtr
		mov		fFileNoSaved, A					;fFileNoSavedXV
;*****		call		_smUpdatePrms					;DPTR|CgGg̓eŃt@CɊւϐ
		mov		fSubDirFound, #0				;TufBNgtONA
		;
_smPrevDir2:	;							;̃Gg
		anl		DPL, #NOT 031d					;DPTR̃Gg̐擪ɂ
		AddYYA16	DPH, DPL, #0, #032d				;DPTR : DPTR + 32 = ̃Gg
		mov		A, DPH						;A : ZN^|C^(H)
		cjne		A, #002h, _smPrevDir3				;DPTR < 512ȂWv
		;
		;							;̃ZN^
		mov		A, fDirNestLevel				;A : fBNglXgx
		jz		_smPrevDir4					;A = 0ȂWv
		;
		;							;TufBNg̏ꍇ
		call		FindNextCS					;ɓǂݍނׂf[^̃NX^ԍEZN^ԍ擾
		jnc		_smPrevDir5					;CNAȂ玟̃ZN^
		;
		;							;EOCo
		call		_smAscendDir					;X^bNɕۑĂGg𕜋AāA1x̃fBNg֖߂
		mov		fSubDirFound, #0				;TufBNgtONA
		jmp		_smPrevDir2					;̃Gg
		;
_smPrevDir4:	;							;[gfBNg̏ꍇ
		call		_smNextRootSec					;[gfBNgɂZN^ЂƂi߂
		jnc		_smPrevDir5					;CNAȂ玟̃ZN^
		;
		;							;[gfBNg̍ŌɓB
		mov		A, fFileNoSaved					;A : ʌfFileNoꎞۑWX^
		jnz		_smPrevDir6					;łɌ₪ĂȂWv
		;
		;							;[gfBNg̍Ō㓞Bɂ܂₪ĂȂꍇ@fFileNo0ffĥ܂܂Ȃ̂Œ
		mov		A, #001h					;G[
		;
_smPrevDir0:	pop		DPH
		pop		DPL
		pop		PSW						;WX^oNA
		rrc		A						;C : IXe[^X
		pop		ACC
		ret
		;
_smReadDirEnt:	;---------------				;SeekMp3*p[JTu[`
		;						;@fBNgGg̃ZN^[h
		mov		A, fDirNestLevel				;A : fBNglXgx
		jnz		_smReadDirEnt1					;A > 0ȂWv
		;
		call		ReadSdSector					;[gfBNg̏ꍇ
		jmp		_smReadDirEnt2					;Wv
		;
_smReadDirEnt1:	call		ReadFileData					;TufBNg̏ꍇ
_smReadDirEnt2:	mov		DPTR, #0					;DPTR : ZN^|C^
		;
		ret
		;
_smChkEmptyEnt:	;---------------				;SeekMp3*p[JTu[`
		;						;@DPTR|CgfBNgGg󂫂ǂ`FbN
		;						;@C : 0 = 󂫁A1 = 󂫂łȂiLȃGgj
		anl		DPL, #NOT 031d					;DPTR̃Gg̐擪ɂ
		movx		A, @DPTR					;A : DIR_Name[0]
		cjne		A, #0e5h, _smCEE2				;A <> 0e5h(󂫃Gg)ȂWv
		;
		jmp		_smCEE1						;󂫃Gg
		;
_smCEE2:	cjne		A, #000h, _smCEE3				;A <> 000h(󂫃Gg)ȂWv
		;
		jmp		_smCEE1						;󂫃Gg
		;
_smCEE3:	cjne		A, #005h, _smCEE4				;A <> 005h(󂫃Gg)ȂWv
		;
		jmp		_smCEE1						;󂫃Gg
		;
_smCEE4:	cjne		A, #".", _smCEE5				;A <> ".", ".."ȂWv
		;
_smCEE1:	;							;󂫃Gg̏ꍇ
		clr		C						;CNA
		jmp		_smCEE0						;^[
		;
_smCEE5:	;							;󂫃GgłȂꍇ
		setb		C						;CZbg
		;
_smCEE0:	ret
		;
_smChkSubDir:	;---------------				;SeekMp3*p[JTu[`
		;						;@DPTR|CgfBNgGgTufBNgǂ`FbN
		;						;@C : 0 = TufBNgA1 = TufBNgłȂ
		anl		DPL, #NOT 031d					;DPTR̃Gg̐擪ɂ
		AddYYA16	DPH, DPL, #0, #011d				;DPTR : GgItZbg = 11
		movx		A, @DPTR					;A : DIR_Attr
		setb		C						;CZbgĂ
		jnb		ACC.4, _smChkSubDir0				;ATTR_DIRECTORYNAȂ΃fBNgł͂Ȃ
		;
		;							;TufBNg̏ꍇ
		clr		C						;CNA
		;
_smChkSubDir0:	ret
		;
_smDescendDir:	;---------------				;SeekMp3*p[JTu[`
		;						;@DPTR|CgGgTufBNgƂ1x
		;						;@オƂ̂߂ɃGgX^bNɕۑĂ
		pop		ACC						;A : ^[AhX(H)
		mov		fRetAddrH, A					;fRetAddrHɈꎞޔ
		pop		ACC						;A : ^[AhX(L)
		mov		fRetAddrL, A					;fRetAddrLɈꎞޔ
		;
		anl		DPL, #NOT 031d					;DPTR̃Gg̐擪ɂ
		push		DPH						;
		push		DPL						;fBNgGg|C^ۑ
		mov		A, fDirNestLevel				;A : fBNglXgx
		jnz		_smDescendDir1					;A > 0ȂWv
		;
		;							;[gfBNg̏ꍇ
		push		fSdSectorNoH					;
		push		fSdSectorNoM					;
		push		fSdSectorNoL					;ԕۑ
		jmp		_smDescendDir2					;Wv
		;
_smDescendDir1:	;							;TufBNg̏ꍇ
		push		fFileClusNoH					;
		push		fFileClusNoL					;
		push		fFileSectorCnt					;ԕۑ
		;
_smDescendDir2:	;							;TufBNg̃NX^EZN^
		AddYYA16	DPH, DPL, #0, #026d				;DPTR : GgItZbg = 26
		movx		A, @DPTR					;A : DIR_FstClusLO(L)
		mov		fFileClusNoL, A					;
		inc		DPTR						;DPTR : GgItZbg = 27
		movx		A, @DPTR					;A : DIR_FstClusLO(H)
		mov		fFileClusNoH, A					;fFileClusNo
		mov		fFileSectorCnt, #0				;fFileSectorCnt
		inc		fDirNestLevel					;fBNglXgx + 1
		;
		mov		A, fRetAddrL					;A : ^[AhX(L)
		push		ACC						;X^bNA
		mov		A, fRetAddrH					;A : ^[AhX(H)
		push		ACC						;X^bNA
		;
		ret
		;
_smChkMp3File:	;---------------				;SeekMp3*p[JTu[`
		;						;@DPTR|CgfBNgGgMP3t@Cǂ`FbN
		;						;@C : 0 = MP3t@CA1 = MP3t@CłȂ
		anl		DPL, #NOT 031d					;DPTR̃Gg̐擪ɂ
		AddYYA16	DPH, DPL, #0, #008d				;DPTR : GgItZbg = 8
		movx		A, @DPTR					;A : DIR_Name[8]
		cjne		A, #"M", _smChkMp3File1				;A <> "M"ȂWv
		;
		inc		DPTR						;DPTR : GgItZbg = 9
		movx		A, @DPTR					;A : DIR_Name[9]
		cjne		A, #"P", _smChkMp3File1				;A <> "P"ȂWv
		;
		inc		DPTR						;DPTR : GgItZbg = 10
		movx		A, @DPTR					;A : DIR_Name[10]
		cjne		A, #"3", _smChkMp3File1				;A <> "3"ȂWv
		;
		inc		DPTR						;DPTR : GgItZbg = 11
		movx		A, @DPTR					;A : DIR_Attr
		jb		ACC.3, _smChkMp3File1				;ATTR_VOLUME_IDZbgȂWv
		;
		;							;MP3t@C
		clr		C						;CNA
		jmp		_smChkMp3File0					;^[
		;
_smChkMp3File1:	;							;MP3t@CłȂꍇ
		setb		C						;CZbg
		;
_smChkMp3File0:	ret
		;
_smUpdatePrms:	;---------------				;SeekMp3*p[JTu[`
		;						;@DPTR|CgGg̓eŃt@CɊւϐ
		anl		DPL, #NOT 031d					;DPTR̃Gg̐擪ɂ
		AddYYA16	DPH, DPL, #0, #026d				;DPTR : GgItZbg = 26
		movx		A, @DPTR					;A : DIR_FstClusLO(L)
		mov		fFileClusNoL, A					;
		inc		DPTR						;DPTR : GgItZbg = 27
		movx		A, @DPTR					;A : DIR_FstClusLO(H)
		mov		fFileClusNoH, A					;fFileClusNo
		inc		DPTR						;DPTR : GgItZbg = 28
		movx		A, @DPTR					;A : DIR_FileSize(0)
		mov		fFileSizeL, A					;
		mov		fRemainBytesL, A				;
		inc		DPTR						;DPTR : GgItZbg = 29
		movx		A, @DPTR					;A : DIR_FileSize(1)
		mov		fFileSizeN, A					;
		mov		fRemainBytesN, A				;
		inc		DPTR						;DPTR : GgItZbg = 30
		movx		A, @DPTR					;A : DIR_FileSize(2)
		mov		fFileSizeM, A					;
		mov		fRemainBytesM, A				;
		inc		DPTR						;DPTR : GgItZbg = 31
		movx		A, @DPTR					;A : DIR_FileSize(3)
		mov		fFileSizeH, A					;fFileSize
		mov		fRemainBytesH, A				;fRemainBytes
		mov		fFileSectorCnt, #0				;fFileSectorCnt
		mov		fStartTimeH, #0					;
		mov		fStartTimeL, #0					;fStartTime
		;
		ret
		;
_smAscendRoot:	;---------------				;SeekMp3*p[JTu[`
		;						;@[gfBNg܂Ŗ߂
		pop		ACC						;A : ^[AhX(H)
		mov		fRetAddrH, A					;fRetAddrHɈꎞޔ
		pop		ACC						;A : ^[AhX(L)
		mov		fRetAddrL, A					;fRetAddrLɈꎞޔ
		;
		;							;X^bN|
_smAscendRoot1:	mov		A, fDirNestLevel				;A : fBNglXgx
		jz		_smAscendRoot0					;A = 0ȂWv
		;
		pop		ACC
		pop		ACC
		pop		ACC
		pop		ACC
		pop		ACC						;ۑĂGgj
		dec		fDirNestLevel					;fBNglXgx - 1
		jmp		_smAscendRoot1					;[v
		;
_smAscendRoot0:	mov		A, fRetAddrL					;A : ^[AhX(L)
		push		ACC						;X^bNA
		mov		A, fRetAddrH					;A : ^[AhX(H)
		push		ACC						;X^bNA
		;
		ret
		;
_smAscendDir:	;---------------				;SeekMp3*p[JTu[`
		;						;@X^bNɕۑĂGg𕜋AāA1x̃fBNg֖߂
		pop		ACC						;A : ^[AhX(H)
		mov		fRetAddrH, A					;fRetAddrHɈꎞޔ
		pop		ACC						;A : ^[AhX(L)
		mov		fRetAddrL, A					;fRetAddrLɈꎞޔ
		;
		dec		fDirNestLevel					;fBNglXgx - 1
		mov		A, fDirNestLevel				;A : fBNglXgx
		jz		_smAscendDir1					;A = 0ȂWv
		;
		;							;eTufBNg̏ꍇ
		pop		fFileSectorCnt					;
		pop		fFileClusNoL					;
		pop		fFileClusNoH					;ԕA
		call		ReadFileData					;fBNgGgǂݍ
		jmp		_smAscendDir2					;Wv
		;
_smAscendDir1:	;							;e[gfBNg̏ꍇ
		pop		fSdSectorNoL					;
		pop		fSdSectorNoM					;
		pop		fSdSectorNoH					;ԕA
		call		ReadSdSector					;fBNgGgǂݍ
_smAscendDir2:	pop		DPL						;
		pop		DPH						;fBNgGg|C^A
		;
		mov		A, fRetAddrL					;A : ^[AhX(L)
		push		ACC						;X^bNA
		mov		A, fRetAddrH					;A : ^[AhX(H)
		push		ACC						;X^bNA
		;
		ret
		;
_smNextRootSec:	;---------------				;SeekMp3*p[JTu[`
		;						;@[gfBNgɂZN^ЂƂi߂
		;						;@C : 0 = ̃ZN^A1 = ̃ZN^͖
		AddYYA16	fSdSectorNoM, fSdSectorNoL, #0, #1	;fSdSectorNo : GgZN^ԍ + 1
		mov		A, fSdSectorNoL				;A : GgZN^ԍ(L)
		cjne		A, fFirstDataSecL, _smNextRootSec1		;A <> fFirstDataSecLȂ玟̃ZN^
		;
		mov		A, fSdSectorNoM					;A : GgZN^ԍ(H)
		cjne		A, fFirstDataSecH, _smNextRootSec1		;A <> fFirstDataSecHȂ玟̃ZN^
		;
		;							;̃ZN^͖
		setb		C						;CZbg
		jmp		_smNextRootSec0					;^[
		;
_smNextRootSec1:;							;̃ZN^
		clr		C						;CNA
		;
_smNextRootSec0:ret
		;
ReadFileData:	;---------------------------------------;t@C1ZN^ǂݍ
		;					;  fFileClusterNo : [hNX^ԍ
		;					;  fFileSectorCnt : NX^̃ZN^ԍ
		push		ACC
		;
		mov		fSdSectorNoH, #0				;
		mov		fSdSectorNoM, fFileClusNoH			;
		mov		fSdSectorNoL, fFileClusNoL			;fSdSectorNo : [hNX^ԍ
		SubYYA16	fSdSectorNoM, fSdSectorNoL, #0, #2		;fSdSectorNo : [hNX^ԍ - 2
		mov		A, fSecPerClus					;A : NX^̃ZN^
_ReadFileData1:	jb		ACC.0, _ReadFileData2				;ACC.0ZbgȂVtgI
		;
		push		ACC						;Aۑ
		ShiftL24	fSdSectorNoH, fSdSectorNoM, fSdSectorNoL
		;								;fSdSectorNo : fSdSectorNo * 2
		pop		ACC						;AA
		rr		A						;A : A / 2
		jmp		_ReadFileData1					;[v
		;
_ReadFileData2:	AddYYA24	fSdSectorNoH, fSdSectorNoM, fSdSectorNoL, #0, fFirstDataSecH, fFirstDataSecL
		;								;fSdSectorNo : ([hNX^ԍ - 2) * NX^̃ZN^ + f[^̈̐擪ZN^ԍ
		AddYYA24	fSdSectorNoH, fSdSectorNoM, fSdSectorNoL, #0, #0, fFileSectorCnt
		;								;fSdSectorNo : ([hNX^ԍ - 2) * NX^̃ZN^ + f[^̈̐擪ZN^ԍ + NX^̃ZN^ԍ
		call		ReadSdSector					;ZN^[h
		;
		pop		ACC
		ret
		;
CheckRemain:	;---------------------------------------;Đf[^cĂ邩ǂ̃`FbN
		;					;  fRemainBytes : f[^t@C̍ĐcoCg
		;					;  A = 0 : cȂA<> 0 : c肠
		mov		A, fRemainBytesL				;A : fRemainBytes(3)
		orl		A, fRemainBytesN				;A : fRemainBytes(3 | 2)
		orl		A, fRemainBytesM				;A : fRemainBytes(3 | 2 | 1)
		orl		A, fRemainBytesH				;A : fRemainBytes(3 | 2 | 1 | 0)
		;
		ret
		;
MakeSdCheckD:	;---------------------------------------;SDJ[h`FbNpf[^
		;					;  fSdCheckData : fMp3Files + fFileSize
		push		ACC
		;
		mov		fSdCheckDataH, fFileSizeH			;
		mov		fSdCheckDataM, fFileSizeM			;
		mov		fSdCheckDataN, fFileSizeN			;
		mov		fSdCheckDataL, fFileSizeL			;fSdCheckData : J[hopf[^fFileSizeŏ
		AddYYA32	fSdCheckDataH, fSdCheckDataM, fSdCheckDataN, fSdCheckDataL, #0, #0, #0, fMp3Files
		;								;fSdCheckData : fMp3Files + fFileSize
		;
		pop		ACC
		ret
		;
OnFatalError:	;---------------------------------------;vIG[
		;					;  G[ʒmr[v̌AVbg_E
		clr		EA						;S荞݋֎~
		MakeBeep	cBeepNoteL, cBeepTimeErr			;r[v(ቹ)
		mov		A, #0100d					;0.1b҂
		call		WaitAmsec					;Amsec҂
		MakeBeep	cBeepNoteL, cBeepTimeErr			;r[v(ቹ)
		jmp		ShutDown				;Vbg_E
		;
ShutDown:	;---------------------------------------;Vbg_E
		clr		EA						;S荞݋֎~
		;jmp		ShutDown					;***** DEBUG *****
		;
		LmOff								;LM4924 Vbg_EON
		;
		mov		fTdaReg0, #10111111b				;OFF
		mov		fTdaReg1, #11111111b				;OFF
		mov		fTdaReg2, #11111111b				;OFF
		call		TxTdaReg					;TDA7463ADWX^Cg
		;
		mov		fNsR0, #00010010b				;PE = 0
		call		TxNsR0						;NS953MX^oC
		;
		call		PowerDownVs					;VS1011~
		;
		mov		P0, #11111100b					;pSwR, pSwF"L"
		mov		P1, #10111111b					;pVsReset"L"
		mov		P2, #00100111b					;pSwDApIrRxPwr, pAmpSd, pIrTxMod"L"
		mov		P3, #11111110b					;pSwU"L"
		mov		XBR1, #01000000b				;SytFATC֎~ANXo[Cl[u
		mov		XBR0, #00000000b				;SytFATC֎~
		mov		P0SKIP,  #11111111b				;SsXLbv
		mov		P1SKIP,  #11111111b				;SsXLbv
		mov		P2SKIP,  #00001111b				;SsXLbv
		;
		orl		PCON, #00000010b				;STOPZbgACPU~
		nop								;_~[
		;
		;							;Zzz...
		;
LoadNvParams:	;---------------------------------------;sԕA
		push		ACC
		push		PSW
		push		DPL
		push		DPH
		SelectRegBank	rbLoadNvParams					;WX^oNؑ
		;
		mov		DPTR, #NvAreaTop				;DPTR : ԕۑ̈擪AhX
		mov		fLoadNvPrmsLCtr, #cNvParamEnd - cNvParamTop	;fLoadNvPrmsLCtr : [vJE^
		mov		fLoadNvPrmsDPtr, #cNvParamTop			;fLoadNvPrmsDPtr
_LoadNvParams1:	ReadFlash							;A : [hf[^
		mov		@fLoadNvPrmsDPtr, A				;f[^A
		inc		DPTR						;DPTR + 1
		inc		fLoadNvPrmsDPtr					;fLoadNvPrmsDPtr + 1
		djnz		fLoadNvPrmsLCtr, _LoadNvParams1			;fLoadNvPrmsLCtr - 1A<> 0Ȃ烋[v
		;
		pop		DPH
		pop		DPL
		pop		PSW						;WX^oNA
		pop		ACC
		ret
		;
SaveNvParams:	;---------------------------------------;s֏ԕۑ
		push		ACC
		push		PSW
		push		DPL
		push		DPH
		push		IE
		SelectRegBank	rbSaveNvParams					;WX^oNؑ
		;
		clr		EA						;S荞݋֎~
		call		MakeSdCheckD					;SDJ[h`FbNpf[^
		;
		;							;ԕۑ̈
		mov		DPTR, #NvAreaTop				;DPTR : ԕۑ̈擪AhX
		orl		PSCTL, #00000011b				;PSEEAPSWEZbg
		clr		A						;A : 0(_~[)
		WriteFlash							;݂ɂ
		anl		PSCTL, #NOT (00000010b)				;PSEENA
		;							;ԕۑ
		mov		fSaveNvPrmsLCtr, #cNvParamEnd - cNvParamTop	;fSaveNvPrmsLCtr : [vJE^
		mov		fSaveNvPrmsDPtr, #cNvParamTop			;fSaveNvPrmsDPtr
_SaveNvParams1:	mov		A, @fSaveNvPrmsDPtr				;A : ۑf[^
		WriteFlash							;ۑ
		inc		DPTR						;DPTR + 1
		inc		fSaveNvPrmsDPtr					;fSaveNvPrmsDPtr + 1
		djnz		fSaveNvPrmsLCtr, _SaveNvParams1			;fSaveNvPrmsLCtr - 1A<> 0Ȃ烋[v
		;
		anl		PSCTL, #NOT (00000001b)				;PSWENA
		;
		pop		IE
		pop		DPH
		pop		DPL
		pop		PSW					;WX^oNA
		pop		ACC
		ret
		;
		;===============================================================
		;	Interrupt Service Routines
		;
IsrInt1:	;---------------------------------------;Int1荞ݏ : VS1011 DREQɂċN
		reti								;IDLE畜A邾
		;
IsrUart0:	;---------------------------------------;UART0荞ݏ : ԊOʐM
		push		ACC
		push		PSW
		SelectRegBank	rbIsrUart0					;WX^oNؑ
		;
		jb		fIrMode.bImTx, _IsrUart0Tx			;MȂ瑗M
		;
		jmp		_IsrUart0Rx					;M
		;
_IsrUart0Tx:	;							;M
		clr		RI0						;RI𖳏ɃNA
		jnb		TI0, _IsrUart00					;TINAȂI
		;
		clr		TI0						;TINA
		mov		A, fIrTxRemain					;A : MoCg
		jz		_IsrUart0Tx1					;c0Ȃ瑗M
		;
		;							;1oCgM
		mov		EMI0CN, #HIGH cIrTxBuffer			;EMI0CN𑗐Mobt@̈ɐݒ
		movx		A, @fIrTxDataPtr				;A : Mf[^
		mov		SBUF0, A					;M
		inc		fIrTxDataPtr					;Mobt@f[^|C^XV
		dec		fIrTxRemain					;MoCgXV
		jmp		_IsrUart00					;I
		;
_IsrUart0Tx1:	;							;M
		setb		pIrRxPwr					;W[dON
		SetUartBaud	Rx						;Mp{[[gɐݒ
		mov		fIrMode, #0					;ԊOʐM[hStONA
		clr		RI0						;RItONA
		setb		REN0						;M싖
		jmp		_IsrUart00					;I
		;
_IsrUart0Rx:	;							;M
		clr		TI0						;TI𖳏ɃNA
		jnb		RI0, _IsrUart00					;RINAȂI
		;
		clr		RI0						;RINA
		jb		fIrMode.bImActive, _IsrUart0Rx1			;łɒʐMȂWv
		;
		;							;X^[gR[h`FbN
		mov		A, SBUF0					;A : Mf[^
		cjne		A, #cIrStartCode, _IsrUart00			;X^[gR[hłȂȂ疳ďI
		;
		;							;MJn
		setb		fIrMode.bImActive				;ʐMtOZbg
		setb		fIrMode.bImRx					;MtOZbg
		mov		EMI0CN, #HIGH cIrRxBuffer			;EMI0CNMobt@̈ɐݒ
		mov		fIrRxDataPtr, #LOW cIrRxBuffer			;Mobt@f[^|C^
		movx		@fIrRxDataPtr, A				;Mf[^Mobt@֊i[
		mov		fIrCheckSum, A					;`FbNTX^[gR[hŏ
		inc		fIrRxDataPtr					;Mobt@f[^|C^XV
		mov		fIrRxBytes, #1					;Mf[^oCg
		jmp		_IsrUart00					;I
		;
_IsrUart0Rx1:	;							;1oCgM
		mov		A, SBUF0					;A : Mf[^
		mov		EMI0CN, #HIGH cIrRxBuffer			;EMI0CNMobt@̈ɐݒ
		movx		@fIrRxDataPtr, A				;Mf[^Mobt@֊i[
		add		A, fIrCheckSum					;`FbNTvZ
		mov		fIrCheckSum, A					;`FbNTXV
		inc		fIrRxDataPtr					;Mobt@f[^|C^XV
		inc		fIrRxBytes					;Mf[^oCgXV
		mov		A, fIrRxBytes					;A : Mf[^oCg
		cjne		A, #cIrRxLength, _IsrUart00			;MoCgMtH[}bgłȂΏI
		;
		clr		fIrMode.bImRx					;MtONA
		mov		A, fIrCheckSum					;A : `FbNT
		jnz		_IsrUart0Rx2					;`FbNTG[ȂWv
		;
		;							;Mf[^tH[}bg`FbN
		setb		fIrMode.bImRxDataReady				;MtOZbg
		clr		RI0						;RItONA
		clr		REN0						;M֎~
		jmp		_IsrUart00					;I
		;
_IsrUart0Rx2:	;							;`FbNTG[
		mov		fIrMode, #0					;ԊOʐM[hStONA
		jmp		_IsrUart00					;I
		;
_IsrUart00:	;							;I
		mov		fIrInterval, #0					;ԊOf[^C^[oJE^
		;
		pop		PSW
		pop		ACC
		reti
		;
IsrTimer3:	;---------------------------------------;Timer3荞ݏ : [UC^[tF[X
		;					;  fSwStatus*̐邱Ƃɒ
		push		ACC
		push		PSW
		;
		anl		TMR3CN, #01111111b				;TF3HNA
		inc		fUITimerCtr					;Timer3荞݃JE^XV
		;
		jb		fPlayMode.bPmSwUpdate, _IsrTimer3Sw0		;PmSwUpdatetOZbgȂ΍XVXLbv
		;
		;							;XCb`
		mov		fSwStatus0to1, fSwStatus			;fSwStatus0to1fSwStatus̑OlRs[Ă
		mov		fSwStatus1to0, fSwStatus			;fSwStatus1to0fSwStatus̑OlRs[Ă
		mov		C, pSwD						;C : pSwD̍l
		mov		ACC.bSwD, C					;ACC.bSwDXV
		mov		C, pSwR						;C : pSwR̍l
		mov		ACC.bSwR, C					;ACC.bSwRXV
		mov		C, pSwF						;C : pSwF̍l
		mov		ACC.bSwF, C					;ACC.bSwFXV
		mov		C, pSwU						;C : pSwU̍l
		mov		ACC.bSwU, C					;ACC.bSwUXV
		cpl		A						;_]Đ_ɂ
		mov		fSwPortSave, A					;fSwPortSaveɈꎞۑ
		xrl		A, fSwPortPrev					;A : Ol xor l
		anl		fSwStatus, A					;fSwStatusɂđOl = l̃rbĝ݃NA
		cpl		A						;A : Ol = l̃rbĝ1
		anl		A, fSwPortSave					;A : fSwPortSaveɂđOl = l̃rbg𒊏o
		orl		A, fSwStatus					;A : fSwStatusɂđOl = l̃rbgXV
		anl		A, #cSwBitMask					;A : XCb`̓rbĝݒo
		mov		fSwStatus, A					;fSwStatusXV
		xrl		fSwStatus0to1, A				;fSwStatus0to1 : fSwStatusɂđOl <> l̃rbĝ1
		anl		fSwStatus0to1, A				;fSwStatus0to1 : ((Ol <> l) and (l = 1))̃rbĝ1
		xrl		fSwStatus1to0, A				;fSwStatus1to0 : fSwStatusɂđOl <> l̃rbĝ1
		cpl		A						;]
		anl		fSwStatus1to0, A				;fSwStatus1to0 : ((Ol <> l) and (l = 0))̃rbĝ1
		mov		fSwPortPrev, fSwPortSave			;fSwPortPrevXV
		setb		fPlayMode.bPmSwUpdate				;PmSwUpdatetOZbg
		;
_IsrTimer3Sw0:	;							;ԊOʐM
		SelectRegBank	rbIsrUart0					;WX^oNؑ
		;
		jb		fIrMode.bImTxReq, _IsrTimer3Ir1			;MJnvtOZbgȂWv
		;
		jnb		fIrMode.bImActive, _IsrTimer3Ir0		;ʐMłȂΏsv
		;
		jb		fIrMode.bImRx, _IsrTimer3Ir2			;MȂWv
		;
		jb		fIrMode.bImTxInterval, _IsrTimer3Ir3		;MJnC^[oȂWv
		;
		jb		fIrMode.bImTx, _IsrTimer3Ir0			;MȂ珈sv
		;
		jmp		_IsrTimer3Ir0					;ԊOʐMI
		;
_IsrTimer3Ir3:	;							;MJn҂
		inc		fIrInterval					;ԊOf[^C^[oJE^XV
		mov		A, #cIrTxInterval				;A : MJnC^[o萔
		cjne		A, fIrInterval, _IsrTimer3Ir0			;MJnłȂΐԊOʐMI
		;
		;							;MJn
		clr		fIrMode.bImTxInterval				;MJnC^[otONA
		setb		fIrMode.bImTx					;MtOZbg
		mov		fIrInterval, #0					;ԊOf[^C^[oJE^
		clr		TI0						;TINA
		mov		EMI0CN, #HIGH cIrTxBuffer			;EMI0CN𑗐Mobt@̈ɐݒ
		movx		A, @fIrTxDataPtr				;A : Mf[^
		mov		SBUF0, A					;M
		inc		fIrTxDataPtr					;Mobt@f[^|C^XV
		dec		fIrTxRemain					;MoCgXV
		jmp		_IsrTimer3Ir0					;ԊOʐMIփWvAȍ~̑MIsrUart0ɂď
		;
_IsrTimer3Ir2:	;							;M
		inc		fIrInterval					;ԊOf[^C^[oJE^XV
		mov		A, #cIrRxTimeout				;A : M^CAEg萔
		cjne		A, fIrInterval, _IsrTimer3Ir0			;^CAEgłȂΐԊOʐMI
		;
		;							;M^CAEg
		mov		fIrMode, #0					;ԊOʐM[hStONA
		jmp		_IsrTimer3Ir0					;ԊOʐMI
		;
_IsrTimer3Ir1:	;							;MJnvo
		clr		fIrMode.bImTxReq				;MJnvtONA
		setb		fIrMode.bImTxInterval				;MJnC^[otOZbg
		clr		pIrRxPwr					;W[dOFF
		SetUartBaud	Tx						;Mp{[[gɐݒ
		mov		fIrTxDataPtr, #LOW cIrTxBuffer			;Mobt@f[^|C^
		mov		fIrTxRemain, fIrTxBytes				;MoCgԊOMf[^oCgŏ
		mov		fIrInterval, #0					;ԊOf[^C^[oJE^
		jmp		_IsrTimer3Ir0					;ԊOʐMI
		;
_IsrTimer3Ir0:	;
		pop		PSW
		pop		ACC
		reti
		;
IsrEnd:		;---------------------------------------;荞ݏ[`̖̈
		;
		;===============================================================
		;	Constant Tables
		;
PreStTableTop:	;---------------------------------------;vZbgǂ̎ge[uCfbNX̃e[u
		db		0001d						;Index =   0 : 76.1MHz InterFM
		db		0004d						;Index =   1 : 76.4MHz RADIO BERRY
		db		0020d						;Index =   2 : 78.0MHz bayfm
		db		0026d						;Index =   3 : 78.6MHz FM-FUJI
		db		0035d						;Index =   4 : 79.5MHz NACK5
		db		0040d						;Index =   5 : 80.0MHz TOKYO FM
		db		0053d						;Index =   6 : 81.3MHz J-WAVE
		db		0065d						;Index =   7 : 82.5MHz NHK-FM
		db		0087d						;Index =   8 : 84.7MHz FMRn}
		db		0103d						;Index =   9 : 86.3MHz FM
PreStTableEnd	equ		$
cPreStTables	equ		PreStTableEnd - PreStTableTop			;vZbgǂ̐
		;
FmR1TableTop:	;---------------------------------------;NS953M 0.1MHz݂R1ݒle[u
		db		06Ch						;Index =   0 : f = 76.0MHz
		db		078h						;Index =   1 : f = 76.1MHz
		db		084h						;Index =   2 : f = 76.2MHz
		db		090h						;Index =   3 : f = 76.3MHz
		db		09Ch						;Index =   4 : f = 76.4MHz
		db		0A9h						;Index =   5 : f = 76.5MHz
		db		0B5h						;Index =   6 : f = 76.6MHz
		db		0C1h						;Index =   7 : f = 76.7MHz
		db		0CDh						;Index =   8 : f = 76.8MHz
		db		0D9h						;Index =   9 : f = 76.9MHz
		db		0E6h						;Index =  10 : f = 77.0MHz
		db		0F2h						;Index =  11 : f = 77.1MHz
		db		0FEh						;Index =  12 : f = 77.2MHz
		db		00Ah						;Index =  13 : f = 77.3MHz
		db		017h						;Index =  14 : f = 77.4MHz
		db		023h						;Index =  15 : f = 77.5MHz
		db		02Fh						;Index =  16 : f = 77.6MHz
		db		03Bh						;Index =  17 : f = 77.7MHz
		db		047h						;Index =  18 : f = 77.8MHz
		db		054h						;Index =  19 : f = 77.9MHz
		db		060h						;Index =  20 : f = 78.0MHz
		db		06Ch						;Index =  21 : f = 78.1MHz
		db		078h						;Index =  22 : f = 78.2MHz
		db		084h						;Index =  23 : f = 78.3MHz
		db		091h						;Index =  24 : f = 78.4MHz
		db		09Dh						;Index =  25 : f = 78.5MHz
		db		0A9h						;Index =  26 : f = 78.6MHz
		db		0B5h						;Index =  27 : f = 78.7MHz
		db		0C1h						;Index =  28 : f = 78.8MHz
		db		0CEh						;Index =  29 : f = 78.9MHz
		db		0DAh						;Index =  30 : f = 79.0MHz
		db		0E6h						;Index =  31 : f = 79.1MHz
		db		0F2h						;Index =  32 : f = 79.2MHz
		db		0FEh						;Index =  33 : f = 79.3MHz
		db		00Bh						;Index =  34 : f = 79.4MHz
		db		017h						;Index =  35 : f = 79.5MHz
		db		023h						;Index =  36 : f = 79.6MHz
		db		02Fh						;Index =  37 : f = 79.7MHz
		db		03Bh						;Index =  38 : f = 79.8MHz
		db		048h						;Index =  39 : f = 79.9MHz
		db		054h						;Index =  40 : f = 80.0MHz
		db		060h						;Index =  41 : f = 80.1MHz
		db		06Ch						;Index =  42 : f = 80.2MHz
		db		079h						;Index =  43 : f = 80.3MHz
		db		085h						;Index =  44 : f = 80.4MHz
		db		091h						;Index =  45 : f = 80.5MHz
		db		09Dh						;Index =  46 : f = 80.6MHz
		db		0A9h						;Index =  47 : f = 80.7MHz
		db		0B6h						;Index =  48 : f = 80.8MHz
		db		0C2h						;Index =  49 : f = 80.9MHz
		db		0CEh						;Index =  50 : f = 81.0MHz
		db		0DAh						;Index =  51 : f = 81.1MHz
		db		0E6h						;Index =  52 : f = 81.2MHz
		db		0F3h						;Index =  53 : f = 81.3MHz
		db		0FFh						;Index =  54 : f = 81.4MHz
		db		00Bh						;Index =  55 : f = 81.5MHz
		db		017h						;Index =  56 : f = 81.6MHz
		db		023h						;Index =  57 : f = 81.7MHz
		db		030h						;Index =  58 : f = 81.8MHz
		db		03Ch						;Index =  59 : f = 81.9MHz
		db		048h						;Index =  60 : f = 82.0MHz
		db		054h						;Index =  61 : f = 82.1MHz
		db		060h						;Index =  62 : f = 82.2MHz
		db		06Dh						;Index =  63 : f = 82.3MHz
		db		079h						;Index =  64 : f = 82.4MHz
		db		085h						;Index =  65 : f = 82.5MHz
		db		091h						;Index =  66 : f = 82.6MHz
		db		09Dh						;Index =  67 : f = 82.7MHz
		db		0AAh						;Index =  68 : f = 82.8MHz
		db		0B6h						;Index =  69 : f = 82.9MHz
		db		0C2h						;Index =  70 : f = 83.0MHz
		db		0CEh						;Index =  71 : f = 83.1MHz
		db		0DBh						;Index =  72 : f = 83.2MHz
		db		0E7h						;Index =  73 : f = 83.3MHz
		db		0F3h						;Index =  74 : f = 83.4MHz
		db		0FFh						;Index =  75 : f = 83.5MHz
		db		00Bh						;Index =  76 : f = 83.6MHz
		db		018h						;Index =  77 : f = 83.7MHz
		db		024h						;Index =  78 : f = 83.8MHz
		db		030h						;Index =  79 : f = 83.9MHz
		db		03Ch						;Index =  80 : f = 84.0MHz
		db		048h						;Index =  81 : f = 84.1MHz
		db		055h						;Index =  82 : f = 84.2MHz
		db		061h						;Index =  83 : f = 84.3MHz
		db		06Dh						;Index =  84 : f = 84.4MHz
		db		079h						;Index =  85 : f = 84.5MHz
		db		085h						;Index =  86 : f = 84.6MHz
		db		092h						;Index =  87 : f = 84.7MHz
		db		09Eh						;Index =  88 : f = 84.8MHz
		db		0AAh						;Index =  89 : f = 84.9MHz
		db		0B6h						;Index =  90 : f = 85.0MHz
		db		0C2h						;Index =  91 : f = 85.1MHz
		db		0CFh						;Index =  92 : f = 85.2MHz
		db		0DBh						;Index =  93 : f = 85.3MHz
		db		0E7h						;Index =  94 : f = 85.4MHz
		db		0F3h						;Index =  95 : f = 85.5MHz
		db		0FFh						;Index =  96 : f = 85.6MHz
		db		00Ch						;Index =  97 : f = 85.7MHz
		db		018h						;Index =  98 : f = 85.8MHz
		db		024h						;Index =  99 : f = 85.9MHz
		db		030h						;Index = 100 : f = 86.0MHz
		db		03Dh						;Index = 101 : f = 86.1MHz
		db		049h						;Index = 102 : f = 86.2MHz
		db		055h						;Index = 103 : f = 86.3MHz
		db		061h						;Index = 104 : f = 86.4MHz
		db		06Dh						;Index = 105 : f = 86.5MHz
		db		07Ah						;Index = 106 : f = 86.6MHz
		db		086h						;Index = 107 : f = 86.7MHz
		db		092h						;Index = 108 : f = 86.8MHz
		db		09Eh						;Index = 109 : f = 86.9MHz
		db		0AAh						;Index = 110 : f = 87.0MHz
		db		0B7h						;Index = 111 : f = 87.1MHz
		db		0C3h						;Index = 112 : f = 87.2MHz
		db		0CFh						;Index = 113 : f = 87.3MHz
		db		0DBh						;Index = 114 : f = 87.4MHz
		db		0E7h						;Index = 115 : f = 87.5MHz
		db		0F4h						;Index = 116 : f = 87.6MHz
		db		000h						;Index = 117 : f = 87.7MHz
		db		00Ch						;Index = 118 : f = 87.8MHz
		db		018h						;Index = 119 : f = 87.9MHz
		db		024h						;Index = 120 : f = 88.0MHz
		db		031h						;Index = 121 : f = 88.1MHz
		db		03Dh						;Index = 122 : f = 88.2MHz
		db		049h						;Index = 123 : f = 88.3MHz
		db		055h						;Index = 124 : f = 88.4MHz
		db		061h						;Index = 125 : f = 88.5MHz
		db		06Eh						;Index = 126 : f = 88.6MHz
		db		07Ah						;Index = 127 : f = 88.7MHz
		db		086h						;Index = 128 : f = 88.8MHz
		db		092h						;Index = 129 : f = 88.9MHz
		db		09Fh						;Index = 130 : f = 89.0MHz
		db		0ABh						;Index = 131 : f = 89.1MHz
		db		0B7h						;Index = 132 : f = 89.2MHz
		db		0C3h						;Index = 133 : f = 89.3MHz
		db		0CFh						;Index = 134 : f = 89.4MHz
		db		0DCh						;Index = 135 : f = 89.5MHz
		db		0E8h						;Index = 136 : f = 89.6MHz
		db		0F4h						;Index = 137 : f = 89.7MHz
		db		000h						;Index = 138 : f = 89.8MHz
		db		00Ch						;Index = 139 : f = 89.9MHz
		db		019h						;Index = 140 : f = 90.0MHz
FmR1TableEnd	equ		$
cFreqTableIdxes	equ		FmR1TableEnd - FmR1TableTop			;NS953M R1, R2ݒl̗vf
		;
FmR2TableTop:	;---------------------------------------;NS953M 0.1MHz݂R2ݒle[u
		db		0c0h + 024h					;Index =   0 : f = 76.0MHz
		db		0c0h + 024h					;Index =   1 : f = 76.1MHz
		db		0c0h + 024h					;Index =   2 : f = 76.2MHz
		db		0c0h + 024h					;Index =   3 : f = 76.3MHz
		db		0c0h + 024h					;Index =   4 : f = 76.4MHz
		db		0c0h + 024h					;Index =   5 : f = 76.5MHz
		db		0c0h + 024h					;Index =   6 : f = 76.6MHz
		db		0c0h + 024h					;Index =   7 : f = 76.7MHz
		db		0c0h + 024h					;Index =   8 : f = 76.8MHz
		db		0c0h + 024h					;Index =   9 : f = 76.9MHz
		db		0c0h + 024h					;Index =  10 : f = 77.0MHz
		db		0c0h + 024h					;Index =  11 : f = 77.1MHz
		db		0c0h + 024h					;Index =  12 : f = 77.2MHz
		db		0c0h + 025h					;Index =  13 : f = 77.3MHz
		db		0c0h + 025h					;Index =  14 : f = 77.4MHz
		db		0c0h + 025h					;Index =  15 : f = 77.5MHz
		db		0c0h + 025h					;Index =  16 : f = 77.6MHz
		db		0c0h + 025h					;Index =  17 : f = 77.7MHz
		db		0c0h + 025h					;Index =  18 : f = 77.8MHz
		db		0c0h + 025h					;Index =  19 : f = 77.9MHz
		db		0c0h + 025h					;Index =  20 : f = 78.0MHz
		db		0c0h + 025h					;Index =  21 : f = 78.1MHz
		db		0c0h + 025h					;Index =  22 : f = 78.2MHz
		db		0c0h + 025h					;Index =  23 : f = 78.3MHz
		db		0c0h + 025h					;Index =  24 : f = 78.4MHz
		db		0c0h + 025h					;Index =  25 : f = 78.5MHz
		db		0c0h + 025h					;Index =  26 : f = 78.6MHz
		db		0c0h + 025h					;Index =  27 : f = 78.7MHz
		db		0c0h + 025h					;Index =  28 : f = 78.8MHz
		db		0c0h + 025h					;Index =  29 : f = 78.9MHz
		db		0c0h + 025h					;Index =  30 : f = 79.0MHz
		db		0c0h + 025h					;Index =  31 : f = 79.1MHz
		db		0c0h + 025h					;Index =  32 : f = 79.2MHz
		db		0c0h + 025h					;Index =  33 : f = 79.3MHz
		db		0c0h + 026h					;Index =  34 : f = 79.4MHz
		db		0c0h + 026h					;Index =  35 : f = 79.5MHz
		db		0c0h + 026h					;Index =  36 : f = 79.6MHz
		db		0c0h + 026h					;Index =  37 : f = 79.7MHz
		db		0c0h + 026h					;Index =  38 : f = 79.8MHz
		db		0c0h + 026h					;Index =  39 : f = 79.9MHz
		db		0c0h + 026h					;Index =  40 : f = 80.0MHz
		db		0c0h + 026h					;Index =  41 : f = 80.1MHz
		db		0c0h + 026h					;Index =  42 : f = 80.2MHz
		db		0c0h + 026h					;Index =  43 : f = 80.3MHz
		db		0c0h + 026h					;Index =  44 : f = 80.4MHz
		db		0c0h + 026h					;Index =  45 : f = 80.5MHz
		db		0c0h + 026h					;Index =  46 : f = 80.6MHz
		db		0c0h + 026h					;Index =  47 : f = 80.7MHz
		db		0c0h + 026h					;Index =  48 : f = 80.8MHz
		db		0c0h + 026h					;Index =  49 : f = 80.9MHz
		db		0c0h + 026h					;Index =  50 : f = 81.0MHz
		db		0c0h + 026h					;Index =  51 : f = 81.1MHz
		db		0c0h + 026h					;Index =  52 : f = 81.2MHz
		db		0c0h + 026h					;Index =  53 : f = 81.3MHz
		db		0c0h + 026h					;Index =  54 : f = 81.4MHz
		db		0c0h + 027h					;Index =  55 : f = 81.5MHz
		db		0c0h + 027h					;Index =  56 : f = 81.6MHz
		db		0c0h + 027h					;Index =  57 : f = 81.7MHz
		db		0c0h + 027h					;Index =  58 : f = 81.8MHz
		db		0c0h + 027h					;Index =  59 : f = 81.9MHz
		db		0c0h + 027h					;Index =  60 : f = 82.0MHz
		db		0c0h + 027h					;Index =  61 : f = 82.1MHz
		db		0c0h + 027h					;Index =  62 : f = 82.2MHz
		db		0c0h + 027h					;Index =  63 : f = 82.3MHz
		db		0c0h + 027h					;Index =  64 : f = 82.4MHz
		db		0c0h + 027h					;Index =  65 : f = 82.5MHz
		db		0c0h + 027h					;Index =  66 : f = 82.6MHz
		db		0c0h + 027h					;Index =  67 : f = 82.7MHz
		db		0c0h + 027h					;Index =  68 : f = 82.8MHz
		db		0c0h + 027h					;Index =  69 : f = 82.9MHz
		db		0c0h + 027h					;Index =  70 : f = 83.0MHz
		db		0c0h + 027h					;Index =  71 : f = 83.1MHz
		db		0c0h + 027h					;Index =  72 : f = 83.2MHz
		db		0c0h + 027h					;Index =  73 : f = 83.3MHz
		db		0c0h + 027h					;Index =  74 : f = 83.4MHz
		db		0c0h + 027h					;Index =  75 : f = 83.5MHz
		db		0c0h + 028h					;Index =  76 : f = 83.6MHz
		db		0c0h + 028h					;Index =  77 : f = 83.7MHz
		db		0c0h + 028h					;Index =  78 : f = 83.8MHz
		db		0c0h + 028h					;Index =  79 : f = 83.9MHz
		db		0c0h + 028h					;Index =  80 : f = 84.0MHz
		db		0c0h + 028h					;Index =  81 : f = 84.1MHz
		db		0c0h + 028h					;Index =  82 : f = 84.2MHz
		db		0c0h + 028h					;Index =  83 : f = 84.3MHz
		db		0c0h + 028h					;Index =  84 : f = 84.4MHz
		db		0c0h + 028h					;Index =  85 : f = 84.5MHz
		db		0c0h + 028h					;Index =  86 : f = 84.6MHz
		db		0c0h + 028h					;Index =  87 : f = 84.7MHz
		db		0c0h + 028h					;Index =  88 : f = 84.8MHz
		db		0c0h + 028h					;Index =  89 : f = 84.9MHz
		db		0c0h + 028h					;Index =  90 : f = 85.0MHz
		db		0c0h + 028h					;Index =  91 : f = 85.1MHz
		db		0c0h + 028h					;Index =  92 : f = 85.2MHz
		db		0c0h + 028h					;Index =  93 : f = 85.3MHz
		db		0c0h + 028h					;Index =  94 : f = 85.4MHz
		db		0c0h + 028h					;Index =  95 : f = 85.5MHz
		db		0c0h + 028h					;Index =  96 : f = 85.6MHz
		db		0c0h + 029h					;Index =  97 : f = 85.7MHz
		db		0c0h + 029h					;Index =  98 : f = 85.8MHz
		db		0c0h + 029h					;Index =  99 : f = 85.9MHz
		db		0c0h + 029h					;Index = 100 : f = 86.0MHz
		db		0c0h + 029h					;Index = 101 : f = 86.1MHz
		db		0c0h + 029h					;Index = 102 : f = 86.2MHz
		db		0c0h + 029h					;Index = 103 : f = 86.3MHz
		db		0c0h + 029h					;Index = 104 : f = 86.4MHz
		db		0c0h + 029h					;Index = 105 : f = 86.5MHz
		db		0c0h + 029h					;Index = 106 : f = 86.6MHz
		db		0c0h + 029h					;Index = 107 : f = 86.7MHz
		db		0c0h + 029h					;Index = 108 : f = 86.8MHz
		db		0c0h + 029h					;Index = 109 : f = 86.9MHz
		db		0c0h + 029h					;Index = 110 : f = 87.0MHz
		db		0c0h + 029h					;Index = 111 : f = 87.1MHz
		db		0c0h + 029h					;Index = 112 : f = 87.2MHz
		db		0c0h + 029h					;Index = 113 : f = 87.3MHz
		db		0c0h + 029h					;Index = 114 : f = 87.4MHz
		db		0c0h + 029h					;Index = 115 : f = 87.5MHz
		db		0c0h + 029h					;Index = 116 : f = 87.6MHz
		db		0c0h + 02Ah					;Index = 117 : f = 87.7MHz
		db		0c0h + 02Ah					;Index = 118 : f = 87.8MHz
		db		0c0h + 02Ah					;Index = 119 : f = 87.9MHz
		db		0c0h + 02Ah					;Index = 120 : f = 88.0MHz
		db		0c0h + 02Ah					;Index = 121 : f = 88.1MHz
		db		0c0h + 02Ah					;Index = 122 : f = 88.2MHz
		db		0c0h + 02Ah					;Index = 123 : f = 88.3MHz
		db		0c0h + 02Ah					;Index = 124 : f = 88.4MHz
		db		0c0h + 02Ah					;Index = 125 : f = 88.5MHz
		db		0c0h + 02Ah					;Index = 126 : f = 88.6MHz
		db		0c0h + 02Ah					;Index = 127 : f = 88.7MHz
		db		0c0h + 02Ah					;Index = 128 : f = 88.8MHz
		db		0c0h + 02Ah					;Index = 129 : f = 88.9MHz
		db		0c0h + 02Ah					;Index = 130 : f = 89.0MHz
		db		0c0h + 02Ah					;Index = 131 : f = 89.1MHz
		db		0c0h + 02Ah					;Index = 132 : f = 89.2MHz
		db		0c0h + 02Ah					;Index = 133 : f = 89.3MHz
		db		0c0h + 02Ah					;Index = 134 : f = 89.4MHz
		db		0c0h + 02Ah					;Index = 135 : f = 89.5MHz
		db		0c0h + 02Ah					;Index = 136 : f = 89.6MHz
		db		0c0h + 02Ah					;Index = 137 : f = 89.7MHz
		db		0c0h + 02Bh					;Index = 138 : f = 89.8MHz
		db		0c0h + 02Bh					;Index = 139 : f = 89.9MHz
		db		0c0h + 02Bh					;Index = 140 : f = 90.0MHz
FmR2TableEnd	equ		$
		;
VarCodeAreaEnd	equ		$					;TCYϓvÖ̖
		;
		;===============================================================
		;	Non-volatile Parameter(s)
		;
		cseg		at	03b00h		;ԕۑp̈
		;
NvAreaTop:	ds		cNvParamEnd - cNvParamTop
		;
		;===============================================================
		;	End of Source
CodeSegmentEnd:	;
		;
	if	VarCodeAreaEnd >= NvAreaTop
		__ERROR__	"Program area is too large."
	endif
		;
	if	CodeSegmentEnd >= 03dffh
		__ERROR__	"Code segment is too large."
	endif
		;
		end
		;===============================================================
