       		;***************************************************************
		;
		;	Title:		Timpy - Remote
		;	Comment:	Tiny MP3 Player [ Timpy ] Rev4.0 Rpt@[EFA
		;	File Name:	Timpy-R.asm
		;	Version:	1.0
		;	(		Jan. 15, 2006	CjV[X)
		;	Last Update:	Jan. 15, 2006
		;	Copyright(C) 	Chiaki Nakajima
		;
		;***************************************************************
		;	Include File(s)
		;
		$pl		(65535)
		$pw		(132)
		$include	(c8051f310.inc)			;vZbTŗL`
		;
		;===============================================================
		;	Port Assign
		;
pSwA		bit		P0.0				;AXCb`
pSwB		bit		P0.1				;BXCb`
pSwC		bit		P0.2				;CXCb`
pEncoderPwr	bit		P0.3				;[^[GR[_d
pIrTx		bit		P0.4				;Uart0 TX
pIrRx		bit		P0.5				;Uart0 RX
pEncoder1	bit		P0.6				;[^[GR[_1
pEncoder2	bit		P0.7				;[^[GR[_2
pBattery	bit		P1.0				;obedo
pIrRxPwr	bit		P1.1				;ԊOW[d
pReserved1	bit		P1.2				;\
pSmbSda		bit		P1.3				;SMBus SDA
pSmbScl		bit		P1.4				;SMBus SCL
pEepromWp	bit		P1.5				;EEPROM WP
pIrTxMod	bit		P1.6				;ԊOLEDϒo
pLcdBlShdn	bit		P1.7				;LCDobNCgpRo[^Vbg_E
pLcdD0		bit		P2.0				;LCDf[^oXD0
pLcdD1		bit		P2.1				;LCDf[^oXD1
pLcdD2		bit		P2.2				;LCDf[^oXD2
pLcdD3		bit		P2.3				;LCDf[^oXD3
pLcdD4		bit		P2.4				;LCDf[^oXD4
pLcdD5		bit		P2.5				;LCDf[^oXD5
pLcdD6		bit		P2.6				;LCDf[^oXD6
pLcdD7		bit		P2.7				;LCDf[^oXD7
pC2D		bit		P3.0				;C2D
pLcdA0		bit		P3.1				;LCDAhXA0
pLcdRd		bit		P3.2				;LCD /RD
pLcdWr		bit		P3.3				;LCD /WR
pLcdRest	bit		P3.4				;LCD /REST
		;
pLcdDB		equ		P2				;LCDf[^oX
pLcdDBMDOUT	equ		P2MDOUT				;LCDf[^oXMDOUT
		;
		;===============================================================
		;	Constant(s)
		;
bSwA		equ		0				;AXCb`rbgԍ
bSwB		equ		1				;BXCb`rbgԍ
bSwC		equ		2				;CXCb`rbgԍ
cSwBitMask	equ		(1 SHL bSwA) OR (1 SHL bSwB) OR (1 SHL bSwC)	;XCb`rbg}XN
		;
cShutdown	equ		018000d				;CPU~܂ł̑҂(10msecP)
cPlayScrnDelay	equ		00300d				;vCʐ؂ւ܂ł̑҂(10msecP)
		;
cIrRxInterval	equ		002d				;MMւ̐؂ւC^[o(10msecP)
cIrRxTimeout	equ		050d				;M^CAEg(10msecP)
cIrStartCode	equ		055h				;X^[gR[h
cIrAck		equ		006h				;ACK
cIrNack		equ		015h				;NACK
cIrBusy		equ		011h				;BUSY
		;
cFAsciiSizeX	equ		006d				;pXTCY
cFAsciiSizeY	equ		010d				;pYTCY
		;
cFKanjiSizeX	equ		012d				;SpXTCY
cFKanjiSizeY	equ		010d				;SpYTCY
		;
cFAsciiBmpTopH	equ		000h				;ptHgrbg}bv擪AhX(H)
cFAsciiBmpTopM	equ		000h				;ptHgrbg}bv擪AhX(M)
cFAsciiBmpTopL	equ		000h				;ptHgrbg}bv擪AhX(L)
		;
cFKanjiIdxTopH	equ		000h				;SptHgCfbNX擪AhX(H)
cFKanjiIdxTopM	equ		00ah				;SptHgCfbNX擪AhX(M)
cFKanjiIdxTopL	equ		000h				;SptHgCfbNX擪AhX(L)
		;
cFKanjiBmpTopH	equ		000h				;SptHgrbg}bv擪AhX(H)
cFKanjiBmpTopM	equ		0dch				;SptHgrbg}bv擪AhX(M)
cFKanjiBmpTopL	equ		0cah				;SptHgrbg}bv擪AhX(L)
		;
cFKanjiCodeOfsH	equ		081h				;Shift-JISR[hItZbg(H)
cFKanjiCodeOfsL	equ		040h				;Shift-JISR[hItZbg(L)
		;
cFFontDataEndH	equ		002h				;tHgf[^ŏIAhX(H)
cFFontDataEndM	equ		0fch				;tHgf[^ŏIAhX(M)
cFFontDataEndL	equ		0ffh				;tHgf[^ŏIAhX(L)
		;
cMp3TagTopH	equ		003h				;MP3^Oz擪AhX(H)
cMp3TagTopM	equ		000h				;MP3^Oz擪AhX(M)
cMp3TagTopL	equ		000h				;MP3^Oz擪AhX(L)
		;
cNvPrmAreaTopH	equ		003h				;ԕϐۑGA擪AhX(H)
cNvPrmAreaTopM	equ		080h				;ԕϐۑGA擪AhX(M)
cNvPrmAreaTopL	equ		000h				;ԕϐۑGA擪AhX(L)
		;
cInherit	equ		0ffffh				;ݒl̂܂܎gꍇ̎wl
		;
cW7		equ		0ffh				;7
cB0		equ		000h				;
cG8		equ		05ch				;8
cG7		equ		01ch				;7
cG4		equ		010h				;4
cO7		equ		0ech				;7
cR8		equ		0e9h				;8
cR7		equ		0e0h				;7
cR4		equ		080h				;4
cY7		equ		0fch				;7
cY4		equ		090h				;4
cY1		equ		024h				;1
cB3		equ		003h				;3
cB7		equ		06fh				;3
		;
cFC		set		cW7				;OiF
cBC		set		cB0				;wiF
		;
cFCMenuNrm	set		cW7				;j[IACȇOiF
cBCMenuNrm	set		cB0				;j[IACe̔wiF
cFCMenuSel	set		cB0				;j[IACȇOiF
cBCMenuSel	set		cR7				;j[IACe̔wiF
cFCMenuSet	set		cB0				;j[IσACȇOiF
cBCMenuSet	set		cY7				;j[IσACe̔wiF
cFCMenuDir	set		cW7				;fBNgACȇOiF
cBCMenuDir	set		cB3				;fBNgACe̔wiF
		;
cMenuItemLen	equ		018d				;j[̃oCg(NULL܂܂)
		;
DrawDirR	equ		1				;`FE
DrawDirU	equ		2				;`F
		;
cEepromBuffer	equ		00000h				;EEPROM[h/Cgobt@(XRAM)
cIrTxBuffer	equ		00200h				;ԊOMobt@̐擪AhX(XRAM)
cIrRxBuffer	equ		00210h				;ԊOMobt@̐擪AhX(XRAM)
cLcdStrBuffer	equ		002e0h				;LCD`敶obt@(XRAM)
		;
cFreqTableIdxes	equ		0141d				;ge[uCfbNX
		;
		;===============================================================
		;	Data Area
		;
		;---------------------------------------;General Purpose Registers
		;					;  gp[`dȂ悤Ɋ蓖Ă
		dseg		at	000h				;WX^oN0
rbMain		equ		$						;MainɂĎgp
fMSrcPtr	equ		R0						;]|C^
fMDstPtr	equ		R1						;]|C^
fIdleCtrH	equ		R2						;~ԃJE^(H)
fIdleCtrL	equ		R3						;~ԃJE^(L)
fNoOpCtrH	equ		R4						;쎞ԃJE^(H)
fNoOpCtrL	equ		R5						;쎞ԃJE^(L)
fLoopCtr	equ		R6						;ėp[vJE^
		;
		dseg		at	008h				;WX^oN1
rbSubLcd	equ		$						;ClearLcd, SubLcd***ɂĎgp
fSrcPtr		equ		R0						;]|C^
fDstPtr		equ		R1						;]|C^
fXCtr		equ		R2						;XJE^
fYCtr		equ		R3						;YJE^
		;
		dseg		at	010h				;WX^oN2
rbSubSpSync	equ		$						;SubSpSyncɂĎgp
fRomAddrL	set		R0						;EEPROM[hAhX(L)
fRomAddrM	set		R1						;EEPROM[hAhX(H)
fByteCtr	set		R2						;]oCgJE^
fLcdOrgYSave	equ		R3						;LcdOrgY̕ۑp
		;
rbDrawListMp3	equ		$						;DrawListMp3ɂĎgp
fRomAddrL	set		R0						;EEPROM[hAhX(L)
fRomAddrM	set		R1						;EEPROM[hAhX(H)
fByteCtr	set		R2						;]oCgJE^
fListTopFileNo	equ		R3						;Xg̍ŏsɕ\ACe̋Ȕԍ(0..fMp3Files-1)
fListFileNoCtr	equ		R4						;\ACe̋ȔԍJE^(0..fMp3Files-1)
fListLineCtr	equ		R5						;Xg\sJE^
fDrawStrLen	equ		R6						;\镶
		;
rbLoadNvParams	equ		$						;LoadNvParamsɂĎgp
fLoadNvPrmsLCtr	equ		R0						;[vJE^
fLoadNvPrmsDPtr	equ		R1						;f[^|C^
		;
rbSaveNvParams	equ		$						;SaveNvParamsɂĎgp
fSaveNvPrmsLCtr	equ		R0						;[vJE^
fSaveNvPrmsDPtr	equ		R1						;f[^|C^
		;
		dseg		at	018h				;WX^oN3
rbIsrUart0	equ		$						;IsrUart0ATxIrCommandɂĎgp
fIrTxDataPtr	equ		R0						;Mobt@f[^|C^
fIrRxDataPtr	equ		R1						;Mobt@f[^|C^
fIrTxRemain	equ		R2						;MoCg
fIrCheckSum	equ		R3						;`FbNT
fIrRxExpects	equ		R4						;M\oCg
		;
		;---------------------------------------;Bit Addressable
		dseg		at	020h
fRemoteMode:	ds		1						;R샂[h
cRmStopMin	equ		000d						;~[hԍ̍ŏl
cRmStop		equ		cRmStopMin + 000d				;~[h
cRmStopMenu	equ		cRmStopMin + 001d				;~j[샂[h
cRmStopSync	equ		cRmStopMin + 002d				;~VN샂[h
cRmStopBlite	equ		cRmStopMin + 003d				;~obNCgݒ葀샂[h
cRmStopContr	equ		cRmStopMin + 004d				;~RgXgݒ葀샂[h
cRmStopMax	equ		cRmStopContr					;~[hԍ̍ŏl
		;
cRmMp3Min	equ		cRmStopMax + 1					;MP3[hԍ̍ŏl
cRmMp3Play	equ		cRmMp3Min + 000d				;MP3vC[h
cRmMp3Jump	equ		cRmMp3Min + 001d				;MP3Wv샂[h
cRmMp3Menu	equ		cRmMp3Min + 002d				;MP3j[샂[h
cRmMp3FfRew	equ		cRmMp3Min + 003d				;MP3/߂샂[h
cRmMp3Repeat	equ		cRmMp3Min + 004d				;MP3s[gݒ葀샂[h
cRmMp3Treble	equ		cRmMp3Min + 005d				;MP3g[Rg[()샂[h
cRmMp3Bass	equ		cRmMp3Min + 006d				;MP3g[Rg[()샂[h
cRmMp3Blite	equ		cRmMp3Min + 007d				;MP3obNCgݒ葀샂[h
cRmMp3Contr	equ		cRmMp3Min + 008d				;MP3RgXgݒ葀샂[h
cRmMp3Max	equ		cRmMp3Contr					;MP3[hԍ̍ől
		;
cRmFmMin	equ		cRmMp3Max + 1					;FM[hԍ̍ŏl
cRmFmPlay	equ		cRmFmMin + 000d					;FMvC[h
cRmFmJump	equ		cRmFmMin + 001d					;FMWv샂[h
cRmFmMenu	equ		cRmFmMin + 002d					;FMj[샂[h
cRmFmSearch	equ		cRmFmMin + 003d					;FMI[gT[`샂[h
cRmFmManual	equ		cRmFmMin + 004d					;FM}jAIǑ샂[h
cRmFmTreble	equ		cRmFmMin + 005d					;FMg[Rg[()샂[h
cRmFmBass	equ		cRmFmMin + 006d					;FMg[Rg[()샂[h
cRmFmBlite	equ		cRmFmMin + 007d					;FMobNCgݒ葀샂[h
cRmFmContr	equ		cRmFmMin + 008d					;FMRgXgݒ葀샂[h
cRmFmMax	equ		cRmFmContr					;FM[hԍ̍ől
		;
fPlayMode:	ds		1						;{̃vC[hoCg
bPmOpMode0	equ		0						;샂[h(rbg0)
bPmOpMode1	equ		1						;샂[h(rbg1)
bPmOpMode2	equ		2						;샂[h(rbg2)
bPmPlayScreen	equ		3						;DrawPlayMp3ʕ\σtO
bPmPlaying	equ		5						;~łȂԃZbgĂtO
bPmFm		equ		6						;FM[ĥƂZbg
bPmSwUpdate	equ		7						;[UC^[tF[X̂߂̊荞݂sꂽZbg
bmPlayModeH	equ		01100111b					;{̂̃vC[hrbg}XN
bmPlayModeR	equ		LOW (NOT (bmPlayModeH))				;R̃vC[hrbg}XN
bmPmOpMode	equ		007h						;샂[hrbg}XN
cOmMp3Play	equ		0						;bPmFm = 0̂Ƃ : MP3ʏĐ[h
cOmMp3TrJump	equ		1						;bPmFm = 0̂Ƃ : gbNWv[h
cOmMp3DirJump	equ		2						;bPmFm = 0̂Ƃ : fBNgWv[h
cOmMp3FfRew	equ		3						;bPmFm = 0̂Ƃ : 芪߂[h
cOmMp3ToneCnt	equ		4						;bPmFm = 0̂Ƃ : g[Rg[ݒ胂[h
cOmMp3Repeat	equ		5						;bPmFm = 0̂Ƃ : s[gݒ胂[h
cOmFmPlay	equ		0						;bPmFm = 1̂Ƃ : FMʏM[h
cOmFmSelectSt	equ		1						;bPmFm = 1̂Ƃ : vZbgǑI[h
cOmFmSearchSt	equ		2						;bPmFm = 1̂Ƃ : ǃT[`[h
cOmFmTuneManu	equ		3						;bPmFm = 1̂Ƃ : }jAIǃ[h
cOmFmToneCnt	equ		4						;bPmFm = 1̂Ƃ : g[Rg[ݒ胂[h
		;
fRepeatMode:	ds		1						;s[gĐ[hݒoCgp
bRmOne		equ		0						;݂̋Ȃs[gĐ(1ON)
bRmDir		equ		1						;݂̃fBNgs[gĐ(1ON)
bRmAll		equ		2						;SȂs[gĐ(1ON)
		;
fIrMode:	ds		1						;ԊOʐM[hoCg
bImActive	equ		0						;ʐMtO
bImTxReq	equ		1						;MJnvtO
bImTx		equ		2						;MtO
bImRxInterval	equ		3						;MJnC^[otO
bImRx		equ		4						;MtO
bImRxDataReady	equ		5						;MtO
bImRxTimeout	equ		6						;M^CAEgtO
bImRxError	equ		7						;Mf[^G[tO
		;
fIRCom:		ds		1						;MR}h
cIRComStatReq	equ		000d						;Xe[^XNGXgR}h
cIRComSync	equ		001d						;VNR}h
cIRComResend	equ		002d						;ÕpPbgđR}h
cIRComVolUp	equ		003d						;{[AbvR}h
cIRComVolDn	equ		004d						;{[_ER}h
cIRComTreble	equ		005d						;拭ݒR}h
cIRComBass	equ		006d						;拭ݒR}h
cIRComMp3Stop	equ		007d						;MP3XgbvR}h
cIRComMp3Play	equ		008d						;MP3vCR}h
cIRComMp3Jump	equ		009d						;MP3WvR}h
cIRComMp3FfRew	equ		010d						;MP3芪߂R}h
cIRComMp3Repeat	equ		011d						;MP3s[gݒR}h
cIRComFmStop	equ		012d						;FMWIIt
cIRComFmPlay	equ		013d						;FMWII
cIRComFmJump	equ		014d						;FMvZbgǑIR}h
cIRComFmSearch	equ		015d						;FMI[gT[`R}h
cIRComFmManual	equ		016d						;FM}jAIǃR}h
cIRComTest	equ		017d						;eXgR}h
cIRComNums	equ		018d						;ԊOMR}h̒`ςݐ
		;
fLcdMode:	ds		1						;LCD샂[h
bLmDirU		equ		0						;1 : ֕`A0 : E(ftHg)
		;
fSwPortPrev:	ds		1						;pSwPort̑Ol
fSwPortSave:	ds		1						;pSwPort̕ۑp
fSwStatus:	ds		1						;pSwPort̏(`b^LZς݁A1=ON)
fSwStatus0to1:	ds		1						;fSwStatusOFFONɕωrbg=1
fSwStatus1to0:	ds		1						;fSwStatusONOFFɕωrbg=1
		;
BitAddressEnd	equ		$					;rbgAhẌ̍Ō
		;
	if	BitAddressEnd >= 030h
		__ERROR__	"Bit address area too large."
	endif
		;
		;---------------------------------------;Direct and Indirect Addressing
		dseg		at	030h
fUITimerCtr:	ds		1						;Timer3荞݃JE^
fBattVoltageR:	ds		1						;Robed(BCD2)
fBattVoltageH:	ds		1						;wbhtHobed(BCD2)
		;
fEncoderCtr:	ds		1						;GR[_(-128..+127)
		;
fMenuRmSel:	ds		1						;݃nCCgĂ郁j[ACẽ[g샂[h
fFocusFileNo:	ds		1						;݃nCCgĂ郊XgACe̋Ȕԍ(1..fMp3Files)
		;
fIrTxBytes:	ds		1						;ԊOMf[^oCg
fIrRxBytes:	ds		1						;ԊOMf[^oCg
fIrInterval:	ds		1						;ԊOf[^C^[oJE^
fIrTxCom:	ds		1						;MR}h
fIrTxPrm:	ds		1						;Mp[^
		;
fLcdOrgX:	ds		1						;LCD `挴_XW
fLcdOrgY:	ds		1						;LCD `挴_YW
fLcdSizeX:	ds		1						;LCD X`TCY
fLcdSizeY:	ds		1						;LCD Y`TCY
fLcdSJisH:	ds		1						;LCD Shift-JISR[h(H)
fLcdSJisL:	ds		1						;LCD Shift-JISR[h(L)
fLcdFColor:	ds		1						;LCD OiF
fLcdBColor:	ds		1						;LCD wiF
fLcdPtnAdrH:	ds		1						;LCD `p^[擪AhX(H)
fLcdPtnAdrL:	ds		1						;LCD `p^[擪AhX(L)
fLcdStrAdrH:	ds		1						;LCD `敶擪AhX(H)
fLcdStrAdrL:	ds		1						;LCD `敶擪AhX(L)
fFontPtrH:	ds		1						;LCD tHgf[^|C^(H)
fFontPtrM:	ds		1						;LCD tHgf[^|C^(M)
fFontPtrL:	ds		1						;LCD tHgf[^|C^(L)
fFontBmpH:	ds		1						;LCD tHgrbg}bv(H)
fFontBmpL:	ds		1						;LCD tHgrbg}bv(L)
		;
fVolume:	ds		1						;{[l(03fh..000h)
fFileNo:	ds		1						;Ώۃt@Cԍ
fVsLoudnessNo:	ds		1						;Loudnessԍ(0..12)
fPreStNo:	ds		1						;vZbgǔԍ
fFreqTableIdx:	ds		1						;Iǒ̎ge[uCfbNX
fTdaReg0:	ds		1						;TDA7463AD WX^ݒl(TuAhX0)
fTdaReg1:	ds		1						;TDA7463AD WX^ݒl(TuAhX1)
fMp3FileCtr:	ds		1						;VNR}h̃t@CJE^
fFfRewMode:	ds		1						;/߂[h
cFfMode		equ		+1d						;胂[h
cFfRewOff	equ		 0d						;ʏ푬x[h
cRewMode	equ		-1d						;߂[h
fDecodeTimeH:	ds		1						;VS1011 fR[h(H)
fDecodeTimeL:	ds		1						;VS1011 fR[h(L)
		;
		;
cNvParamTop	equ		$					;ԕۑϐGA
fMp3Files:	ds		1						;J[hMP3t@C̑S
		;
fLcdBlite:	ds		1						;LCDobNCgf[eB
fLcdContr:	ds		1						;LCDRgXg
cNvParamEnd	equ		$					;ԕۑϐGA܂
		;
DataSegmentEnd	equ		$			;f[^ZOg̍Ō
		;
		iseg		at	080h		;StackZOgJnAhX
Stack:		ds		07fh						;128oCg
		;
	if	DataSegmentEnd >= Stack
		__ERROR__	"DataSegment too large."
	endif
		;
		;===============================================================
		;	Macro(s)
		;
		;---------------------------------------;WX^oNI}N
SelectRegBank	macro		_rbSelect
		;
		anl		PSW, #11100111b					;RS0, RS1NA
		orl		PSW, #_rbSelect AND 00011000b			;RS0, RS1XV
		;
		endm
		;
		;---------------------------------------;24rbgVtg}N
ShiftL24	macro		_H, _M, _L
		;
		push		ACC
		;
		clr		C						;CNA
		mov		A, _L						;A : ʃoCg
		rlc		A						;A : C܂߂č[e[g
		mov		_L, A						;_LXV
		mov		A, _M						;A : ʃoCg
		rlc		A						;A : C܂߂č[e[g
		mov		_M, A						;_MXV
		mov		A, _H						;A : ʃoCg
		rlc		A						;A : C܂߂č[e[g
		mov		_H, A						;_HXV
		;
		pop		ACC
		;
		endm
		;
		;---------------------------------------;8rbgZ}N(̏Ԃɒ)
		;					;  Y = Y + A
		;					;  C : L
AddYYA8		macro		_Y, _A
		;
	if	(_Y = ACC)
		__ERROR__	"Illegal operand in AddYYA8."
	endif
		;
		push		ACC
		;
		mov		A, _A						;A : _A
		add		A, _Y						;A : _A + _Y
		mov		_Y, A						;_YXV
		; 
		pop		ACC
		;
		endm
		;
		;---------------------------------------;16rbgZ}N(̏Ԃɒ)
		;					;  Y = A + B
		;					;  C : L
AddYAB16	macro		_YH, _YL, _AH, _AL, _BH, _BL
		;
	if	(_YH = ACC) or (_YL = ACC)
		__ERROR__	"Illegal operand in AddYAB16."
	endif
		;
		push		ACC
		;
		mov		A, _AL						;A : _AL
		add		A, _BL						;A : _AL + _BL
		mov		_YL, A						;_YLXV
		mov		A, _AH						;A : _AH
		addc		A, _BH						;A : _AH + _BH + C
		mov		_YH, A						;_YHXV
		;
		pop		ACC
		;
		endm
		;
		;---------------------------------------;16rbgZ}N(̏Ԃɒ)
		;					;  Y = Y + A
		;					;  C : L
AddYYA16	macro		_YH, _YL, _AH, _AL
		;
	if	(_YH = ACC) or (_YL = ACC)
		__ERROR__	"Illegal operand in AddYYA16."
	endif
		;
		push		ACC
		;
		mov		A, _AL						;A : _AL
		add		A, _YL						;A : _AL + _YL
		mov		_YL, A						;_YLXV
		mov		A, _AH						;A : _AH
		addc		A, _YH						;A : _AH + _YH + C
		mov		_YH, A						;_YHXV
		;
		pop		ACC
		;
		endm
		;
		;---------------------------------------;16rbgZ}N(̏Ԃɒ)
		;					;  Y = A - B
		;					;  C : {[
SubYAB16	macro		_YH, _YL, _AH, _AL, _BH, _BL
		;
	if	(_YH = ACC) or (_YL = ACC)
		__ERROR__	"Illegal operand in SubYAB16."
	endif
		;
		push		ACC
		;
		clr		C						;CNA
		mov		A, _AL						;A : _AL
		subb		A, _BL						;A : _AL - _BL
		mov		_YL, A						;_YLXV
		mov		A, _AH						;A : _AH
		subb		A, _BH						;A : _AH - _BH - C
		mov		_YH, A						;_YHXV
		;
		pop		ACC
		;
		endm
		;
		;
		;---------------------------------------;16rbgZ}N(̏Ԃɒ)
		;					;  Y = Y - A
		;					;  C : {[
SubYYA16	macro		_YH, _YL, _AH, _AL
		;
	if	(_YH = ACC) or (_YL = ACC)
		__ERROR__	"Illegal operand in SubYYA16."
	endif
		;
		push		ACC
		;
		clr		C						;CNA
		mov		A, _YL						;A : _YL
		subb		A, _AL						;A : _YL - _AL
		mov		_YL, A						;_YLXV
		mov		A, _YH						;A : _YH
		subb		A, _AH						;A : _YH - _AH - C
		mov		_YH, A						;_YHXV
		;
		pop		ACC
		;
		endm
		;
		;
		;---------------------------------------;24rbgZ}N(̏Ԃɒ)
		;					;  Y = Y + A
		;					;  C : L
AddYYA24	macro		_YH, _YM, _YL, _AH, _AM, _AL
		;
	if	(_YH = ACC) or (_YM = ACC) or (_YL = ACC)
		__ERROR__	"Illegal operand in AddYYA24."
	endif
		;
		push		ACC
		;
		mov		A, _AL						;A : _AL
		add		A, _YL						;A : _AL + _YL
		mov		_YL, A						;_YLXV
		mov		A, _AM						;A : _AM
		addc		A, _YM						;A : _AM + _YM + C
		mov		_YM, A						;_YMXV
		mov		A, _AH						;A : _AH
		addc		A, _YH						;A : _AH + _YH + C
		mov		_YH, A						;_YHXV
		;
		pop		ACC
		;
		endm
		;
		;---------------------------------------;FLASH[h}N
		;					;  DPTR : [hAhX
		;					;  A : [hf[^
ReadFlash	macro
		;
		clr		A						;A : 0
		movc		A, @A + DPTR					;A : [hf[^
		;
		endm
		;
		;---------------------------------------;FLASHCg}N
		;					;  DPTR : CgAhX
		;					;  A : Cgf[^
WriteFlash	macro
		;
		mov		FLKEY, #0a5h					;FLKEY : 0a5h
		mov		FLKEY, #0f1h					;FLKEY : 0f1h
		movx		@DPTR, A					;
		;
		endm
		;
		;---------------------------------------;UART0 {[[gݒ}N
Tx		equ		1
Rx		equ		2
		;
SetUartBaud	macro		_TxRx
		;
	if _TxRx = Tx							;Mpݒ : 9600baud
		orl		CKCON, #00000010b				;SCA1Zbg : NbN\[X = SYSCLK / 48
		mov		TH1, #02bh					;1200baud
	else
	if _TxRx = Rx							;Mpݒ : 1200baud
		anl		CKCON, #11111101b				;SCA1NA : NbN\[X = SYSCLK / 12
		mov		TH1, #096h					;9600baud
	else
		__ERROR__	"Illegal operand in SetUartBaud."
	endif
	endif
		;
		endm
		;
		;---------------------------------------;SMBus X^[gRfBV}N
		;					;@IASI̓ZbgĂ
TxSmbSta	macro
		;
		clr		SI						;SINA
		setb		STA						;X^[gRfBV
		jnb		SI, $						;SIZbg҂
		;
		clr		STA						;STANA
		;
		endm
		;
		;---------------------------------------;SMBus f[^M}N
		;					;@M҂BIASI̓ZbgAMACK/NACKSMB0CN.ACKrbgɓĂ
TxSmbData	macro		_Data
		;
		mov		SMB0DAT, _Data					;f[^Cg
		clr		SI						;SINA
		jnb		SI, $						;SIZbg҂ASI̓Zbgꂽ܂܂ɂȂĂ
		;
		endm
		;
		;---------------------------------------;SMBus f[^M}N
		;					;@SINAĎM҂BIASI̓ZbgAMf[^SMB0DATɓĂ
ResACK		equ		1
ResNACK		equ		2
		;
RxSmbData	macro		_Res
		;
		clr		SI						;SINA
		jnb		SI, $						;SIZbg҂ASI̓Zbgꂽ܂܂ɂȂĂ
		;
	if	_Res = ResACK
		setb		ACK						;ACK
	else
	if	_Res = ResNACK
		clr		ACK						;NACK
	else
		__ERROR__	"Illegal operand in RxSmbData."
	endif
	endif
		;
		endm
		;
		;---------------------------------------;SMBus XgbvRfBV}N
		;					;@IASI̓NAĂ
TxSmbSto	macro
		;
		setb		STO						;XgbvRfBV
		clr		SI						;SINA
		;
		endm
		;
		;---------------------------------------;LCD Cg}N
WriteLcd	macro		_A0, _DataSrc
		;
	if	_A0 = 0
		clr		pLcdA0						;pLcdA0 : _A0
	else
	if	_A0 = 1
		setb		pLcdA0						;pLcdA0 : _A0
	else
		__ERROR__	"Illegal operand in WriteLcd."
	endif
	endif
		;
		setb		pLcdRd						;pLcdRd = "H"(Ô)
		clr		pLcdWr						;pLcdWr = "L"
		mov		pLcdDB, _DataSrc				;pLcdDBo
		mov		pLcdDBMDOUT, #0ffh				;pLcdDB : SrbgvbVv
		nop								;40nsec҂
		setb		pLcdWr						;pLcdWr = "H"
		nop								;40nsec҂
		mov		pLcdDBMDOUT, #000h				;pLcdDB : SrbgI[vhC
		mov		pLcdDB, #0ffh					;pLcdDB : Srbg"H"
		;
		endm
		;
		;---------------------------------------;LCD [h}N
ReadLcd		macro		_A0, _DataDst
		;
	if	_A0 = 0
		clr		pLcdA0						;pLcdA0 : _A0
	else
	if	_A0 = 1
		setb		pLcdA0						;pLcdA0 : _A0
	else
		__ERROR__	"Illegal operand in ReadLcd."
	endif
	endif
		;
		mov		pLcdDBMDOUT, #000h				;pLcdDB : SrbgI[vhC(Ô)
		mov		pLcdDB, #0ffh					;pLcdDB : Srbg"H"(Ô)
		setb		pLcdWr						;pLcdWr = "H"(Ô)
		clr		pLcdRd						;pLcdRd = "L"
		nop								;40nsec҂
		nop								;40nsec҂
		nop								;40nsec҂
		nop								;40nsec҂
		nop								;40nsec҂
		mov		_DataDst, pLcdDB				;pLcdDB
		setb		pLcdRd						;pLcdRd = "H"
		nop								;40nsec҂
		nop								;40nsec҂
		;
		endm
		;
		;---------------------------------------;LCD R}hs}N
		;					;@InitLcdɂĎgp
		;					;  DPTR͔j
WrLcdComStr	macro		_ComStrAdr
		;
		mov		DPTR, _ComStrAdr				;R}hAp[^擪AhX
		call		SubWrLcdComStr					;R}hAp[^s
		;
		endm
		;
		;---------------------------------------;LCD `̈tB}N
DrawFill	macro		_OrgX, _OrgY, _SizeX, _SizeY, _Data
		;
	if	(_OrgX <> cInherit)
		mov		fLcdOrgX, #_OrgX				;`挴_XWݒ
	endif
	if	(_OrgY <> cInherit)
		mov		fLcdOrgY, #_OrgY				;`挴_YWݒ
	endif
	if	(_SizeX <> cInherit)
		mov		fLcdSizeX, #_SizeX				;X`TCYݒ
	endif
	if	(_SizeY <> cInherit)
		mov		fLcdSizeY, #_SizeY				;Y`TCYݒ
	endif
		mov		fLcdFColor, #_Data				;tBf[^ݒ
		call		SubLcdFill					;tBs
		;
		endm
		;
		;---------------------------------------;LCD p^[\}N
DrawPattern	macro		_OrgX, _OrgY, _SizeX, _SizeY, _PtnAdr
		;
	if	(_OrgX <> cInherit)
		mov		fLcdOrgX, #_OrgX				;`挴_XWݒ
	endif
	if	(_OrgY <> cInherit)
		mov		fLcdOrgY, #_OrgY				;`挴_YWݒ
	endif
	if	(_SizeX <> cInherit)
		mov		fLcdSizeX, #_SizeX				;X`TCYݒ
	endif
	if	(_SizeY <> cInherit)
		mov		fLcdSizeY, #_SizeY				;Y`TCYݒ
	endif
		mov		fLcdPtnAdrH, #HIGH _PtnAdr			;`p^[擪AhX(H)
		mov		fLcdPtnAdrL, #LOW _PtnAdr			;`p^[擪AhX(L)
		call		SubLcdPattern					;p^[\
		;
		endm
		;
		;---------------------------------------;LCD p1\}N
DrawAscii	macro		_OrgX, _OrgY, _Ascii, _FColor, _BColor, _Dir
		;
	if	(_OrgX <> cInherit)
		mov		fLcdOrgX, #_OrgX				;`挴_XWݒ
	endif
	if	(_OrgY <> cInherit)
		mov		fLcdOrgY, #_OrgY				;`挴_YWݒ
	endif
		mov		fLcdSJisL, _Ascii				;Shift-JISR[h(L) : R[h
	if	(_FColor <> cInherit)
		mov		fLcdFColor, #_FColor				;OiFݒ
	endif
	if	(_BColor <> cInherit)
		mov		fLcdBColor, #_BColor				;wiFݒ
	endif
	if	_Dir = DrawDirR
		clr		fLcdMode.bLmDirU				;E֕`
	else
	if	_Dir = DrawDirU
		setb		fLcdMode.bLmDirU				;ォ牺֕`
	else
		__ERROR__	"Illegal operand in DrawAscii."
	endif
	endif
		call		SubLcdAscii					;p1\
		;
		endm
		;
		;---------------------------------------;LCD Sp1\}N
DrawKanji	macro		_OrgX, _OrgY, _SJis, _FColor, _BColor, _Dir
		;
	if	(_OrgX <> cInherit)
		mov		fLcdOrgX, #_OrgX				;`挴_XWݒ
	endif
	if	(_OrgY <> cInherit)
		mov		fLcdOrgY, #_OrgY				;`挴_YWݒ
	endif
		mov		fLcdSJisH, #HIGH _SJis				;Shift-JISR[h(H)ݒ
		mov		fLcdSJisL, #LOW  _SJis				;Shift-JISR[h(L)ݒ
	if	(_FColor <> cInherit)
		mov		fLcdFColor, #_FColor				;OiFݒ
	endif
	if	(_BColor <> cInherit)
		mov		fLcdBColor, #_BColor				;wiFݒ
	endif
	if	_Dir = DrawDirR
		clr		fLcdMode.bLmDirU				;E֕`
	else
	if	_Dir = DrawDirU
		setb		fLcdMode.bLmDirU				;ォ牺֕`
	else
		__ERROR__	"Illegal operand in DrawKanji."
	endif
	endif
		call		SubLcdKanji					;Sp1\
		;
		endm
		;
		;---------------------------------------;LCD Of[^̕\}N
DrawXdataStr	macro		_OrgX, _OrgY, _FColor, _BColor, _StrAdrH, _StrAdrL, _Dir
		;
	if	(_OrgX <> cInherit)
		mov		fLcdOrgX, #_OrgX				;`挴_XWݒ
	endif
	if	(_OrgY <> cInherit)
		mov		fLcdOrgY, #_OrgY				;`挴_YWݒ
	endif
	if	(_FColor <> cInherit)
		mov		fLcdFColor, #_FColor				;OiFݒ
	endif
	if	(_BColor <> cInherit)
		mov		fLcdBColor, #_BColor				;wiFݒ
	endif
		mov		fLcdStrAdrH, _StrAdrH				;`敶擪AhX(H)
		mov		fLcdStrAdrL, _StrAdrL				;`敶擪AhX(L)
	if	_Dir = DrawDirR
		clr		fLcdMode.bLmDirU				;E֕`
	else
	if	_Dir = DrawDirU
		setb		fLcdMode.bLmDirU				;ォ牺֕`
	else
		__ERROR__	"Illegal operand in DrawXdataStr."
	endif
	endif
		call		SubLcdStrOnX					;\
		;
		endm
		;
		;---------------------------------------;LCD vO̕\}N
DrawConstStr	macro		_OrgX, _OrgY, _FColor, _BColor, _StrAdr, _Dir
		;
	if	(_OrgX <> cInherit)
		mov		fLcdOrgX, #_OrgX				;`挴_XWݒ
	endif
	if	(_OrgY <> cInherit)
		mov		fLcdOrgY, #_OrgY				;`挴_YWݒ
	endif
	if	(_FColor <> cInherit)
		mov		fLcdFColor, #_FColor				;OiFݒ
	endif
	if	(_BColor <> cInherit)
		mov		fLcdBColor, #_BColor				;wiFݒ
	endif
		mov		fLcdStrAdrH, #HIGH _StrAdr			;`敶擪AhX(H)
		mov		fLcdStrAdrL, #LOW  _StrAdr			;`敶擪AhX(L)
	if	_Dir = DrawDirR
		clr		fLcdMode.bLmDirU				;E֕`
	else
	if	_Dir = DrawDirU
		setb		fLcdMode.bLmDirU				;ォ牺֕`
	else
		__ERROR__	"Illegal operand in DrawConstStr."
	endif
	endif
		call		SubLcdStrOnC					;vO̕\
		;
		endm
		;
		;---------------------------------------;LCD vO̕\}N(`敶擪AhXHALɕēn)
DrawConstStrHL	macro		_OrgX, _OrgY, _FColor, _BColor, _StrAdrH, _StrAdrL, _Dir
		;
	if	(_OrgX <> cInherit)
		mov		fLcdOrgX, #_OrgX				;`挴_XWݒ
	endif
	if	(_OrgY <> cInherit)
		mov		fLcdOrgY, #_OrgY				;`挴_YWݒ
	endif
	if	(_FColor <> cInherit)
		mov		fLcdFColor, #_FColor				;OiFݒ
	endif
	if	(_BColor <> cInherit)
		mov		fLcdBColor, #_BColor				;wiFݒ
	endif
	if	(_StrAdrH <> cInherit)
		mov		fLcdStrAdrH, #_StrAdrH				;`敶擪AhX(H)
	endif
	if	(_StrAdrL <> cInherit)
		mov		fLcdStrAdrL, #_StrAdrL				;`敶擪AhX(L)
	endif
	if	_Dir = DrawDirR
		clr		fLcdMode.bLmDirU				;E֕`
	else
	if	_Dir = DrawDirU
		setb		fLcdMode.bLmDirU				;ォ牺֕`
	else
		__ERROR__	"Illegal operand in DrawConstStrHL."
	endif
	endif
		call		SubLcdStrOnC					;vO̕\
		;
		endm
		;
		;---------------------------------------;LCD 1oCgl(10i3)\}N([fBO[TvXȂ)
DrawByte3d	macro		_OrgX, _OrgY, _Num, _FColor, _BColor, _Dir
		;
		push		ACC
		push		PSW
		push		B
		;
		mov		A, _Num						;A : lf[^(0..255)
		mov		B, #0100d					;B : 100
		div		AB						;A / 100
		add		A, #030h					;ASCIIɕϊ
		DrawAscii	_OrgX, _OrgY, A, _FColor, _BColor, _Dir		;100̈ʕ`
		;
		mov		A, B						;A : /100̏]
		mov		B, #010d					;B : 10
		div		AB						;A / 10
		add		A, #030h					;ASCIIɕϊ
		DrawAscii	cInherit, cInherit, A, cInherit, cInherit, _Dir	;10̈ʕ`
		;
		mov		A, B						;A : /10̏]
		add		A, #030h					;ASCIIɕϊ
		DrawAscii	cInherit, cInherit, A, cInherit, cInherit, _Dir	;1̈ʕ`
		;
		pop		B
		pop		PSW
		pop		ACC
		;
		endm
		;
		;---------------------------------------;LCD 1oCgl(10i3)\}N([fBO[TvX)
DrawByte3dZs	macro		_OrgX, _OrgY, _Num, _FColor, _BColor, _Dir
		local		_DrawByte3dZs1, _DrawByte3dZs2, _DrawByte3dZs4, _DrawByte3dZs5
		;
		push		ACC
		push		PSW
		push		B
		;
		clr		F0						;100̈ʂ0tONA
		mov		A, _Num						;A : lf[^(0..255)
		mov		B, #0100d					;B : 100
		div		AB						;A / 100
		jnz		_DrawByte3dZs1					;100̈ <> 0ȂWv
		;
		setb		F0						;100̈ʂ0tOZbg
		mov		A, #" "						;100̈ = 0Ȃ" "
		jmp		_DrawByte3dZs2					;`
		;
_DrawByte3dZs1:	add		A, #030h					;ASCIIɕϊ
_DrawByte3dZs2:	DrawAscii	_OrgX, _OrgY, A, _FColor, _BColor, _Dir		;100̈ʕ`
		;
		mov		A, B						;A : /100̏]
		mov		B, #010d					;B : 10
		div		AB						;A / 10
		jnz		_DrawByte3dZs4					;10̈ <> 0ȂWv
		;
		jnb		F0, _DrawByte3dZs4				;100̈ʂ0tONAȂWv
		;
		mov		A, #" "						;10̈ = 0Ȃ" "
		jmp		_DrawByte3dZs5					;`
		;
_DrawByte3dZs4:	add		A, #030h					;ASCIIɕϊ
_DrawByte3dZs5:	DrawAscii	cInherit, cInherit, A, cInherit, cInherit, _Dir	;10̈ʕ`
		;
		mov		A, B						;A : /10̏]
		add		A, #030h					;ASCIIɕϊ
		DrawAscii	cInherit, cInherit, A, cInherit, cInherit, _Dir	;1̈ʕ`
		;
		pop		B
		pop		PSW
		pop		ACC
		;
		endm
		;
		;---------------------------------------;LCD 1oCgl(10i2)\}N([fBO[TvXȂ)
DrawByte2d	macro		_OrgX, _OrgY, _Num, _FColor, _BColor, _Dir
		;
		push		ACC
		push		PSW
		push		B
		;
		mov		A, _Num						;A : lf[^(0..255)
		mov		B, #010d					;B : 10
		div		AB						;A / 10
		add		A, #030h					;ASCIIɕϊ
		DrawAscii	_OrgX, _OrgY, A, _FColor, _BColor, _Dir		;10̈ʕ`
		;
		mov		A, B						;A : /10̏]
		add		A, #030h					;ASCIIɕϊ
		DrawAscii	cInherit, cInherit, A, cInherit, cInherit, _Dir	;1̈ʕ`
		;
		pop		B
		pop		PSW
		pop		ACC
		;
		endm
		;
		;---------------------------------------;LCD 1oCgl(10i2)\}N([fBO[TvX)
DrawByte2dZs	macro		_OrgX, _OrgY, _Num, _FColor, _BColor, _Dir
		local		_DrawByte2dZs4, _DrawByte2dZs5
		;
		push		ACC
		push		PSW
		push		B
		;
		mov		A, _Num						;A : lf[^(0..255)
		mov		B, #010d					;B : 10
		div		AB						;A / 10
		jnz		_DrawByte2dZs4					;10̈ <> 0ȂWv
		;
		mov		A, #" "						;10̈ = 0Ȃ" "
		jmp		_DrawByte2dZs5					;`
		;
_DrawByte2dZs4:	add		A, #030h					;ASCIIɕϊ
_DrawByte2dZs5:	DrawAscii	_OrgX, _OrgY, A, _FColor, _BColor, _Dir		;10̈ʕ`
		;
		mov		A, B						;A : /10̏]
		add		A, #030h					;ASCIIɕϊ
		DrawAscii	cInherit, cInherit, A, cInherit, cInherit, _Dir	;1̈ʕ`
		;
		pop		B
		pop		PSW
		pop		ACC
		;
		endm
		;
		;---------------------------------------;LCD Xy[X\}N
DrawSpaces	macro		_OrgX, _OrgY, _Num, _FColor, _BColor, _Dir
		local		_DrawSpaces1
		;
		push		ACC
		;
	if	(_OrgX <> cInherit)
		mov		fLcdOrgX, #_OrgX				;`挴_XWݒ
	endif
	if	(_OrgY <> cInherit)
		mov		fLcdOrgY, #_OrgY				;`挴_YWݒ
	endif
	if	(_FColor <> cInherit)
		mov		fLcdFColor, _FColor				;OiFݒ
	endif
	if	(_BColor <> cInherit)
		mov		fLcdBColor, _BColor				;wiFݒ
	endif
		mov		A, _Num						;A : 
_DrawSpaces1:	DrawAscii	cInherit, cInherit, #" ", cInherit, cInherit, _Dir	;" "`
		djnz		ACC, _DrawSpaces1				;[v
		;
		pop		ACC
		;
		endm
		;
		;---------------------------------------;ԊOʐMR}hs}N
SendIrCommand	macro		_Command, _Param
		;
		mov		fIrTxCom, _Command				;R}hݒ
		mov		fIrTxPrm, _Param				;p[^ݒ
		call		SubIrCommand					;R}hs
		;
		endm
		;
		;===============================================================
		;	Vectors Section
		;
		;---------------------------------------;X^[g
		cseg		at	00000h
VectorReset:	ljmp		Initialize			;Zbg
		cseg		at	00003h
VectorInt0:	ljmp		IsrInt0				;Int0
		cseg		at	0000bh
VectorTmr0Ovfl:	ljmp		VectorReset			;Tmr0I[ot[
		cseg		at	00013h
VectorInt1:	ljmp		VectorReset			;Int1
		cseg		at	0001bh
VectorTmr1Ovfl:	ljmp		VectorReset			;Tmr1I[ot[
		cseg		at	00023h
VectorUart0:	ljmp		IsrUart0			;Uart0
		cseg		at	0002bh
VectorTmr2Ovfl:	ljmp		VectorReset			;Tmr2I[ot[
		cseg		at	00033h
VectorSpi0:	ljmp		VectorReset			;Spi0
		cseg		at	0003bh
VectorSmb0:	ljmp		VectorReset			;Smb0
		cseg		at	00043h
VectorReserve0:	ljmp		VectorReset			;Reserved
		cseg		at	0004bh
VectorAdc0Wind:	ljmp		VectorReset			;Adc0EChEr
		cseg		at	00053h
VectorAdc0End:	ljmp		VectorReset			;Adc0ϊI
		cseg		at	0005bh
VectorPca:	ljmp		VectorReset			;Pca
		cseg		at	00063h
VectorCmp0:	ljmp		VectorReset			;Cmp0
		cseg		at	0006bh
VectorReserve1:	ljmp		VectorReset			;Reserved
		cseg		at	00073h
VectorTmr3Ovfl:	ljmp		IsrTimer3			;Tmr3I[ot[
		;
		;===============================================================
		;	Initializing
		;
		cseg		at	00080h
		;
Initialize:	;---------------------------------------;ԏ
		mov		SP, #Stack - 1					;X^bN|C^
		;
		;							;HFIV[^
;		mov		OSCICL, #0xxh					;HFUgł邾24.576MHzɋ߂Â
		mov		OSCICN, #083h					;HFIV[^Cl[uAȂ
		;
		;							;Wdt
		mov		PCA0MD, #000h					;WDTfBXG[u
		;
		;							;UART0
		mov		SCON0, #01000000b				;8rbg[hAMƂ肠֎~
		;
		;							;SMBus
		mov		SMB0CF, #11000010b				;싖Ȃ@\֎~ANbN\[X : Timer2
		;
		;							;Voltage Reference
		mov		REF0CN, #008h					;VREF=VDD
		;
		;							;Adc0 : obedo
		mov		AMX0P, #000h					;P1.0:bBattery
		mov		AMX0N, #01fh					;VOGh[h
		mov		ADC0CF, #01001100b				;CLKSAR=SYSCLK/10Af[^͍l
		mov		ADC0CN, #01000000b				;[p[gbN[hAADC0~
		;
		;							;Timer0..3 : NbNݒ
		mov		CKCON, #00110100b				;Timer0ATimer2SYSCLKATimer1ATimer3͕NbNgp
		;
		;							;Timer0 :PCANbN\[X 24576000 / 3 = 8192000Hz
		;							;Timer1 :UART0NbN\[X
		mov		TMOD, #00100010b				;Timer0 : Mode2ATimer1 : Mode2
		mov		TH0, #LOW (0 - 003d)				;0 - (24576000 / 8192000)
		mov		TH1, #096h					;Ƃ肠9600baud
		mov		TCON, #01010101b				;Timer0ATimer1싖A/INT0A/INT1̓GbWgK
		;
		;							;Timer2 :SMBusNbN\[X 300kHz
		mov		TMR2RLL, #LOW  (0 - 082d)			;LOW  (0 - (cSysclk / 300000))
		mov		TMR2RLH, #HIGH (0 - 082d)			;HIGH (0 - (cSysclk / 300000))
		mov		TMR2CN, #00000100b				;16bit[h^C}A싖
		;
		;							;Timer3 : [UC^[tF[X̂߂̃C^[o^C}
		mov		TMR3RLL, #LOW  (0 - 20480d)			;LOW  (0 - (cSysclk / 12d / 100d)) : C^[o = 10msec
		mov		TMR3RLH, #HIGH (0 - 20480d)			;HIGH (0 - (cSysclk / 12d / 100d)) : C^[o = 10msec
		mov		TMR3CN, #00000000b				;16bit[h^C}ANbN = SYSCLK / 12A~
		;
		;							;PCA
		mov		PCA0MD, #00000100b				;NbN : ^C}0I[ot[
		mov		PCA0CPH0, #108d					;W[0 : o͎g = 37.926kHz
		mov		PCA0CPM0, #01000110b				;W[0 : go̓[h
		mov		PCA0CPL1, #080h					;W[1 : f[eB = 50
		mov		PCA0CPH1, #080h					;W[1 : f[eB = 50
		mov		PCA0CPM1, #11000010b				;W[1 : 16rbgPWM[h
		mov		PCA0CPM2, #01001000b				;W[2 : \tgEFA^C}[h(WaitAusec, WaitAmsecŎgp)
		setb		CR						;PCA싖
		;
		;							;I/O|[g : 萔錾gĂȂ̂ŕύX̍ۂ͗v
		mov		P0, #11111111b					;Ss"H"
		mov		P0MDIN,  #11111111b				;SsfW^I/O
		mov		P0MDOUT, #00011000b				;pIrTxApEncoderPwr̓vbVvA̓I[vhC()
		mov		P0SKIP,  #11001111b				;UART0ȊÕsXLbv
		mov		P1, #00111101b					;pLcdBlShdnApIrTxModApIrRxPwr̂"L"
		mov		P1MDIN,  #11111110b				;pBatterŷ݃AiO
;		mov		P1MDOUT, #11100010b				;pSmbSclApSmbSdaApReserved1ApBattery̓I[vhC
		mov		P1MDOUT, #11100110b				;pSmbSclApSmbSdaApReserved1ApBattery̓I[vhC *******
		mov		P1SKIP,  #00100111b				;pLcdBlShdnApIrTxModApSmbSclApSmbSdasXLbv
		mov		P2, #11111111b					;Ss"H"
		mov		P2MDIN,  #11111111b				;SsfW^I/O
		mov		P2MDOUT, #00000000b				;SsƂ肠I[vhC()
		mov		P2SKIP,  #11111111b				;SsXLbv
		mov		P3, #11101111b					;pLcdRest̂"L"
		mov		P3MDIN,  #11111111b				;SsfW^I/O
		mov		P3MDOUT, #00011110b				;pC2D̂݃I[vhC()
		mov		XBR0, #00000101b				;SMBusAUARTsɃATC
		mov		XBR1, #01000010b				;CEX0ACEX1sɃATCANXo[Cl[u
		;
		;							;ϐ揉
		mov		R0, #Stack					;R0 : JnAhX
_Init1:		mov		@R0, #0						;@R0 : 0NA
		djnz		R0, _Init1					;R0 : R0 - 1A<> 0 Ȃ烋[v
		;
		;							;Waiting 100msec
;		mov		A, #001d					;A : 100
;		call		WaitA100msec					;Amsec҂
		;
		;							;荞ݐ
		mov		IT01CF, #01110110b				;/INT0̓ANeBu"L"ApEncoder1 = P0.6́A
		;								;/INT1̓ANeBu"L"ApEncoder2 = P0.7
		;
		call		LoadNvParams				;sԕA
;		mov		fLcdBlite, #080h				;LCD obNCg
;		mov		fLcdContr, #037d				;LCD RgXg
		call		UpdateBlite					;obNCgݒXV
		;
		;							;LCD
		call		InitLcd						;LCD
		call		UpdateContr					;RgXgݒXV
		call		DrawStatFrame					;Xe[^XC̃x[Xg`
		call		DrawSwStop					;XCb`C̕` : ~[h
		call		DrawLogo					;S`
		;
		;							;Jn
		clr		IE0						;IE0NA
		setb		EX0						;/INT0荞݋
		;
		setb		ES0						;UART0荞݋
		;
		orl		TMR3CN, #00000100b				;TR3ZbgATimer3Jn
		orl		EIE1, #10000000b				;ET3ZbgATimer3荞݋
		setb		EA						;O[o荞݋
		;
		;===============================================================
		;	Main
		;
Main:		;---------------------------------------;C[v
		;
_Main2:		;							;삪ꍇ̃^[|Cg
		mov		fIdleCtrL, #0
		mov		fIdleCtrH, #0					;~ԃJE^
		mov		fNoOpCtrL, #0
		mov		fNoOpCtrH, #0					;쎞ԃJE^
		;
_Main1:		;---------------------------------------;荞݋ɂăACh[h
		orl		PCON, #00000001b				;IDLEZbg
		;
		;		Zzzzz.....					;̊荞݂܂ŏȓd͏
		;
		;---------------------------------------;荞݂ɂIDLE畜A
		;
_MainBattCheck:	;---------------------------------------;obed`FbN
		call		ReadBattVolts					;obed[h
		mov		A, fBattVoltageR				;A : obedl(BCD2)
		add		A, #0 - 030h					;A < 3.0VȂL[Ȃ
		jc		_MainBattChk0					;3.0VȏȂ玟
		;
		jmp		OnFatalError					;3.0VȂvIG[
		;
_MainBattChk0:	;
		;
_MainIrProc:	;---------------------------------------;ԊOʐM
		jb		fIrMode.bImActive, _MainIrProc0			;ʐMȂ珈XLbv
		;
		jmp		MipComStat					;ʐMłȂȂXe[^X`FbN
		;
_MainIrProc0:	;
		;
_MainDialProc:	;---------------------------------------;GR[_
		;							;GR[_JEgl`FbN
		mov		A, fEncoderCtr					;A : GR[_JEgl
		jnz		_MainDialProc1					;<> 0Ȃ珈s
		;
		jmp		_MainDialProc0					;= 0Ȃ珈sv
		;
_MainDialProc1:	;							;JEgꍇ
		mov		fIdleCtrL, #0
		mov		fIdleCtrH, #0					;~ԃJE^
		mov		fNoOpCtrL, #0
		mov		fNoOpCtrH, #0					;쎞ԃJE^
		;
		;							;GR[_s : [hƂɕ
		mov		A, fRemoteMode					;A : R䃂[h
		add		A, ACC						;A * 2
		mov		DPTR, #_MainDialProcT				;DPTR : Wve[u擪AhX
		jmp		@A + DPTR					;Wv
		;
_MainDialProcT:	ajmp		MdpRmStop					;~[h
		ajmp		MdpRmStopMenu					;~j[샂[h
		ajmp		MdpRmStopSync					;~VN샂[h
		ajmp		MdpRmStopBlite					;~obNCgݒ葀샂[h
		ajmp		MdpRmStopContr					;~RgXgݒ葀샂[h
		ajmp		MdpRmMp3Play					;MP3vC[h
		ajmp		MdpRmMp3Jump					;MP3Wv샂[h
		ajmp		MdpRmMp3Menu					;MP3j[샂[h
		ajmp		MdpRmMp3FfRew					;MP3/߂샂[h
		ajmp		MdpRmMp3Repeat					;MP3s[gݒ葀샂[h
		ajmp		MdpRmMp3Treble					;MP3g[Rg[()샂[h
		ajmp		MdpRmMp3Bass					;MP3g[Rg[()샂[h
		ajmp		MdpRmMp3Blite					;MP3obNCgݒ葀샂[h
		ajmp		MdpRmMp3Contr					;MP3RgXgݒ葀샂[h
		ajmp		MdpRmFmPlay					;FMvC[h
		ajmp		MdpRmFmJump					;FMWv샂[h
		ajmp		MdpRmFmMenu					;FMj[샂[h
		ajmp		MdpRmFmSearch					;FMI[gT[`샂[h
		ajmp		MdpRmFmManual					;FM}jAIǑ샂[h
		ajmp		MdpRmFmTreble					;FMg[Rg[()샂[h
		ajmp		MdpRmFmBass					;FMg[Rg[()샂[h
		ajmp		MdpRmFmBlite					;FMobNCgݒ葀샂[h
		ajmp		MdpRmFmContr					;FMRgXgݒ葀샂[h
		;
_MainDialProc0:	;
		;
_MainSwProc:	;---------------------------------------;XCb`
		;							;XCb`XV`FbN
		jb		fPlayMode.bPmSwUpdate, _MainSwProc4		;PmSwUpdateZbgȂ珈s
		;
		jmp		_MainSwProc01					;NAȂ珈sv
		;
_MainSwProc4:	;							;XCb`s
		;
		;							;XCb`̓`FbN
		mov		A, fSwStatus					;A : XCb`̏
		jnz		_MainSwProc3					;ǂꂩXCb`Ă΃XCb`
		;
		mov		A, fSwStatus1to0				;A : XCb`̏ԕω(ONOFF)
		jnz		_MainSwProc3					;XCb`삪΃XCb`
		;
		;							;SXCb`OFF̏ꍇ@쎞ԍXV
		AddYYA16	fNoOpCtrH, fNoOpCtrL, #0, #1			;fNoOpCtr : fNoOpCtr + 1
		jmp		_MainSwProc0					;XCb`I
		;
_MainSwProc3:	;							;XCb`Cxgꍇ
		mov		fIdleCtrL, #0
		mov		fIdleCtrH, #0					;~ԃJE^
		mov		fNoOpCtrL, #0
		mov		fNoOpCtrH, #0					;쎞ԃJE^
		;
		;							;XCb`s : [hƂɕ
		mov		A, fRemoteMode					;A : R䃂[h
		add		A, ACC						;A * 2
		mov		DPTR, #_MainSwProcT				;DPTR : Wve[u擪AhX
		jmp		@A + DPTR					;Wv
		;
_MainSwProcT:	ajmp		MspRmStop					;~[h
		ajmp		MspRmStopMenu					;~j[샂[h
		ajmp		MspRmStopSync					;~VN샂[h
		ajmp		MspRmStopBlite					;~obNCgݒ葀샂[h
		ajmp		MspRmStopContr					;~RgXgݒ葀샂[h
		ajmp		MspRmMp3Play					;MP3vC[h
		ajmp		MspRmMp3Jump					;MP3Wv샂[h
		ajmp		MspRmMp3Menu					;MP3j[샂[h
		ajmp		MspRmMp3FfRew					;MP3/߂샂[h
		ajmp		MspRmMp3Repeat					;MP3s[gݒ葀샂[h
		ajmp		MspRmMp3Treble					;MP3g[Rg[()샂[h
		ajmp		MspRmMp3Bass					;MP3g[Rg[()샂[h
		ajmp		MspRmMp3Blite					;MP3obNCgݒ葀샂[h
		ajmp		MspRmMp3Contr					;MP3RgXgݒ葀샂[h
		ajmp		MspRmFmPlay					;FMvC[h
		ajmp		MspRmFmJump					;FMWv샂[h
		ajmp		MspRmFmMenu					;FMj[샂[h
		ajmp		MspRmFmSearch					;FMI[gT[`샂[h
		ajmp		MspRmFmManual					;FM}jAIǑ샂[h
		ajmp		MspRmFmTreble					;FMg[Rg[()샂[h
		ajmp		MspRmFmBass					;FMg[Rg[()샂[h
		ajmp		MspRmFmBlite					;FMobNCgݒ葀샂[h
		ajmp		MspRmFmContr					;FMRgXgݒ葀샂[h
		;
_MainSwProc0:	clr		fPlayMode.bPmSwUpdate				;PmSwUpdateNA
		;
_MainSwProc01:	;
		;
		;---------------------------------------;쎞Ԃ̃`FbN
		;							;쎞ԃ`FbN
		SubYAB16	DPH, DPL, fNoOpCtrH, fNoOpCtrL, #HIGH cShutdown, #LOW cShutdown		;DPTR : fNoOpCtr - cShutdown
		jc		_MainNoOpChk0					;fNoOpCtr < cShutdownȂWv
		;
		;							;쎞ԂcShutDownԌp̂ŃVbg_E
		jmp		ShutDown					;Vbg_E
		;
_MainNoOpChk0:	jmp		_Main1					;C[v
		;
MipComStat:	;---------------------------------------;Xe[^X`FbN
		;							;Timer3荞1281̂ݏ
		mov		A, fUITimerCtr					;A : fUITimerCtr
		anl		A, #01111111b					;7rbg𒊏o
		jnz		_sMipComStat0					;A <> 0Ȃ珈XLbv
		;
		;							;Xe[^XNGXgR}hM
		SendIrCommand	#cIRComStatReq, #0				;Xe[^XNGXgR}hs
		jb		fIrMode.bImRxDataReady, _MipComStat5		;MtOZbgȂs
		;
_sMipComStat0:	jmp		_MipComStat0					;_MipComStat0ւ̓ݑ
		;
_MipComStat5:	;							;s
		clr		F0						;ύXtONA
		;
		push		B						;[NWX^
		mov		B, fPlayMode					;B : fPlayModeۑ
		anl		fPlayMode, #bmPlayModeR				;fPlayMode : R̃vC[hrbgo
		;
		mov		DPTR, #cIrRxBuffer + 3				;DPTR : Mobt@̈̐擪AhX + 3
		movx		A, @DPTR					;A : vC[hoCg
		anl		A, #bmPlayModeH					;{̂̃vC[hrbgo
		orl		fPlayMode, A					;fPlayModeXV
		;
		xrl		A, B						;A : fPlayMode xor {̂̃vC[h
		anl		A, #bmPlayModeH					;{̂̃vC[hrbgo
		jz		_MipComStatA1					;ύXȂȂWv
		;
		setb		F0						;ύXtOZbg
_MipComStatA1:	inc		DPTR						;Mobt@f[^|C^XV
		pop		B						;[NWX^J
		;
		movx		A, @DPTR					;A : obed(BCD2)
		xrl		fBattVoltageH, A				;fBattVoltageH : fBattVoltageH xor A
		xch		A, fBattVoltageH				;fBattVoltageHXVAA : fBattVoltageH xor A
		jz		_MipComStatA2					;ύXȂȂWv
		;
		setb		F0						;ύXtOZbg
_MipComStatA2:	inc		DPTR						;Mobt@f[^|C^XV
		;
		movx		A, @DPTR					;A : {[l
		xrl		fVolume, A					;fVolume : fVolume xor A
		xch		A, fVolume					;fVolumeXVAA : fVolume xor A
		jz		_MipComStatA3					;ύXȂȂWv
		;
		setb		F0						;ύXtOZbg
_MipComStatA3:	inc		DPTR						;Mobt@f[^|C^XV
		;
		movx		A, @DPTR					;A : TDA7463AD WX^ݒl(TuAhX0)
		xrl		fTdaReg0, A					;fTdaReg0 : fTdaReg0 xor A
		xch		A, fTdaReg0					;fTdaReg0XVAA : fTdaReg0 xor A
		jz		_MipComStatA4					;ύXȂȂWv
		;
		setb		F0						;ύXtOZbg
_MipComStatA4:	inc		DPTR						;Mobt@f[^|C^XV
		;
		movx		A, @DPTR					;A : TDA7463AD WX^ݒl(TuAhX1)
		xrl		fTdaReg1, A					;fTdaReg1 : fTdaReg1 xor A
		xch		A, fTdaReg1					;fTdaReg1XVAA : fTdaReg1 xor A
		jz		_MipComStatA5					;ύXȂȂWv
		;
		setb		F0						;ύXtOZbg
_MipComStatA5:	inc		DPTR						;Mobt@f[^|C^XV
		;
		movx		A, @DPTR					;A : }WbNioAƂ肠MP3t@C
		xrl		fMp3Files, A					;fMp3Files : fMp3Files xor A
		xch		A, fMp3Files					;fMp3FilesXVAA : fMp3Files xor A
		jz		_MipComStatA6					;ύXȂȂWv
		;
		setb		F0						;ύXtOZbg
_MipComStatA6:	inc		DPTR						;Mobt@f[^|C^XV
		;
		movx		A, @DPTR					;A : Đ̃t@Cԍ
		xrl		fFileNo, A					;fFileNo : fFileNo xor A
		xch		A, fFileNo					;fFileNoXVAA : fFileNo xor A
		jz		_MipComStatA7					;ύXȂȂWv
		;
		setb		F0						;ύXtOZbg
_MipComStatA7:	inc		DPTR						;Mobt@f[^|C^XV
		;
		movx		A, @DPTR					;A : fR[h(H)
		xrl		fDecodeTimeH, A					;fDecodeTimeH : fDecodeTimeH xor A
		xch		A, fDecodeTimeH					;fDecodeTimeHXVAA : fDecodeTimeH xor A
		jz		_MipComStatA11					;ύXȂȂWv
		;
		setb		F0						;ύXtOZbg
_MipComStatA11:	inc		DPTR						;Mobt@f[^|C^XV
		;
		movx		A, @DPTR					;A : fR[h(L)
		xrl		fDecodeTimeL, A					;fDecodeTimeL : fDecodeTimeL xor A
		xch		A, fDecodeTimeL					;fDecodeTimeLXVAA : fDecodeTimeL xor A
		jz		_MipComStatA12					;ύXȂȂWv
		;
		setb		F0						;ύXtOZbg
_MipComStatA12:	inc		DPTR						;Mobt@f[^|C^XV
		;
		movx		A, @DPTR					;A : s[gĐ[hݒoCg
		xrl		fRepeatMode, A					;fRepeatMode : fRepeatMode xor A
		xch		A, fRepeatMode					;fRepeatModeXVAA : fRepeatMode xor A
		jz		_MipComStatA8					;ύXȂȂWv
		;
		setb		F0						;ύXtOZbg
_MipComStatA8:	inc		DPTR						;Mobt@f[^|C^XV
		;
		movx		A, @DPTR					;A : vZbgǔԍ
		xrl		fPreStNo, A					;fPreStNo : fPreStNo xor A
		xch		A, fPreStNo					;fPreStNoXVAA : fPreStNo xor A
		jz		_MipComStatA9					;ύXȂȂWv
		;
		setb		F0						;ύXtOZbg
_MipComStatA9:	inc		DPTR						;Mobt@f[^|C^XV
		;
		movx		A, @DPTR					;A : Iǒ̎ge[uCfbNX
		xrl		fFreqTableIdx, A				;fFreqTableIdx : fFreqTableIdx xor A
		xch		A, fFreqTableIdx				;fFreqTableIdxXVAA : fFreqTableIdx xor A
		jz		_MipComStatA10					;ύXȂȂWv
		;
		setb		F0						;ύXtOZbg
_MipComStatA10:	call		DrawStatus					;LCDXe[^XC̕`
		;
		jnb		F0, _MipComStat0				;ύXtONAȂWv
		;
_MipComStat3:	;							;R샂[hXV
		jb		fPlayMode.bPmPlaying, _MipComStat1		;{̂~łȂ΃Wv
		;
		;							;{̂~̏ꍇ
		mov		A, fRemoteMode					;A : R샂[h
		cjne		A, #cRmStopMax + 1, $ + 3			;A - cRmStopMax + 1
		jc		_MipComStat0					;R~[ĥꂩȂI
		;
		mov		fRemoteMode, #cRmStop				;~[h
		call		DrawLogo					;S`
		call		DrawSwStop					;XCb`C̕` : ~[h
		jmp		_MipComStat0					;I
		;
_MipComStat1:	jb		fPlayMode.bPmFm, _MipComStat2			;FM[hȂWv
		;
		;							;{̂MP3[h̏ꍇ
		mov		A, fRemoteMode					;A : R샂[h
		cjne		A, #cRmMp3Play + 1, $ + 3			;A - cRmMp3Play + 1
		jc		_MipComStat4					;RMP3vC[hC~[ĥꂩȂWv
		;
		cjne		A, #cRmMp3Max + 1, $ + 3			;A - cRmMp3Max + 1
		jc		_MipComStat0					;RMP3[ĥꂩȂI
		;
_MipComStat4:	mov		fRemoteMode, #cRmMp3Play			;MP3vC[h
		SubYAB16	DPH, DPL, fNoOpCtrH, fNoOpCtrL, #HIGH cPlayScrnDelay, #LOW cPlayScrnDelay	;DPTR : fNoOpCtr - cPlayScrnDelay
		jnc		_MipComStat6					;fNoOpCtr >= cPlayScrnDelayȂWv
		;
		call		DrawListMp3					;MP3ȃXg`
		clr		fPlayMode.bPmPlayScreen				;DrawPlayMp3ʕ\σtONA
		jmp		_MipComStat7					;
		;
_MipComStat6:	call		DrawPlayMp3					;MP3vCʕ`
_MipComStat7:	call		DrawSwPlay					;XCb`C̕` : vC[h
		jmp		_MipComStat0					;I
		;
_MipComStat2:	;							;{̂FM[h̏ꍇ
		mov		A, fRemoteMode					;A : R샂[h
		cjne		A, #cRmFmPlay + 1, $ + 3			;A - cRmFmPlay + 1
		jnc		_MipComStat0					;RFM샂[ĥꂩȂI
		;
		mov		fRemoteMode, #cRmFmPlay				;FMvC[h
		call		DrawListFmSt					;FMǃXg`
		call		DrawSwPlay					;XCb`C̕` : vC[h
		;
_MipComStat0:	jmp		_MainIrProc0
		;
		;---------------------------------------;샂[hʃGR[_
		;
MdpRmStop:	;---------------------------------------;GR[_ : ~[h
		call		SubDpVolume					;GR[_ɂ{[ݒ
		;
		jmp		_MainDialProc0
		;
MdpRmStopMenu:	;---------------------------------------;GR[_ : ~j[샂[h
		call		SubDpStopMenu					;GR[_ɂ~j[ACeI
		;
		jmp		_MainDialProc0
		;
MdpRmStopSync:	;---------------------------------------;GR[_ : ~VN샂[h
		mov		fEncoderCtr, #0					;GR[_JEglNA
		;
		jmp		_MainDialProc0
		;
MdpRmStopBlite:	;---------------------------------------;GR[_ : ~obNCgݒ葀샂[h
		mov		fLcdOrgY, #(cRmStopBlite - cRmStopMenu + 3) * cFAsciiSizeY	;Tuj[\ʒu
		call		SubDpBlite					;GR[_ɂobNCgݒ
		;
		jmp		_MainDialProc0
		;
MdpRmStopContr:	;---------------------------------------;GR[_ : ~RgXgݒ葀샂[h
		mov		fLcdOrgY, #(cRmStopContr - cRmStopMenu + 3) * cFAsciiSizeY	;Tuj[\ʒu
		call		SubDpContr					;GR[_ɂRgXgݒ
		;
		jmp		_MainDialProc0
		;
MdpRmMp3Play:	;---------------------------------------;GR[_ : MP3vC[h
		call		SubDpVolume					;GR[_ɂ{[ݒ
		;
		jmp		_MainDialProc0
		;
MdpRmMp3Jump:	;---------------------------------------;GR[_ : MP3Wv샂[h
		call		SubDpMp3Jump					;GR[_ɂMP3ȑI
		;
		jmp		_MainDialProc0
		;
MdpRmMp3Menu:	;---------------------------------------;GR[_ : MP3j[샂[h
		call		SubDpMp3Menu					;GR[_ɂMP3j[ACeI
		;
		jmp		_MainDialProc0
		;
MdpRmMp3FfRew:	;---------------------------------------;GR[_ : MP3/߂샂[h
		mov		fLcdOrgY, #(cRmMp3FfRew - cRmMp3Menu + 3) * cFAsciiSizeY	;Tuj[\ʒu
		call		SubDpMp3FfRew					;GR[_ɂ鑁/߂
		;
		jmp		_MainDialProc0
		;
MdpRmMp3Repeat:	;---------------------------------------;GR[_ : MP3s[gݒ葀샂[h
		mov		fLcdOrgY, #(cRmMp3Repeat - cRmMp3Menu + 3) * cFAsciiSizeY	;Tuj[\ʒu
		call		SubDpMp3Repeat					;GR[_ɂ郊s[gݒ
		;
		jmp		_MainDialProc0
		;
MdpRmMp3Treble:	;---------------------------------------;GR[_ : MP3g[Rg[()샂[h
		mov		fLcdOrgY, #(cRmMp3Treble - cRmMp3Menu + 3) * cFAsciiSizeY	;Tuj[\ʒu
		call		SubDpTreble					;GR[_ɂg[Rg[()ݒ
		;
		jmp		_MainDialProc0
		;
MdpRmMp3Bass:	;---------------------------------------;GR[_ : MP3g[Rg[()샂[h
		mov		fLcdOrgY, #(cRmMp3Bass - cRmMp3Menu + 3) * cFAsciiSizeY		;Tuj[\ʒu
		call		SubDpBass					;GR[_ɂg[Rg[()ݒ
		;
		jmp		_MainDialProc0
		;
MdpRmMp3Blite:	;---------------------------------------;GR[_ : MP3obNCgݒ葀샂[h
		mov		fLcdOrgY, #(cRmMp3Blite - cRmMp3Menu + 3) * cFAsciiSizeY	;Tuj[\ʒu
		call		SubDpBlite					;GR[_ɂobNCgݒ
		;
		jmp		_MainDialProc0
		;
MdpRmMp3Contr:	;---------------------------------------;GR[_ : MP3RgXgݒ葀샂[h
		mov		fLcdOrgY, #(cRmMp3Contr - cRmMp3Menu + 3) * cFAsciiSizeY	;Tuj[\ʒu
		call		SubDpContr					;GR[_ɂRgXgݒ
		;
		jmp		_MainDialProc0
		;
MdpRmFmPlay:	;---------------------------------------;GR[_ : FMvC[h
		call		SubDpVolume					;GR[_ɂ{[ݒ
		;
		jmp		_MainDialProc0
		;
MdpRmFmJump:	;---------------------------------------;GR[_ : FMWv샂[h
		call		SubDpFmJump					;GR[_ɂFMǑI
		;
		jmp		_MainDialProc0
		;
MdpRmFmMenu:	;---------------------------------------;GR[_ : FMj[샂[h
		call		SubDpFmMenu					;GR[_ɂFMj[ACeI
		;
		jmp		_MainDialProc0
		;
MdpRmFmSearch:	;---------------------------------------;GR[_ : FMI[gT[`샂[h
		jmp		_MainDialProc0
		;
MdpRmFmManual:	;---------------------------------------;GR[_ : FM}jAIǑ샂[h
		mov		fLcdOrgY, #(cRmFmManual - cRmFmMenu + 3) * cFAsciiSizeY	;Tuj[\ʒu
		call		SubDpFmManual					;GR[_ɂFM}jAI
		;
		jmp		_MainDialProc0
		;
MdpRmFmTreble:	;---------------------------------------;GR[_ : FMg[Rg[()샂[h
		mov		fLcdOrgY, #(cRmFmTreble - cRmFmMenu + 3) * cFAsciiSizeY	;Tuj[\ʒu
		call		SubDpTreble					;GR[_ɂg[Rg[()ݒ
		;
		jmp		_MainDialProc0
		;
MdpRmFmBass:	;---------------------------------------;GR[_ : FMg[Rg[()샂[h
		mov		fLcdOrgY, #(cRmFmBass - cRmFmMenu + 3) * cFAsciiSizeY	;Tuj[\ʒu
		call		SubDpBass					;GR[_ɂg[Rg[()ݒ
		;
		jmp		_MainDialProc0
		;
MdpRmFmBlite:	;---------------------------------------;GR[_ : FMobNCgݒ葀샂[h
		mov		fLcdOrgY, #(cRmFmBlite - cRmFmMenu + 3) * cFAsciiSizeY	;Tuj[\ʒu
		call		SubDpBlite					;GR[_ɂobNCgݒ
		;
		jmp		_MainDialProc0
		;
MdpRmFmContr:	;---------------------------------------;GR[_ : FMRgXgݒ葀샂[h
		mov		fLcdOrgY, #(cRmFmContr - cRmFmMenu + 3) * cFAsciiSizeY	;Tuj[\ʒu
		call		SubDpContr					;GR[_ɂRgXgݒ
		;
		jmp		_MainDialProc0
		;
		;---------------------------------------;샂[hʃXCb`
		;
MspRmStop:	;---------------------------------------;XCb` : ~[h
		jb		fSwStatus0to1.bSwA, SubSpStopA			;SwAOFFON
		jb		fSwStatus0to1.bSwB, SubSpStopB			;SwBOFFON
		jb		fSwStatus0to1.bSwC, SubSpStopC			;SwCOFFON
		;
		jmp		_MainSwProc0
		;
SubSpStopA:	;							;~j[샂[h
		DrawFill	0000d, 0020d, 0108d, 0140d, cBCMenuNrm		;̈NA
		mov		fRemoteMode, #cRmStopMenu			;fRemoteMode : ~j[샂[h
		mov		fMenuRmSel, #cRmStopMenu + 1			;~j[샂[h̎̃[hnCCg
		call		DrawMenuRmStop					;~[h̑Sj[ACe`
		call		DrawSwOkCancel					;XCb`C̕` : "OK - Cancel"
		;
		jmp		_MainSwProc0
		;
SubSpStopB:	;							;MP3vC[h
		SendIrCommand	#cIRComMp3Play, #0				;MP3vCR}hs
		jnb		fIrMode.bImRxDataReady, _SSStopB0		;MtONAȂI
		;
		;								;s
		mov		fRemoteMode, #cRmMp3Play			;fRemoteMode : MP3vC[h
		mov		DPTR, #cIrRxBuffer + 3				;DPTR : Mobt@̈̐擪AhX + 3
		movx		A, @DPTR					;A : vC[hoCg
		mov		fPlayMode, A					;fPlayModeXV
		call		DrawStatus					;LCDXe[^XC̕`
		call		DrawListMp3					;MP3ȃXg`
		call		DrawSwPlay					;XCb`C̕` : vC[h
		;
_SSStopB0:	jmp		_MainSwProc0
		;
SubSpStopC:	;							;FMvC[h
		SendIrCommand	#cIRComFmPlay, #0				;FMvCR}hs
		jnb		fIrMode.bImRxDataReady, _SSStopC0		;MtONAȂI
		;
		;								;s
		mov		fRemoteMode, #cRmFmPlay				;fRemoteMode : FMvC[h
		mov		DPTR, #cIrRxBuffer + 3				;DPTR : Mobt@̈̐擪AhX + 3
		movx		A, @DPTR					;A : vC[hoCg
		mov		fPlayMode, A					;fPlayModeXV
		call		DrawStatus					;LCDXe[^XC̕`
		call		DrawListFmSt					;FMǃXg`
		call		DrawSwPlay					;XCb`C̕` : vC[h
		;
_SSStopC0:	jmp		_MainSwProc0
		;
MspRmStopMenu:	;---------------------------------------;XCb` : ~j[샂[h
		jb		fSwStatus0to1.bSwA, SubSpStopMenuA		;SwAOFFON
		jb		fSwStatus0to1.bSwC, SubSpStopMenuC		;SwCOFFON
		;
		jmp		_MainSwProc0
		;
SubSpStopMenuA:	;							;Tuj[
		mov		fMp3FileCtr, #0					;VNR}h̃Tuj[\ɔăt@CJE^NAĂ
		mov		fRemoteMode, fMenuRmSel				;fRemoteMode : nCCgĂ鑀샂[h
		call		DrawMenuRmStop					;~[h̑Sj[ACe`
		call		DrawSwOk					;XCb`C̕` : "OK - -"
		;
		jmp		_MainSwProc0
		;
SubSpStopMenuC:	;							;~[h
		mov		fRemoteMode, #cRmStop				;fRemoteMode : ~[h
		call		DrawLogo					;S`
		call		DrawSwStop					;XCb`C̕` : ~[h
		;
		jmp		_MainSwProc0
		;
MspRmStopSync:	;---------------------------------------;XCb` : ~VN샂[h
		jb		fSwStatus0to1.bSwA, SubSpSSyncA			;SwAOFFON
		;
		jmp		_MainSwProc0
		;
SubSpSSyncA:	;							;VNs
		DrawFill	0108d, 0020d, 0012d, 0140d, cB3			;XCb`̈NA
		mov		fLcdOrgY, #(cRmStopSync - cRmStopMenu + 3) * cFAsciiSizeY	;Tuj[\ʒu
		call		SubSpSync					;VNs
		jmp		SubSpStopMenu				;~j[
		;
MspRmStopBlite:	;---------------------------------------;XCb` : ~obNCgݒ葀샂[h
		jb		fSwStatus0to1.bSwA, SubSpSBliteA		;SwAOFFON
		;
		jmp		_MainSwProc0
		;
SubSpSBliteA:	;							;obNCgݒXV
		call		SaveNvParams					;s֏ԕۑ
		;
SubSpStopMenu:	;							;~j[
		mov		fRemoteMode, #cRmStopMenu			;fRemoteMode : ~j[샂[h
		DrawFill	0000d, 0020d, 0108d, 0140d, cBCMenuNrm		;̈NA
		call		DrawMenuRmStop					;~[h̑Sj[ACe`
		call		DrawSwOkCancel					;XCb`C̕` : "OK - Cancel"
		;
		jmp		_MainSwProc0
		;
MspRmStopContr:	;---------------------------------------;XCb` : ~RgXgݒ葀샂[h
		jb		fSwStatus0to1.bSwA, SubSpSContrA		;SwAOFFON
		;
		jmp		_MainSwProc0
		;
SubSpSContrA:	;							;RgXgݒXV
		call		SaveNvParams					;s֏ԕۑ
		;
		jmp		SubSpStopMenu				;~j[
		;
MspRmMp3Play:	;---------------------------------------;XCb` : MP3vC[h
		jb		fSwStatus0to1.bSwA, SubSpMp3PlayA		;SwAOFFON
		jb		fSwStatus0to1.bSwB, SubSpMp3PlayB		;SwBOFFON
		jb		fSwStatus0to1.bSwC, SubSpMp3PlayC		;SwCOFFON
		;
		jmp		_MainSwProc0
		;
SubSpMp3PlayA:	;							;MP3j[샂[h
		mov		fRemoteMode, #cRmMp3Menu			;fRemoteMode : MP3j[샂[h
		DrawFill	0000d, 0020d, 0108d, 0140d, cBCMenuNrm		;̈NA
		mov		fMenuRmSel, #cRmMp3Menu + 1			;MP3j[샂[h̎̃[hnCCg
		call		DrawMenuRmMp3					;MP3[h̑Sj[ACe`
		call		DrawSwOkCancel					;XCb`C̕` : "OK - Cancel"
		;
		jmp		_MainSwProc0
		;
SubSpMp3PlayB:	;							;MP3Wv[h
		mov		fRemoteMode, #cRmMp3Jump			;fRemoteMode : MP3Wv샂[h
		mov		fFocusFileNo, fFileNo				;nCCg郊XgACe̋Ȕԍ݂̋Ȕԍŏ
		call		DrawListMp3					;MP3ȃXg`
		call		DrawSwOkCancel					;XCb`C̕` : "OK - Cancel"
		;
		jmp		_MainSwProc0
		;
SubSpMp3PlayC:	;							;~[h
		SendIrCommand	#cIRComMp3Stop, #0				;MP3XgbvR}hs
		jnb		fIrMode.bImRxDataReady, _SSMp3PlayC0		;MtONAȂI
		;
		;							;s
		mov		fRemoteMode, #cRmStop				;fRemoteMode : ~[h
		mov		DPTR, #cIrRxBuffer + 3				;DPTR : Mobt@̈̐擪AhX + 3
		movx		A, @DPTR					;A : vC[hoCg
		mov		fPlayMode, A					;fPlayModeXV
		call		DrawStatus					;LCDXe[^XC̕`
		call		DrawLogo					;S`
		call		DrawSwStop					;XCb`C̕` : ~[h
		;
_SSMp3PlayC0:	jmp		_MainSwProc0
		;
MspRmMp3Jump:	;---------------------------------------;XCb` : MP3Wv샂[h
		jb		fSwStatus0to1.bSwA, SubSpMp3JumpA		;SwAOFFON
		jb		fSwStatus0to1.bSwC, SubSpMp3JumpC		;SwCOFFON
		;
		jmp		_MainSwProc0
		;
SubSpMp3JumpA:	;							;MP3WvR}hs
		SendIrCommand	#cIRComMp3Jump, fFocusFileNo			;MP3WvR}hs
		jnb		fIrMode.bImRxDataReady, _SSMp3JumpA0		;MtONAȂI
		;
		;							;s
		mov		DPTR, #cIrRxBuffer + 3				;DPTR : Mobt@̈̐擪AhX + 3
		movx		A, @DPTR					;A : t@Cԍ
		mov		fFileNo, A					;fFileNoXV
		call		DrawStatus					;LCDXe[^XC̕`
		call		DrawListMp3					;MP3ȃXg`
		;
_SSMp3JumpA0:	jmp		_MainSwProc0
		;
SubSpMp3JumpC:	;							;MP3vC[h
		jmp		SubSpMp3Play					;MP3vC[h
		;
MspRmMp3Menu:	;---------------------------------------;XCb` : MP3j[샂[h
		jb		fSwStatus0to1.bSwA, SubSpMp3MenuA		;SwAOFFON
		jb		fSwStatus0to1.bSwC, SubSpMp3MenuC		;SwCOFFON
		;
		jmp		_MainSwProc0
		;
SubSpMp3MenuA:	;							;Tuj[
		mov		fRemoteMode, fMenuRmSel				;fRemoteMode : nCCgĂ鑀샂[h
		call		DrawMenuRmMp3					;MP3[h̑Sj[ACe`
		call		DrawSwOk					;XCb`C̕` : "OK - -"
		;
		jmp		_MainSwProc0
		;
SubSpMp3Play:	;
SubSpMp3MenuC:	;							;MP3vC[h
		mov		fRemoteMode, #cRmMp3Play			;fRemoteMode : MP3vC[h
		call		DrawListMp3					;MP3ȃXg`
		call		DrawSwPlay					;XCb`C̕` : vC[h
		;
		jmp		_MainSwProc0
		;
MspRmMp3FfRew:	;---------------------------------------;XCb` : MP3/߂샂[h
		jb		fSwStatus0to1.bSwA, SubSpMp3FfRewA		;SwAOFFON
		;
		jmp		_MainSwProc0
		;
SubSpMp3Menu:	;
SubSpMp3FfRewA:	;							;MP3j[
		mov		fRemoteMode, #cRmMp3Menu			;fRemoteMode : MP3j[샂[h
		DrawFill	0000d, 0020d, 0108d, 0140d, cBCMenuNrm		;̈NA
		call		DrawMenuRmMp3					;MP3[h̑Sj[ACe`
		call		DrawSwOkCancel					;XCb`C̕` : "OK - Cancel"
		;
		jmp		_MainSwProc0
		;
MspRmMp3Repeat:	;---------------------------------------;XCb` : MP3s[gݒ葀샂[h
		jb		fSwStatus0to1.bSwA, SubSpMp3RptA		;SwAOFFON
		;
		jmp		_MainSwProc0
		;
SubSpMp3RptA:	jmp		SubSpMp3Menu				;MP3j[
		;
MspRmMp3Treble:	;---------------------------------------;XCb` : MP3g[Rg[()샂[h
		jb		fSwStatus0to1.bSwA, SubSpMp3TrblA		;SwAOFFON
		;
		jmp		_MainSwProc0
		;
SubSpMp3TrblA:	jmp		SubSpMp3Menu				;MP3j[
		;
MspRmMp3Bass:	;---------------------------------------;XCb` : MP3g[Rg[()샂[h
		jb		fSwStatus0to1.bSwA, SubSpMp3BassA		;SwAOFFON
		;
		jmp		_MainSwProc0
		;
SubSpMp3BassA:	jmp		SubSpMp3Menu				;MP3j[
		;
MspRmMp3Blite:	;---------------------------------------;XCb` : MP3obNCgݒ葀샂[h
		jb		fSwStatus0to1.bSwA, SubSpMp3BliteA		;SwAOFFON
		;
		jmp		_MainSwProc0
		;
SubSpMp3BliteA:	;							;obNCgݒXV
		call		SaveNvParams					;s֏ԕۑ
		;
		jmp		SubSpMp3Menu				;MP3j[
		;
MspRmMp3Contr:	;---------------------------------------;XCb` : MP3RgXgݒ葀샂[h
		jb		fSwStatus0to1.bSwA, SubSpMContrA		;SwAOFFON
		;
		jmp		_MainSwProc0
		;
SubSpMContrA:	;							;RgXgݒXV
		call		SaveNvParams					;s֏ԕۑ
		;
		jmp		SubSpMp3Menu				;MP3j[
		;
MspRmFmPlay:	;---------------------------------------;XCb` : FMvC[h
		jb		fSwStatus0to1.bSwA, SubSpFmPlayA		;SwAOFFON
		jb		fSwStatus0to1.bSwB, SubSpFmPlayB		;SwBOFFON
		jb		fSwStatus0to1.bSwC, SubSpFmPlayC		;SwCOFFON
		;
		jmp		_MainSwProc0
		;
SubSpFmPlayA:	;							;FMj[샂[h
		mov		fRemoteMode, #cRmFmMenu				;fRemoteMode : FMj[샂[h
		DrawFill	0000d, 0020d, 0108d, 0140d, cBCMenuNrm		;̈NA
		mov		fMenuRmSel, #cRmFmMenu + 1			;FMj[샂[h̎̃[hnCCg
		call		DrawMenuRmFm					;FM[h̑Sj[ACe`
		call		DrawSwOkCancel					;XCb`C̕` : "OK - Cancel"
		;
		jmp		_MainSwProc0
		;
SubSpFmPlayB:	;							;FMWv[h
		mov		fRemoteMode, #cRmFmJump				;fRemoteMode : FMWv샂[h
		call		DrawListFmSt					;FMǃXg`
		call		DrawSwOk					;XCb`C̕` : "OK - -"
		;
		jmp		_MainSwProc0
		;
SubSpFmPlayC:	;							;~[h
		SendIrCommand	#cIRComFmStop, #0				;FMXgbvR}hs
		jnb		fIrMode.bImRxDataReady, _SSFmPlayC0		;MtONAȂI
		;
		;							;s
		mov		fRemoteMode, #cRmStop				;fRemoteMode : ~[h
		mov		DPTR, #cIrRxBuffer + 3				;DPTR : Mobt@̈̐擪AhX + 3
		movx		A, @DPTR					;A : vC[hoCg
		mov		fPlayMode, A					;fPlayModeXV
		call		DrawStatus					;LCDXe[^XC̕`
		call		DrawLogo					;S`
		call		DrawSwStop					;XCb`C̕` : ~[h
		;
_SSFmPlayC0:	jmp		_MainSwProc0
		;
MspRmFmJump:	;---------------------------------------;XCb` : FMWv샂[h
		jb		fSwStatus0to1.bSwA, SubSpFmJumpA		;SwAOFFON
		;
		jmp		_MainSwProc0
		;
SubSpFmJumpA:	;							;FMvC[h
		jmp		SubSpFmPlay					;FMvC[h
		;
MspRmFmMenu:	;---------------------------------------;XCb` : FMj[샂[h
		jb		fSwStatus0to1.bSwA, SubSpFmMenuA		;SwAOFFON
		jb		fSwStatus0to1.bSwC, SubSpFmMenuC		;SwCOFFON
		;
		jmp		_MainSwProc0
		;
SubSpFmMenuA:	;							;Tuj[
		mov		fRemoteMode, fMenuRmSel				;fRemoteMode : nCCgĂ鑀샂[h
		call		DrawMenuRmFm					;FM[h̑Sj[ACe`
		call		DrawSwOk					;XCb`C̕` : "OK - -"
		;
		jmp		_MainSwProc0
		;
SubSpFmPlay:	;
SubSpFmMenuC:	;							;FMvC[h
		mov		fRemoteMode, #cRmFmPlay				;fRemoteMode : FMvC[h
		call		DrawListFmSt					;FMǃXg`
		call		DrawSwPlay					;XCb`C̕` : vC[h
		;
		jmp		_MainSwProc0
		;
MspRmFmSearch:	;---------------------------------------;XCb` : FMI[gT[`샂[h
		jb		fSwStatus0to1.bSwA, SubSpFmSearchA		;SwAOFFON
		;
		jmp		_MainSwProc0
		;
SubSpFmMenu:	;
SubSpFmSearchA:	;							;FMj[
		mov		fRemoteMode, #cRmFmMenu				;fRemoteMode : FMj[샂[h
		DrawFill	0000d, 0020d, 0108d, 0140d, cBCMenuNrm		;̈NA
		call		DrawMenuRmFm					;FM[h̑Sj[ACe`
		call		DrawSwOkCancel					;XCb`C̕` : "OK - Cancel"
		;
		jmp		_MainSwProc0
		;
MspRmFmManual:	;---------------------------------------;XCb` : FM}jAIǑ샂[h
		jb		fSwStatus0to1.bSwA, SubSpFmManualA		;SwAOFFON
		;
		jmp		_MainSwProc0
		;
SubSpFmManualA:	jmp		SubSpFmMenu				;FMj[
		;
MspRmFmTreble:	;---------------------------------------;XCb` : FMg[Rg[()샂[h
		jb		fSwStatus0to1.bSwA, SubSpFmTrblA		;SwAOFFON
		;
		jmp		_MainSwProc0
		;
SubSpFmTrblA:	jmp		SubSpFmMenu				;FMj[
		;
MspRmFmBass:	;---------------------------------------;XCb` : FMg[Rg[()샂[h
		jb		fSwStatus0to1.bSwA, SubSpFmBassA		;SwAOFFON
		;
		jmp		_MainSwProc0
		;
SubSpFmBassA:	jmp		SubSpFmMenu				;FMj[
		;
MspRmFmBlite:	;---------------------------------------;XCb` : FMobNCgݒ葀샂[h
		jb		fSwStatus0to1.bSwA, SubSpFmBliteA		;SwAOFFON
		;
		jmp		_MainSwProc0
		;
SubSpFmBliteA:	;							;obNCgݒXV
		call		SaveNvParams					;s֏ԕۑ
		;
		jmp		SubSpFmMenu				;FMj[
		;
MspRmFmContr:	;---------------------------------------;XCb` : FMRgXgݒ葀샂[h
		jb		fSwStatus0to1.bSwA, SubSpFmContrA		;SwAOFFON
		;
		jmp		_MainSwProc0
		;
SubSpFmContrA:	;							;RgXgݒXV
		call		SaveNvParams					;s֏ԕۑ
		;
		jmp		SubSpFmMenu				;FMj[
		;
		;===============================================================
		;	Subroutines
		;
WaitAusec:	;---------------------------------------;Acc(usec)҂ (A > 0)
		;					;@PCA Module2gp
		push		ACC
		push		B
		;
		mov		B, #08d						;B : 24576000 / 3 / 1000000
		mul		AB						;BA : A * 8
		AddYAB16	PCA0CPH2, PCA0CPL2, B, ACC, PCA0H, PCA0L	;PCA0CP[HL]2 : PCA0[HL] + (A * 8)
		clr		CCF2						;CCF2NA
		jnb		CCF2, $						;CCF2Zbg܂Ń[v
		;
		pop		B
		pop		ACC
		ret
		;
WaitAmsec:	;---------------------------------------;Acc(msec)҂ (A > 0)
		;					;@PCA Module2gp
		push		ACC
		;
_WaitAmsec1:	;							;1msec҂
		push		ACC
		;
		AddYAB16	PCA0CPH2, PCA0CPL2, #HIGH 08192d, #LOW 08192d, PCA0H, PCA0L	;PCA0CP[HL]2 : PCA0[HL] + (24576000 / 3 / 1000)
		clr		CCF2						;CCF2NA
		jnb		CCF2, $						;CCF2Zbg܂Ń[v
		;
		pop		ACC
		djnz		ACC, _WaitAmsec1				;A : A - 1A<> 0Ȃ烋[v
		;
		pop		ACC
		ret
		;
WaitA100msec:	;---------------------------------------;Acc(100msec)҂(ᐸx)
		;					;@WaitAmsecgp
		push		ACC
		push		B
		;
		mov		B, ACC						;B : [vJE^
		mov		A, #0100d					;A : 100(msec)
		;
_WaitA100msec1:	call		WaitAmsec					;Amsec҂
		djnz		B, _WaitA100msec1				;B : B - 1A<> 0Ȃ烋[v
		;
		pop		B
		pop		ACC
		ret
		;
ReadBattVolts:	;---------------------------------------;obedǂݍ
		;					;  Adc0ϊlobedɕϊ
		;					;  fBattVoltageR : obed(BCD2Aa.b[V]:ʃju=aAʃju=b)
		push		ACC
		push		B
		;
		;							;A/Dϊ
		setb		AD0EN						;ADC0Cl[u
		clr		AD0INT						;AD0INTNA
		setb		AD0BUSY						;ϊJn
		jnb		AD0INT, $					;ϊI҂
		;
		;							;f[^ϊ
		mov		A, ADC0H					;A : ϊl̏ʃoCg
		clr		AD0EN						;ADC0fBXG[u
		;
		mov		B, #057d					;B : tXP[ɑΉdl = 2.85V * 2 * 10
		mul		AB						;B : 2.85 * 2 * 10 * 255 / 256(oCi)
		mov		A, B						;AɃRs[
		mov		B, #010d					;B : 10
		div		AB						;A : A / 10AB : ]
		swap		A						;\̈ʂʃju
		add		A, B						;A : ʃju : Aʃju : 
		mov		fBattVoltageR, A				;fBattVoltageRXV
		;
		pop		B						;WX^oNA
		pop		ACC
		ret
		;
SubDpMp3Jump:	;---------------------------------------;GR[_ɂMP3ȑI
		push		ACC
		;
		mov		A, fEncoderCtr					;A : GR[_JEgl
		jz		_SubDpMJump0					;= 0ȂI
		;
		jb		ACC.7, _SubDpMJump1				;ȂWv
		;
		;							;̃XgACe
		mov		A, fFocusFileNo					;A : ݃nCCgĂ郊XgACe̋Ȕԍ(1..fMp3Files)
		clr		C						;CNA
		subb		A, fEncoderCtr					;A : ݃nCCgĂ郊XgACe̋Ȕԍ - GR[_JEgl
		mov		fFocusFileNo, A					;fFocusFileNoXV
		jz		_SubDpMJump4					;݃nCCgĂ郊XgACe̋Ȕԍ = GR[_JEglȂ烍[I[o
		;
		jc		_SubDpMJump4					;݃nCCgĂ郊XgACe̋Ȕԍ < GR[_JEglȂ烍[I[o
		;
		jmp		_SubDpMJump2					;XV
		;
_SubDpMJump4:	mov		fFocusFileNo, fMp3Files				;ŉʂ̃XgACe
		jmp		_SubDpMJump2					;XV
		;
_SubDpMJump1:	;							;̃XgACe
		cpl		A						;
		inc		A						;GR[_JEgl𐳐ɂ
		add		A, fFocusFileNo					;A : ݃nCCgĂ郊XgACe̋Ȕԍ + GR[_JEgl
		mov		fFocusFileNo, A					;fFocusFileNoXV
		mov		A, fMp3Files					;A : SȐ
		cjne		A, fFocusFileNo, $ + 3				;SȐ - ݃nCCgĂ郊XgACe̋Ȕԍ
		jnc		_SubDpMJump2					;SȐ >= ݃nCCgĂ郊XgACe̋ȔԍȂXV
		;
		mov		fFocusFileNo, #1				;ŏʂ̃XgACe
_SubDpMJump2:	mov		fEncoderCtr, #0					;GR[_JEgl
		call		DrawListMp3					;MP3ȃXg`
		;
_SubDpMJump0:	pop		ACC
		ret
		;
SubDpFmJump:	;---------------------------------------;GR[_ɂFMǑI
		push		ACC
		;
		mov		A, fEncoderCtr					;A : GR[_JEgl
		jz		_SubDpFJump0					;= 0ȂI
		;
		jb		ACC.7, _SubDpFJump1				;ȂWv
		;
		;							;ЂƂ̃XgACe
		dec		fEncoderCtr					;GR[_JEgl - 1
		mov		A, fPreStNo					;A : vZbgǔԍ
		dec		A						;A : XgACe - 1
		cjne		A, #0ffh, _SubDpFJump2				;[I[oȂ΍XV
		;
		mov		A, #cPreStTables - 1				;ŉʂ̃XgACe
		jmp		_SubDpFJump2					;XV
		;
_SubDpFJump1:	;							;ЂƂ̃XgACe
		inc		fEncoderCtr					;GR[_JEgl + 1
		mov		A, fPreStNo					;A : vZbgǔԍ
		inc		A						;A : XgACe + 1
		cjne		A, #cPreStTables, _SubDpFJump2			;[I[oȂ΍XV
		;
		mov		A, #0						;ŏʂ̃XgACe
_SubDpFJump2:	SendIrCommand	#cIRComFmJump, ACC				;FMvZbgǑIR}hs
		jnb		fIrMode.bImRxDataReady, _SubDpFJump0		;MtONAȂI
		;
		;							;s
		mov		DPTR, #cIrRxBuffer + 3				;DPTR : Mobt@̈̐擪AhX + 3
		movx		A, @DPTR					;A : vZbgǔԍ
		mov		fPreStNo, A					;fPreStNoXV
		call		DrawStatus					;LCDXe[^XC̕`
		call		DrawListFmSt					;FMǃXg`
		;
_SubDpFJump0:	pop		ACC
		ret
		;
SubDpStopMenu:	;---------------------------------------;GR[_ɂ~j[ACeI
		push		ACC
		;
		mov		A, fEncoderCtr					;A : GR[_JEgl
		jz		_SubDpSMenu0					;= 0ȂI
		;
		jb		ACC.7, _SubDpSMenu1				;ȂWv
		;
		;							;ЂƂ̃j[ACe
		dec		fEncoderCtr					;GR[_JEgl - 1
		mov		A, fMenuRmSel					;A : ݃nCCgĂ郁j[ACẽ[g샂[h
		dec		A						;A : j[ACẽ[g샂[h - 1
		cjne		A, #cRmStopMenu, _SubDpSMenu2			;[I[oȂ΃Wv
		;
		mov		A, #cRmStopMax					;ŉʂ̃j[ACe
		jmp		_SubDpSMenu2					;XV
		;
_SubDpSMenu1:	;							;ЂƂ̃j[ACe
		inc		fEncoderCtr					;GR[_JEgl + 1
		mov		A, fMenuRmSel					;A : ݃nCCgĂ郁j[ACẽ[g샂[h
		inc		A						;A : j[ACẽ[g샂[h + 1
		cjne		A, #cRmStopMax + 1, _SubDpSMenu2		;[I[oȂ΃Wv
		;
		mov		A, #cRmStopMenu + 1				;ŏʂ̃j[ACe
_SubDpSMenu2:	mov		fMenuRmSel, A					;nCCg郁j[ACẽ[g샂[hXV
		call		DrawMenuRmStop					;~[h̑Sj[ACe`
		;
_SubDpSMenu0:	pop		ACC
		ret
		;
SubDpMp3Menu:	;---------------------------------------;GR[_ɂMP3j[ACeI
		push		ACC
		;
		mov		A, fEncoderCtr					;A : GR[_JEgl
		jz		_SubDpMMenu0					;= 0ȂI
		;
		jb		ACC.7, _SubDpMMenu1				;ȂWv
		;
		;							;ЂƂ̃j[ACe
		dec		fEncoderCtr					;GR[_JEgl - 1
		mov		A, fMenuRmSel					;A : ݃nCCgĂ郁j[ACẽ[g샂[h
		dec		A						;A : j[ACẽ[g샂[h - 1
		cjne		A, #cRmMp3Menu, _SubDpMMenu2			;[I[oȂ΃Wv
		;
		mov		A, #cRmMp3Max					;ŉʂ̃j[ACe
		jmp		_SubDpMMenu2					;XV
		;
_SubDpMMenu1:	;							;ЂƂ̃j[ACe
		inc		fEncoderCtr					;GR[_JEgl + 1
		mov		A, fMenuRmSel					;A : ݃nCCgĂ郁j[ACẽ[g샂[h
		inc		A						;A : j[ACẽ[g샂[h + 1
		cjne		A, #cRmMp3Max + 1, _SubDpMMenu2			;[I[oȂ΃Wv
		;
		mov		A, #cRmMp3Menu + 1				;ŏʂ̃j[ACe
_SubDpMMenu2:	mov		fMenuRmSel, A					;nCCg郁j[ACẽ[g샂[hXV
		call		DrawMenuRmMp3					;MP3[h̑Sj[ACe`
		;
_SubDpMMenu0:	pop		ACC
		ret
		;
SubDpFmMenu:	;---------------------------------------;GR[_ɂFMj[ACeI
		push		ACC
		;
		mov		A, fEncoderCtr					;A : GR[_JEgl
		jz		_SubDpFMenu0					;= 0ȂI
		;
		jb		ACC.7, _SubDpFMenu1				;ȂWv
		;
		;							;ЂƂ̃j[ACe
		dec		fEncoderCtr					;GR[_JEgl - 1
		mov		A, fMenuRmSel					;A : ݃nCCgĂ郁j[ACẽ[g샂[h
		dec		A						;A : j[ACẽ[g샂[h - 1
		cjne		A, #cRmFmMenu, _SubDpFMenu2			;[I[oȂ΃Wv
		;
		mov		A, #cRmFmMax					;ŉʂ̃j[ACe
		jmp		_SubDpFMenu2					;XV
		;
_SubDpFMenu1:	;							;ЂƂ̃j[ACe
		inc		fEncoderCtr					;GR[_JEgl + 1
		mov		A, fMenuRmSel					;A : ݃nCCgĂ郁j[ACẽ[g샂[h
		inc		A						;A : j[ACẽ[g샂[h + 1
		cjne		A, #cRmFmMax + 1, _SubDpFMenu2			;[I[oȂ΃Wv
		;
		mov		A, #cRmFmMenu + 1				;ŏʂ̃j[ACe
_SubDpFMenu2:	mov		fMenuRmSel, A					;nCCg郁j[ACẽ[g샂[hXV
		call		DrawMenuRmFm					;FM[h̑Sj[ACe`
		;
_SubDpFMenu0:	pop		ACC
		ret
		;
SubDpVolume:	;---------------------------------------;GR[_ɂ{[ݒ
		push		ACC
		push		DPH
		push		DPL
		;
		mov		A, fEncoderCtr					;A : GR[_JEgl
		jz		_SubDpVolume0					;= 0ȂI
		;
		jb		ACC.7, _SubDpVolume1				;ȂWv
		;
		;							;{[Abv
		dec		fEncoderCtr					;GR[_JEgl - 1
		mov		fIrTxCom, #cIRComVolUp				;{[AbvR}h
		jmp		_SubDpVolume2					;R}hs
		;
		;							;{[_E
_SubDpVolume1:	inc		fEncoderCtr					;GR[_JEgl + 1
		mov		fIrTxCom, #cIRComVolDn				;{[_ER}h
_SubDpVolume2:	SendIrCommand	fIrTxCom, #0					;ԊOʐMR}hs
		jnb		fIrMode.bImRxDataReady, _SubDpVolume0		;MtONAȂI
		;
		;							;s
		mov		DPTR, #cIrRxBuffer + 3				;DPTR : Mobt@̈̐擪AhX + 3
		movx		A, @DPTR					;A : {[l
		mov		fVolume, A					;fVolumeXV
		call		DrawStatus					;LCDXe[^XC̕`
		;
_SubDpVolume0:	pop		DPL
		pop		DPH
		pop		ACC
		ret
		;
SubDpMp3FfRew:	;---------------------------------------;GR[_ɂ鑁/߂
		push		ACC
		;
		mov		A, fEncoderCtr					;A : GR[_JEgl
		jz		_SubDpMp3FR0					;= 0ȂI
		;
		jb		ACC.7, _SubDpMp3FR1				;ȂWv
		;
		;							;ЂƂ̃Tuj[ACe
		mov		A, fFfRewMode					;A : /߂샂[h
		cjne		A, #cFfMode, _SubDpMp3FR3			;胂[hłȂȂWv
		;
		jmp		_SubDpMp3FR4					;胂[hȂ珈sv
		;
_SubDpMp3FR3:	inc		A						;/߂샂[h + 1
		jmp		_SubDpMp3FR2					;XV
		;
_SubDpMp3FR1:	;							;ЂƂ̃Tuj[ACe
		mov		A, fFfRewMode					;A : /߂샂[h
		cjne		A, #cRewMode, _SubDpMp3FR5			;߂[hłȂȂWv
		;
		jmp		_SubDpMp3FR4					;胂[hȂ珈sv
		;
_SubDpMp3FR5:	dec		A						;/߂샂[h - 1
		;
_SubDpMp3FR2:	SendIrCommand	#cIRComMp3FfRew, ACC				;MP3/߂R}hs
		jnb		fIrMode.bImRxDataReady, _SubDpMp3FR0		;MtONAȂI
		;
		;							;s
		mov		DPTR, #cIrRxBuffer + 3				;DPTR : Mobt@̈̐擪AhX + 3
		movx		A, @DPTR					;A : /߂샂[h
		mov		fFfRewMode, A					;fFfRewModeXV
		call		DmSmFfRew					;Tuj[` : /߂
		call		DrawStatus					;LCDXe[^XC̕`
_SubDpMp3FR4:	mov		fEncoderCtr, #0					;GR[_JEglNA
		;
_SubDpMp3FR0:	pop		ACC
		ret
		;
SubDpMp3Repeat:	;---------------------------------------;GR[_ɂ郊s[gݒ
		push		ACC
		;
		mov		A, fEncoderCtr					;A : GR[_JEgl
		jz		_SubDpMp3Rpt0					;= 0ȂI
		;
		jb		ACC.7, _SubDpMp3Rpt1				;ȂWv
		;
		;							;ЂƂ̃Tuj[ACe
		dec		fEncoderCtr					;GR[_JEgl - 1
		mov		A, fRepeatMode					;A : s[gĐ[h
		jnz		_SubDpMp3Rpt2					;ꂩ̃s[gĐݒ肳ĂȂWv
		;
		setb		ACC.bRmAll					;[I[oȂSȃs[g[h
		jmp		_SubDpMp3Rpt3					;ݒ
		;
_SubDpMp3Rpt2:	rrc		A						;s[gĐ[h - 1
		jmp		_SubDpMp3Rpt3					;ݒ
		;
_SubDpMp3Rpt1:	;							;ЂƂ̃Tuj[ACe
		inc		fEncoderCtr					;GR[_JEgl + 1
		mov		A, fMenuRmSel					;A : ݃nCCgĂ郁j[ACẽ[g샂[h
		mov		A, fRepeatMode					;A : s[gĐ[h
		jnz		_SubDpMp3Rpt4					;ꂩ̃s[gĐݒ肳ĂȂWv
		;
		setb		ACC.bRmOne					;݂̋ȃs[g[h
		jmp		_SubDpMp3Rpt3					;ݒ
		;
_SubDpMp3Rpt4:	rl		A						;s[gĐ[h + 1
		clr		ACC.bRmAll + 1					;[I[oȂ烊s[gIt
		jmp		_SubDpMp3Rpt3					;ݒ
		;
_SubDpMp3Rpt3:	SendIrCommand	#cIRComMp3Repeat, ACC				;MP3s[gݒR}hs
		jnb		fIrMode.bImRxDataReady, _SubDpMp3Rpt0		;MtONAȂI
		;
		;							;s
		mov		DPTR, #cIrRxBuffer + 3				;DPTR : Mobt@̈̐擪AhX + 3
		movx		A, @DPTR					;A : s[gĐ[h
		mov		fRepeatMode, A					;fRepeatModeXV
		call		DmSmRepeat					;Tuj[` : s[gݒXV
		call		DrawStatus					;LCDXe[^XC̕`
		;
_SubDpMp3Rpt0:	pop		ACC
		ret
		;
SubDpFmManual:	;---------------------------------------;GR[_ɂFM}jAI
		push		ACC
		;
		mov		A, fEncoderCtr					;A : GR[_JEgl
		jz		_SubDpFmManu0					;= 0ȂI
		;
		jb		ACC.7, _SubDpFmManu1				;ȂWv
		;
		;							;Mgグ
		mov		A, fFreqTableIdx				;A : ge[uCfbNX
		add		A, fEncoderCtr					;A : ge[uCfbNX + GR[_JEgl
		cjne		A, #cFreqTableIdxes, $ + 3			;ge[uCfbNX + GR[_JEgl - ge[uCfbNX
		jc		_SubDpFmManu2					;ge[uCfbNX + GR[_JEgl < ge[uCfbNXȂXV
		;
		clr		A						;Œgփ[I[o
		jmp		_SubDpFmManu2					;XV
		;
_SubDpFmManu1:	;							;Mg
		cpl		A						;
		inc		A						;GR[_JEgl𐳐ɂ
		xch		A, fFreqTableIdx				;ge[uCfbNXƃGR[_JEgl
		clr		C						;CNA
		subb		A, fFreqTableIdx				;A : ge[uCfbNX - GR[_JEgl
		jnc		_SubDpFmManu2					;ge[uCfbNX - GR[_JEgl >= 0ȂXV
		;
		mov		A, #cFreqTableIdxes - 1				;ōgփ[I[o
_SubDpFmManu2:	mov		fFreqTableIdx, A				;fFreqTableIdxXV
		mov		fEncoderCtr, #0					;GR[_JEgl
		;
		SendIrCommand	#cIRComFmManual, fFreqTableIdx			;FM}jAIǃR}hs
		jnb		fIrMode.bImRxDataReady, _SubDpFmManu0		;MtONAȂI
		;
		;							;s
		mov		DPTR, #cIrRxBuffer + 3				;DPTR : Mobt@̈̐擪AhX + 3
		movx		A, @DPTR					;A : ge[uCfbNX
		mov		fFreqTableIdx, A				;fFreqTableIdxXV
		call		DmSmManual					;Tuj[` : FM}jAI
		call		DrawStatus					;LCDXe[^XC̕`
		;
_SubDpFmmanu0:	pop		ACC
		ret
		;
SubDpTreble:	;---------------------------------------;GR[_ɂg[Rg[()ݒ
		push		ACC
		;
		mov		A, fEncoderCtr					;A : GR[_JEgl
		jz		_SubDpTreble0					;= 0ȂI
		;
		jb		ACC.7, _SubDpTreble1				;ȂWv
		;
		;							;ЂƂ̃Tuj[ACe
		dec		fEncoderCtr					;GR[_JEgl - 1
		mov		A, fTdaReg0					;A : TDA7463AD WX^ݒl(TuAhX0)
		anl		A, #00001100b					;Trebleݒrbgo
		jnb		ACC.2, _SubDpTreble2				;Boost OnȂWv
		;
		mov		A, #00001000b					;A : High Boost
		jmp		_SubDpTreble3					;ݒ
		;
_SubDpTreble2:	cjne		A, #00000000b, _SubDpTreble4			;Low BoostłȂȂWv
		;
		mov		A, #00000100b					;A : Boost Off
		jmp		_SubDpTreble3					;ݒ
		;
_SubDpTreble4:	mov		A, #00000000b					;A : Low Boost
		jmp		_SubDpTreble3					;ݒ
		;
_SubDpTreble1:	;							;ЂƂ̃Tuj[ACe
		inc		fEncoderCtr					;GR[_JEgl + 1
		mov		A, fTdaReg0					;A : TDA7463AD WX^ݒl(TuAhX0)
		anl		A, #00001100b					;Trebleݒrbgo
		jnb		ACC.2, _SubDpTreble5				;Boost OnȂWv
		;
		mov		A, #00000000b					;A : Low Boost
		jmp		_SubDpTreble3					;ݒ
		;
_SubDpTreble5:	cjne		A, #00000000b, _SubDpTreble6			;Low BoostłȂȂWv
		;
		mov		A, #00001000b					;A : High Boost
		jmp		_SubDpTreble3					;ݒ
		;
_SubDpTreble6:	mov		A, #00000100b					;A : Boost Off
		jmp		_SubDpTreble3					;ݒ
		;
_SubDpTreble3:	anl		fTdaReg0, #11110011b				;TrebleݒrbgNA
		orl		fTdaReg0, A					;fTdaReg0XV
		SendIrCommand	#cIRComTreble, fTdaReg0				;拭ݒR}hs
		jnb		fIrMode.bImRxDataReady, _SubDpTreble0		;MtONAȂI
		;
		;							;s
		mov		DPTR, #cIrRxBuffer + 3				;DPTR : Mobt@̈̐擪AhX + 3
		movx		A, @DPTR					;A : TDA7463AD WX^ݒl(TuAhX0)
		mov		fTdaReg0, A					;fTdaReg0XV
		call		DmSmTreble					;Tuj[` : g[Rg[()XV
		call		DrawStatus					;LCDXe[^XC̕`
		;
_SubDpTreble0:	pop		ACC
		ret
		;
SubDpBass:	;---------------------------------------;GR[_ɂg[Rg[()ݒ
		push		ACC
		;
		mov		A, fEncoderCtr					;A : GR[_JEgl
		jz		_SubDpBass0					;= 0ȂI
		;
		jb		ACC.7, _SubDpBass1				;ȂWv
		;
		;							;ЂƂ̃Tuj[ACe
		dec		fEncoderCtr					;GR[_JEgl - 1
		mov		A, fTdaReg1					;A : TDA7463AD WX^ݒl(TuAhX1)
		anl		A, #00000110b					;Bassݒrbgo
		jnb		ACC.1, _SubDpBass2				;Boost OnȂWv
		;
		mov		A, #00000100b					;A : High Boost
		jmp		_SubDpBass3					;ݒ
		;
_SubDpBass2:	cjne		A, #00000000b, _SubDpBass4			;Low BoostłȂȂWv
		;
		mov		A, #00000010b					;A : Boost Off
		jmp		_SubDpBass3					;ݒ
		;
_SubDpBass4:	mov		A, #00000000b					;A : Low Boost
		jmp		_SubDpBass3					;ݒ
		;
_SubDpBass1:	;							;ЂƂ̃Tuj[ACe
		inc		fEncoderCtr					;GR[_JEgl + 1
		mov		A, fTdaReg1					;A : TDA7463AD WX^ݒl(TuAhX1)
		anl		A, #00000110b					;Bassݒrbgo
		jnb		ACC.1, _SubDpBass5				;Boost OnȂWv
		;
		mov		A, #00000000b					;A : Low Boost
		jmp		_SubDpBass3					;ݒ
		;
_SubDpBass5:	cjne		A, #00000000b, _SubDpBass6			;Low BoostłȂȂWv
		;
		mov		A, #00000100b					;A : High Boost
		jmp		_SubDpBass3					;ݒ
		;
_SubDpBass6:	mov		A, #00000010b					;A : Boost Off
		jmp		_SubDpBass3					;ݒ
		;
_SubDpBass3:	anl		fTdaReg1, #11111001b				;BassݒrbgNA
		orl		fTdaReg1, A					;fTdaReg1XV
		SendIrCommand	#cIRComBass, fTdaReg1				;拭ݒR}hs
		jnb		fIrMode.bImRxDataReady, _SubDpBass0		;MtONAȂI
		;
		;							;s
		mov		DPTR, #cIrRxBuffer + 3				;DPTR : Mobt@̈̐擪AhX + 3
		movx		A, @DPTR					;A : TDA7463AD WX^ݒl(TuAhX1)
		mov		fTdaReg1, A					;fTdaReg1XV
		call		DmSmBass					;Tuj[` : g[Rg[()XV
		call		DrawStatus					;LCDXe[^XC̕`
		;
_SubDpBass0:	pop		ACC
		ret
		;
SubDpBlite:	;---------------------------------------;GR[_ɂobNCgݒ
		push		ACC
		;
		mov		A, fEncoderCtr					;A : GR[_JEgl
		jz		_SubDpBlite0					;= 0ȂI
		;
		jb		ACC.7, _SubDpBlite1				;ȂWv
		;
		;							;f[eBAbv
		dec		fEncoderCtr					;GR[_JEgl - 1
		mov		A, fLcdBlite					;A : LCDobNCgf[eB
		jz		_SubDpBlite0					;łɍőlȂ珈sv
		;
		dec		fLcdBlite					;LCDobNCgf[eBXV
		jmp		_SubDpBlite2					;f[eBݒ
		;
		;							;f[eB_E
_SubDpBlite1:	inc		fEncoderCtr					;GR[_JEgl + 1
		mov		A, fLcdBlite					;A : LCDobNCgf[eB
		cjne		A, #0ffh, _SubDpBlite3				;ŏlłȂȂWv
		;
		jmp		_SubDpBlite0					;łɍŏlȂ珈sv
		;
_SubDpBlite3:	inc		fLcdBlite					;LCDobNCgf[eBXV
_SubDpBlite2:	call		UpdateBlite					;obNCgݒXV
		call		DmSmBlite					;Tuj[` : obNCgݒXV
		;
_SubDpBlite0:	pop		ACC
		ret
		;
SubDpContr:	;---------------------------------------;GR[_ɂRgXgݒ
		push		ACC
		;
		mov		A, fEncoderCtr					;A : GR[_JEgl
		jz		_SubDpContr0					;= 0ȂI
		;
		jb		ACC.7, _SubDpContr1				;ȂWv
		;
		;							;RgXgAbv
		dec		fEncoderCtr					;GR[_JEgl - 1
		mov		A, fLcdContr					;A : LCDRgXg
		jz		_SubDpContr0					;łɍőlȂ珈sv
		;
		dec		fLcdContr					;LCDRgXgXV
		jmp		_SubDpContr2					;RgXgݒ
		;
		;							;RgXg_E
_SubDpContr1:	inc		fEncoderCtr					;GR[_JEgl + 1
		mov		A, fLcdContr					;A : LCDRgXg
		cjne		A, #03fh, _SubDpContr3				;ŏlłȂȂWv
		;
		jmp		_SubDpContr0					;łɍŏlȂ珈sv
		;
_SubDpContr3:	inc		fLcdContr					;LCDRgXgXV
_SubDpContr2:	call		UpdateContr					;RgXgݒXV
		call		DmSmContr					;Tuj[` : RgXgݒXV
		;
_SubDpContr0:	pop		ACC
		ret
		;
SubSpSync:	;---------------------------------------;XCb`ɂVNs
		push		ACC
		push		PSW
		push		DPH
		push		DPL
		SelectRegBank	rbSubSpSync					;WX^oNؑ
		;
		mov		fLcdOrgYSave, fLcdOrgY				;݂fLcdOrgYۑ
		SendIrCommand	#cIRComSync, #0					;VNR}hs
		jnb		fIrMode.bImRxDataReady, _SubSpSyncE		;MtONAȂI
		;
		;							;ACKM
		mov		DPTR, #cIrRxBuffer + 3				;DPTR : Mobt@̈̐擪AhX + 3
		movx		A, @DPTR					;A : J[hMP3t@C̑S
		mov		fMp3Files, A					;fMp3FilesXV
		mov		fMp3FileCtr, #0					;t@CJE^
		mov		fRomAddrM, #cMp3TagTopM				;fRomAddrM : MP3^Oz擪AhX(M)
		mov		fRomAddrL, #0					;fRomAddrL : EEPROMCgobt@(XRAM)̉ʃoCg
		;
_SubSpSync1:	;							;I
		mov		A, fMp3FileCtr					;A : t@CJE^
		cjne		A, fMp3Files, _SubSpSync2			;t@CJE^ <> J[hMP3t@C̑SȂWv
		;
		cjne		fRomAddrL, #0, _SubSpSync4			;obt@Ƀf[^cĂȂEEPROMփCg
		;
		jmp		_SubSpSync0					;I
		;
_SubSpSync2:	;							;^OMNGXg
		inc		fMp3FileCtr					;t@CJE^ + 1
		SendIrCommand	#cIRComSync, fMp3FileCtr			;VNR}h(^ONGXg)s
		jnb		fIrMode.bImRxDataReady, _SubSpSyncE		;MtONAȂI
		;
		;							;ACKM
		mov		DPTR, #cIrRxBuffer + 3				;DPTR : Mobt@̈̐擪AhX + 3
		mov		EMI0CN, #HIGH cEepromBuffer			;EMI0CN : EEPROMCgobt@(XRAM)̏ʃoCg
		mov		fByteCtr, #0128d				;oCgJE^
_SubSpSync3:	movx		A, @DPTR					;A : ^Of[^
		movx		@fRomAddrL, A					;EEPROMCgobt@֓]
		inc		DPTR						;]|C^ + 1
		inc		fRomAddrL					;]|C^ + 1
		djnz		fByteCtr, _SubSpSync3				;oCgJE^0ɂȂ܂Ń[v
		;
		mov		fLcdOrgY, fLcdOrgYSave				;fLcdOrgYۑlɖ߂
		call		DmSmSync					;Tuj[`XV
		cjne		fRomAddrL, #0, _SubSpSync1			;obt@tłȂΎ̃^OM
		;
_SubSpSync4:	;							;EEPROMւ̃Cg
		clr		pEepromWp					;EEPROMCgveNg
		mov		fRomAddrL, #0					;fRomAddrL : MP3^Oz擪AhX(L) = EEPROMCgobt@(XRAM)̉ʃoCg
		TxSmbSta							;X^[gRfBV
		TxSmbData	#10100000b + (cMp3TagTopH SHL 1)		;X[uAhXACg
		TxSmbData	fRomAddrM					;[hAhX(H)
		TxSmbData	fRomAddrL					;[hAhX(L)
		;
_SubSpSync5:	movx		A, @fRomAddrL					;A : ^Of[^
		TxSmbData	A						;^Of[^EEPROM֑
		inc		fRomAddrL					;]|C^ + 1
		cjne		fRomAddrL, #0, _SubSpSync5			;256oCgIłȂ΃[v
		;
		TxSmbSto							;XgbvRfBV
		mov		A, 005d						;A : 5
		call		WaitAmsec					;Amsec҂
		setb		pEepromWp					;EEPROMCgveNgݒ
		;
		inc		fRomAddrM					;EEPROMAhX(M) + 1
		jmp		_SubSpSync1					;̃^O
		;
_SubSpSyncE:	;
_SubSpSync0:	pop		DPL
		pop		DPH
		pop		PSW
		pop		ACC
		ret
		;
InitLcd:	;---------------------------------------;LCD
		push		ACC
		push		DPH
		push		DPL
		;
		;							;n[hEFAZbg
		mov		A, #1						;A : 1
		clr		pLcdRest					;pLcdRest = "L"
		call		WaitAusec					;1usec҂
		setb		pLcdRest					;pLcdRest = "H"
		call		WaitAusec					;1usec҂
		;
		;							;Display Setting
		WrLcdComStr	#ComStrDISCTL					;DISCTLR}h
		WrLcdComStr	#ComStrCOMSCN					;COMSCNR}h
		WrLcdComStr	#ComStrOSCON					;OSCONR}h
		WrLcdComStr	#ComStrSLPOUT					;SLPOUTR}h
		;
		;							;Power Supply Setting
		WrLcdComStr	#ComStrVOLCTR					;VOLCTRR}h
		WrLcdComStr	#ComStrTMPGRD					;TMPGRDR}h
		WrLcdComStr	#ComStrPWRCTL					;PWRCTLR}h
		;
		;							;Display Setting 2
		WrLcdComStr	#ComStrDISNOR					;DISNORR}h
;		WrLcdComStr	#ComStrDISINV					;DISINVR}h
		WrLcdComStr	#ComStrPTLOUT					;PTLOUTR}h
		WrLcdComStr	#ComStrASCSET					;ASCSETR}h
		WrLcdComStr	#ComStrSCSTART					;SCSTARTR}h
		;
		;							;Display Setting 3
		WrLcdComStr	#ComStrDATCTL					;DATCTLR}h
		WrLcdComStr	#ComStrRGBSET8					;RGBSET8R}h
		;
		;							;Waiting 100msec
		mov		A, #0100d					;A : 100
		call		WaitAmsec					;Amsec҂
		;
		WrLcdComStr	#ComStrDISON					;DISONR}h
		;
		call		ClearLcd				;LCD\NA
		;
		pop		DPL
		pop		DPH
		pop		ACC
		ret
		;
SetPaCaMax:	;---------------------------------------;Sʕ\pPASETACASETR}h𔭍s
		WriteLcd	0, #075h					;PASETR}h
		WriteLcd	1, #0000d					;P1
		WriteLcd	1, #0159d					;P2
		;
		WriteLcd	0, #015h					;CASETR}h
		WriteLcd	1, #0012d					;P1
		WriteLcd	1, #0131d					;P2
		;
		ret
		;
ClearLcd:	;---------------------------------------;LCD\NA
		push		ACC
		push		PSW
		SelectRegBank	rbSubLcd					;WX^oNؑ
		;
		call		SetPaCaMax					;Sʕ\pPASETACASETR}h𔭍s
		WriteLcd	0, #05ch					;RAMWRR}h
		mov		fYCtr, #0					;YJE^
		mov		A, #0						;A : NAf[^
_ClearLcd2:	mov		fXCtr, #0					;XJE^
_ClearLcd1:	WriteLcd	1, A						;f[^Cg
		inc		fXCtr						;XJE^XV
		cjne		fXCtr, #0120d, _ClearLcd1			;X[v
		;
		inc		fYCtr						;YJE^XV
		cjne		fYCtr, #0160d, _ClearLcd2			;Y[v
		;
		pop		PSW
		pop		ACC
		ret
		;
UpdateBlite:	;---------------------------------------;obNCgݒXV
		mov		PCA0CPL1, PCA0CPL1				;W[1 : f[eBXV(L)
		mov		PCA0CPH1, fLcdBlite				;W[1 : f[eBXV(H)
		;
		ret
		;
UpdateContr:	;---------------------------------------;RgXgݒXV
		WriteLcd	0, #081h					;VOLCTRR}h
		WriteLcd	1, fLcdContr					;P1
		WriteLcd	1, 0004d					;P2
		;
		ret
		;
DrawSwStop:	;---------------------------------------;XCb`C̕` : ~[h
cFC		set		cW7				;OiF
cBC		set		cB3				;wiF
		;
		DrawFill	0108d, 0020d, 0012d, 0140d, cBC			;̈NA
		;
		;							;SwA
		DrawConstStr	0110d, 0047d, cFC, cBC, StrMenu, DrawDirU	;"Menu"`
		;
		;							;SwB
		DrawConstStr	0110d, 0091d, cInherit, cInherit, StrMp3, DrawDirU	;"MP3"`
		DrawKanji	0109d, 0063d, 081a3h, cInherit, cInherit, DrawDirR	;""`
		;
		;							;SwC
		DrawConstStr	0110d, 0136d, cInherit, cInherit, StrFm,  DrawDirU	;"FM"`
		DrawKanji	0109d, 0114d, 081a3h, cInherit, cInherit, DrawDirR	;""`
		;
		ret
		;
DrawSwPlay:	;---------------------------------------;XCb`C̕` : vC[h
cFC		set		cW7				;OiF
cBC		set		cB3				;wiF
		;
		DrawFill	0108d, 0020d, 0012d, 0140d, cBC			;̈NA
		;
		;							;SwA
		DrawConstStr	0110d, 0047d, cFC, cBC, StrMenu, DrawDirU	;"Menu"`
		;
		;							;SwB
		DrawConstStr	0110d, 0093d, cInherit, cInherit, StrJump, DrawDirU	;"Jump"`
		;
		;							;SwC
		DrawKanji	0109d, 0123d, 081a1h, cInherit, cInherit, DrawDirR	;""`
		;
		ret
		;
DrawSwOkCancel:	;---------------------------------------;XCb`C̕` : "OK - Cancel"
cFC		set		cW7				;OiF
cBC		set		cB3				;wiF
		;
		DrawFill	0108d, 0020d, 0012d, 0140d, cBC			;̈NA
		;
		;							;SwA
		DrawConstStr	0110d, 0039d, cFC, cBC, StrOk, DrawDirU		;"OK"`
		;
		;							;SwB
		;
		;							;SwC
		DrawConstStr	0110d, 0145d, cInherit, cInherit, StrCancel, DrawDirU	;"Cancel"`
		;
		ret
		;
DrawSwOk:	;---------------------------------------;XCb`C̕` : "OK - -"
cFC		set		cW7				;OiF
cBC		set		cB3				;wiF
		;
		DrawFill	0108d, 0020d, 0012d, 0140d, cBC			;̈NA
		;
		;							;SwA
		DrawConstStr	0110d, 0039d, cFC, cBC, StrOk, DrawDirU		;"OK"`
		;
		;							;SwB
		;
		;							;SwC
		;
		ret
		;
DrawLogo:	;---------------------------------------;S`
LogoOrgX	set		0016d
LogoOrgY	set		0056d
cFC		set		cW7				;OiF
cBC		set		cB0				;wiF
		;
		DrawFill	0000d, 0020d, 0108d, 0140d, cBC			;̈NA
		;
		DrawAscii	0027d,    0025d,    #"T", cFC,      cBC,      DrawDirR	;"T"`
		inc		fLcdOrgX
		DrawAscii	cInherit, cInherit, #"i", cInherit, cInherit, DrawDirR	;"i"`
		inc		fLcdOrgX
		DrawAscii	cInherit, cInherit, #"n", cInherit, cInherit, DrawDirR	;"n"`
		inc		fLcdOrgX
		inc		fLcdOrgX
		DrawAscii	cInherit, cInherit, #"y", cInherit, cInherit, DrawDirR	;"y"`
		DrawAscii	cInherit, cInherit, #" ", cInherit, cInherit, DrawDirR	;" "`
		DrawAscii	cInherit, cInherit, #"M", cInherit, cInherit, DrawDirR	;"M"`
		inc		fLcdOrgX
		inc		fLcdOrgX
		DrawAscii	cInherit, cInherit, #"P", cInherit, cInherit, DrawDirR	;"P"`
		inc		fLcdOrgX
		inc		fLcdOrgX
		DrawAscii	cInherit, cInherit, #"3", cInherit, cInherit, DrawDirR	;"3"`
		;
		DrawAscii	0034d,    0038d,    #"P", cInherit, cInherit, DrawDirR	;"P"`
		inc		fLcdOrgX
		DrawAscii	cInherit, cInherit, #"l", cInherit, cInherit, DrawDirR	;"l"`
		inc		fLcdOrgX
		DrawAscii	cInherit, cInherit, #"a", cInherit, cInherit, DrawDirR	;"a"`
		inc		fLcdOrgX
		inc		fLcdOrgX
		DrawAscii	cInherit, cInherit, #"y", cInherit, cInherit, DrawDirR	;"y"`
		inc		fLcdOrgX
		inc		fLcdOrgX
		DrawAscii	cInherit, cInherit, #"e", cInherit, cInherit, DrawDirR	;"e"`
		inc		fLcdOrgX
		inc		fLcdOrgX
		DrawAscii	cInherit, cInherit, #"r", cInherit, cInherit, DrawDirR	;"r"`
		;
		DrawPattern	LogoOrgX + 0025d, LogoOrgY + 0000d, 0026d, 0008d, PtnLogoU	;"U"`
		DrawPattern	LogoOrgX + 0012d, LogoOrgY + 0012d, 0051d, 0015d, PtnLogoTimpy	;"Timpy"`
		DrawPattern	LogoOrgX + 0000d, LogoOrgY + 0018d, 0009d, 0009d, PtnLogoR	;"R"`
		DrawPattern	LogoOrgX + 0068d, LogoOrgY + 0017d, 0011d, 0011d, PtnLogoF	;"F"`
		DrawPattern	LogoOrgX + 0018d, LogoOrgY + 0029d, 0041d, 0007d, PtnLogoRev	;"Rev. 4.0"`
		DrawPattern	LogoOrgX + 0025d, LogoOrgY + 0039d, 0026d, 0008d, PtnLogoD	;"D"`
		DrawConstStr	0024d, 0113d, cInherit, cInherit, StrFmTuner, DrawDirR		;"+ FM Tuner"`
		DrawConstStr	0024d, 0124d, cInherit, cInherit, StrIrRemote, DrawDirR		;"+ Ir Remote"`
		DrawConstStr	0013d, 0145d, cInherit, cInherit, StrCredit, DrawDirR		;"Chiaki 2005"`
		;
		ret
		;
DrawListMp3:	;---------------------------------------;MP3ȃXg`
		push		ACC
		push		PSW
		push		DPH
		push		DPL
		SelectRegBank	rbDrawListMp3					;WX^oNؑ
		;
		;							;ȖCAoCA[eBXg̕\
		mov		A, fRemoteMode					;A : R샂[h
		cjne		A, #cRmMp3Jump, _DrawListMp3B			;MP3Wv샂[hłȂ΃Wv
		;
		mov		A, fFocusFileNo					;A : ݃nCCgĂ郊XgACe̋Ȕԍ(1..fMp3Files)
		mov		fLcdFColor, #cB0				;OiF
		mov		fLcdBColor, #cR8				;wiF
		jmp		_DrawListMp3C					;`
		;
_DrawListMp3B:	mov		A, fFileNo					;A : ݂̋Ȕԍ(1..fMp3Files)
		mov		fFocusFileNo, fFileNo				;MP3Wv샂[hłȂȂ猻݂̋ȔԍnCCg
		mov		fLcdFColor, #cB0				;OiF
		mov		fLcdBColor, #cG8				;wiF
		;
_DrawListMp3C:	dec		A						;A : `悷Ȕԍ(0..fMp3Files-1)
		call		_dlmRdMp3Tag					;EEPROM^Of[^[h
		mov		DPTR, #cEepromBuffer + 003d			;DPTR : Ȗ\GA̐擪|Cg
		mov		fDrawStrLen, #018d				;ő18\
		call		_dlmInsNull					;NULL^[~l[g
		mov		DPTR, #cEepromBuffer + 063d			;DPTR : Ao\GA̐擪|Cg
		mov		fDrawStrLen, #018d				;ő18\
		call		_dlmInsNull					;NULL^[~l[g
		mov		DPTR, #cEepromBuffer + 033d			;DPTR : A[eBXg\GA̐擪|Cg
		mov		fDrawStrLen, #018d				;ő18\
		call		_dlmInsNull					;NULL^[~l[g
		mov		DPTR, #cEepromBuffer + 003d			;DPTR : Ȗ\GA̐擪|Cg
		DrawXdataStr	0000d, 0020d,    cInherit, cInherit, DPH, DPL, DrawDirR	;Ȗ`
		AddYYA8		fLcdOrgY, #cFAsciiSizeY				;LCD`挴_YW1si߂
		mov		DPTR, #cEepromBuffer + 063d			;DPTR : Ao\GA̐擪|Cg
		DrawXdataStr	0000d, cInherit, cInherit, cInherit, DPH, DPL, DrawDirR	;Ao`
		AddYYA8		fLcdOrgY, #cFAsciiSizeY				;LCD`挴_YW1si߂
		mov		DPTR, #cEepromBuffer + 033d			;DPTR : A[eBXg\GA̐擪|Cg
		DrawXdataStr	0000d, cInherit, cInherit, cInherit, DPH, DPL, DrawDirR	;A[eBXg`
		AddYYA8		fLcdOrgY, #cFAsciiSizeY				;LCD`挴_YW1si߂
		;
		;							;Xgŏsɕ\ACe̋Ȕԍ߂
		mov		A, fFocusFileNo					;A : ݃nCCgĂ郊XgACe̋Ȕԍ(1..fMp3Files)
		dec		A						;A : ݃nCCgĂ郊XgACe̋Ȕԍ(0..fMp3Files-1)
		clr		C						;CNA
		subb		A, #005d					;A : A - 5
		jnc		_DrawListMp31					;A >= 5ȂWv
		;
		clr		A						;Xgŏs̋Ȕԍ0
_DrawListMp31:	mov		fListTopFileNo, A				;Xgŏsɕ\ACe̋Ȕԍ(0..fMp3Files-1)ݒ
		add		A, #011d					;A : ŉsɕ\Ȕԍ(1..)
		clr		C						;CNA
		subb		A, fMp3Files					;A : ŉsɕ\Ȕԍ(1..) - J[hMP3t@C̑S
		jc		_DrawListMp37					;ŉsɕ\Ȕԍ(1..) < J[hMP3t@C̑SȂWv
		;
		xch		A, fListTopFileNo				;̌Z2ւ
		clr		C						;CNA
		subb		A, fListTopFileNo				;ŉs̕sŏs̋ȔԍZ
		jnc		_DrawListMp38					;>= 0ȂWv
		;
		clr		A						;Xgŏs̋Ȕԍ0
_DrawListMp38:	mov		fListTopFileNo, A				;Xgŏsɕ\ACe̋Ȕԍ(0..fMp3Files-1)ݒ
		;
_DrawListMp37:	mov		A, fListTopFileNo				;A : Xgŏsɕ\ACe̋Ȕԍ(0..fMp3Files-1)
		mov		fListFileNoCtr, A				;\ACe̋ȔԍJE^(0..fMp3Files-1)
		mov		fListLineCtr, #005d				;Xg\sJE^
		;
_DrawListMp32:	;							;\ACe̋ȔԍJ[hMP3t@C̑Szǂ̃`FbN
		mov		A, fListFileNoCtr				;A : \ACe̋Ȕԍ(0..fMp3Files-1)
		clr		C						;CNA
		subb		A, fMp3Files					;\ACe̋Ȕԍ(0..fMp3Files-1) - J[hMP3t@C̑S
		jc		_DrawListMp39					;\ACe̋Ȕԍ(0..fMp3Files-1) < J[hMP3t@C̑S
		;
		;							;uN\
		DrawFill	0000d, cInherit, 0108d, cFAsciiSizeY, cBCMenuNrm	;uNs`
		AddYYA8		fLcdOrgY, #cFAsciiSizeY				;LCD`挴_YW1si߂
		jmp		_DrawListMp3A					;I
		;
_DrawListMp39:	;							;`Fݒ
		mov		A, fListFileNoCtr				;A : \ACe̋Ȕԍ(0..fMp3Files-1)
		call		_dlmRdMp3Tag					;EEPROM^Of[^[hĂ
		;
		mov		A, fRemoteMode					;A : R샂[h
		cjne		A, #cRmMp3Jump, _DrawListMp33			;MP3Wv샂[hłȂ΃Wv
		;
		mov		A, fListFileNoCtr				;A : \ACe̋Ȕԍ(0..fMp3Files-1)
		inc		A						;A : \ACe̋Ȕԍ(1..fMp3Files)
		cjne		A, fFocusFileNo, _DrawListMp33			;\ACe̋Ȕԍ <> ݃nCCgĂȔԍȂWv
		;
		mov		fLcdFColor, #cFCMenuSel				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuSel				;j[IACe̔wiF
		jmp		_DrawListMp34					;`
		;
_DrawListMp33:	mov		A, fListFileNoCtr				;A : \ACe̋Ȕԍ(0..fMp3Files-1)
		inc		A						;A : \ACe̋Ȕԍ(1..fMp3Files)
		cjne		A, fFileNo, _DrawListMp35			;\ACe̋Ȕԍ <> ݂̋ȔԍȂWv
		;
		mov		fLcdFColor, #cFCMenuSet				;j[IσACȇOiF
		mov		fLcdBColor, #cBCMenuSet				;j[IσACe̔wiF
		jmp		_DrawListMp34					;`
		;
_DrawListMp35:	mov		DPTR, #cEepromBuffer + 002d			;DPTR : "TAG"3ڂ|Cg
		movx		A, @DPTR					;A : "TAG"3
		cjne		A, #"G", _DrawListMp3F				;"G"łȂ("g"FfBNg1Ȗ)ȂWv
		;
		mov		fLcdFColor, #cFCMenuNrm				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuNrm				;j[IACe̔wiF
		jmp		_DrawListMp34					;`
		;
_DrawListMp3F:	mov		fLcdFColor, #cFCMenuDir				;fBNgACȇOiF
		mov		fLcdBColor, #cBCMenuDir				;fBNgACe̔wiF
		;
_DrawListMp34:	;							;XgACe`
		mov		A, fListFileNoCtr				;A : \ACe̋Ȕԍ(0..fMp3Files-1)
		inc		A						;A : \ACe̋Ȕԍ(1..fMp3Files)
		DrawByte3d	0000d,    cInherit, ACC,  cInherit, cInherit, DrawDirR	;Ȕԍ`
		DrawAscii	cInherit, cInherit, #" ", cInherit, cInherit, DrawDirR	;Ȕԍ`
		;
		mov		DPTR, #cEepromBuffer + 003d			;DPTR : Ȗ\GA̐擪|Cg
		mov		fDrawStrLen, #014d				;ő18\
		call		_dlmInsNull					;NULL^[~l[g
		mov		DPTR, #cEepromBuffer + 003d			;DPTR : Ȗ\GA̐擪|Cg
		DrawXdataStr	cInherit, cInherit, cInherit, cInherit, DPH, DPL, DrawDirR	;Ȗ`
		AddYYA8		fLcdOrgY, #cFAsciiSizeY				;LCD`挴_YW1si߂
		;
_DrawListMp3A:	inc		fListFileNoCtr					;\ACe̋ȔԍJE^(0..fMp3Files-1)XV
		inc		fListLineCtr					;Xg\sJE^XV
		cjne		fListLineCtr, #016d, _DrawListMp36		;ŉs܂ŏIłȂ΃Wv
		;
		jmp		_DrawListMp30					;I
		;
_DrawListMp36:	jmp		_DrawListMp32					;̃ACe
		;
_DrawListMp30:	pop		DPL
		pop		DPH
		pop		PSW
		pop		ACC
		ret
		;
_dlmInsNull:	;---------------				;DrawListMp3p[JTu[` : NULL^[~l[g
		;						;DPTR : \Jnʒu(j)
		;						;fDrawStrLen : \镶(j)
		push		ACC
		;
_dlmInsNull2:	movx		A, @DPTR					;A : f[^
		jb		ACC.7, _dlmInsNull1				;MSBZbg(1)ȂWv
		;
		;							;ASCIȈꍇ
		inc		DPTR						;|C^1i߂
		djnz		fDrawStrLen, _dlmInsNull2			;\镶񒷂ɒBĂȂΎ̕
		;
		jmp		_dlmInsNull3					;NULLZbg
		;
_dlmInsNull1:	;							;KANJȈꍇ
		inc		DPTR						;|C^1i߂
		djnz		fDrawStrLen, _dlmInsNull4			;\镶񒷂ɒBĂȂ2oCgڂ
		;
		;							;2oCgڂ͂ݏoꍇ
		SubYYA16	DPH, DPL, #0, #1				;|C^1߂
		mov		A, #" "						;A : " "
		movx		@DPTR, A					;1oCgڂ" "Œu
		inc		DPTR						;|C^1i߂
		jmp		_dlmInsNull3					;NULLZbg
		;
_dlmInsNull4:	inc		DPTR						;|C^1i߂
		djnz		fDrawStrLen, _dlmInsNull2			;\镶񒷂ɒBĂȂΎ̕
		;
_dlmInsNull3:	;							;NULLZbg
		clr		A						;A : NULL
		movx		@DPTR, A					;NULLZbg
		;
		pop		ACC
		ret
		;
_dlmRdMp3Tag:	;---------------				;DrawListMp3p[JTu[` : EEPROM^Of[^[h
		;						;A : Ȕԍ(0..fMp3Files-1)
		push		ACC
		push		B
		push		DPH
		push		DPL
		;
		mov		B, #0128d					;B : ^Of[^̃TCY
		mul		AB						;AB : ^Of[^̐擪ւ̃ItZbg
		mov		fRomAddrM, B					;fRomAddrMXV
		mov		fRomAddrL, A					;fRomAddrLXV
		AddYYA16	fRomAddrM, fRomAddrL, #cMp3TagTopM, #cMp3TagTopL	;EEPROM[hAhX(ML)vZ
		;
		TxSmbSta							;X^[gRfBV
		TxSmbData	#10100000b + (cMp3TagTopH SHL 1)		;foCXAhXACg[hM
		TxSmbData	fRomAddrM					;[hAhX(M)M
		TxSmbData	fRomAddrL					;[hAhX(L)M
		;
		TxSmbSta							;X^[gRfBV
		TxSmbData	#10100001b + (cMp3TagTopH SHL 1)		;foCXAhXA[h[hM
		mov		fByteCtr, #0128d				;oCgJE^
		mov		DPTR, #cEepromBuffer				;DPTR : EEPROM[hobt@擪AhXŏ
		;
_dlmRdMp3Tag1:	RxSmbData	ResACK						;f[^[h
		mov		A, SMB0DAT					;A : ^Of[^
		movx		@DPTR, A					;EEPROM[hobt@֓]
		inc		DPTR						;]|C^XV
		djnz		fByteCtr, _dlmRdMp3Tag1				;oCgJE^0ɂȂ܂Ń[v
		;
		RxSmbData	ResNACK						;_~[[h
		TxSmbSto							;XgbvRfBV
		;
		pop		DPL
		pop		DPH
		pop		B
		pop		ACC
		ret
		;
DrawPlayMp3:	;---------------------------------------;MP3vCʕ`
LogoOrgX	set		0016d
LogoOrgY	set		0030d
cFC		set		cW7				;OiF
cBC		set		cB0				;wiF
		;
		push		ACC
		push		DPH
		push		DPL
		;
		jnb		fPlayMode.bPmPlayScreen, _DrawPlayMp34		;DrawPlayMp3ʕ\σtONAȂSʕ`
		;
		jmp		_DrawPlayMp33					;ĕ`svXLbv
		;
_DrawPlayMp34:	DrawFill	0000d, 0020d, 0108d, 0140d, cBC			;̈NA
		;
		DrawPattern	LogoOrgX + 0025d, LogoOrgY + 0000d, 0026d, 0008d, PtnLogoU	;"U"`
		DrawPattern	LogoOrgX + 0012d, LogoOrgY + 0012d, 0051d, 0015d, PtnLogoTimpy	;"Timpy"`
		DrawPattern	LogoOrgX + 0000d, LogoOrgY + 0018d, 0009d, 0009d, PtnLogoR	;"R"`
		DrawPattern	LogoOrgX + 0068d, LogoOrgY + 0017d, 0011d, 0011d, PtnLogoF	;"F"`
		DrawPattern	LogoOrgX + 0018d, LogoOrgY + 0029d, 0041d, 0007d, PtnLogoRev	;"Rev. 4.0"`
		DrawPattern	LogoOrgX + 0025d, LogoOrgY + 0039d, 0026d, 0008d, PtnLogoD	;"D"`
		;
		DrawConstStr	0012d, 0086d, cFC, cBC, StrNowPlaying, DrawDirR	;"Now playing..."`
		;
_DrawPlayMp33:	mov		A, fFileNo					;A : ݂̋Ȕԍ(1..fMp3Files)
		dec		A						;A : `悷Ȕԍ(0..fMp3Files-1)
		call		_dlmRdMp3Tag					;EEPROM^Of[^[h
		mov		DPTR, #cEepromBuffer + 003d			;DPTR : Ȗ\GA̐擪|Cg
		mov		fDrawStrLen, #016d				;ő18\
		call		_dlmInsNull					;NULL^[~l[g
		mov		DPTR, #cEepromBuffer + 063d			;DPTR : Ao\GA̐擪|Cg
		mov		fDrawStrLen, #016d				;ő18\
		call		_dlmInsNull					;NULL^[~l[g
		mov		DPTR, #cEepromBuffer + 033d			;DPTR : A[eBXg\GA̐擪|Cg
		mov		fDrawStrLen, #016d				;ő18\
		call		_dlmInsNull					;NULL^[~l[g
		mov		DPTR, #cEepromBuffer + 003d			;DPTR : Ȗ\GA̐擪|Cg
		DrawXdataStr	0006d, 0105d,    cFC,      cBC,      DPH, DPL, DrawDirR	;Ȗ`
		AddYYA8		fLcdOrgY, #cFAsciiSizeY + 2			;LCD`挴_YW1si߂
		mov		DPTR, #cEepromBuffer + 063d			;DPTR : Ao\GA̐擪|Cg
		DrawXdataStr	0006d, cInherit, cInherit, cInherit, DPH, DPL, DrawDirR	;Ao`
		AddYYA8		fLcdOrgY, #cFAsciiSizeY + 2			;LCD`挴_YW1si߂
		mov		DPTR, #cEepromBuffer + 033d			;DPTR : A[eBXg\GA̐擪|Cg
		DrawXdataStr	0006d, cInherit, cInherit, cInherit, DPH, DPL, DrawDirR	;A[eBXg`
		AddYYA8		fLcdOrgY, #cFAsciiSizeY	+ 2			;LCD`挴_YW1si߂
		;
		;							;ԕ\
		DrawConstStr	0006d, cInherit, cInherit, cInherit, StrTime, DrawDirR	;"Time ["`
		;
		clr		A						;A : JE^NA
		mov		DPH, fDecodeTimeH
		mov		DPL, fDecodeTimeL				;DPTR : fDecodeTime
_DrawPlayMp31:	SubYYA16	DPH, DPL, #0d, #060d				;DPTR : DPTR - 60
		jc		_DrawPlayMp32					;DPTR < 60ȂWv
		;
		inc		A						;A : JE^ + 1
		jmp		_DrawPlayMp31					;[v
		;
_DrawPlayMp32:	AddYYA16	DPH, DPL, #0d, #060d				;DPTR : DPTR + 60
		DrawByte2d	cInherit, cInherit, ACC,  cInherit, cInherit, DrawDirR	;`
		DrawAscii	cInherit, cInherit, #":", cInherit, cInherit, DrawDirR	;":"`
		DrawByte2d	cInherit, cInherit, DPL,  cInherit, cInherit, DrawDirR	;b`
		DrawAscii	cInherit, cInherit, #"]", cInherit, cInherit, DrawDirR	;"]"`
		;
		setb		fPlayMode.bPmPlayScreen				;DrawPlayMp3ʕ\σtOZbg
		;
		pop		DPL
		pop		DPH
		pop		ACC
		ret
		;
DrawListFmSt:	;---------------------------------------;FMǃXg`
		push		ACC
		push		B
		;
		DrawConstStr	0000d, 0020d, cFCMenuNrm, cBCMenuNrm, StrPreStList, DrawDirR	;vZbg
		;
		;							;XgACe`
		mov		A, #0						;A : ŏ̃XgACeԍ
		mov		fLcdOrgY, #030d					;fLcdOrgY
		;
_DlFmSt4:	push		ACC						;Aꎞޔ
		mov		B, #cMenuItemLen + 1				;B : ACẽoCg
		mul		AB						;AB : \ACeɑ΂ItZbg
		AddYAB16	fLcdStrAdrH, fLcdStrAdrL, B, ACC, #HIGH StrPreSt1st, #LOW StrPreSt1st	;\ACẽAhXݒ
		pop		ACC						;AA
		;
		mov		fLcdFColor, #cFCMenuNrm				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuNrm				;j[IACe̔wiF
		cjne		A, fPreStNo, _DlFmSt1				;A <> ݂̃vZbgǔԍȂ`
		;
		mov		fLcdFColor, #cFCMenuSet				;j[IσACȇOiF
		mov		fLcdBColor, #cBCMenuSet				;j[IσACe̔wiF
		push		ACC						;Aꎞޔ
		mov		A, fRemoteMode					;A : [g샂[h
		cjne		A, #cRmFmJump, _DlFmSt6				;A <> FMWv샂[hȂWv
		;
		mov		fLcdFColor, #cFCMenuSel				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuSel				;j[IACe̔wiF
		;
_DlFmSt6:	pop		ACC						;AA
		;
_DlFmSt1:	DrawConstStrHL	0000d, cInherit, cInherit, cInherit, cInherit, cInherit, DrawDirR	;ACe`
		AddYYA8		fLcdOrgY, #cFAsciiSizeY				;LCD`挴_YW1si߂
		;
		;							;I
		cjne		A, #cPreStTables - 1, _DlFmSt5			;A <> Ō̃XgACeȂWv
		;
		jmp		_DlFmSt2					;I
		;
_DlFmSt5:	inc		A						;A : XgACeԍ + 1
		jmp		_DlFmSt4					;̃ACe`
		;
_DlFmSt2:	;							;`̗̈NA
		mov		A, fLcdOrgY					;A : fLcdOrgY
		cjne		A, #0160d, $ + 3				;fLcdOrgY - 160
		jnc		_DlFmSt0					;>= 0ȂI
		;
		DrawFill	0000d, cInherit, 0108d, cFAsciiSizeY, cBCMenuNrm	;uNs`
		AddYYA8		fLcdOrgY, #cFAsciiSizeY				;LCD`挴_YW1si߂
		jmp		_DlFmSt2					;[v
		;
_DlFmSt0:	pop		B
		pop		ACC
		ret
		;
DrawMenuRmStop:	;---------------------------------------;~[h̑Sj[ACe`
		push		ACC
		push		B
		push		DPH
		push		DPL
		;
		DrawConstStr	0000d, 0020d, cFCMenuNrm, cBCMenuNrm, StrDmStopMenu, DrawDirR	;Menu
		;
		;							;j[ACe`
		mov		A, #cRmStopMenu + 1				;A : ŏ̃j[ACeɑΉ郂[hԍ
		mov		fLcdOrgY, #030d					;fLcdOrgY
		;
_DmRmStop4:	push		ACC						;Aꎞޔ
		clr		C						;CNA
		subb		A, #cRmStopMenu + 1				;A : A - ŏ̃j[ACeɑΉ郂[hԍ
		mov		B, #cMenuItemLen + 1				;B : ACẽoCg
		mul		AB						;AB : \ACeɑ΂ItZbg
		AddYAB16	fLcdStrAdrH, fLcdStrAdrL, B, ACC, #HIGH StrDmStop1st, #LOW StrDmStop1st	;\ACẽAhXݒ
		pop		ACC						;AA
		;
		mov		fLcdFColor, #cFCMenuNrm				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuNrm				;j[IACe̔wiF
		cjne		A, fRemoteMode, _DmRmStop1			;A <> [g샂[hȂWv
		;
		mov		fLcdFColor, #cFCMenuSet				;j[IσACȇOiF
		mov		fLcdBColor, #cBCMenuSet				;j[IσACe̔wiF
		jmp		_DmRmStop2					;`
		;
_DmRmStop1:	cjne		A, fMenuRmSel, _DmRmStop2			;A <> ݃nCCgĂACeȂWv
		;
		mov		fLcdFColor, #cFCMenuSel				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuSel				;j[IACe̔wiF
		;
_DmRmStop2:	DrawConstStrHL	0000d, cInherit, cInherit, cInherit, cInherit, cInherit, DrawDirR	;ACe`
		AddYYA8		fLcdOrgY, #cFAsciiSizeY				;LCD`挴_YW1si߂
		;
		;							;`悵ACẽ݂[g샂[hȂTuj[\
		cjne		A, fRemoteMode, _DmRmStop3			;A <> [g샂[hȂWv
		;
		push		ACC						;Aꎞޔ
		mov		DPTR, #_DmRmStopRet				;DPTR : e[uWṽ^[AhX
		push		DPL						;^[AhXX^bN֐ςł
		push		DPH
		clr		C						;CNA
		subb		A, #cRmStopMenu + 1				;A : A - ŏ̃j[ACeɑΉ郂[hԍ
		mov		B, #3						;ljmpȂ̂3{
		mul		AB						;A : A * 3
		mov		DPTR, #_DmRmStopTable				;DPTR : Wve[u擪AhX
		jmp		@A + DPTR					;Wv
		;
_DmRmStopTable:	ljmp		DmSmSync					;Tuj[` : VN
		ljmp		DmSmBlite					;Tuj[` : obNCgݒ
		ljmp		DmSmContr					;Tuj[` : RgXgݒ
		;
_DmRmStopRet:	;								;Tuj[`悩̃^[AhX
		pop		ACC						;AA
		;
_DmRmStop3:	;							;I
		cjne		A, #cRmStopMax, _DmRmStop5			;A <> Ō̃j[ACeȂWv
		;
		jmp		_DmRmStop0					;I
		;
_DmRmStop5:	inc		A						;A : j[ACeɑΉ郂[hԍ + 1
		jmp		_DmRmStop4					;̃ACe`
		;
_DmRmStop0:	pop		DPL
		pop		DPH
		pop		B
		pop		ACC
		ret
		;
DrawMenuRmMp3:	;---------------------------------------;MP3[h̑Sj[ACe`
		push		ACC
		push		B
		push		DPH
		push		DPL
		;
		DrawConstStr	0000d, 0020d, cFCMenuNrm, cBCMenuNrm, StrDmMp3Menu, DrawDirR	;Menu
		;
		;							;j[ACe`
		mov		A, #cRmMp3Menu + 1				;A : ŏ̃j[ACeɑΉ郂[hԍ
		mov		fLcdOrgY, #030d					;fLcdOrgY
		;
_DmRmMp34:	push		ACC						;Aꎞޔ
		clr		C						;CNA
		subb		A, #cRmMp3Menu + 1				;A : A - ŏ̃j[ACeɑΉ郂[hԍ
		mov		B, #cMenuItemLen + 1				;B : ACẽoCg
		mul		AB						;AB : \ACeɑ΂ItZbg
		AddYAB16	fLcdStrAdrH, fLcdStrAdrL, B, ACC, #HIGH StrDmMp31st, #LOW StrDmMp31st	;\ACẽAhXݒ
		pop		ACC						;AA
		;
		mov		fLcdFColor, #cFCMenuNrm				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuNrm				;j[IACe̔wiF
		cjne		A, fRemoteMode, _DmRmMp31			;A <> [g샂[hȂWv
		;
		mov		fLcdFColor, #cFCMenuSet				;j[IσACȇOiF
		mov		fLcdBColor, #cBCMenuSet				;j[IσACe̔wiF
		jmp		_DmRmMp32					;`
		;
_DmRmMp31:	cjne		A, fMenuRmSel, _DmRmMp32			;A <> ݃nCCgĂACeȂWv
		;
		mov		fLcdFColor, #cFCMenuSel				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuSel				;j[IACe̔wiF
		;
_DmRmMp32:	DrawConstStrHL	0000d, cInherit, cInherit, cInherit, cInherit, cInherit, DrawDirR	;ACe`
		AddYYA8		fLcdOrgY, #cFAsciiSizeY				;LCD`挴_YW1si߂
		;
		;							;`悵ACẽ݂[g샂[hȂTuj[\
		cjne		A, fRemoteMode, _DmRmMp33			;A <> [g샂[hȂWv
		;
		push		ACC						;Aꎞޔ
		mov		DPTR, #_DmRmMp3Ret				;DPTR : e[uWṽ^[AhX
		push		DPL						;^[AhXX^bN֐ςł
		push		DPH
		clr		C						;CNA
		subb		A, #cRmMp3Menu + 1				;A : A - ŏ̃j[ACeɑΉ郂[hԍ
		mov		B, #3						;ljmpȂ̂3{
		mul		AB						;A : A * 3
		mov		DPTR, #_DmRmMp3Table				;DPTR : Wve[u擪AhX
		jmp		@A + DPTR					;Wv
		;
_DmRmMp3Table:	ljmp		DmSmFfRew					;Tuj[` : /߂
		ljmp		DmSmRepeat					;Tuj[` : s[gݒ
		ljmp		DmSmTreble					;Tuj[` : g[Rg[()
		ljmp		DmSmBass					;Tuj[` : g[Rg[()
		ljmp		DmSmBlite					;Tuj[` : obNCgݒ
		ljmp		DmSmContr					;Tuj[` : RgXgݒ
		;
_DmRmMp3Ret:	;								;Tuj[`悩̃^[AhX
		pop		ACC						;AA
		;
_DmRmMp33:	;							;I
		cjne		A, #cRmMp3Max, _DmRmMp35			;A <> Ō̃j[ACeȂWv
		;
		jmp		_DmRmMp30					;I
		;
_DmRmMp35:	inc		A						;A : j[ACeɑΉ郂[hԍ + 1
		jmp		_DmRmMp34					;̃ACe`
		;
_DmRmMp30:	pop		DPL
		pop		DPH
		pop		B
		pop		ACC
		ret
		;
DrawMenuRmFm:	;---------------------------------------;FM[h̑Sj[ACe`
		push		ACC
		push		B
		push		DPH
		push		DPL
		;
		DrawConstStr	0000d, 0020d, cFCMenuNrm, cBCMenuNrm, StrDmFmMenu, DrawDirR	;Menu
		;
		;							;j[ACe`
		mov		A, #cRmFmMenu + 1				;A : ŏ̃j[ACeɑΉ郂[hԍ
		mov		fLcdOrgY, #030d					;fLcdOrgY
		;
_DmRmFm4:	push		ACC						;Aꎞޔ
		clr		C						;CNA
		subb		A, #cRmFmMenu + 1				;A : A - ŏ̃j[ACeɑΉ郂[hԍ
		mov		B, #cMenuItemLen + 1				;B : ACẽoCg
		mul		AB						;AB : \ACeɑ΂ItZbg
		AddYAB16	fLcdStrAdrH, fLcdStrAdrL, B, ACC, #HIGH StrDmFm1st, #LOW StrDmFm1st	;\ACẽAhXݒ
		pop		ACC						;AA
		;
		mov		fLcdFColor, #cFCMenuNrm				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuNrm				;j[IACe̔wiF
		cjne		A, fRemoteMode, _DmRmFm1			;A <> [g샂[hȂWv
		;
		mov		fLcdFColor, #cFCMenuSet				;j[IσACȇOiF
		mov		fLcdBColor, #cBCMenuSet				;j[IσACe̔wiF
		jmp		_DmRmFm2					;`
		;
_DmRmFm1:	cjne		A, fMenuRmSel, _DmRmFm2				;A <> ݃nCCgĂACeȂWv
		;
		mov		fLcdFColor, #cFCMenuSel				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuSel				;j[IACe̔wiF
		;
_DmRmFm2:	DrawConstStrHL	0000d, cInherit, cInherit, cInherit, cInherit, cInherit, DrawDirR	;ACe`
		AddYYA8		fLcdOrgY, #cFAsciiSizeY				;LCD`挴_YW1si߂
		;
		;							;`悵ACẽ݂[g샂[hȂTuj[\
		cjne		A, fRemoteMode, _DmRmFm3			;A <> [g샂[hȂWv
		;
		push		ACC						;Aꎞޔ
		mov		DPTR, #_DmRmFmRet				;DPTR : e[uWṽ^[AhX
		push		DPL						;^[AhXX^bN֐ςł
		push		DPH
		clr		C						;CNA
		subb		A, #cRmFmMenu + 1				;A : A - ŏ̃j[ACeɑΉ郂[hԍ
		mov		B, #3						;ljmpȂ̂3{
		mul		AB						;A : A * 3
		mov		DPTR, #_DmRmFmTable				;DPTR : Wve[u擪AhX
		jmp		@A + DPTR					;Wv
		;
_DmRmFmTable:	ljmp		DmSmSearch					;Tuj[` : I[gT[`
		ljmp		DmSmManual					;Tuj[` : }jAI
		ljmp		DmSmTreble					;Tuj[` : g[Rg[()
		ljmp		DmSmBass					;Tuj[` : g[Rg[()
		ljmp		DmSmBlite					;Tuj[` : obNCgݒ
		ljmp		DmSmContr					;Tuj[` : RgXgݒ
		;
_DmRmFmRet:	;								;Tuj[`悩̃^[AhX
		pop		ACC						;AA
		;
_DmRmFm3:	;							;I
		cjne		A, #cRmFmMax, _DmRmFm5				;A <> Ō̃j[ACeȂWv
		;
		jmp		_DmRmFm0					;I
		;
_DmRmFm5:	inc		A						;A : j[ACeɑΉ郂[hԍ + 1
		jmp		_DmRmFm4					;̃ACe`
		;
_DmRmFm0:	pop		DPL
		pop		DPH
		pop		B
		pop		ACC
		ret
		;
DmSmSync:	;---------------------------------------;Tuj[` : VN
		;					;  fLcdOrgYݒ肵Ă
		DrawKanji	0000d,    cInherit, 084a0h,      cFCMenuNrm, cBCMenuNrm, DrawDirR	;""`
		DrawKanji	cInherit, cInherit, 084a4h,      cFCMenuSel, cBCMenuSel, DrawDirR	;""`
		DrawAscii	cInherit, cInherit, #" ",        cInherit,   cInherit,   DrawDirR	;" "`
		DrawByte3dZs	cInherit, cInherit, fMp3FileCtr, cInherit,   cInherit,   DrawDirR	;MP3t@CJE^`
		DrawAscii	cInherit, cInherit, #"/",        cInherit,   cInherit,   DrawDirR	;"/"`
		DrawByte3dZs	cInherit, cInherit, fMp3Files,   cInherit,   cInherit,   DrawDirR	;MP3St@C`
		DrawSpaces	cInherit, cInherit, #006d,       cInherit,   cInherit,   DrawDirR	;" "Ŗ߂
		AddYYA8		fLcdOrgY, #cFAsciiSizeY				;1sYWi߂
		;
		ret
		;
DmSmFfRew:	;---------------------------------------;Tuj[` : /߂
		;					;  fLcdOrgYݒ肵Ă
		push		ACC
		;
		;							;
		DrawKanji	0000d, cInherit, 084a0h, cFCMenuNrm, cBCMenuNrm, DrawDirR	;""`
		mov		fLcdFColor, #cFCMenuNrm				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuNrm				;j[IACe̔wiF
		mov		A, fFfRewMode					;A : /߂샂[h
		cjne		A, #cFfMode, _DmSmFfRew1			;胂[hłȂ΃Wv
		;
		mov		fLcdFColor, #cFCMenuSel				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuSel				;j[IACe̔wiF
_DmSmFfRew1:	DrawConstStr	cInherit, cInherit, cInherit, cInherit, StrDmFf, DrawDirR	;""
		AddYYA8		fLcdOrgY, #cFAsciiSizeY				;1sYWi߂
		;
		;							;ʏ푬x
		DrawKanji	0000d, cInherit, 084a0h, cFCMenuNrm, cBCMenuNrm, DrawDirR	;""`
		mov		fLcdFColor, #cFCMenuNrm				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuNrm				;j[IACe̔wiF
		mov		A, fFfRewMode					;A : /߂샂[h
		cjne		A, #cFfRewOff, _DmSmFfRew2			;ʏ푬x[hłȂ΃Wv
		;
		mov		fLcdFColor, #cFCMenuSel				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuSel				;j[IACe̔wiF
_DmSmFfRew2:	DrawConstStr	cInherit, cInherit, cInherit, cInherit, StrDmFfrewOff, DrawDirR	;"ʏ푬x"
		AddYYA8		fLcdOrgY, #cFAsciiSizeY				;1sYWi߂
		;
		;							;߂
		DrawKanji	0000d, cInherit, 084a0h, cFCMenuNrm, cBCMenuNrm, DrawDirR	;""`
		mov		fLcdFColor, #cFCMenuNrm				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuNrm				;j[IACe̔wiF
		mov		A, fFfRewMode					;A : /߂샂[h
		cjne		A, #cRewMode, _DmSmFfRew3			;߂[hłȂ΃Wv
		;
		mov		fLcdFColor, #cFCMenuSel				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuSel				;j[IACe̔wiF
_DmSmFfRew3:	DrawConstStr	cInherit, cInherit, cInherit, cInherit, StrDmRew, DrawDirR	;"߂"
		AddYYA8		fLcdOrgY, #cFAsciiSizeY				;1sYWi߂
		;
		pop		ACC
		ret
		;
DmSmRepeat:	;---------------------------------------;Tuj[` : s[gݒ
		;					;  fLcdOrgYݒ肵Ă
		push		ACC
		;
		;							;s[gĐIt
		DrawKanji	0000d, cInherit, 084a0h, cFCMenuNrm, cBCMenuNrm, DrawDirR	;""`
		mov		fLcdFColor, #cFCMenuNrm				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuNrm				;j[IACe̔wiF
		mov		A, fRepeatMode					;A : s[gĐ[h
		jnz		_DmSmRepeat1					;ꂩ̃s[gĐݒ肳ĂȂWv
		;
		mov		fLcdFColor, #cFCMenuSel				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuSel				;j[IACe̔wiF
_DmSmRepeat1:	DrawConstStr	cInherit, cInherit, cInherit, cInherit, StrDmRepeatOff, DrawDirR	;"Off"
		AddYYA8		fLcdOrgY, #cFAsciiSizeY				;1sYWi߂
		;
		;							;݂̋ȃs[gĐ
		DrawKanji	0000d, cInherit, 084a0h, cFCMenuNrm, cBCMenuNrm, DrawDirR	;""`
		mov		fLcdFColor, #cFCMenuNrm				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuNrm				;j[IACe̔wiF
		jnb		fRepeatMode.bRmOne, _DmSmRepeat2		;݂̋ȃs[gĐłȂ΃Wv
		;
		mov		fLcdFColor, #cFCMenuSel				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuSel				;j[IACe̔wiF
_DmSmRepeat2:	DrawConstStr	cInherit, cInherit, cInherit, cInherit, StrDmRepeatOne, DrawDirR	;"One"
		AddYYA8		fLcdOrgY, #cFAsciiSizeY				;1sYWi߂
		;
		;							;݂̃fBNgs[gĐ
		DrawKanji	0000d, cInherit, 084a0h, cFCMenuNrm, cBCMenuNrm, DrawDirR	;""`
		mov		fLcdFColor, #cFCMenuNrm				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuNrm				;j[IACe̔wiF
		jnb		fRepeatMode.bRmDir, _DmSmRepeat3		;݂̃fBNgs[gĐłȂ΃Wv
		;
		mov		fLcdFColor, #cFCMenuSel				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuSel				;j[IACe̔wiF
_DmSmRepeat3:	DrawConstStr	cInherit, cInherit, cInherit, cInherit, StrDmRepeatDir, DrawDirR	;"Dir"
		AddYYA8		fLcdOrgY, #cFAsciiSizeY				;1sYWi߂
		;
		;							;Sȃs[gĐ
		DrawKanji	0000d, cInherit, 084a0h, cFCMenuNrm, cBCMenuNrm, DrawDirR	;""`
		mov		fLcdFColor, #cFCMenuNrm				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuNrm				;j[IACe̔wiF
		jnb		fRepeatMode.bRmAll, _DmSmRepeat4		;Sȃs[gĐłȂ΃Wv
		;
		mov		fLcdFColor, #cFCMenuSel				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuSel				;j[IACe̔wiF
_DmSmRepeat4:	DrawConstStr	cInherit, cInherit, cInherit, cInherit, StrDmRepeatAll, DrawDirR	;"All"
		AddYYA8		fLcdOrgY, #cFAsciiSizeY				;1sYWi߂
		;
		pop		ACC
		ret
		;
DmSmTreble:	;---------------------------------------;Tuj[` : g[Rg[()
		;					;  fLcdOrgYݒ肵Ă
		push		ACC
		;
		;							;Boost Off
		DrawKanji	0000d, cInherit, 084a0h, cFCMenuNrm, cBCMenuNrm, DrawDirR	;""`
		mov		fLcdFColor, #cFCMenuNrm				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuNrm				;j[IACe̔wiF
		mov		A, fTdaReg0					;A : TDA7463AD WX^ݒl(TuAhX0)
		jnb		ACC.2, _DmSmTreble1				;Boost OnȂWv
		;
		mov		fLcdFColor, #cFCMenuSel				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuSel				;j[IACe̔wiF
_DmSmTreble1:	DrawConstStr	cInherit, cInherit, cInherit, cInherit, StrDmTrblOff, DrawDirR	;"Off"
		AddYYA8		fLcdOrgY, #cFAsciiSizeY				;1sYWi߂
		;
		;							;Low Boost
		DrawKanji	0000d, cInherit, 084a0h, cFCMenuNrm, cBCMenuNrm, DrawDirR	;""`
		mov		fLcdFColor, #cFCMenuNrm				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuNrm				;j[IACe̔wiF
		mov		A, fTdaReg0					;A : TDA7463AD WX^ݒl(TuAhX0)
		anl		A, #00001100b					;Trebleݒrbgo
		cjne		A, #00000000b, _DmSmTreble2			;Low BoostłȂ΃Wv
		;
		mov		fLcdFColor, #cFCMenuSel				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuSel				;j[IACe̔wiF
_DmSmTreble2:	DrawConstStr	cInherit, cInherit, cInherit, cInherit, StrDmTrblLow, DrawDirR	;"Low"
		AddYYA8		fLcdOrgY, #cFAsciiSizeY				;1sYWi߂
		;
		;							;High Boost
		DrawKanji	0000d, cInherit, 084a0h, cFCMenuNrm, cBCMenuNrm, DrawDirR	;""`
		mov		fLcdFColor, #cFCMenuNrm				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuNrm				;j[IACe̔wiF
		mov		A, fTdaReg0					;A : TDA7463AD WX^ݒl(TuAhX0)
		anl		A, #00001100b					;Trebleݒrbgo
		cjne		A, #00001000b, _DmSmTreble3			;High BoostłȂ΃Wv
		;
		mov		fLcdFColor, #cFCMenuSel				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuSel				;j[IACe̔wiF
_DmSmTreble3:	DrawConstStr	cInherit, cInherit, cInherit, cInherit, StrDmTrblHigh, DrawDirR	;"High"
		AddYYA8		fLcdOrgY, #cFAsciiSizeY				;1sYWi߂
		;
		pop		ACC
		ret
		;
DmSmBass:	;---------------------------------------;Tuj[` : g[Rg[()
		;					;  fLcdOrgYݒ肵Ă
		push		ACC
		;
		;							;Boost Off
		DrawKanji	0000d, cInherit, 084a0h, cFCMenuNrm, cBCMenuNrm, DrawDirR	;""`
		mov		fLcdFColor, #cFCMenuNrm				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuNrm				;j[IACe̔wiF
		mov		A, fTdaReg1					;A : TDA7463AD WX^ݒl(TuAhX1)
		jnb		ACC.1, _DmSmBass1				;Boost OnȂWv
		;
		mov		fLcdFColor, #cFCMenuSel				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuSel				;j[IACe̔wiF
_DmSmBass1:	DrawConstStr	cInherit, cInherit, cInherit, cInherit, StrDmBassOff, DrawDirR	;"Off"
		AddYYA8		fLcdOrgY, #cFAsciiSizeY				;1sYWi߂
		;
		;							;Low Boost
		DrawKanji	0000d, cInherit, 084a0h, cFCMenuNrm, cBCMenuNrm, DrawDirR	;""`
		mov		fLcdFColor, #cFCMenuNrm				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuNrm				;j[IACe̔wiF
		mov		A, fTdaReg1					;A : TDA7463AD WX^ݒl(TuAhX1)
		anl		A, #00000110b					;Bassݒrbgo
		cjne		A, #00000000b, _DmSmBass2			;Low BoostłȂ΃Wv
		;
		mov		fLcdFColor, #cFCMenuSel				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuSel				;j[IACe̔wiF
_DmSmBass2:	DrawConstStr	cInherit, cInherit, cInherit, cInherit, StrDmBassLow, DrawDirR	;"Low"
		AddYYA8		fLcdOrgY, #cFAsciiSizeY				;1sYWi߂
		;
		;							;High Boost
		DrawKanji	0000d, cInherit, 084a0h, cFCMenuNrm, cBCMenuNrm, DrawDirR	;""`
		mov		fLcdFColor, #cFCMenuNrm				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuNrm				;j[IACe̔wiF
		mov		A, fTdaReg1					;A : TDA7463AD WX^ݒl(TuAhX1)
		anl		A, #00000110b					;Bassݒrbgo
		cjne		A, #00000100b, _DmSmBass3			;High BoostłȂ΃Wv
		;
		mov		fLcdFColor, #cFCMenuSel				;j[IACȇOiF
		mov		fLcdBColor, #cBCMenuSel				;j[IACe̔wiF
_DmSmBass3:	DrawConstStr	cInherit, cInherit, cInherit, cInherit, StrDmBassHigh, DrawDirR	;"High"
		AddYYA8		fLcdOrgY, #cFAsciiSizeY				;1sYWi߂
		;
		pop		ACC
		ret
		;
DmSmBlite:	;---------------------------------------;Tuj[`FobNCgݒ
		;					;  fLcdOrgYݒ肵Ă
		DrawKanji	0000d,    cInherit, 084a0h,    cFCMenuNrm, cBCMenuNrm, DrawDirR	;""`
		DrawKanji	cInherit, cInherit, 084a4h,    cFCMenuSel, cBCMenuSel, DrawDirR	;""`
		DrawAscii	cInherit, cInherit, #" ",      cInherit,   cInherit,   DrawDirR	;" "`
		DrawByte3dZs	cInherit, cInherit, fLcdBlite, cInherit,   cInherit,   DrawDirR	;LCDobNCgf[eB(0..255)`
		DrawSpaces	cInherit, cInherit, #010d,     cInherit,   cInherit,   DrawDirR	;" "Ŗ߂
		AddYYA8		fLcdOrgY, #cFAsciiSizeY				;1sYWi߂
		;
		ret
		;
DmSmContr:	;---------------------------------------;Tuj[`FRgXgݒ
		;					;  fLcdOrgYݒ肵Ă
		DrawKanji	0000d,    cInherit, 08140h,    cFCMenuNrm, cBCMenuNrm, DrawDirR	;"@"`
		DrawKanji	cInherit, cInherit, 084a4h,    cFCMenuSel, cBCMenuSel, DrawDirR	;""`
		DrawAscii	cInherit, cInherit, #" ",      cInherit,   cInherit,   DrawDirR	;" "`
		DrawByte2dZs	cInherit, cInherit, fLcdContr, cInherit,   cInherit,   DrawDirR	;LCDRgXg(0..63)`
		DrawSpaces	cInherit, cInherit, #011d,     cInherit,   cInherit,   DrawDirR	;" "Ŗ߂
		AddYYA8		fLcdOrgY, #cFAsciiSizeY				;1sYWi߂
		;
		ret
		;
DmSmSearch:	;---------------------------------------;Tuj[` : I[gT[`
		ret
		;
DmSmManual:	;---------------------------------------;Tuj[` : }jAI
		;					;  fLcdOrgYݒ肵Ă
		push		ACC
		push		B
		;
		DrawKanji	0000d,    cInherit, 084a0h, cFCMenuNrm, cBCMenuNrm, DrawDirR	;""`
		DrawKanji	cInherit, cInherit, 084a4h, cFCMenuSel, cBCMenuSel, DrawDirR	;""`
		DrawAscii	cInherit, cInherit, #" ", cInherit, cInherit, DrawDirR	;" "`
		;
		mov		A, fFreqTableIdx				;A : ge[uCfbNX
		mov		B, #010d					;B : 10
		div		AB						;ge[uCfbNX / 10
		push		B						;ꎞޔ
		add		A, #076d					;76MHz̃ItZbgZ
		mov		B, #010d					;B : 10
		div		AB						; / 10
		add		A, #030h					;lASCIIɕϊ
		DrawAscii	cInherit, cInherit, A,    cInherit, cInherit, DrawDirR	;10̈ʕ`
		mov		A, B						;A : 1̈
		add		A, #030h					;lASCIIɕϊ
		DrawAscii	cInherit, cInherit, A,    cInherit, cInherit, DrawDirR	;1̈ʕ`
		DrawAscii	cInherit, cInherit, #".", cInherit, cInherit, DrawDirR	;_`
		pop		ACC						;A : 
		add		A, #030h					;lASCIIɕϊ
		DrawAscii	cInherit, cInherit, A,    cInherit, cInherit, DrawDirR	;`
		DrawConstStr	cInherit, cInherit, cInherit, cInherit, StrMhz, DrawDirR	;"MHz"`
		DrawSpaces	cInherit, cInherit, #006d, cInherit, cInherit, DrawDirR	;" "Ŗ߂
		AddYYA8		fLcdOrgY, #cFAsciiSizeY				;1sYWi߂
		;
		pop		B
		pop		ACC
		ret
		;
DrawStatFrame:	;---------------------------------------;Xe[^XC̃x[Xg`
		;					;@Xe[^XeDrawStatusŕ`悷
		;
cFC		set		cB0				;OiF
cBC		set		cY7				;wiF
		;
		DrawFill	0000d, 0000d, 0120d, 0020d, cBC			;̈NA
		;
		;							;1sڕ`
		DrawPattern	0000d, 0000d,    0027d, 0010d,    PtnTimpy	;"Timpy"`
		DrawPattern	0056d, cInherit, 0011d, cInherit, PtnSpeaker	;Xs[J}[NA}CiX`
		DrawPattern	0079d, cInherit, 0010d, cInherit, PtnDb		;"dB"`
		DrawPattern	0090d, cInherit, 0005d, cInherit, PtnBattHead	;obe()`
		DrawAscii	0095d, cInherit, #"H",  cFC, cBC, DrawDirR	;"H"`
		DrawPattern	0101d, cInherit, 0002d, cInherit, PtnBattColn	;obe(":")`
		DrawPattern	0109d, cInherit, 0002d, cInherit, PtnBattDp	;obe(".")`
		DrawPattern	0117d, cInherit, 0003d, cInherit, PtnBattTail	;obe(ꑤ)`
		;
		;							;2sڕ`
		DrawAscii	0057d, 0010d,    #"B", cFC, cBC, DrawDirR	;"B"`
		DrawPattern	0071d, cInherit, 0003d, 0010d,   PtnToneC	;g[Rg[Ot`
		DrawAscii	0083d, cInherit, #"T", cFC, cBC, DrawDirR	;"T"`
		DrawPattern	0090d, cInherit, 0005d, cInherit, PtnBattHead	;obe()`
		DrawAscii	0095d, cInherit, #"R", cFC, cBC, DrawDirR	;"R"`
		DrawPattern	0101d, cInherit, 0002d, cInherit, PtnBattColn	;obe(":")`
		DrawPattern	0109d, cInherit, 0002d, cInherit, PtnBattDp	;obe(".")`
		DrawPattern	0117d, cInherit, 0003d, cInherit, PtnBattTail	;obe(ꑤ)`
		;
		ret
		;
DrawStatus:	;---------------------------------------;Xe[^XC̕`
		push		ACC
		push		B
		push		DPH
		push		DPL
		;
cFC		set		cB0				;OiF
cBC		set		cY7				;wiF
		;
		;							;1sڕ`
		;							;vC/~}[N`
		jb		fPlayMode.bPmPlaying, _DrawStatus1		;~łȂ΃Wv
		;
		DrawPattern	0028d, 0000d, 0009d, 0010d, PtnPmStop		;~}[N`
		jmp		_DrawStatus2					;
		;
_DrawStatus1:	DrawPattern	0028d, 0000d, 0009d, 0010d, PtnPmPlay		;vC}[N`
		;
_DrawStatus2:	;							;{[l`
		DrawByte2dZs	0067d, cInherit, fVolume, cFC, cBC, DrawDirR	;{[l`
		;
		;							;g[Rg[ݒl`
		mov		A, fTdaReg1					;A : TDA7463AD WX^ݒl(TuAhX1)
		anl		A, #00000110b					;BASSݒrbg𒊏o
		cjne		A, #00000100b, _DrawStatus5			;High BoostłȂ΃Wv
		;
		DrawPattern	0063d, 0010d, 0008d, 0010d, PtnBassHigh		;BASS High Boost`
		jmp		_DrawStatus7					;
		;
_DrawStatus5:	cjne		A, #00000000b, _DrawStatus6			;Low BoostłȂ΃Wv
		;
		DrawPattern	0063d, 0010d, 0008d, 0010d, PtnBassLow		;BASS Low Boost`
		jmp		_DrawStatus7					;
		;
_DrawStatus6:	;								;Boost Off
		DrawPattern	0063d, 0010d, 0008d, 0010d, PtnBassOff		;BASS Boost Off`
		;
_DrawStatus7:	mov		A, fTdaReg0					;A : TDA7463AD WX^ݒl(TuAhX0)
		anl		A, #00001100b					;TREBLEݒrbg𒊏o
		cjne		A, #00001000b, _DrawStatus8			;High BoostłȂ΃Wv
		;
		DrawPattern	0074d, 0010d, 0008d, 0010d, PtnTrebHigh		;TREBLE High Boost`
		jmp		_DrawStatus10					;
		;
_DrawStatus8:	cjne		A, #00000000b, _DrawStatus9			;Low BoostłȂ΃Wv
		;
		DrawPattern	0074d, 0010d, 0008d, 0010d, PtnTrebLow		;TREBLE Low Boost`
		jmp		_DrawStatus10					;
		;
_DrawStatus9:	;								;Boost Off
		DrawPattern	0074d, 0010d, 0008d, 0010d, PtnTrebOff		;TREBLE Boost Off`
		;
_DrawStatus10:	;							;obed`
		mov		A, fBattVoltageH				;A : wbhtHobed(BCD2)
		swap		A						;ju
		anl		A, #00fh					;4rbgo
		add		A, #030h					;lASCIIɕϊ
		DrawAscii	0103d, 0000d,    A, cFC,      cBC,      DrawDirR	;`
		mov		A, fBattVoltageH				;A : wbhtHobed(BCD2)
		anl		A, #00fh					;4rbgo
		add		A, #030h					;lASCIIɕϊ
		DrawAscii	0111d, cInherit, A, cInherit, cInherit, DrawDirR	;`
		;
		mov		A, fBattVoltageR				;A : Robed(BCD2)
		swap		A						;ju
		anl		A, #00fh					;4rbgo
		add		A, #030h					;lASCIIɕϊ
		DrawAscii	0103d, 0010d,    A, cInherit, cInherit, DrawDirR	;`
		mov		A, fBattVoltageR				;A : Robed(BCD2)
		anl		A, #00fh					;4rbgo
		add		A, #030h					;lASCIIɕϊ
		DrawAscii	0111d, cInherit, A, cInherit, cInherit, DrawDirR	;`
		;
		jnb		fPlayMode.bPmFm, _DrawStatus11			;FM[hłȂ΃Wv
		;
		jmp		_DrawStatus17					;FM[hȂWv
		;
_DrawStatus11:	;							;MP3[h̏ꍇ
		DrawPattern	0038d, 0000d,    0005d,    0010d,    PtnRepeatL	;s[g}[N(L)`
		DrawPattern	0050d, cInherit, cInherit, cInherit, PtnRepeatR	;s[g}[N(R)`
		mov		fLcdFColor, #cFC				;OiFݒ
		mov		fLcdBColor, #cBC				;wiFݒ
		jnb		fRepeatMode.bRmAll, _DrawStatus12		;Sȃs[głȂ΃Wv
		;
		DrawAscii	0044d, cInherit, #"A", cInherit, cInherit, DrawDirR	;"A"`
		jmp		_DrawStatus15					;
		;
_DrawStatus12:	jnb		fRepeatMode.bRmDir, _DrawStatus13		;fBNgs[głȂ΃Wv
		;
		DrawAscii	0044d, cInherit, #"D", cInherit, cInherit, DrawDirR	;"D"`
		jmp		_DrawStatus15					;
		;
_DrawStatus13:	jnb		fRepeatMode.bRmOne, _DrawStatus14		;1ȃs[głȂ΃Wv
		;
		DrawAscii	0044d, cInherit, #"1", cInherit, cInherit, DrawDirR	;"1"`
		jmp		_DrawStatus15					;
		;
_DrawStatus14:	DrawAscii	0044d, cInherit, #"-", cInherit, cInherit, DrawDirR	;"-"`
		;
_DrawStatus15:	DrawConstStr	0001d, 0010d, cFC, cBC, StrTrack, DrawDirR	;"Track:"`
		DrawByte3d	0037d, cInherit, fFileNo, cInherit, cInherit, DrawDirR	;Đ̃t@Cԍ`
		jmp		_DrawStatus16					;
		;
_DrawStatus17:	;							;FM[h̏ꍇ
		DrawFill	0038d, 0000d, 0017d, 0010d,    cBC		;s[g[h\NA
		DrawFill	0001d, 0010d, 0016d, cInherit, cBC		;t@Cԍ\NA
		;
		mov		A, fFreqTableIdx				;A : ge[uCfbNX
		mov		B, #010d					;B : 10
		div		AB						;ge[uCfbNX / 10
		push		ACC						;ꎞޔ
		mov		A, B						;A : 
		add		A, #030h					;lASCIIɕϊ
		DrawAscii	0031d, 0010d, A, cFC, cBC, DrawDirR		;`
		DrawPattern	0029d, cInherit, 0002d, 0010d, PtnFreqDp	;_`
		pop		ACC						;A : 
		add		A, #076d					;76MHz̃ItZbgZ
		mov		B, #010d					;B : 10
		div		AB						; / 10
		add		A, #030h					;lASCIIɕϊ
		DrawAscii	0017d, cInherit, A, cInherit, cInherit, DrawDirR	;10̈ʕ`
		mov		A, B						;A : 1̈
		add		A, #030h					;lASCIIɕϊ
		DrawAscii	0023d, cInherit, A, cInherit, cInherit, DrawDirR	;1̈ʕ`
		;
		DrawConstStr	0037d, cInherit, cInherit, cInherit, StrMhz, DrawDirR	;"MHz"`
		;
_DrawStatus16:	pop		DPL
		pop		DPH
		pop		B
		pop		ACC
		ret
		;
SubWrLcdComStr:	;---------------------------------------;R}hAp[^s
		;					;@WrLcdComStr}NɂR[
		;					;  DPTR : R}hAp[^擪AhX
		push		ACC
		push		B
		;
		;							;p[^̃oCg
		clr		A						;ANA
		movc		A, @A + DPTR					;A : p[^̃oCg
		inc		DPTR						;|C^XV
		mov		B, ACC						;B : [vJE^
		;
		;							;R}hCg
		clr		A						;ANA
		movc		A, @A + DPTR					;A : R}h
		inc		DPTR						;|C^XV
		WriteLcd	0, ACC						;R}hCg
		;
		;							;p[^Cg
_SubWrLcdComS1:	mov		A, B						;A : [vJE^
		jz		_SubWrLcdComS0					;[vJE^ = 0ȂI
		;
		clr		A						;ANA
		movc		A, @A + DPTR					;A : p[^
		inc		DPTR						;|C^XV
		WriteLcd	1, ACC						;p[^Cg
		dec		B						;[vJE^XV
		jmp		_SubWrLcdComS1					;̃p[^փ[v
		;
_SubWrLcdComS0:	pop		B
		pop		ACC
		ret
		;
SubLcdFill:	;---------------------------------------;`̈tB
		;					;@DrawFill}NɂR[
		push		ACC
		push		PSW
		SelectRegBank	rbSubLcd					;WX^oNؑ
		;
		;							;RAM Setting
		WriteLcd	0, #015h					;CASETR}h
		mov		A, fLcdOrgX					;A : `挴_XW
		add		A, #012d					;ۂXAhXɑ΂ItZbg
		WriteLcd	1, A						;P1
		add		A, fLcdSizeX					;XTCYZ
		dec		A						;A : A - 1
		WriteLcd	1, A						;P2
		;
		WriteLcd	0, #075h					;PASETR}h
		WriteLcd	1, fLcdOrgY					;P1 : `挴_YW
		mov		A, fLcdOrgY					;A : P1
		add		A, fLcdSizeY					;YTCYZ
		dec		A						;A : A - 1
		WriteLcd	1, A						;P2
		;
		;							;`
		WriteLcd	0, #05ch					;RAMWRR}h
		mov		fYCtr, #0					;YJE^
_SubLcdFill2:	mov		fXCtr, #0					;XJE^
_SubLcdFill3:	WriteLcd	1, fLcdFColor					;LCDփf[^]
		inc		fXCtr						;XJE^XV
		mov		A, fXCtr					;A : XJE^
		cjne		A, fLcdSizeX, _SubLcdFill3			;XTCYȂ烋[v
		;
		inc		fYCtr						;YJE^XV
		mov		A, fYCtr					;A : YJE^
		cjne		A, fLcdSizeY, _SubLcdFill2			;YTCYȂ烋[v
		;
		pop		PSW
		pop		ACC
		ret
		;
SubLcdPattern:	;---------------------------------------;p^[\
		;					;@DrawPattern}NɂR[
		push		ACC
		push		PSW
		push		DPH
		push		DPL
		SelectRegBank	rbSubLcd					;WX^oNؑ
		;
		;							;RAM Setting
		WriteLcd	0, #015h					;CASETR}h
		mov		A, fLcdOrgX					;A : `挴_XW
		add		A, #012d					;ۂXAhXɑ΂ItZbg
		WriteLcd	1, A						;P1
		add		A, fLcdSizeX					;XTCYZ
		dec		A						;A : A - 1
		WriteLcd	1, A						;P2
		;
		WriteLcd	0, #075h					;PASETR}h
		WriteLcd	1, fLcdOrgY					;P1 : `挴_YW
		mov		A, fLcdOrgY					;A : P1
		add		A, fLcdSizeY					;YTCYZ
		dec		A						;A : A - 1
		WriteLcd	1, A						;P2
		;
		;							;`
		mov		DPH, fLcdPtnAdrH				;DPH : `p^[擪AhX(H)
		mov		DPL, fLcdPtnAdrL				;DPL : `p^[擪AhX(L)
		WriteLcd	0, #05ch					;RAMWRR}h
		mov		fYCtr, #0					;YJE^
_SubLcdPtn2:	mov		fXCtr, #0					;XJE^
_SubLcdPtn3:	clr		A						;ANA
		movc		A, @A + DPTR					;A : `f[^
		WriteLcd	1, A						;LCDփf[^]
		inc		DPTR						;`p^[|C^XV
		inc		fXCtr						;XJE^XV
		mov		A, fXCtr					;A : XJE^
		cjne		A, fLcdSizeX, _SubLcdPtn3			;XTCYȂ烋[v
		;
		inc		fYCtr						;YJE^XV
		mov		A, fYCtr					;A : YJE^
		cjne		A, fLcdSizeY, _SubLcdPtn2			;YTCYȂ烋[v
		;
		pop		DPL
		pop		DPH
		pop		PSW
		pop		ACC
		ret
		;
SubLcdAscii:	;---------------------------------------;p1\
		;					;@DrawAscii}NɂR[
		push		ACC
		push		PSW
		push		B
		SelectRegBank	rbSubLcd					;WX^oNؑ
		;
		jnb		fLcdMode.bLmDirU, _SubLcdAscii1			;E֕`ȂWv
		;
		jmp		_SubLcdAscii7					;֕`փWv
		;
_SubLcdAscii1:	;							;E֕`
		;							;RAM Setting
		WriteLcd	0, #015h					;CASETR}h
		mov		A, fLcdOrgX					;A : `挴_XW
		add		A, #012d					;ۂXAhXɑ΂ItZbg
		WriteLcd	1, A						;P1
		add		A, #cFAsciiSizeX - 1				;(XTCY - 1)Z
		WriteLcd	1, A						;P2
		;
		WriteLcd	0, #075h					;PASETR}h
		WriteLcd	1, fLcdOrgY					;P1 : `挴_YW
		mov		A, fLcdOrgY					;A : P1
		add		A, #cFAsciiSizeY - 1				;(YTCY - 1)Z
		WriteLcd	1, A						;P2
		jmp		_SubLcdAscii4					;
		;
_SubLcdAscii7:	;							;֕`
		;							;AhXXLPageɐݒ
		WriteLcd	0, #0bch					;DATCTLR}h
		WriteLcd	1, #00000111b					;P1
		WriteLcd	1, #00000001b					;P2
		WriteLcd	1, #00000001b					;P3
		;
		;							;RAM Setting
		WriteLcd	0, #015h					;CASETR}h
		mov		A, fLcdOrgX					;A : `挴_XW
		add		A, #012d					;ۂXAhXɑ΂ItZbg
		WriteLcd	1, A						;P1
		add		A, #cFAsciiSizeY - 1				;(YTCY - 1)Z
		WriteLcd	1, A						;P2
		;
		push		fLcdOrgY					;`挴_YWޔ
		mov		A, #0168d					;A : 168
		clr		C						;CNA
		subb		A, fLcdOrgY					;A : 168 - `挴_YW
		mov		fLcdOrgY, A					;fLcdOrgYXV
		;
		WriteLcd	0, #075h					;PASETR}h
		WriteLcd	1, fLcdOrgY					;P1 : `挴_YW
		mov		A, fLcdOrgY					;A : P1
		add		A, #cFAsciiSizeX - 1				;(XTCY - 1)Z
		WriteLcd	1, A						;P2
		;
_SubLcdAscii4:	;							;tHgrbg}bvAhX̌vZ
		mov		A, fLcdSJisL					;ASCIIR[h
		mov		B, #cFAsciiSizeY				;YTCY = 1̃oCg
		mul		AB						;
		mov		fFontPtrH, #0					;rbg}bvAhX(H)ݒ
		mov		fFontPtrM, B					;rbg}bvAhX(M)ݒ
		mov		fFontPtrL, A					;rbg}bvAhX(L)ݒ
		AddYYA24	fFontPtrH, fFontPtrM, fFontPtrL, #cFAsciiBmpTopH, #cFAsciiBmpTopM, #cFAsciiBmpTopL	;EEPROM̃rbg}bv擪AhXZ
		;
		;							;tHgrbg}bv[h
		mov		A, fFontPtrH					;A : rbg}bvAhX(H)
		rl		A						;1rbgVtg
		orl		A, #10100000b					;foCXAhXݒ
		anl		A, #11111110b					;R/WrbgCg[hɐݒ
		mov		fFontPtrH, A					;fFontPtrHXV
		;
		TxSmbSta							;X^[gRfBV
		TxSmbData	fFontPtrH					;foCXAhXACg[hM
		TxSmbData	fFontPtrM					;rbg}bvAhX(M)M
		TxSmbData	fFontPtrL					;rbg}bvAhX(L)M
		;
		orl		fFontPtrH, #00000001b				;R/Wrbg[h[hɐݒ
		TxSmbSta							;X^[gRfBV
		TxSmbData	fFontPtrH					;foCXAhXA[h[hM
		;
		;							;rbg}bv[hA`
		WriteLcd	0, #05ch					;RAMWRR}h
		mov		fYCtr, #0					;YJE^
_SubLcdAscii2:	mov		fXCtr, #0					;XJE^
		RxSmbData	ResACK						;f[^[h
		mov		fFontBmpL, SMB0DAT				;tHgrbg}bv(L)XV
_SubLcdAscii3:	mov		A, fFontBmpL					;A : tHgrbg}bv
		rlc		A						;C : rbg}bvMSB
		mov		fFontBmpL, A					;tHgrbg}bvXV
		mov		A, fLcdBColor					;A : wiFɐݒ
		jnc		_SubLcdAscii5					;rbg}bv0ȂWv
		;
		mov		A, fLcdFColor					;A : OiF
_SubLcdAscii5:	WriteLcd	1, A						;LCDփf[^]
		inc		fXCtr						;XJE^XV
		cjne		fXCtr, #cFAsciiSizeX, _SubLcdAscii3		;XTCYȂ烋[v
		;
		inc		fYCtr						;YJE^XV
		cjne		fYCtr, #cFAsciiSizeY, _SubLcdAscii2		;YTCYȂ烋[v
		;
		RxSmbData	ResNACK						;_~[[h
		TxSmbSto							;XgbvRfBV
		;
		jb		fLcdMode.bLmDirU, _SubLcdAscii6			;֕`ȂWv
		;
		;							;E֕`
		;							;`挴_XW1E֐i߂
		mov		A, fLcdOrgX					;A : `挴_XW
		add		A, #cFAsciiSizeX				;1Z
		mov		fLcdOrgX, A					;fLcdOrgXXV
		jmp		_SubLcdAscii0					;
		;
_SubLcdAscii6:	;							;֕`
		;							;`挴_YW1E֐i߂
		pop		fLcdOrgY					;`挴_YW𕜋A
		mov		A, fLcdOrgY					;A : `挴_YW
		clr		C						;CNA
		subb		A, #cFAsciiSizeX				;1Z
		mov		fLcdOrgY, A					;fLcdOrgYXV
		;
		;							;AhXXLColumnɖ߂
		WriteLcd	0, #0bch					;DATCTLR}h
		WriteLcd	1, #00000010b					;P1
		WriteLcd	1, #00000001b					;P2
		WriteLcd	1, #00000001b					;P3
		;
_SubLcdAscii0:	pop		B
		pop		PSW
		pop		ACC
		ret
		;
SubLcdKanji:	;---------------------------------------;Sp1\
		;					;@DrawKanji}NɂR[
		push		ACC
		push		PSW
		push		B
		SelectRegBank	rbSubLcd					;WX^oNؑ
		;
		jnb		fLcdMode.bLmDirU, _SubLcdKanji1			;E֕`ȂWv
		;
		jmp		_SubLcdKanji7					;֕`փWv
		;
_SubLcdKanji1:	;							;E֕`
		;							;RAM Setting
		WriteLcd	0, #015h					;CASETR}h
		mov		A, fLcdOrgX					;A : `挴_XW
		add		A, #012d					;ۂXAhXɑ΂ItZbg
		WriteLcd	1, A						;P1
		add		A, #cFKanjiSizeX - 1				;(XTCY - 1)Z
		WriteLcd	1, A						;P2
		;
		WriteLcd	0, #075h					;PASETR}h
		WriteLcd	1, fLcdOrgY					;P1 : `挴_YW
		mov		A, fLcdOrgY					;A : P1
		add		A, #cFKanjiSizeY - 1				;(YTCY - 1)Z
		WriteLcd	1, A						;P2
		jmp		_SubLcdKanji4					;
		;
_SubLcdKanji7:	;							;֕`
		;							;AhXXLPageɐݒ
		WriteLcd	0, #0bch					;DATCTLR}h
		WriteLcd	1, #00000111b					;P1
		WriteLcd	1, #00000001b					;P2
		WriteLcd	1, #00000001b					;P3
		;
		;							;RAM Setting
		WriteLcd	0, #015h					;CASETR}h
		mov		A, fLcdOrgX					;A : `挴_XW
		add		A, #012d					;ۂXAhXɑ΂ItZbg
		WriteLcd	1, A						;P1
		add		A, #cFKanjiSizeY - 1				;(YTCY - 1)Z
		WriteLcd	1, A						;P2
		;
		push		fLcdOrgY					;`挴_YWޔ
		mov		A, #0168d					;A : 168
		clr		C						;CNA
		subb		A, fLcdOrgY					;A : 168 - `挴_YW
		mov		fLcdOrgY, A					;fLcdOrgYXV
		;
		WriteLcd	0, #075h					;PASETR}h
		WriteLcd	1, fLcdOrgY					;P1 : `挴_YW
		mov		A, fLcdOrgY					;A : P1
		add		A, #cFKanjiSizeX - 1				;(XTCY - 1)Z
		WriteLcd	1, A						;P2
		;
_SubLcdKanji4:	;							;tHgCfbNX[h
		SubYAB16	fFontPtrM, fFontPtrL, fLcdSJisH, fLcdSJisL, #cFKanjiCodeOfsH, #cFKanjiCodeOfsL	;Shift-JISR[hItZbgZ
		mov		fFontPtrH, #0					;CfbNXAhX(H)ݒ
		ShiftL24	fFontPtrH, fFontPtrM, fFontPtrL			;[hAhXɂ邽߂2{
		AddYYA24	fFontPtrH, fFontPtrM, fFontPtrL, #cFKanjiIdxTopH, #cFKanjiIdxTopM, #cFKanjiIdxTopL	;EEPROM̃CfbNX擪AhXZ
		mov		A, fFontPtrH					;A : CfbNXAhX(H)
		rl		A						;1rbgVtg
		orl		A, #10100000b					;foCXAhXݒ
		anl		A, #11111110b					;R/WrbgCg[hɐݒ
		mov		fFontPtrH, A					;fFontPtrHXV
		;
		TxSmbSta							;X^[gRfBV
		TxSmbData	fFontPtrH					;foCXAhXACg[hM
		TxSmbData	fFontPtrM					;CfbNXAhX(M)M
		TxSmbData	fFontPtrL					;CfbNXAhX(L)M
		;
		orl		fFontPtrH, #00000001b				;R/Wrbg[h[hɐݒ
		TxSmbSta							;X^[gRfBV
		TxSmbData	fFontPtrH					;foCXAhXA[h[hM
		RxSmbData	ResACK						;f[^[h
		mov		fFontPtrL, SMB0DAT				;tHgrbg}bvւ̃|C^(L)
		RxSmbData	ResNACK						;f[^[h
		mov		fFontPtrM, SMB0DAT				;tHgrbg}bvւ̃|C^(M)
		TxSmbSto							;XgbvRfBV
		;
		;							;tHgrbg}bvAhX̌vZ
		mov		A, fFontPtrM					;tHgrbg}bvւ̃|C^(M)
		mov		B, #cFKanjiSizeY * 2				;YTCY * 2 = 1̃oCg
		mul		AB						;
		mov		fFontPtrH, B					;rbg}bvAhX(H)ݒ
		mov		fFontPtrM, A					;rbg}bvAhX(M)ݒ
		;
		mov		A, fFontPtrL					;tHgrbg}bvւ̃|C^(L)
		mov		B, #cFKanjiSizeY * 2				;YTCY * 2 = 1̃oCg
		mul		AB						;
		mov		fFontPtrL, A					;rbg}bvAhX(M)ݒ
		AddYYA16	fFontPtrH, fFontPtrM, #0, B			;ςZ
		;
		AddYYA24	fFontPtrH, fFontPtrM, fFontPtrL, #cFKanjiBmpTopH, #cFKanjiBmpTopM, #cFKanjiBmpTopL	;EEPROM̃rbg}bv擪AhXZ
		;
		;							;tHgrbg}bv[h
		mov		A, fFontPtrH					;A : rbg}bvAhX(H)
		rl		A						;1rbgVtg
		orl		A, #10100000b					;foCXAhXݒ
		anl		A, #11111110b					;R/WrbgCg[hɐݒ
		mov		fFontPtrH, A					;fFontPtrHXV
		;
		TxSmbSta							;X^[gRfBV
		TxSmbData	fFontPtrH					;foCXAhXACg[hM
		TxSmbData	fFontPtrM					;rbg}bvAhX(M)M
		TxSmbData	fFontPtrL					;rbg}bvAhX(L)M
		;
		orl		fFontPtrH, #00000001b				;R/Wrbg[h[hɐݒ
		TxSmbSta							;X^[gRfBV
		TxSmbData	fFontPtrH					;foCXAhXA[h[hM
		;
		;							;rbg}bv[hA`
		WriteLcd	0, #05ch					;RAMWRR}h
		mov		fYCtr, #0					;YJE^
_SubLcdKanji2:	mov		fXCtr, #0					;XJE^
		RxSmbData	ResACK						;f[^[h
		mov		fFontBmpH, SMB0DAT				;tHgrbg}bv(H)XV
		RxSmbData	ResACK						;f[^[h
		mov		fFontBmpL, SMB0DAT				;tHgrbg}bv(L)XV
_SubLcdKanji3:	mov		A, fFontBmpL					;A : tHgrbg}bv(L)
		rlc		A						;C : rbg}bv(L)MSB
		mov		fFontBmpL, A					;tHgrbg}bv(L)XV
		mov		A, fFontBmpH					;A : tHgrbg}bv(H)
		rlc		A						;C : rbg}bv(H)MSB
		mov		fFontBmpH, A					;tHgrbg}bv(H)XV
		mov		A, fLcdBColor					;A : wiFɐݒ
		jnc		_SubLcdKanji5					;rbg}bv0ȂWv
		;
		mov		A, fLcdFColor					;A : OiF
_SubLcdKanji5:	WriteLcd	1, A						;LCDփf[^]
		inc		fXCtr						;XJE^XV
		cjne		fXCtr, #cFKanjiSizeX, _SubLcdKanji3		;XTCYȂ烋[v
		;
		inc		fYCtr						;YJE^XV
		cjne		fYCtr, #cFKanjiSizeY, _SubLcdKanji2		;YTCYȂ烋[v
		;
		RxSmbData	ResNACK						;_~[[h
		TxSmbSto							;XgbvRfBV
		;
		jb		fLcdMode.bLmDirU, _SubLcdKanji6			;֕`ȂWv
		;
		;							;E֕`
		;							;`挴_XW1E֐i߂
		mov		A, fLcdOrgX					;A : `挴_XW
		add		A, #cFKanjiSizeX				;1Z
		mov		fLcdOrgX, A					;fLcdOrgXXV
		jmp		_SubLcdKanji0					;
		;
_SubLcdKanji6:	;							;֕`
		;							;`挴_YW1E֐i߂
		pop		fLcdOrgY					;`挴_YW𕜋A
		mov		A, fLcdOrgY					;A : `挴_YW
		clr		C						;CNA
		subb		A, #cFKanjiSizeX				;1Z
		mov		fLcdOrgY, A					;fLcdOrgYXV
		;
		;							;AhXXLColumnɖ߂
		WriteLcd	0, #0bch					;DATCTLR}h
		WriteLcd	1, #00000010b					;P1
		WriteLcd	1, #00000001b					;P2
		WriteLcd	1, #00000001b					;P3
		;
_SubLcdKanji0:	pop		B
		pop		PSW
		pop		ACC
		ret
		;
SubLcdStrOnX:	;---------------------------------------;Of[^̕\
		;					;@DrawXdataStr}NɂR[
		push		ACC
		push		PSW
		push		DPH
		push		DPL
		SelectRegBank	rbSubLcd					;WX^oNؑ
		;
		mov		DPH, fLcdStrAdrH				;
		mov		DPL, fLcdStrAdrL				;f[^|C^
		;
		;							;1Ƃ̏[v
_SubLcdString1:	movx		A, @DPTR					;A : f[^
		inc		DPTR						;f[^|C^ + 1
		jz		_SubLcdString0					;NULLȂI
		;
		jb		ACC.7, _SubLcdString2				;R[h > 80hȂSp
		;
		;							;p\
		mov		fLcdSJisL, A					;Shift-JISR[h(L) : R[h
		call		SubLcdAscii					;p1\
		jmp		_SubLcdString1					;̕
		;
_SubLcdString2:	;							;Sp\
		mov		fLcdSJisH, A					;Shift-JISR[h(H)ݒ
		movx		A, @DPTR					;A : f[^
		inc		DPTR						;f[^|C^ + 1
		mov		fLcdSJisL, A					;Shift-JISR[h(L)ݒ
		call		SubLcdKanji					;Sp1\
		jmp		_SubLcdString1					;̕
		;
_SubLcdString0:	pop		DPL
		pop		DPH
		pop		PSW
		pop		ACC
		ret
		;
SubLcdStrOnC:	;---------------------------------------;vO̕\
		;					;@DrawConstStr}NɂR[
		push		ACC
		push		PSW
		push		DPH
		push		DPL
		SelectRegBank	rbSubLcd					;WX^oNؑ
		;
		mov		DPH, fLcdStrAdrH				;
		mov		DPL, fLcdStrAdrL				;f[^|C^
		;
		;							;1Ƃ̏[v
_SubLcdStrOnC1:	clr		A						;ANA
		movc		A, @A + DPTR					;A : f[^
		inc		DPTR						;f[^|C^ + 1
		jz		_SubLcdStrOnC0					;NULLȂI
		;
		jb		ACC.7, _SubLcdStrOnC2				;R[h > 80hȂSp
		;
		;							;p\
		mov		fLcdSJisL, A					;Shift-JISR[h(L) : R[h
		call		SubLcdAscii					;p1\
		jmp		_SubLcdStrOnC1					;̕
		;
_SubLcdStrOnC2:	;							;Sp\
		mov		fLcdSJisH, A					;Shift-JISR[h(H)ݒ
		clr		A						;ANA
		movc		A, @A + DPTR					;A : f[^
		inc		DPTR						;f[^|C^ + 1
		mov		fLcdSJisL, A					;Shift-JISR[h(L)ݒ
		call		SubLcdKanji					;Sp1\
		jmp		_SubLcdStrOnC1					;̕
		;
_SubLcdStrOnC0:	pop		DPL
		pop		DPH
		pop		PSW
		pop		ACC
		ret
		;
TxIrCommand:	;---------------------------------------;ԊOʐM@R}hM
		;					;@fIrTxCom : R}hAfIrTxPrm : p[^
		push		ACC
		push		PSW
		SelectRegBank	rbIsrUart0					;WX^oNؑ
		clr		EA						;O[o荞݋֎~
		;
		mov		EMI0CN, #HIGH cIrTxBuffer			;EMI0CN𑗐Mobt@̈ɐݒ
		mov		fIrTxDataPtr, #LOW cIrTxBuffer			;Mobt@f[^|C^
		;
		mov		A, #cIrStartCode				;A : X^[gR[h
		movx		@fIrTxDataPtr, A				;Mf[^obt@֓]
		mov		fIrCheckSum, A					;`FbNT
		inc		fIrTxDataPtr					;Mobt@f[^|C^XV
		;
		mov		A, fIrTxCom					;A : R}h
		movx		@fIrTxDataPtr, A				;Mf[^obt@֓]
		add		A, fIrCheckSum					;`FbNTvZ
		mov		fIrCheckSum, A					;`FbNTXV
		inc		fIrTxDataPtr					;Mobt@f[^|C^XV
		;
		mov		A, fIrTxPrm					;A : p[^
		movx		@fIrTxDataPtr, A				;Mf[^obt@֓]
		add		A, fIrCheckSum					;`FbNTvZ
		mov		fIrCheckSum, A					;`FbNTXV
		inc		fIrTxDataPtr					;Mobt@f[^|C^XV
		;
		clr		C						;CNA
		clr		A						;A : 0
		subb		A, fIrCheckSum					;A : 0 - `FbNT
		movx		@fIrTxDataPtr, A				;`FbNTobt@֓]
		mov		fIrTxBytes, #004d				;ԊOMf[^oCg
		mov		fIrMode, #0					;ԊOʐM[hStONA
		setb		fIrMode.bImTxReq				;MJnvtOZbg
		;
		setb		EA						;O[o荞݋
		pop		PSW
		pop		ACC
		ret
		;
SubIrCommand:	;---------------------------------------;ԊOʐM@R}hs
		;					;@R}hMA{̂̃X|X҂BMG[ȂđvB
		;					;@I͎MA܂̓^CAEgB{̂rW[̏ꍇ̓^CAEgƂ݂ȂďIB
		;					;@fIrTxCom : R}hAfIrTxPrm : p[^
		push		ACC
		push		PSW
		push		DPH
		push		DPL
		;
		call		TxIrCommand					;R}hM
		;
		;							;I`FbN
_SubIrCommand1:	jb		fIrMode.bImRxDataReady, _SubIrCommand2		;MtOZbgȂWv
		;
		jb		fIrMode.bImRxTimeout, _SubIrCommand3		;M^CAEgtOZbgȂWv
		;
		jb		fIrMode.bImRxError, _SubIrCommand4		;Mf[^G[tOZbgȂWv
		;
		jmp		_SubIrCommand1					;[v
		;
_SubIrCommand4:	;							;Mf[^G[
		mov		A, #0100d					;A : 100
		call		WaitAmsec					;Amsec҂
		mov		fIrTxCom, #cIRComResend				;ÕpPbgđR}h
		mov		fIrTxPrm, #0					;p[^
		call		TxIrCommand					;R}hM
		;
		DrawPattern	0028d, 0000d, 0009d, 0010d, PtnIrError		;ԊOʐMG[`
		jmp		_SubIrCommand1					;[v
		;
_SubIrCommand3:	;							;M^CAEg
		clr		fIrMode.bImActive				;ʐMtONA
		DrawPattern	0028d, 0000d, 0009d, 0010d, PtnIrTimOut		;ԊOʐM^CAEg`
		jmp		_SubIrCommand0					;I
		;
_SubIrCommand2:	;							;M
		clr		fIrMode.bImActive				;ʐMtONA
		mov		DPTR, #cIrRxBuffer + 2				;DPTR : Mobt@̈̐擪AhX + 2
		movx		A, @DPTR					;A : {̂̃Xe[^X
		cjne		A, #cIrAck, _SubIrCommand5			;ACKłȂ΃Wv
		;
		;							;ACKM@R}hs
		jmp		_SubIrCommand0					;I
		;
_SubIrCommand5:	;							;M͐IACKłȂꍇ
		clr		fIrMode.bImRxDataReady				;MtONA
		setb		fIrMode.bImRxTimeout				;M^CAEgƂ݂Ȃ
		;
_SubIrCommand0:	pop		DPL
		pop		DPH
		pop		PSW
		pop		ACC
		ret
		;
OnFatalError:	;---------------------------------------;vIG[
		jmp		ShutDown				;Vbg_E
		;
ShutDown:	;---------------------------------------;Vbg_E
		clr		EA						;S荞݋֎~
		;jmp		ShutDown					;***** DEBUG *****
		;
		mov		P0, #00110000b					;pEncoder2, pEncoder1, pEncoderPwr, pSwC, pSwB, pSwA"L"
		mov		P1, #00111101b					;pLcdBlShdn, pIrTxMod, pIrRxPwr"L"
		mov		P2, #11111111b					;pLcdD7..0"H"
		mov		P3, #11101111b					;pLcdRest"L"
		mov		XBR1, #01000000b				;SytFATC֎~ANXo[Cl[u
		mov		XBR0, #00000000b				;SytFATC֎~
		mov		P0SKIP,  #11111111b				;SsXLbv
		mov		P1SKIP,  #11111111b				;SsXLbv
		mov		P2SKIP,  #00001111b				;SsXLbv
		;
		orl		PCON, #00000010b				;STOPZbgACPU~
		nop								;_~[
		;
		;							;Zzz...
		;
LoadNvParams:	;---------------------------------------;sԕA
		push		ACC
		push		PSW
		SelectRegBank	rbLoadNvParams					;WX^oNؑ
		;
		TxSmbSta							;X^[gRfBV
		TxSmbData	#10100000b + (cNvPrmAreaTopH SHL 1)		;foCXAhXACg[hM
		TxSmbData	#cNvPrmAreaTopM					;[hAhX(M)M
		TxSmbData	#cNvPrmAreaTopL					;[hAhX(L)M
		;
		TxSmbSta							;X^[gRfBV
		TxSmbData	#10100001b + (cNvPrmAreaTopH SHL 1)		;foCXAhXA[h[hM
		;
		mov		fLoadNvPrmsLCtr, #cNvParamEnd - cNvParamTop	;fLoadNvPrmsLCtr : [vJE^
		mov		fLoadNvPrmsDPtr, #cNvParamTop			;fLoadNvPrmsDPtr
		;
_LoadNvParams1:	RxSmbData	ResACK						;f[^[h
		mov		A, SMB0DAT					;A : ^Of[^
		mov		@fLoadNvPrmsDPtr, A				;f[^A
		inc		fLoadNvPrmsDPtr					;fLoadNvPrmsDPtr + 1
		djnz		fLoadNvPrmsLCtr, _LoadNvParams1			;fLoadNvPrmsLCtr - 1A<> 0Ȃ烋[v
		;
		RxSmbData	ResNACK						;_~[[h
		TxSmbSto							;XgbvRfBV
		;
		pop		PSW						;WX^oNA
		pop		ACC
		ret
		;
SaveNvParams:	;---------------------------------------;s֏ԕۑ
		push		ACC
		push		PSW
		SelectRegBank	rbSaveNvParams					;WX^oNؑ
		;
		clr		pEepromWp					;EEPROMCgveNg
		mov		fRomAddrL, #0					;fRomAddrL : MP3^Oz擪AhX(L) = EEPROMCgobt@(XRAM)̉ʃoCg
		TxSmbSta							;X^[gRfBV
		TxSmbData	#10100000b + (cNvPrmAreaTopH SHL 1)		;foCXAhXACg[hM
		TxSmbData	#cNvPrmAreaTopM					;[hAhX(M)M
		TxSmbData	#cNvPrmAreaTopL					;[hAhX(L)M
		;
		mov		fSaveNvPrmsLCtr, #cNvParamEnd - cNvParamTop	;fSaveNvPrmsLCtr : [vJE^
		mov		fSaveNvPrmsDPtr, #cNvParamTop			;fSaveNvPrmsDPtr
		;
_SaveNvParams1:	mov		A, @fSaveNvPrmsDPtr				;A : ۑf[^
		TxSmbData	A						;^Of[^EEPROM֑
		inc		fSaveNvPrmsDPtr					;fSaveNvPrmsDPtr + 1
		djnz		fSaveNvPrmsLCtr, _SaveNvParams1			;fSaveNvPrmsLCtr - 1A<> 0Ȃ烋[v
		;
		TxSmbSto							;XgbvRfBV
		mov		A, 005d						;A : 5
		call		WaitAmsec					;Amsec҂
		setb		pEepromWp					;EEPROMCgveNgݒ
		;
		pop		PSW					;WX^oNA
		pop		ACC
		ret
		;
		;===============================================================
		;	Interrupt Service Routines
		;
IsrInt0:	;---------------------------------------;Int0荞ݏ : GR[_ʌv
		push		ACC
		push		PSW
		;
		mov		A, IT01CF					;A : IT01CF
		anl		A, #00001000b					;IN0PLrbgo
		jnz		_IsrInt02					;Int0"H"ANeBuȂWv
		;
		;							;Int0"L"ANeBȕꍇ
		jnb		pEncoder2, _IsrInt01				;pEncoder2NAȂWv
		;
		inc		fEncoderCtr					;GR[_ + 1
		jmp		_IsrInt00					;I
		;
_IsrInt01:	dec		fEncoderCtr					;GR[_ - 1
		jmp		_IsrInt00					;I
		;
_IsrInt02:	;							;Int0"H"ANeBȕꍇ
		jb		pEncoder2, _IsrInt03				;pEncoder2ZbgȂWv
		;
		inc		fEncoderCtr					;GR[_ + 1
		jmp		_IsrInt00					;I
		;
_IsrInt03:	dec		fEncoderCtr					;GR[_ - 1
		;
_IsrInt00:	xrl		IT01CF, #00001000b			;Int0ANeBux𔽓]
		;
		pop		PSW
		pop		ACC
		reti
		;
IsrUart0:	;---------------------------------------;UART0荞ݏ : ԊOʐM
		push		ACC
		push		PSW
		SelectRegBank	rbIsrUart0					;WX^oNؑ
		;
		jb		fIrMode.bImTx, _IsrUart0Tx			;MȂ瑗M
		;
		jb		fIrMode.bImRx, _IsrUart0Rx			;MȂM
		;
		clr		TI0						;TINA
		clr		RI0						;RINA
		jmp		_IsrUart00					;I
		;
_IsrUart0Tx:	;							;M
		clr		RI0						;RI𖳏ɃNA
		jnb		TI0, _IsrUart00					;TINAȂI
		;
		clr		TI0						;TINA
		mov		A, fIrTxRemain					;A : MoCg
		jz		_IsrUart0Tx1					;c0Ȃ瑗M
		;
		;							;1oCgM
		mov		EMI0CN, #HIGH cIrTxBuffer			;EMI0CN𑗐Mobt@̈ɐݒ
		movx		A, @fIrTxDataPtr				;A : Mf[^
		mov		SBUF0, A					;M
		inc		fIrTxDataPtr					;Mobt@f[^|C^XV
		dec		fIrTxRemain					;MoCgXV
		jmp		_IsrUart00					;I
		;
_IsrUart0Tx1:	;							;M
		clr		fIrMode.bImTx					;MtONA
		setb		fIrMode.bImRxInterval				;MJnC^[otOZbg
		setb		pIrRxPwr					;W[dON
		SetUartBaud	Rx						;Mp{[[gɐݒ
		jmp		_IsrUart00					;I
		;
_IsrUart0Rx:	;							;M
		clr		TI0						;TI𖳏ɃNA
		jnb		RI0, _IsrUart00					;RINAȂI
		;
		;							;1oCgM
		clr		RI0						;RINA
		mov		A, SBUF0					;A : Mf[^
		mov		EMI0CN, #HIGH cIrRxBuffer			;EMI0CNMobt@̈ɐݒ
		movx		@fIrRxDataPtr, A				;Mf[^Mobt@֊i[
		add		A, fIrCheckSum					;`FbNTvZ
		mov		fIrCheckSum, A					;`FbNTXV
		inc		fIrRxBytes					;Mf[^oCgXV
		mov		A, fIrRxBytes					;A : Mf[^oCg
		cjne		A, #002d, _IsrUart0Rx1				;Mf[^oCg2łȂ΃Wv
		;
		;							;M\oCg̐ݒ
		movx		A, @fIrRxDataPtr				;A : f[^
		add		A, #003d					;A : f[^ + 3 = M\oCg
		mov		fIrRxExpects, A					;M\oCgXV
		;
_IsrUart0Rx1:	;							;MoCg`FbN
		inc		fIrRxDataPtr					;Mobt@f[^|C^XV
		mov		A, fIrRxExpects					;A : M\oCg
		cjne		A, fIrRxBytes, _IsrUart00			;MoCg\萔ɒBĂȂΏI
		;
		;							;\oCgM
		clr		fIrMode.bImRx					;MtONA
		clr		RI0						;RItONA
		clr		REN0						;M֎~
		clr		pIrRxPwr					;W[dOFF
		mov		A, fIrCheckSum					;A : `FbNT
		jnz		_IsrUart0Rx2					;`FbNTG[ȂWv
		;
		;							;Mf[^tH[}bg`FbN
		setb		fIrMode.bImRxDataReady				;MtOZbg
		jmp		_IsrUart00					;I
		;
_IsrUart0Rx2:	;							;`FbNTG[
		setb		fIrMode.bImRxError				;MG[tOZbg
		jmp		_IsrUart00					;I
		;
_IsrUart00:	;							;I
		mov		fIrInterval, #0					;ԊOf[^C^[oJE^
		;
		pop		PSW
		pop		ACC
		reti
		;
IsrTimer3:	;---------------------------------------;Timer3荞ݏ : [UC^[tF[X
		;					;  fSwStatus*̐邱Ƃɒ
		push		ACC
		push		PSW
		;
		anl		TMR3CN, #01111111b				;TF3HNA
		inc		fUITimerCtr					;Timer3荞݃JE^XV
		;
		jb		fPlayMode.bPmSwUpdate, _IsrTimer3Sw0		;PmSwUpdatetOZbgȂ΍XVXLbv
		;
		mov		fSwStatus0to1, fSwStatus			;fSwStatus0to1fSwStatus̑OlRs[Ă
		mov		fSwStatus1to0, fSwStatus			;fSwStatus1to0fSwStatus̑OlRs[Ă
		mov		C, pSwA						;C : pSwA̍l
		mov		ACC.bSwA, C					;ACC.bSwAXV
		mov		C, pSwB						;C : pSwB̍l
		mov		ACC.bSwB, C					;ACC.bSwBXV
		mov		C, pSwC						;C : pSwC̍l
		mov		ACC.bSwC, C					;ACC.bSwCXV
		cpl		A						;_]Đ_ɂ
		mov		fSwPortSave, A					;fSwPortSaveɈꎞۑ
		xrl		A, fSwPortPrev					;A : Ol xor l
		anl		fSwStatus, A					;fSwStatusɂđOl = l̃rbĝ݃NA
		cpl		A						;A : Ol = l̃rbĝ1
		anl		A, fSwPortSave					;A : fSwPortSaveɂđOl = l̃rbg𒊏o
		orl		A, fSwStatus					;A : fSwStatusɂđOl = l̃rbgXV
		anl		A, #cSwBitMask					;A : XCb`̓rbĝݒo
		mov		fSwStatus, A					;fSwStatusXV
		xrl		fSwStatus0to1, A				;fSwStatus0to1 : fSwStatusɂđOl <> l̃rbĝ1
		anl		fSwStatus0to1, A				;fSwStatus0to1 : ((Ol <> l) and (l = 1))̃rbĝ1
		xrl		fSwStatus1to0, A				;fSwStatus1to0 : fSwStatusɂđOl <> l̃rbĝ1
		cpl		A						;]
		anl		fSwStatus1to0, A				;fSwStatus1to0 : ((Ol <> l) and (l = 0))̃rbĝ1
		mov		fSwPortPrev, fSwPortSave			;fSwPortPrevXV
		setb		fPlayMode.bPmSwUpdate				;PmSwUpdatetOZbg
		;
_IsrTimer3Sw0:	;							;ԊOʐM
		SelectRegBank	rbIsrUart0					;WX^oNؑ
		;
		jb		fIrMode.bImTxReq, _IsrTimer3Ir1			;MJnvtOZbgȂWv
		;
		jnb		fIrMode.bImActive, _IsrTimer3Ir0		;ʐMłȂΏsv
		;
		jb		fIrMode.bImTx, _IsrTimer3Ir0			;MȂ珈sv
		;
		jb		fIrMode.bImRxInterval, _IsrTimer3Ir3		;MJnC^[oȂWv
		;
		jb		fIrMode.bImRx, _IsrTimer3Ir2			;MȂWv
		;
		jmp		_IsrTimer3Ir0					;ԊOʐMI
		;
_IsrTimer3Ir3:	;							;MJn҂
		inc		fIrInterval					;ԊOf[^C^[oJE^XV
		mov		A, #cIrRxInterval				;A : MJnC^[o萔
		cjne		A, fIrInterval, _IsrTimer3Ir0			;MJnłȂΐԊOʐMI
		;
		;							;MJn
		clr		fIrMode.bImRxInterval				;MJnC^[otONA
		setb		fIrMode.bImRx					;MtOZbg
		mov		fIrRxDataPtr, #LOW cIrRxBuffer			;Mobt@f[^|C^
		mov		fIrRxBytes, #0					;Mf[^oCg
		mov		fIrCheckSum, #0					;`FbNT
		mov		fIrRxExpects, #0				;M\oCg
		mov		fIrInterval, #0					;ԊOf[^C^[oJE^
		clr		RI0						;RItONA
		setb		REN0						;M싖
		jmp		_IsrTimer3Ir0					;ԊOʐMI
		;
_IsrTimer3Ir2:	;							;M
		inc		fIrInterval					;ԊOf[^C^[oJE^XV
		mov		A, #cIrRxTimeout				;A : M^CAEg萔
		cjne		A, fIrInterval, _IsrTimer3Ir0			;^CAEgłȂΐԊOʐMI
		;
		;							;M^CAEg
		clr		fIrMode.bImRx					;MtONA
		setb		fIrMode.bImRxTimeout				;M^CAEgtOZbg
		clr		REN0						;M֎~
		jmp		_IsrTimer3Ir0					;ԊOʐMI
		;
_IsrTimer3Ir1:	;							;MJnvoAMJn
		clr		pIrRxPwr					;W[dOFF
		SetUartBaud	Tx						;Mp{[[gɐݒ
		clr		fIrMode.bImTxReq				;MJnvtONA
		setb		fIrMode.bImActive				;ʐMtOZbg
		setb		fIrMode.bImTx					;MtOZbg
		mov		EMI0CN, #HIGH cIrTxBuffer			;EMI0CN𑗐Mobt@̈ɐݒ
		mov		fIrTxDataPtr, #LOW cIrTxBuffer			;Mobt@f[^|C^
		mov		fIrTxRemain, fIrTxBytes				;MoCgԊOMf[^oCgŏ
		mov		fIrInterval, #0					;ԊOf[^C^[oJE^
		clr		TI0						;TINA
		movx		A, @fIrTxDataPtr				;A : Mf[^
		mov		SBUF0, A					;M
		inc		fIrTxDataPtr					;Mobt@f[^|C^XV
		dec		fIrTxRemain					;MoCgXV
		jmp		_IsrTimer3Ir0					;ԊOʐMIփWvAȍ~̑MIsrUart0ɂď
		;
_IsrTimer3Ir0:	;
		pop		PSW
		pop		ACC
		reti
		;
IsrEnd:		;---------------------------------------;荞ݏ[`̖̈
		;
		;===============================================================
		;	Constant Tables
		;
ComStrDISCTL:	;---------------------------------------;LCD DISCTLR}h
		db		003d						;p[^
		db		0cah						;DISCTLR}h
		db		00000000b					;P1
		db		00100111b					;P2
		db		00001010b					;P3
		;
ComStrCOMSCN:	;---------------------------------------;LCD COMSCNR}h
		db		001d						;p[^
		db		0bbh						;COMSCNR}h
		db		00000001b					;P1
		;
ComStrOSCON:	;---------------------------------------;LCD OSCONR}h
		db		000d						;p[^
		db		0d1h						;OSCONR}h
		;
ComStrSLPOUT:	;---------------------------------------;LCD SLPOUTR}h
		db		000d						;p[^
		db		094h						;SLPOUTR}h
		;
ComStrVOLCTR:	;---------------------------------------;LCD VOLCTRR}h
		db		002d						;p[^
		db		081h						;VOLCTRR}h
		db		0037d						;P1
		db		0004d						;P2
		;
ComStrTMPGRD:	;---------------------------------------;LCD TMPGRDR}h
		db		001d						;p[^
		db		082h						;TMPGRDR}h
		db		0000d						;P1
		;
ComStrPWRCTL:	;---------------------------------------;LCD PWRCTLR}h
		db		001d						;p[^
		db		020h						;PWRCTLR}h
		db		00001111b					;P1
		;
ComStrDISNOR:	;---------------------------------------;LCD DISNORR}h
		db		000d						;p[^
		db		0a6h						;DISNORR}h
		;
ComStrDISINV:	;---------------------------------------;LCD DISINVR}h
		db		000d						;p[^
		db		0a7h						;DISINVR}h
		;
ComStrPTLOUT:	;---------------------------------------;LCD PTLOUTR}h
		db		000d						;p[^
		db		0a9h						;PTLOUTR}h
		;
ComStrASCSET:	;---------------------------------------;LCD ASCSETR}h
		db		004d						;p[^
		db		0aah						;ASCSETR}h
		db		0000d						;P1
		db		0039d						;P2
		db		0040d						;P3
		db		00000011b					;P4
		;
ComStrSCSTART:	;---------------------------------------;LCD SCSTARTR}h
		db		001d						;p[^
		db		0abh						;SCSTARTR}h
		db		0000d						;P1
		;
ComStrDATCTL:	;---------------------------------------;LCD DATCTLR}h
		db		003d						;p[^
		db		0bch						;DATCTLR}h
		db		00000010b					;P1
		db		00000001b					;P2
		db		00000001b					;P3
		;
ComStrRGBSET8:	;---------------------------------------;LCD RGBSET8R}h
		db		020d						;p[^
		db		0ceh						;RGBSET8R}h
	if	0
		db		000d						;P1
		db		003d						;P2
		db		005d						;P3
		db		007d						;P4
		db		009d						;P5
		db		011d						;P6
		db		013d						;P7
		db		015d						;P8
		db		000d						;P9
		db		006d						;P10
		db		007d						;P11
		db		008d						;P12
		db		009d						;P13
		db		010d						;P14
		db		012d						;P15
		db		015d						;P16
		db		000d						;P17
		db		006d						;P18
		db		008d						;P19
		db		015d						;P20
	else
		db		NOT 000d					;P1
		db		NOT 003d					;P2
		db		NOT 005d					;P3
		db		NOT 007d					;P4
		db		NOT 009d					;P5
		db		NOT 011d					;P6
		db		NOT 013d					;P7
		db		NOT 015d					;P8
		db		NOT 000d					;P9
		db		NOT 006d					;P10
		db		NOT 007d					;P11
		db		NOT 008d					;P12
		db		NOT 009d					;P13
		db		NOT 010d					;P14
		db		NOT 012d					;P15
		db		NOT 015d					;P16
		db		NOT 000d					;P17
		db		NOT 006d					;P18
		db		NOT 008d					;P19
		db		NOT 015d					;P20
	endif
		;
ComStrDISON:	;---------------------------------------;LCD DISONR}h
		db		000d						;p[^
		db		0afh						;DISONR}h
		;
		;---------------------------------------;LCDp^[f[^ : TimpyS
		;
u		set		cY7
f		set		cR7
r		set		cG7
d		set		cB7
w		set		cW7
i		set		cB0
		;
PtnLogoTimpy:	;								;"Timpy"
		db		w,w,w,w,w,w,w,w,w,w,w,i,i,w,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,w,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,w,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,w,i,i,i,i,i,w,i,i,i,w,w,w,i,i,i,i,i,i,i,w,w,w,i,i,i,w,w,w,w,w,w,i,i,i,i,w,i,i,i,i,i,i,w
		db		i,i,i,i,i,i,i,w,i,i,i,i,i,w,i,i,w,w,i,w,w,i,i,i,i,i,w,w,i,w,w,i,i,w,i,i,i,i,i,w,i,i,i,w,i,i,i,i,i,i,w
		db		i,i,i,i,i,i,i,w,i,i,i,i,i,w,i,i,w,i,i,i,w,i,i,i,i,i,w,i,i,i,w,i,i,w,i,i,i,i,i,i,w,i,i,w,i,i,i,i,i,i,w
		db		i,i,i,i,i,i,i,w,i,i,i,i,i,w,i,i,w,i,i,i,w,w,i,i,i,w,w,i,i,i,w,i,i,w,i,i,i,i,i,i,w,i,i,w,i,i,i,i,i,i,w
		db		i,i,i,i,i,i,i,w,i,i,i,i,i,w,i,i,w,i,i,i,i,w,i,i,i,w,i,i,i,i,w,i,i,w,i,i,i,i,i,i,w,i,i,w,i,i,i,i,i,i,w
		db		i,i,i,i,i,i,i,w,i,i,i,i,i,w,i,i,w,i,i,i,i,w,w,i,w,w,i,i,i,i,w,i,i,w,i,i,i,i,i,i,w,i,i,w,i,i,i,i,i,i,w
		db		i,i,i,i,i,i,i,w,i,i,i,i,i,w,i,i,w,i,i,i,i,i,w,w,w,i,i,i,i,i,w,i,i,w,i,i,i,i,i,w,i,i,i,i,w,i,i,i,i,w,w
		db		i,i,i,i,i,i,i,w,i,i,i,i,i,w,i,i,w,i,i,i,i,i,i,i,i,i,i,i,i,i,w,i,i,w,w,w,w,w,w,i,i,i,i,i,i,w,w,w,w,i,w
		db		i,i,i,i,i,i,i,w,i,i,i,i,i,w,i,i,w,i,i,i,i,i,i,i,i,i,i,i,i,i,w,i,i,w,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,w
		db		i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,w,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,w,i
		db		i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,w,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,w,i
		db		i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,w,i,i,i,i,i,i,i,i,i,i,i,i,i,i,w,i,i
		;
PtnLogoRev:	;								;"Rev. 4.0"
		db		w,w,w,w,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,w,w,i,i,i,i,i,w,w,w,i
		db		w,i,i,i,w,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,w,i,w,i,i,i,i,w,i,i,i,w
		db		w,i,i,i,w,i,i,i,w,w,w,i,i,i,w,i,i,i,w,i,i,i,i,i,i,i,i,i,w,i,i,w,i,i,i,i,w,w,i,i,w
		db		w,i,i,i,w,i,i,w,i,i,i,w,i,i,w,i,i,i,w,i,i,i,i,i,i,i,i,w,i,i,i,w,i,i,i,i,w,i,w,i,w
		db		w,w,w,w,i,i,i,w,w,w,w,i,i,i,i,w,i,w,i,i,i,i,i,i,i,i,i,w,w,w,w,w,w,i,i,i,w,i,i,w,w
		db		w,i,i,w,i,i,i,w,i,i,i,i,i,i,i,w,i,w,i,i,i,i,i,i,i,i,i,i,i,i,i,w,i,i,i,i,w,i,i,i,w
		db		w,i,i,i,w,i,i,i,w,w,w,i,i,i,i,i,w,i,i,i,w,i,i,i,i,i,i,i,i,i,i,w,i,i,w,i,i,w,w,w,i
		;
PtnLogoU:	;								;"U"
		db		i,i,i,i,i,i,i,i,i,i,i,i,u,u,i,i,i,i,i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i,i,i,u,u,u,u,u,u,i,i,i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i,u,u,u,u,u,u,u,u,u,u,i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,u,u,u,u,i,i,u,u,i,i,u,u,u,u,i,i,i,i,i,i
		db		i,i,i,i,u,u,u,u,i,i,i,i,u,u,i,i,i,i,u,u,u,u,i,i,i,i
		db		i,i,u,u,u,u,i,i,i,i,i,i,u,u,i,i,i,i,i,i,u,u,u,u,i,i
		db		u,u,u,u,i,i,i,i,i,i,i,i,u,u,i,i,i,i,i,i,i,i,u,u,u,u
		db		u,u,i,i,i,i,i,i,i,i,i,i,u,u,i,i,i,i,i,i,i,i,i,i,u,u
		;
PtnLogoF:	;								;"F"
		db		f,i,i,i,i,i,i,i,i,i,i
		db		f,f,f,i,i,i,i,i,i,i,i
		db		f,f,f,f,f,i,i,i,i,i,i
		db		f,f,f,f,f,f,f,i,i,i,i
		db		f,f,f,f,f,f,f,f,f,i,i
		db		f,f,f,f,f,f,f,f,f,f,f
		db		f,f,f,f,f,f,f,f,f,i,i
		db		f,f,f,f,f,f,f,i,i,i,i
		db		f,f,f,f,f,i,i,i,i,i,i
		db		f,f,f,i,i,i,i,i,i,i,i
		db		f,i,i,i,i,i,i,i,i,i,i
		;
PtnLogoR:	;								;"R"
		db		r,r,r,r,r,r,r,r,r
		db		r,r,r,r,r,r,r,r,r
		db		r,r,r,r,r,r,r,r,r
		db		r,r,r,r,r,r,r,r,r
		db		r,r,r,r,r,r,r,r,r
		db		r,r,r,r,r,r,r,r,r
		db		r,r,r,r,r,r,r,r,r
		db		r,r,r,r,r,r,r,r,r
		db		r,r,r,r,r,r,r,r,r
		;
PtnLogoD:	;								;"D"
		db		d,d,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,d,d
		db		d,d,d,d,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,d,d,d,d
		db		i,i,d,d,d,d,i,i,i,i,i,i,i,i,i,i,i,i,i,i,d,d,d,d,i,i
		db		i,i,i,i,d,d,d,d,i,i,i,i,i,i,i,i,i,i,d,d,d,d,i,i,i,i
		db		i,i,i,i,i,i,d,d,d,d,i,i,i,i,i,i,d,d,d,d,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i,d,d,d,d,i,i,d,d,d,d,i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i,i,i,d,d,d,d,d,d,i,i,i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i,i,i,i,i,d,d,i,i,i,i,i,i,i,i,i,i,i,i
		;
StrFmTuner:	db		"+ FM Tuner", 0
StrIrRemote:	db		"+ Ir Remote", 0
StrCredit:	db		"Chiaki "
		dw		081f4h
		db		" 2005", 0
StrNowPlaying:	db		"Now playing...", 0
StrTime:	db		"Time [", 0
		;
		;---------------------------------------;LCDp^[f[^ : Xe[^XC
		;
w		set		cB0				;OiF
i		set		cY7				;wiF
y		set		cY4
g		set		cG7
o		set		cO7
r		set		cR7
		;
PtnTimpy:	;								;"Timpy"
		db		i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i
		db		i,w,w,w,w,w,i,w,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i
		db		i,i,i,w,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i
		db		i,i,i,w,i,i,i,w,i,w,w,w,w,i,i,w,w,w,w,i,i,w,i,i,i,w,i
		db		i,i,i,w,i,i,i,w,i,w,i,w,i,w,i,w,i,i,i,w,i,w,i,i,i,w,i
		db		i,i,i,w,i,i,i,w,i,w,i,w,i,w,i,w,i,i,i,w,i,i,w,i,w,i,i
		db		i,i,i,w,i,i,i,w,i,w,i,w,i,w,i,w,i,i,i,w,i,i,w,i,w,i,i
		db		i,i,i,w,i,i,i,w,i,w,i,w,i,w,i,w,w,w,w,i,i,i,i,w,i,i,i
		db		i,i,i,w,i,i,i,w,i,w,i,w,i,w,i,w,i,i,i,i,i,i,i,w,i,i,i
		db		i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,w,i,i,i,i,i,w,w,i,i,i,i
		;
PtnSpeaker:	;								;Xs[J}[NA}CiX
		db		i,i,i,i,i,i,i,i,i,i,i
		db		i,w,w,i,i,i,i,i,i,i,i
		db		i,w,y,w,i,i,i,i,i,i,i
		db		i,w,y,y,w,w,i,i,i,i,i
		db		i,w,y,y,y,w,i,w,w,w,i
		db		i,w,y,y,y,w,i,i,i,i,i
		db		i,w,y,y,w,w,i,i,i,i,i
		db		i,w,y,w,i,i,i,i,i,i,i
		db		i,w,w,i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i,i,i,i
		;
PtnDb:		;---------------------------------------;LCDp^[f[^ : "dB"
		db		i,i,i,i,i,i,i,i,i,i
		db		i,i,i,w,i,w,w,w,i,i
		db		i,i,i,w,i,w,i,i,w,i
		db		i,i,i,w,i,w,i,i,w,i
		db		i,w,w,w,i,w,w,w,i,i
		db		w,i,i,w,i,w,i,i,w,i
		db		w,i,i,w,i,w,i,i,w,i
		db		w,i,i,w,i,w,i,i,w,i
		db		i,w,w,w,i,w,w,w,i,i
		db		i,i,i,i,i,i,i,i,i,i
		;
PtnBattHead:	;---------------------------------------;LCDp^[f[^ : obe()
		db		i,i,i,i,i
		db		i,i,w,w,i
		db		i,i,w,g,i
		db		i,w,w,g,i
		db		i,w,g,g,i
		db		i,w,g,g,i
		db		i,w,w,g,i
		db		i,i,w,g,i
		db		i,i,w,w,i
		db		i,i,i,i,i
		;
PtnBattColn:	;---------------------------------------;LCDp^[f[^ : obe(":")
		db		i,i
		db		i,i
		db		i,i
		db		w,i
		db		i,i
		db		i,i
		db		w,i
		db		i,i
		db		i,i
		db		i,i
		;
PtnBattDp:	;---------------------------------------;LCDp^[f[^ : obe(".")
		db		i,i
		db		i,i
		db		i,i
		db		i,i
		db		i,i
		db		i,i
		db		i,i
		db		i,i
		db		w,i
		db		i,i
		;
PtnBattTail:	;---------------------------------------;LCDp^[f[^ : obe(ꑤ)
		db		i,i,i
		db		w,w,i
		db		g,w,i
		db		g,w,i
		db		g,w,i
		db		g,w,i
		db		g,w,i
		db		g,w,i
		db		w,w,i
		db		i,i,i
		;
PtnToneC:	;---------------------------------------;LCDp^[f[^ : g[Rg[Ot`
		db		i,i,i
		db		i,i,i
		db		i,i,i
		db		i,i,i
		db		i,i,i
		db		i,i,i
		db		i,i,i
		db		i,i,i
		db		w,w,w
		db		i,i,i
		;
PtnPmStop:	;---------------------------------------;LCDp^[f[^ : ~}[N
		db		i,i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i,i
		db		i,i,w,w,w,w,w,i,i
		db		i,i,w,w,w,w,w,i,i
		db		i,i,w,w,w,w,w,i,i
		db		i,i,w,w,w,w,w,i,i
		db		i,i,w,w,w,w,w,i,i
		db		i,i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i,i
		;
PtnPmPlay:	;---------------------------------------;LCDp^[f[^ : vC}[N
		db		i,i,i,i,i,i,i,i,i
		db		i,i,i,i,w,w,i,i,i
		db		i,i,i,i,w,w,w,i,i
		db		i,i,i,i,w,i,w,w,i
		db		i,i,i,i,w,i,i,w,i
		db		i,i,i,i,w,i,i,w,i
		db		i,i,w,w,w,i,i,w,i
		db		i,w,w,w,w,i,w,i,i
		db		i,w,w,w,i,i,i,i,i
		db		i,i,i,i,i,i,i,i,i
		;
PtnBassHigh:	;---------------------------------------;LCDp^[f[^ : BASS High Boost
		db		i,i,i,i,i,i,i,i
		db		w,w,w,w,w,i,i,i
		db		o,o,o,o,o,w,i,i
		db		o,o,o,o,o,w,i,i
		db		o,o,o,o,o,o,w,i
		db		o,o,o,o,o,o,w,i
		db		o,o,o,o,o,o,o,w
		db		o,o,o,o,o,o,o,w
		db		o,o,o,o,o,o,o,o
		db		i,i,i,i,i,i,i,i
		;
PtnBassLow:	;---------------------------------------;LCDp^[f[^ : BASS LOW Boost
		db		i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i
		db		w,w,w,w,w,i,i,i
		db		o,o,o,o,o,w,i,i
		db		o,o,o,o,o,o,w,i
		db		o,o,o,o,o,o,o,w
		db		i,i,i,i,i,i,i,i
		;
PtnBassOff:	;---------------------------------------;LCDp^[f[^ : BASS Boost Off
		db		i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i
		db		w,w,w,w,w,w,w,w
		db		i,i,i,i,i,i,i,i
		;
PtnTrebHigh:	;---------------------------------------;LCDp^[f[^ : TREBLE High Boost
		db		i,i,i,i,i,i,i,i
		db		i,i,i,w,w,w,w,w
		db		i,i,w,o,o,o,o,o
		db		i,i,w,o,o,o,o,o
		db		i,w,o,o,o,o,o,o
		db		i,w,o,o,o,o,o,o
		db		w,o,o,o,o,o,o,o
		db		w,o,o,o,o,o,o,o
		db		o,o,o,o,o,o,o,o
		db		i,i,i,i,i,i,i,i
		;
PtnTrebLow:	;---------------------------------------;LCDp^[f[^ : TREBLE Low Boost
		db		i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i
		db		i,i,i,w,w,w,w,w
		db		i,i,w,o,o,o,o,o
		db		i,w,o,o,o,o,o,o
		db		w,o,o,o,o,o,o,o
		db		i,i,i,i,i,i,i,i
		;
PtnTrebOff:	;---------------------------------------;LCDp^[f[^ : TREBLE Boost Off
		db		i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i
		db		w,w,w,w,w,w,w,w
		db		i,i,i,i,i,i,i,i
		;
PtnRepeatL:	;---------------------------------------;LCDp^[f[^ : s[g}[N(L)
		db		i,i,i,i,i
		db		i,i,i,i,i
		db		i,i,i,i,w
		db		i,i,i,w,i
		db		i,i,w,i,i
		db		i,w,i,i,i
		db		i,i,w,i,w
		db		i,i,i,w,w
		db		i,i,w,w,w
		db		i,i,i,i,i
		;
PtnRepeatR:	;---------------------------------------;LCDp^[f[^ : s[g}[N(R)
		db		i,i,i,i,i
		db		i,i,i,i,i
		db		w,w,w,i,i
		db		w,w,i,i,i
		db		w,i,w,i,i
		db		i,i,i,w,i
		db		i,i,w,i,i
		db		i,w,i,i,i
		db		w,i,i,i,i
		db		i,i,i,i,i
		;
PtnFreqDp:	;---------------------------------------;LCDp^[f[^ : _
		db		i,i
		db		i,i
		db		i,i
		db		i,i
		db		i,i
		db		i,i
		db		i,i
		db		i,i
		db		w,i
		db		i,i
		;
PtnIrError:	;---------------------------------------;LCDp^[f[^ : ԊOʐMG[
		db		i,i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i,i
		db		i,i,r,i,i,i,r,i,i
		db		i,i,i,r,i,r,i,i,i
		db		i,i,i,i,r,i,i,i,i
		db		i,i,i,r,i,r,i,i,i
		db		i,i,r,i,i,i,r,i,i
		db		i,i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i,i
		;
PtnIrTimOut:	;---------------------------------------;LCDp^[f[^ : ԊOʐM^CAEg
		db		i,i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i,i
		db		i,i,w,i,w,i,w,i,i
		db		i,i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i,i
		db		i,i,i,i,i,i,i,i,i
		;
StrDmStopMenu:	;---------------------------------------;LCDf[^ : ~j[샂[h
		db		"Menu...           ", 0
StrDmStop1st:	dw		084a5h						;""
		db		" Sync.          ", 0
		dw		084a5h						;""
		db		" Back Light     ", 0
		dw		084a4h						;""
		db		" Contrast       ", 0
		;
StrDmMp3Menu:	;---------------------------------------;LCDf[^ : MP3j[샂[h
		db		"MP3 Menu...       ", 0
StrDmMp31st:	dw		084a5h						;""
		db		" FF/REW         ", 0
		dw		084a5h						;""
		db		" Repeat         ", 0
		dw		084a5h						;""
		db		" Treble         ", 0
		dw		084a5h						;""
		db		" Bass           ", 0
		dw		084a5h						;""
		db		" Back Light     ", 0
		dw		084a4h						;""
		db		" Contrast       ", 0
		;
StrDmFmMenu:	;---------------------------------------;LCDf[^ : FMj[샂[h
		db		"FM Menu...        ", 0
StrDmFm1st:	dw		084a5h						;""
		db		" Auto Search    ", 0
		dw		084a5h						;""
		db		" Manual Tune    ", 0
		dw		084a5h						;""
		db		" Treble         ", 0
		dw		084a5h						;""
		db		" Bass           ", 0
		dw		084a5h						;""
		db		" Back Light     ", 0
		dw		084a4h						;""
		db		" Contrast       ", 0
		;
StrDmRepeatOff:	;---------------------------------------;LCDf[^ : s[gĐIt
		dw		084a5h						;""
		db		" Off          ", 0
		;
StrDmRepeatOne:	;---------------------------------------;LCDf[^ : ݂̋ȃs[gĐ
		dw		084a5h						;""
		db		" One          ", 0
		;
StrDmRepeatDir:	;---------------------------------------;LCDf[^ : ݂̃fBNgs[gĐ
		dw		084a5h						;""
		db		" Dir          ", 0
		;
StrDmRepeatAll:	;---------------------------------------;LCDf[^ : Sȃs[gĐ
		dw		084a4h						;""
		db		" All          ", 0
		;
StrDmFf:	;---------------------------------------;LCDf[^ : 
		dw		084a5h						;""
		db		" FF           ", 0
		;
StrDmFfRewOff:	;---------------------------------------;LCDf[^ : ʏ푬x
		dw		084a5h						;""
		db		" Normal       ", 0
		;
StrDmRew:	;---------------------------------------;LCDf[^ : ߂
		dw		084a4h						;""
		db		" REW          ", 0
		;
StrDmTrblOff:	;---------------------------------------;LCDf[^ : g[Rg[() : Boost Off
		dw		084a5h						;""
		db		" Off          ", 0
		;
StrDmTrblLow:	;---------------------------------------;LCDf[^ : g[Rg[() : Low Boost
		dw		084a5h						;""
		db		" + 4dB        ", 0
		;
StrDmTrblHigh:	;---------------------------------------;LCDf[^ : g[Rg[() : High Boost
		dw		084a4h						;""
		db		" + 8dB        ", 0
		;
StrDmBassOff:	;---------------------------------------;LCDf[^ : g[Rg[() : OFF
		dw		084a5h						;""
		db		" Off          ", 0
		;
StrDmBassLow:	;---------------------------------------;LCDf[^ : g[Rg[() : Low Boost
		dw		084a5h						;""
		db		" + 6dB        ", 0
		;
StrDmBassHigh:	;---------------------------------------;LCDf[^ : g[Rg[() : High Boost
		dw		084a4h						;""
		db		" +14dB        ", 0
		;
StrTrack:	;---------------------------------------;LCDf[^ : "Track:"
		db		"Track:", 0
		;
StrMhz:		;---------------------------------------;LCDf[^ : "MHz"
		db		"MHz", 0
		;
StrMenu:	;---------------------------------------;LCDf[^ : "Menu"
		db		"MENU", 0
		;
StrJump:	;---------------------------------------;LCDf[^ : "Jump"
		db		"JUMP", 0
		;
StrMp3:		;---------------------------------------;LCDf[^ : "MP3"
		db		"MP3", 0
		;
StrFm:		;---------------------------------------;LCDf[^ : "FM"
		db		"FM", 0
		;
StrOk:		;---------------------------------------;LCDf[^ : "Ok"
		db		"OK", 0
		;
StrCancel:	;---------------------------------------;LCDf[^ : "Cancel"
		db		"CANCEL", 0
		;
StrPreStList:	;---------------------------------------;LCDf[^ : "vZbg"
		db		"FM Station...     ", 0
StrPreSt1st:	dw		084a5h						;""
		db		" InterFM        ", 0
		dw		084a5h						;""
		db		" RADIO BERRY    ", 0
		dw		084a5h						;""
		db		" bayfm          ", 0
		dw		084a5h						;""
		db		" FM-FUJI        ", 0
		dw		084a5h						;""
		db		" NACK5          ", 0
		dw		084a5h						;""
		db		" TOKYO FM       ", 0
		dw		084a5h						;""
		db		" J-WAVE         ", 0
		dw		084a5h						;""
		db		" NHK-FM "
		dw		0938ch, 08b9eh
		db		"    ", 0
		dw		084a5h						;""
		db		" FM"
		dw		08388h, 08352h, 0836eh, 0837dh
		db		"     ", 0
		dw		084a4h						;""
		db		" FM"
		dw		082aeh, 082f1h, 082dch
		db		"       ", 0
		;
PreStTableTop:	;---------------------------------------;vZbgǂ̎ge[uCfbNX̃e[u
		db		0001d						;Index =   0 : 76.1MHz InterFM
		db		0004d						;Index =   1 : 76.4MHz RADIO BERRY
		db		0020d						;Index =   2 : 78.0MHz bayfm
		db		0026d						;Index =   3 : 78.6MHz FM-FUJI
		db		0035d						;Index =   4 : 79.5MHz NACK5
		db		0040d						;Index =   5 : 80.0MHz TOKYO FM
		db		0053d						;Index =   6 : 81.3MHz J-WAVE
		db		0065d						;Index =   7 : 82.5MHz NHK-FM
		db		0087d						;Index =   8 : 84.7MHz FMRn}
		db		0103d						;Index =   9 : 86.3MHz FM
PreStTableEnd	equ		$
cPreStTables	equ		PreStTableEnd - PreStTableTop			;vZbgǂ̐
		;
		;===============================================================
		;	End of Source
CodeSegmentEnd:	;
		;
	if	CodeSegmentEnd >= 03DFFH
		__ERROR__	"Code segment is too large."
	endif
		;
		end
		;===============================================================
